/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-26 10:58:13 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `m6ffNYNjzU_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61486 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=166818 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=184318 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_db7_forms` (
  `form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_post_id` bigint(20) NOT NULL,
  `form_value` longtext NOT NULL,
  `form_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_gla_attribute_mapping_rules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute` varchar(255) NOT NULL,
  `source` varchar(100) NOT NULL,
  `category_condition_type` varchar(10) NOT NULL,
  `categories` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_gla_budget_recommendations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `currency` varchar(3) NOT NULL,
  `country` varchar(2) NOT NULL,
  `daily_budget` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_currency` (`country`,`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=4231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_gla_merchant_issues` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `issue` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `severity` varchar(20) NOT NULL DEFAULT 'warning',
  `product` varchar(100) NOT NULL,
  `action` text NOT NULL,
  `action_url` varchar(1024) NOT NULL,
  `applicable_countries` text NOT NULL,
  `source` varchar(10) NOT NULL DEFAULT 'mc',
  `type` varchar(10) NOT NULL DEFAULT 'product',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_gla_merchant_price_benchmarks` (
  `product_id` bigint(20) NOT NULL,
  `mc_product_id` varchar(255) NOT NULL,
  `mc_product_offer_id` varchar(255) NOT NULL,
  `mc_product_price_micros` varchar(64) NOT NULL,
  `mc_product_currency_code` varchar(3) NOT NULL,
  `mc_price_country_code` varchar(2) NOT NULL,
  `mc_price_benchmark_price_micros` varchar(64) NOT NULL,
  `mc_price_benchmark_price_currency_code` varchar(3) NOT NULL,
  `mc_insights_suggested_price_micros` varchar(64) NOT NULL,
  `mc_insights_suggested_price_currency_code` varchar(3) NOT NULL,
  `mc_insights_predicted_impressions_change_fraction` decimal(10,6) NOT NULL,
  `mc_insights_predicted_clicks_change_fraction` decimal(10,6) NOT NULL,
  `mc_insights_predicted_conversions_change_fraction` decimal(10,6) NOT NULL,
  `mc_insights_effectiveness` tinyint(1) NOT NULL,
  `mc_metrics_clicks` varchar(64) NOT NULL,
  `mc_metrics_impressions` varchar(64) NOT NULL,
  `mc_metrics_ctr` int(20) NOT NULL,
  `mc_metrics_conversions` int(20) NOT NULL,
  `price_compared_with_benchmark` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`product_id`),
  UNIQUE KEY `mc_product_id` (`mc_product_id`),
  KEY `mc_insights_effectiveness` (`mc_insights_effectiveness`),
  KEY `price_compared_with_benchmark` (`price_compared_with_benchmark`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_gla_shipping_rates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) NOT NULL,
  `method` varchar(30) NOT NULL DEFAULT 'flat_rate',
  `currency` varchar(3) NOT NULL,
  `rate` double NOT NULL DEFAULT 0,
  `options` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `country` (`country`),
  KEY `method` (`method`),
  KEY `currency` (`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_gla_shipping_times` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) NOT NULL,
  `time` bigint(20) NOT NULL DEFAULT 0,
  `max_time` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_jetpack_sync_queue` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `queue_id` varchar(50) NOT NULL,
  `event_id` varchar(100) NOT NULL,
  `event_payload` longtext NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `event_id` (`event_id`),
  KEY `queue_id` (`queue_id`),
  KEY `queue_id_event_id` (`queue_id`,`event_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=5138 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_litespeed_img_optming` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `optm_status` tinyint(4) NOT NULL DEFAULT 0,
  `src` varchar(1000) NOT NULL DEFAULT '',
  `server_info` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `optm_status` (`optm_status`),
  KEY `src` (`src`(191))
) ENGINE=InnoDB AUTO_INCREMENT=535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_automation_run_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `step_id` varchar(191) NOT NULL,
  `step_type` varchar(255) NOT NULL,
  `step_key` varchar(255) NOT NULL,
  `status` varchar(191) NOT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `run_number` int(11) NOT NULL,
  `data` longtext NOT NULL,
  `error` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `automation_run_id_step_id` (`automation_run_id`,`step_id`),
  KEY `status` (`status`),
  KEY `step_id` (`step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_automation_run_subjects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `key` varchar(191) DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `hash` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_automation_runs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `version_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `next_step_id` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`,`status`),
  KEY `created_at` (`created_at`),
  KEY `version_id` (`version_id`),
  KEY `status` (`status`),
  KEY `next_step_id` (`next_step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_automation_triggers` (
  `automation_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) NOT NULL,
  PRIMARY KEY (`automation_id`,`trigger_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_automation_versions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `steps` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_automations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `author` bigint(20) NOT NULL,
  `status` varchar(191) NOT NULL,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `activated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_custom_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL,
  `params` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_dynamic_segment_filters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `filter_data` longblob DEFAULT NULL,
  `filter_type` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_feature_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'enabled',
  `body` longtext DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `styles` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `raw_message` longtext DEFAULT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_log_created_at_id` (`created_at`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_mapping_to_external_entities` (
  `old_id` int(11) unsigned NOT NULL,
  `type` varchar(50) NOT NULL,
  `new_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`old_id`,`type`),
  KEY `new_id` (`new_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed_at` timestamp NULL DEFAULT NULL,
  `retries` int(11) unsigned NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_newsletter_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `url` varchar(2083) NOT NULL,
  `hash` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_newsletter_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `option_field_id` int(11) unsigned NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_newsletter_option_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `newsletter_type` varchar(90) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_newsletter_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `post_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_newsletter_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_newsletter_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) DEFAULT 0,
  `name` varchar(250) NOT NULL,
  `categories` varchar(250) NOT NULL DEFAULT '[]',
  `description` varchar(255) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `thumbnail` longtext DEFAULT NULL,
  `thumbnail_data` longtext DEFAULT NULL,
  `readonly` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `subject` varchar(250) NOT NULL DEFAULT '',
  `type` varchar(150) NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) NOT NULL DEFAULT '',
  `sender_name` varchar(150) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) NOT NULL DEFAULT '',
  `preheader` varchar(250) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `ga_campaign` varchar(250) NOT NULL DEFAULT '',
  `wp_post_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`),
  KEY `wp_post_id` (`wp_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_scheduled_task_subscribers` (
  `task_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `processed` int(1) NOT NULL,
  `failed` smallint(1) NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_scheduled_tasks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) DEFAULT NULL,
  `status` varchar(12) DEFAULT NULL,
  `priority` mediumint(9) NOT NULL DEFAULT 0,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int(1) DEFAULT NULL,
  `reschedule_count` int(11) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `cancelled_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9300 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_segments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL DEFAULT 'default',
  `description` varchar(250) NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `display_in_manage_subscription_page` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_sending_queues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(11) unsigned NOT NULL,
  `newsletter_id` int(11) unsigned NOT NULL,
  `newsletter_rendered_body` longtext DEFAULT NULL,
  `newsletter_rendered_subject` varchar(250) DEFAULT NULL,
  `subscribers` longtext DEFAULT NULL,
  `count_total` int(11) unsigned NOT NULL DEFAULT 0,
  `count_processed` int(11) unsigned NOT NULL DEFAULT 0,
  `count_to_process` int(11) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=23238 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_statistics_bounces` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_statistics_clicks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `link_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `count` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_statistics_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_statistics_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_statistics_opens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_statistics_unsubscribes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `source` varchar(255) DEFAULT 'unknown',
  `meta` varchar(255) DEFAULT NULL,
  `method` varchar(40) NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_statistics_woocommerce_purchases` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `click_id` int(11) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `order_currency` char(3) NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` varchar(40) NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_stats_notifications` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `task_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_subscriber_custom_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `custom_field_id` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_subscriber_ips` (
  `ip` varchar(45) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_subscriber_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_subscriber_tag` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `tag_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_tag` (`subscriber_id`,`tag_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_subscribers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) DEFAULT NULL,
  `is_woocommerce_user` int(1) NOT NULL DEFAULT 0,
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(150) NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) DEFAULT NULL,
  `confirmed_ip` varchar(45) DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext DEFAULT NULL,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') DEFAULT 'unknown',
  `count_confirmations` int(11) unsigned NOT NULL DEFAULT 0,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `link_token` char(32) DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  `woocommerce_synced_at` timestamp NULL DEFAULT NULL,
  `email_count` int(11) unsigned NOT NULL DEFAULT 0,
  `last_sending_at` timestamp NULL DEFAULT NULL,
  `last_open_at` timestamp NULL DEFAULT NULL,
  `last_click_at` timestamp NULL DEFAULT NULL,
  `last_purchase_at` timestamp NULL DEFAULT NULL,
  `last_page_view_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `link_token` (`link_token`),
  KEY `first_name` (`first_name`(10)),
  KEY `last_name` (`last_name`(10)),
  KEY `last_sending_at` (`last_sending_at`),
  KEY `last_open_at` (`last_open_at`),
  KEY `last_click_at` (`last_click_at`),
  KEY `last_purchase_at` (`last_purchase_at`),
  KEY `last_page_view_at` (`last_page_view_at`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_tags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_user_agents` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL,
  `user_agent` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_mailpoet_user_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_omnisend_contact_cache` (
  `email` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `contact_id` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_omnisend_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `type` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `endpoint` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `url` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `message` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3778 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=791329 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_sameday_awb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `awb_number` varchar(255) DEFAULT NULL,
  `parcels` text DEFAULT NULL,
  `awb_cost` double(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_sameday_locker` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `locker_id` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `county` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  `postal_code` varchar(255) DEFAULT NULL,
  `boxes` text DEFAULT NULL,
  `is_testing` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3727 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_sameday_pickup_point` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sameday_id` int(11) NOT NULL,
  `sameday_alias` varchar(255) DEFAULT NULL,
  `is_testing` tinyint(1) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `county` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `contactPersons` text DEFAULT NULL,
  `default_pickup_point` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_sameday_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sameday_id` int(11) NOT NULL,
  `sameday_name` varchar(255) DEFAULT NULL,
  `is_testing` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `price` double(10,2) DEFAULT NULL,
  `price_free` double(10,2) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `sameday_code` varchar(255) NOT NULL DEFAULT '',
  `service_optional_taxes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_social_users` (
  `social_users_id` int(11) NOT NULL AUTO_INCREMENT,
  `ID` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `identifier` varchar(100) NOT NULL,
  `register_date` datetime DEFAULT NULL,
  `login_date` datetime DEFAULT NULL,
  `link_date` datetime DEFAULT NULL,
  PRIMARY KEY (`social_users_id`),
  KEY `ID` (`ID`,`type`),
  KEY `identifier` (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2728 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2728 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=321 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5269 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wcpdf_invoice_number` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `order_id` int(16) DEFAULT NULL,
  `date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `calculated_number` int(16) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=29558 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_wpo_404_detector` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` text NOT NULL,
  `request_timestamp` bigint(20) unsigned NOT NULL,
  `request_count` bigint(20) unsigned NOT NULL,
  `referrer` text NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `url` (`url`(75),`request_timestamp`,`referrer`(75)),
  KEY `url_timestamp_referrer` (`url`(75),`request_timestamp`,`referrer`(75)),
  KEY `timestamp_count` (`request_timestamp`,`request_count`)
) ENGINE=InnoDB AUTO_INCREMENT=3328 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_yith_wcan_cache` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `group` varchar(100) NOT NULL,
  `version` varchar(10) NOT NULL,
  `index` char(32) DEFAULT NULL,
  `value` longtext NOT NULL,
  `expiration` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`ID`),
  UNIQUE KEY `cache_entry` (`group`,`version`,`index`),
  KEY `cache_set` (`group`,`version`),
  KEY `cache_version` (`version`),
  KEY `cache_expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_yith_wcwl` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `prod_id` bigint(20) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `wishlist_id` bigint(20) DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=InnoDB AUTO_INCREMENT=774 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `m6ffNYNjzU_yith_wcwl_itemmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `yith_wcwl_item_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `item_id` (`yith_wcwl_item_id`),
  KEY `meta_key` (`meta_key`(250))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_yith_wcwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  UNIQUE KEY `wishlist_token_2` (`wishlist_token`),
  UNIQUE KEY `wishlist_token_3` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=InnoDB AUTO_INCREMENT=771 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `m6ffNYNjzU_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=864 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `m6ffNYNjzU_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `m6ffNYNjzU_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2105 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: m6ffNYNjzU_actionscheduler_actions */
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("23799", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-05-13 06:54:20", "2025-05-13 06:54:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747119260;s:18:\"\0*\0first_timestamp\";i:1728973198;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747119260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "9", "1", "2025-05-13 06:58:32", "2025-05-13 06:58:32", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("24702", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-06-12 06:58:32", "2025-06-12 06:58:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749711512;s:18:\"\0*\0first_timestamp\";i:1728973198;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749711512;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "9", "1", "2025-06-12 07:14:37", "2025-06-12 07:14:37", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("25625", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-11 09:45:40", "2025-06-11 09:45:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749635140;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749635140;}", "9", "1", "2025-06-11 09:53:55", "2025-06-11 09:53:55", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("25743", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-07-12 07:14:37", "2025-07-12 07:14:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752304477;s:18:\"\0*\0first_timestamp\";i:1728973198;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752304477;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "9", "1", "2025-07-12 07:36:35", "2025-07-12 07:36:35", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("25762", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-12 08:34:48", "2025-06-12 08:34:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749717288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749717288;}", "9", "1", "2025-06-12 08:37:04", "2025-06-12 08:37:04", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("25958", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-13 09:18:07", "2025-06-13 09:18:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749806287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749806287;}", "9", "1", "2025-06-13 11:05:41", "2025-06-13 11:05:41", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("26103", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-14 08:32:34", "2025-06-14 08:32:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749889954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749889954;}", "9", "1", "2025-06-14 08:36:04", "2025-06-14 08:36:04", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("26299", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-15 08:46:48", "2025-06-15 08:46:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749977208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749977208;}", "9", "1", "2025-06-15 08:55:42", "2025-06-15 08:55:42", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("26449", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-16 08:33:28", "2025-06-16 08:33:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750062808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750062808;}", "9", "1", "2025-06-16 08:45:23", "2025-06-16 08:45:23", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("26535", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-17 08:35:52", "2025-06-17 08:35:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750149352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750149352;}", "9", "1", "2025-06-17 10:31:06", "2025-06-17 10:31:06", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("26827", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-19 08:57:49", "2025-06-19 08:57:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750323469;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750323469;}", "9", "1", "2025-06-19 09:02:03", "2025-06-19 09:02:03", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("27094", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-20 08:32:18", "2025-06-20 08:32:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750408338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750408338;}", "9", "1", "2025-06-20 08:35:34", "2025-06-20 08:35:34", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("27378", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-21 08:31:05", "2025-06-21 08:31:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750494665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750494665;}", "9", "1", "2025-06-21 08:34:39", "2025-06-21 08:34:39", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("27557", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-22 08:36:11", "2025-06-22 08:36:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750581371;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750581371;}", "9", "1", "2025-06-22 08:42:21", "2025-06-22 08:42:21", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("27765", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-23 08:35:09", "2025-06-23 08:35:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750667709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750667709;}", "9", "1", "2025-06-23 08:39:59", "2025-06-23 08:39:59", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("27982", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-24 08:31:47", "2025-06-24 08:31:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750753907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750753907;}", "9", "1", "2025-06-24 08:42:30", "2025-06-24 08:42:30", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("28172", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-25 08:31:28", "2025-06-25 08:31:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750840288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750840288;}", "9", "1", "2025-06-25 08:37:53", "2025-06-25 08:37:53", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("28314", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-26 08:40:21", "2025-06-26 08:40:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750927221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750927221;}", "9", "1", "2025-06-26 08:42:11", "2025-06-26 08:42:11", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("28494", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-27 08:36:20", "2025-06-27 08:36:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751013380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751013380;}", "9", "1", "2025-06-27 08:43:15", "2025-06-27 08:43:15", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("28597", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-28 09:06:59", "2025-06-28 09:06:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751101619;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751101619;}", "9", "1", "2025-06-28 09:15:36", "2025-06-28 09:15:36", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("28696", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-06-29 08:46:10", "2025-06-29 08:46:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751186770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751186770;}", "9", "1", "2025-06-29 08:57:44", "2025-06-29 08:57:44", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("29065", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-01 08:51:41", "2025-07-01 08:51:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751359901;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751359901;}", "9", "1", "2025-07-01 10:57:04", "2025-07-01 10:57:04", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("29360", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-02 08:38:30", "2025-07-02 08:38:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751445510;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751445510;}", "9", "1", "2025-07-02 08:46:32", "2025-07-02 08:46:32", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("29648", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-03 08:50:40", "2025-07-03 08:50:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751532640;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751532640;}", "9", "1", "2025-07-03 09:14:51", "2025-07-03 09:14:51", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("29916", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-04 08:36:34", "2025-07-04 08:36:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751618194;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751618194;}", "9", "1", "2025-07-04 08:40:26", "2025-07-04 08:40:26", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("30189", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-05 08:38:41", "2025-07-05 08:38:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751704721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751704721;}", "9", "1", "2025-07-05 09:01:15", "2025-07-05 09:01:15", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("30488", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-06 08:33:31", "2025-07-06 08:33:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751790811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751790811;}", "9", "1", "2025-07-06 08:46:29", "2025-07-06 08:46:29", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("30789", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-07 08:34:17", "2025-07-07 08:34:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751877257;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751877257;}", "9", "1", "2025-07-07 08:37:54", "2025-07-07 08:37:54", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("31082", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-08 08:39:44", "2025-07-08 08:39:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751963984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751963984;}", "9", "1", "2025-07-08 08:43:27", "2025-07-08 08:43:27", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("31287", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-09 08:47:46", "2025-07-09 08:47:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752050866;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752050866;}", "9", "1", "2025-07-09 09:00:17", "2025-07-09 09:00:17", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("31534", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-10 09:21:27", "2025-07-10 09:21:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752139287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752139287;}", "9", "1", "2025-07-10 09:34:51", "2025-07-10 09:34:51", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("31750", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-11 08:49:35", "2025-07-11 08:49:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752223775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752223775;}", "9", "1", "2025-07-11 09:49:00", "2025-07-11 09:49:00", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("31958", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-08-11 07:36:35", "2025-08-11 07:36:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754897795;s:18:\"\0*\0first_timestamp\";i:1728973198;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754897795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "9", "1", "2025-08-11 07:42:05", "2025-08-11 07:42:05", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("31964", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-12 08:37:09", "2025-07-12 08:37:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752309429;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752309429;}", "9", "1", "2025-07-12 09:13:14", "2025-07-12 09:13:14", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("32189", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-13 08:41:12", "2025-07-13 08:41:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752396072;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752396072;}", "9", "1", "2025-07-13 08:42:45", "2025-07-13 08:42:45", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("32435", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-14 08:34:23", "2025-07-14 08:34:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752482063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752482063;}", "9", "1", "2025-07-14 08:38:09", "2025-07-14 08:38:09", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("32637", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-15 08:33:06", "2025-07-15 08:33:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752568386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752568386;}", "9", "1", "2025-07-15 08:39:31", "2025-07-15 08:39:31", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("32844", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-16 09:11:56", "2025-07-16 09:11:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752657116;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752657116;}", "9", "1", "2025-07-16 09:38:14", "2025-07-16 09:38:14", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("33078", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-17 08:31:37", "2025-07-17 08:31:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752741097;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752741097;}", "9", "1", "2025-07-17 08:41:13", "2025-07-17 08:41:13", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("33359", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-18 08:41:21", "2025-07-18 08:41:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752828081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752828081;}", "9", "1", "2025-07-18 08:53:30", "2025-07-18 08:53:30", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("33560", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-19 08:59:18", "2025-07-19 08:59:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752915558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752915558;}", "9", "1", "2025-07-19 09:03:46", "2025-07-19 09:03:46", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("33784", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-20 08:33:27", "2025-07-20 08:33:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753000407;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753000407;}", "9", "1", "2025-07-20 08:54:08", "2025-07-20 08:54:08", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("34201", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-22 08:57:38", "2025-07-22 08:57:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753174658;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753174658;}", "9", "1", "2025-07-22 09:14:29", "2025-07-22 09:14:29", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("34424", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-23 08:39:17", "2025-07-23 08:39:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753259957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753259957;}", "9", "1", "2025-07-23 09:06:45", "2025-07-23 09:06:45", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("34893", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-25 08:37:46", "2025-07-25 08:37:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753432666;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753432666;}", "9", "1", "2025-07-25 09:00:08", "2025-07-25 09:00:08", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("35109", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-26 08:33:16", "2025-07-26 08:33:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753518796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753518796;}", "9", "1", "2025-07-26 08:40:42", "2025-07-26 08:40:42", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("35793", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-29 09:23:30", "2025-07-29 09:23:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753781010;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753781010;}", "9", "1", "2025-07-29 09:34:14", "2025-07-29 09:34:14", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("36045", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-30 09:05:01", "2025-07-30 09:05:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753866301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753866301;}", "9", "1", "2025-07-30 09:12:16", "2025-07-30 09:12:16", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("36283", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-07-31 08:42:46", "2025-07-31 08:42:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753951366;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753951366;}", "9", "1", "2025-07-31 09:04:48", "2025-07-31 09:04:48", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("36483", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-01 09:12:48", "2025-08-01 09:12:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754039568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754039568;}", "9", "1", "2025-08-01 10:01:45", "2025-08-01 10:01:45", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("36694", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-02 09:12:56", "2025-08-02 09:12:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754125976;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754125976;}", "9", "1", "2025-08-02 09:22:19", "2025-08-02 09:22:19", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("36916", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-03 11:39:29", "2025-08-03 11:39:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754221169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754221169;}", "9", "1", "2025-08-03 12:04:49", "2025-08-03 12:04:49", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("37117", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-04 08:35:38", "2025-08-04 08:35:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754296538;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754296538;}", "9", "1", "2025-08-04 08:46:41", "2025-08-04 08:46:41", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("37330", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-05 08:35:34", "2025-08-05 08:35:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754382934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754382934;}", "9", "1", "2025-08-05 08:39:39", "2025-08-05 08:39:39", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("37567", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-06 08:36:37", "2025-08-06 08:36:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754469397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754469397;}", "9", "1", "2025-08-06 08:58:59", "2025-08-06 08:58:59", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("37799", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-07 08:42:43", "2025-08-07 08:42:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754556163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754556163;}", "9", "1", "2025-08-07 08:50:00", "2025-08-07 08:50:00", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("38042", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-08 08:32:18", "2025-08-08 08:32:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754641938;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754641938;}", "9", "1", "2025-08-08 08:50:08", "2025-08-08 08:50:08", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("38301", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-09 08:49:42", "2025-08-09 08:49:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754729382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754729382;}", "9", "1", "2025-08-09 08:56:38", "2025-08-09 08:56:38", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("38526", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-10 09:12:06", "2025-08-10 09:12:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754817126;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754817126;}", "9", "1", "2025-08-10 09:29:32", "2025-08-10 09:29:32", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("38760", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-11 08:43:30", "2025-08-11 08:43:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754901810;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754901810;}", "9", "1", "2025-08-11 10:06:37", "2025-08-11 10:06:37", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("38998", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-12 08:39:30", "2025-08-12 08:39:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754987970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754987970;}", "9", "1", "2025-08-12 08:45:48", "2025-08-12 08:45:48", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("39667", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-15 08:53:50", "2025-08-15 08:53:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755248030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755248030;}", "9", "1", "2025-08-15 09:15:29", "2025-08-15 09:15:29", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("40345", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-18 08:41:12", "2025-08-18 08:41:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755506472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755506472;}", "9", "1", "2025-08-18 08:42:08", "2025-08-18 08:42:08", "134660", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("40480", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-19 08:33:23", "2025-08-19 08:33:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755592403;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755592403;}", "9", "1", "2025-08-19 08:36:34", "2025-08-19 08:36:34", "134903", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("40701", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-21 08:32:53", "2025-08-21 08:32:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755765173;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755765173;}", "9", "1", "2025-08-21 08:41:31", "2025-08-21 08:41:31", "135276", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("40846", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-22 08:34:27", "2025-08-22 08:34:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755851667;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755851667;}", "9", "1", "2025-08-22 08:35:52", "2025-08-22 08:35:52", "135566", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("41093", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-24 08:55:58", "2025-08-24 08:55:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756025758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756025758;}", "9", "1", "2025-08-24 09:15:34", "2025-08-24 09:15:34", "135980", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("41332", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-26 08:33:24", "2025-08-26 08:33:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756197204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756197204;}", "9", "1", "2025-08-26 09:10:22", "2025-08-26 09:10:22", "136343", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("41437", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-27 09:03:23", "2025-08-27 09:03:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756285403;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756285403;}", "9", "1", "2025-08-27 09:11:19", "2025-08-27 09:11:19", "136506", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("41557", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-28 09:22:35", "2025-08-28 09:22:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756372955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756372955;}", "9", "1", "2025-08-28 09:33:34", "2025-08-28 09:33:34", "136695", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("41701", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-29 09:06:56", "2025-08-29 09:06:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756458416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756458416;}", "9", "1", "2025-08-29 09:57:00", "2025-08-29 09:57:00", "136935", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("41821", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-30 10:15:24", "2025-08-30 10:15:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756548924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756548924;}", "9", "1", "2025-08-30 10:31:16", "2025-08-30 10:31:16", "137116", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("41906", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-08-31 08:36:35", "2025-08-31 08:36:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756629395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756629395;}", "9", "1", "2025-08-31 08:55:17", "2025-08-31 08:55:17", "137238", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("42019", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-01 09:31:01", "2025-09-01 09:31:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756719061;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756719061;}", "9", "1", "2025-09-01 09:51:58", "2025-09-01 09:51:58", "137424", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("42145", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-02 08:38:50", "2025-09-02 08:38:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756802330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756802330;}", "9", "1", "2025-09-02 09:01:34", "2025-09-02 09:01:34", "137601", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("42433", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-04 08:33:28", "2025-09-04 08:33:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756974808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756974808;}", "9", "1", "2025-09-04 08:52:22", "2025-09-04 08:52:22", "138001", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("42725", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-06 08:43:52", "2025-09-06 08:43:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757148232;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757148232;}", "9", "1", "2025-09-06 08:58:40", "2025-09-06 08:58:40", "138468", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("42870", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-07 08:33:22", "2025-09-07 08:33:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757234002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757234002;}", "9", "1", "2025-09-07 08:39:09", "2025-09-07 08:39:09", "138727", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43012", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-08 08:42:07", "2025-09-08 08:42:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757320927;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757320927;}", "9", "1", "2025-09-08 08:48:45", "2025-09-08 08:48:45", "138944", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43165", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-09 08:43:19", "2025-09-09 08:43:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757407399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757407399;}", "9", "1", "2025-09-09 08:49:11", "2025-09-09 08:49:11", "139192", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43277", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-10 08:34:53", "2025-09-10 08:34:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757493293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757493293;}", "9", "1", "2025-09-10 09:04:59", "2025-09-10 09:04:59", "139326", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43428", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-11 08:36:26", "2025-09-11 08:36:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757579786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757579786;}", "9", "1", "2025-09-11 08:40:24", "2025-09-11 08:40:24", "139558", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43547", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-12 08:50:51", "2025-09-12 08:50:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757667051;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757667051;}", "9", "1", "2025-09-12 08:51:21", "2025-09-12 08:51:21", "139700", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43663", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-13 08:43:00", "2025-09-13 08:43:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757752980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757752980;}", "9", "1", "2025-09-13 08:50:40", "2025-09-13 08:50:40", "139861", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43787", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-14 08:36:16", "2025-09-14 08:36:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757838976;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757838976;}", "9", "1", "2025-09-14 08:48:10", "2025-09-14 08:48:10", "140024", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("43936", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-15 10:06:14", "2025-09-15 10:06:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757930774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757930774;}", "9", "1", "2025-09-15 10:13:08", "2025-09-15 10:13:08", "140242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("44054", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-16 08:38:42", "2025-09-16 08:38:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758011922;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758011922;}", "9", "1", "2025-09-16 08:51:39", "2025-09-16 08:51:39", "140411", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("44184", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-17 08:40:25", "2025-09-17 08:40:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758098425;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758098425;}", "9", "1", "2025-09-17 09:07:07", "2025-09-17 09:07:07", "140595", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("44350", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-18 08:41:08", "2025-09-18 08:41:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758184868;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758184868;}", "9", "1", "2025-09-18 09:02:21", "2025-09-18 09:02:21", "140856", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("44502", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-19 08:46:40", "2025-09-19 08:46:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758271600;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758271600;}", "9", "1", "2025-09-19 08:58:18", "2025-09-19 08:58:18", "141099", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("44632", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-20 09:02:41", "2025-09-20 09:02:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758358961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758358961;}", "9", "1", "2025-09-20 09:08:35", "2025-09-20 09:08:35", "141280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("44865", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-22 08:34:28", "2025-09-22 08:34:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758530068;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758530068;}", "9", "1", "2025-09-22 08:36:34", "2025-09-22 08:36:34", "141593", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("45154", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-24 10:30:14", "2025-09-24 10:30:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758709814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758709814;}", "9", "1", "2025-09-24 10:30:55", "2025-09-24 10:30:55", "142050", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("45263", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-25 08:36:50", "2025-09-25 08:36:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758789410;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758789410;}", "9", "1", "2025-09-25 08:46:31", "2025-09-25 08:46:31", "142196", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("45525", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-27 08:33:13", "2025-09-27 08:33:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758961993;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758961993;}", "9", "1", "2025-09-27 08:33:57", "2025-09-27 08:33:57", "142582", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("45641", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-28 08:42:21", "2025-09-28 08:42:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759048941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759048941;}", "9", "1", "2025-09-28 09:47:42", "2025-09-28 09:47:42", "142749", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("45935", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-09-30 08:36:39", "2025-09-30 08:36:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759221399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759221399;}", "9", "1", "2025-09-30 08:44:22", "2025-09-30 08:44:22", "143277", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("46419", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-03 08:40:58", "2025-10-03 08:40:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759480858;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759480858;}", "9", "1", "2025-10-03 09:38:42", "2025-10-03 09:38:42", "144141", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("46550", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-04 08:43:21", "2025-10-04 08:43:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759567401;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759567401;}", "9", "1", "2025-10-04 08:59:00", "2025-10-04 08:59:00", "144347", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("46643", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-05 09:13:04", "2025-10-05 09:13:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759655584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759655584;}", "9", "1", "2025-10-05 09:49:07", "2025-10-05 09:49:07", "144450", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("46761", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-06 08:48:15", "2025-10-06 08:48:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759740495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759740495;}", "9", "1", "2025-10-06 08:57:07", "2025-10-06 08:57:07", "144606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("46888", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-07 08:40:43", "2025-10-07 08:40:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759826443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759826443;}", "9", "1", "2025-10-07 09:52:00", "2025-10-07 09:52:00", "144790", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("47253", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-10 08:44:35", "2025-10-10 08:44:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760085875;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760085875;}", "9", "1", "2025-10-10 08:47:23", "2025-10-10 08:47:23", "145315", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("47495", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-12 08:52:34", "2025-10-12 08:52:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760259154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760259154;}", "9", "1", "2025-10-12 09:05:51", "2025-10-12 09:05:51", "145624", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("47632", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-13 09:12:58", "2025-10-13 09:12:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760346778;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760346778;}", "9", "1", "2025-10-13 09:17:04", "2025-10-13 09:17:04", "145797", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("47772", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-14 09:20:13", "2025-10-14 09:20:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760433613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760433613;}", "9", "1", "2025-10-14 09:20:19", "2025-10-14 09:20:19", "146004", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("48040", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-16 08:34:23", "2025-10-16 08:34:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760603663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760603663;}", "9", "1", "2025-10-16 08:52:03", "2025-10-16 08:52:03", "146405", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("48192", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-17 08:41:39", "2025-10-17 08:41:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760690499;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760690499;}", "9", "1", "2025-10-17 08:42:45", "2025-10-17 08:42:45", "146647", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("48334", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-18 08:39:15", "2025-10-18 08:39:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760776755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760776755;}", "9", "1", "2025-10-18 08:49:13", "2025-10-18 08:49:13", "146841", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("48594", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-20 08:45:15", "2025-10-20 08:45:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760949915;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760949915;}", "9", "1", "2025-10-20 08:45:18", "2025-10-20 08:45:18", "147234", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("48728", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-21 08:30:47", "2025-10-21 08:30:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761035447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761035447;}", "9", "1", "2025-10-21 08:56:32", "2025-10-21 08:56:32", "147439", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("48847", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-22 08:34:07", "2025-10-22 08:34:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761122047;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761122047;}", "9", "1", "2025-10-22 08:34:28", "2025-10-22 08:34:28", "147608", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("48968", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-23 08:36:19", "2025-10-23 08:36:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761208579;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761208579;}", "9", "1", "2025-10-23 08:52:04", "2025-10-23 08:52:04", "147770", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("49085", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-24 08:34:45", "2025-10-24 08:34:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761294885;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761294885;}", "9", "1", "2025-10-24 09:11:30", "2025-10-24 09:11:30", "147925", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("49217", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-25 09:45:07", "2025-10-25 09:45:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761385507;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761385507;}", "9", "1", "2025-10-25 09:49:30", "2025-10-25 09:49:30", "148111", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("49512", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-27 08:33:19", "2025-10-27 08:33:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761553999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761553999;}", "9", "1", "2025-10-27 08:42:03", "2025-10-27 08:42:03", "148629", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("49824", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-29 09:02:45", "2025-10-29 09:02:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761728565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761728565;}", "9", "1", "2025-10-29 09:45:45", "2025-10-29 09:45:45", "149120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("49937", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-30 08:42:17", "2025-10-30 08:42:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761813737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761813737;}", "9", "1", "2025-10-30 08:59:08", "2025-10-30 08:59:08", "149251", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("50047", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-10-31 08:51:27", "2025-10-31 08:51:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761900687;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761900687;}", "9", "1", "2025-10-31 09:16:28", "2025-10-31 09:16:28", "149368", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("50151", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-01 08:56:58", "2025-11-01 08:56:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761987418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761987418;}", "9", "1", "2025-11-01 08:59:39", "2025-11-01 08:59:39", "149489", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("50374", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-03 08:34:00", "2025-11-03 08:34:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762158840;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762158840;}", "9", "1", "2025-11-03 08:34:22", "2025-11-03 08:34:22", "149753", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("50504", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-04 08:47:18", "2025-11-04 08:47:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762246038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762246038;}", "9", "1", "2025-11-04 09:14:27", "2025-11-04 09:14:27", "149915", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("50634", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-05 08:54:31", "2025-11-05 08:54:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762332871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762332871;}", "9", "1", "2025-11-05 09:12:05", "2025-11-05 09:12:05", "150096", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("50751", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-06 08:37:42", "2025-11-06 08:37:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762418262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762418262;}", "9", "1", "2025-11-06 09:08:01", "2025-11-06 09:08:01", "150247", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("50882", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-07 08:33:43", "2025-11-07 08:33:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762504423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762504423;}", "9", "1", "2025-11-07 08:56:25", "2025-11-07 08:56:25", "150420", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("51021", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-08 08:36:44", "2025-11-08 08:36:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762591004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762591004;}", "9", "1", "2025-11-08 08:38:47", "2025-11-08 08:38:47", "150614", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("51151", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-09 08:55:26", "2025-11-09 08:55:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762678526;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762678526;}", "9", "1", "2025-11-09 09:11:03", "2025-11-09 09:11:03", "150804", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("51286", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-10 08:35:01", "2025-11-10 08:35:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762763701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762763701;}", "9", "1", "2025-11-10 09:12:41", "2025-11-10 09:12:41", "150991", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("51404", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-11 08:41:58", "2025-11-11 08:41:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762850518;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762850518;}", "9", "1", "2025-11-11 09:14:22", "2025-11-11 09:14:22", "151147", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("51664", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-13 08:49:39", "2025-11-13 08:49:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763023779;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763023779;}", "9", "1", "2025-11-13 09:34:23", "2025-11-13 09:34:23", "151512", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("51791", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-14 08:35:59", "2025-11-14 08:35:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763109359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763109359;}", "9", "1", "2025-11-14 08:56:05", "2025-11-14 08:56:05", "151682", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("52123", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-16 08:34:04", "2025-11-16 08:34:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763282044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763282044;}", "9", "1", "2025-11-16 08:43:00", "2025-11-16 08:43:00", "152207", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("52290", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-17 08:38:51", "2025-11-17 08:38:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763368731;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763368731;}", "9", "1", "2025-11-17 09:22:23", "2025-11-17 09:22:23", "152467", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("52476", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-18 08:32:55", "2025-11-18 08:32:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763454775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763454775;}", "9", "1", "2025-11-18 08:46:45", "2025-11-18 08:46:45", "152791", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("52629", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-19 08:49:01", "2025-11-19 08:49:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763542141;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763542141;}", "9", "1", "2025-11-19 08:50:56", "2025-11-19 08:50:56", "153026", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("52785", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-20 08:45:38", "2025-11-20 08:45:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763628338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763628338;}", "9", "1", "2025-11-20 08:57:21", "2025-11-20 08:57:21", "153265", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("52910", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-21 09:02:01", "2025-11-21 09:02:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763715721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763715721;}", "9", "1", "2025-11-21 09:02:18", "2025-11-21 09:02:18", "153448", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("53045", "facebook_for_woocommerce_daily_heartbeat", "failed", "2025-11-22 08:48:07", "2025-11-22 08:48:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763801287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763801287;}", "9", "1", "2025-11-22 08:53:30", "2025-11-22 08:53:30", "153670", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("55413", "wpo_ips_semaphore_lock_cleanup", "complete", "2026-01-08 08:04:19", "2026-01-08 08:04:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767859459;s:18:\"\0*\0first_timestamp\";i:1728973198;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767859459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "9", "1", "2026-01-08 08:09:53", "2026-01-08 08:09:53", "163777", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57350", "woocommerce_geoip_updater", "complete", "2026-01-08 11:08:18", "2026-01-08 11:08:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767870498;s:18:\"\0*\0first_timestamp\";i:1756196768;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767870498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "13", "1", "2026-01-08 11:37:50", "2026-01-08 11:37:50", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57532", "woocommerce_scheduled_sales", "complete", "2025-12-26 16:07:54", "2025-12-26 16:07:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766765274;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766765274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-26 16:13:07", "2025-12-26 16:13:07", "160987", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57544", "woocommerce_cleanup_draft_orders", "complete", "2025-12-26 19:12:56", "2025-12-26 19:12:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766776376;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766776376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-12-26 19:38:22", "2025-12-26 19:38:22", "161010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57545", "wc_gla_cron_daily_notes", "complete", "2025-12-26 19:12:56", "2025-12-26 19:12:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766776376;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766776376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-26 19:38:22", "2025-12-26 19:38:22", "161010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57546", "wc_facebook_regenerate_feed", "complete", "2025-12-26 19:13:07", "2025-12-26 19:13:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766776387;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766776387;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-12-26 19:38:32", "2025-12-26 19:38:32", "161010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57603", "gla/jobs/resubmit_expiring_products/start", "complete", "2025-12-27 03:00:00", "2025-12-27 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766804400;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1766804400;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2025-12-27 03:00:33", "2025-12-27 03:00:33", "161107", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57625", "wc_admin_daily_wrapper", "complete", "2025-12-27 06:56:14", "2025-12-27 06:56:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766818574;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766818574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-27 07:22:20", "2025-12-27 07:22:20", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57626", "woocommerce_cleanup_personal_data", "complete", "2025-12-27 06:56:15", "2025-12-27 06:56:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766818575;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766818575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-27 07:22:20", "2025-12-27 07:22:20", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57627", "woocommerce_tracker_send_event_wrapper", "complete", "2025-12-27 06:56:15", "2025-12-27 06:56:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766818575;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766818575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-27 07:22:20", "2025-12-27 07:22:20", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57628", "woocommerce_cleanup_logs", "complete", "2025-12-27 06:56:15", "2025-12-27 06:56:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766818575;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766818575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-27 07:22:20", "2025-12-27 07:22:20", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57629", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-27 06:56:15", "2025-12-27 06:56:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766818575;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766818575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-27 07:22:20", "2025-12-27 07:22:20", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57630", "fetch_patterns", "complete", "2025-12-27 06:56:16", "2025-12-27 06:56:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766818576;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766818576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-27 07:22:21", "2025-12-27 07:22:21", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57631", "woocommerce_cleanup_sessions", "complete", "2025-12-27 06:00:00", "2025-12-27 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766815200;s:18:\"\0*\0first_timestamp\";i:1766815200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766815200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2025-12-27 06:01:03", "2025-12-27 06:01:03", "161220", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57633", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-27 06:56:16", "2025-12-27 06:56:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766818576;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766818576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-27 07:22:21", "2025-12-27 07:22:21", "161242", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57637", "woocommerce_refresh_order_count_cache", "complete", "2025-12-26 19:48:57", "2025-12-26 19:48:57", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766778537;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766778537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-26 20:00:27", "2025-12-26 20:00:27", "161012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57650", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 11:57:14", "2025-12-26 11:57:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766750234;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766750234;}", "13", "1", "2025-12-26 12:29:51", "2025-12-26 12:29:51", "160972", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57651", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 10:57:14", "2025-12-26 10:57:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766746634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766746634;}", "9", "1", "2025-12-26 10:57:30", "2025-12-26 10:57:30", "160970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57652", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 10:57:14", "2025-12-26 10:57:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766746634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766746634;}", "9", "1", "2025-12-26 10:57:30", "2025-12-26 10:57:30", "160970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57653", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 13:29:51", "2025-12-26 13:29:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766755791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766755791;}", "13", "1", "2025-12-26 13:42:15", "2025-12-26 13:42:15", "160976", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57654", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 12:29:51", "2025-12-26 12:29:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766752191;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766752191;}", "9", "1", "2025-12-26 12:29:54", "2025-12-26 12:29:54", "160974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57655", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 12:29:51", "2025-12-26 12:29:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766752191;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766752191;}", "9", "1", "2025-12-26 12:29:54", "2025-12-26 12:29:54", "160974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57656", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 14:42:15", "2025-12-26 14:42:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766760135;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766760135;}", "13", "1", "2025-12-26 15:40:13", "2025-12-26 15:40:13", "160985", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57657", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 13:42:15", "2025-12-26 13:42:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766756535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766756535;}", "9", "1", "2025-12-26 13:42:16", "2025-12-26 13:42:16", "160978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57658", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 13:42:15", "2025-12-26 13:42:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766756535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766756535;}", "9", "1", "2025-12-26 13:42:16", "2025-12-26 13:42:16", "160978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57659", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 14:08:39", "2025-12-26 14:08:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766758119;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766758119;}", "9", "1", "2025-12-26 14:11:13", "2025-12-26 14:11:13", "160982", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57660", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 14:11:13", "2025-12-26 14:11:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766758273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766758273;}", "9", "1", "2025-12-26 14:11:13", "2025-12-26 14:11:13", "160982", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57661", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 14:41:46", "2025-12-26 14:41:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766760106;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766760106;}", "9", "1", "2025-12-26 15:40:13", "2025-12-26 15:40:13", "160985", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57662", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 14:41:46", "2025-12-26 14:41:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766760106;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766760106;}", "9", "1", "2025-12-26 15:40:13", "2025-12-26 15:40:13", "160985", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57663", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 16:40:13", "2025-12-26 16:40:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766767213;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766767213;}", "13", "1", "2025-12-26 16:58:42", "2025-12-26 16:58:42", "160998", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57664", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 15:40:13", "2025-12-26 15:40:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766763613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766763613;}", "9", "1", "2025-12-26 16:13:07", "2025-12-26 16:13:07", "160987", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57665", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 15:40:13", "2025-12-26 15:40:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766763613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766763613;}", "9", "1", "2025-12-26 16:13:07", "2025-12-26 16:13:07", "160987", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57666", "woocommerce_scheduled_sales", "complete", "2025-12-27 16:13:07", "2025-12-27 16:13:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766851987;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766851987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-27 16:18:30", "2025-12-27 16:18:30", "161404", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57667", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 16:13:07", "2025-12-26 16:13:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766765587;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766765587;}", "9", "1", "2025-12-26 16:13:13", "2025-12-26 16:13:13", "160989", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57668", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 16:20:13", "2025-12-26 16:20:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766766013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766766013;}", "9", "1", "2025-12-26 16:20:14", "2025-12-26 16:20:14", "160992", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57669", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 16:31:26", "2025-12-26 16:31:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766766686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766766686;}", "9", "1", "2025-12-26 16:34:57", "2025-12-26 16:34:57", "160996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57670", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 16:31:26", "2025-12-26 16:31:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766766686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766766686;}", "9", "1", "2025-12-26 16:34:57", "2025-12-26 16:34:57", "160996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57671", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 16:34:57", "2025-12-26 16:34:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766766897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766766897;}", "9", "1", "2025-12-26 16:58:42", "2025-12-26 16:58:42", "160998", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57672", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 17:58:42", "2025-12-26 17:58:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766771922;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766771922;}", "13", "1", "2025-12-26 18:04:46", "2025-12-26 18:04:46", "161000", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57673", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 16:58:42", "2025-12-26 16:58:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766768322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766768322;}", "9", "1", "2025-12-26 18:04:46", "2025-12-26 18:04:46", "161000", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57674", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 18:04:46", "2025-12-26 18:04:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766772286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766772286;}", "9", "1", "2025-12-26 18:04:46", "2025-12-26 18:04:46", "161000", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57675", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 19:04:46", "2025-12-26 19:04:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766775886;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766775886;}", "13", "1", "2025-12-26 19:38:22", "2025-12-26 19:38:22", "161010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57676", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 18:04:46", "2025-12-26 18:04:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766772286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766772286;}", "9", "1", "2025-12-26 18:28:05", "2025-12-26 18:28:05", "161002", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57677", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 18:28:05", "2025-12-26 18:28:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766773685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766773685;}", "9", "1", "2025-12-26 18:35:57", "2025-12-26 18:35:57", "161004", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57678", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 18:35:57", "2025-12-26 18:35:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766774157;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766774157;}", "9", "1", "2025-12-26 18:35:57", "2025-12-26 18:35:57", "161006", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57679", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 18:35:57", "2025-12-26 18:35:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766774157;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766774157;}", "9", "1", "2025-12-26 18:35:57", "2025-12-26 18:35:57", "161006", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57680", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 18:40:30", "2025-12-26 18:40:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766774430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766774430;}", "9", "1", "2025-12-26 19:38:22", "2025-12-26 19:38:22", "161010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57681", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 20:38:22", "2025-12-26 20:38:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766781502;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766781502;}", "13", "1", "2025-12-26 20:53:58", "2025-12-26 20:53:58", "161020", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57682", "woocommerce_cleanup_draft_orders", "complete", "2025-12-27 19:38:22", "2025-12-27 19:38:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766864302;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766864302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-12-27 19:39:16", "2025-12-27 19:39:16", "161467", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57683", "wc_gla_cron_daily_notes", "complete", "2025-12-27 19:38:22", "2025-12-27 19:38:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766864302;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766864302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-27 19:39:16", "2025-12-27 19:39:16", "161467", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57684", "wc_facebook_regenerate_feed", "complete", "2025-12-27 19:38:32", "2025-12-27 19:38:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766864312;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766864312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-12-27 19:39:27", "2025-12-27 19:39:27", "161467", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57685", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 19:38:33", "2025-12-26 19:38:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766777913;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766777913;}", "9", "1", "2025-12-26 20:00:27", "2025-12-26 20:00:27", "161012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57686", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-26 19:38:33", "2025-12-26 19:38:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766777913;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766777913;}", "9", "1", "2025-12-26 20:00:27", "2025-12-26 20:00:27", "161012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57687", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 19:38:33", "2025-12-26 19:38:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766777913;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766777913;}", "9", "1", "2025-12-26 20:00:27", "2025-12-26 20:00:27", "161012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57688", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 20:00:27", "2025-12-26 20:00:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766779227;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766779227;}", "9", "1", "2025-12-26 20:00:28", "2025-12-26 20:00:28", "161013", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57689", "woocommerce_refresh_order_count_cache", "complete", "2025-12-27 08:00:27", "2025-12-27 08:00:27", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766822427;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766822427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-27 08:23:29", "2025-12-27 08:23:29", "161255", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57690", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 20:23:57", "2025-12-26 20:23:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766780637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766780637;}", "9", "1", "2025-12-26 20:24:17", "2025-12-26 20:24:17", "161016", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57691", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 21:53:58", "2025-12-26 21:53:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766786038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766786038;}", "13", "1", "2025-12-26 22:17:29", "2025-12-26 22:17:29", "161041", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57692", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 20:53:58", "2025-12-26 20:53:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766782438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766782438;}", "9", "1", "2025-12-26 20:54:04", "2025-12-26 20:54:04", "161022", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57693", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 20:53:59", "2025-12-26 20:53:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766782439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766782439;}", "9", "1", "2025-12-26 20:54:04", "2025-12-26 20:54:04", "161022", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57694", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 21:05:12", "2025-12-26 21:05:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766783112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766783112;}", "9", "1", "2025-12-26 21:05:12", "2025-12-26 21:05:12", "161026", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57695", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 21:09:57", "2025-12-26 21:09:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766783397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766783397;}", "9", "1", "2025-12-26 21:10:05", "2025-12-26 21:10:05", "161031", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57696", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 21:14:43", "2025-12-26 21:14:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766783683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766783683;}", "9", "1", "2025-12-26 21:14:49", "2025-12-26 21:14:49", "161035", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57697", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 21:26:40", "2025-12-26 21:26:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766784400;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766784400;}", "9", "1", "2025-12-26 21:26:49", "2025-12-26 21:26:49", "161038", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57698", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 21:52:22", "2025-12-26 21:52:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766785942;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766785942;}", "9", "1", "2025-12-26 22:17:29", "2025-12-26 22:17:29", "161041", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57699", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 21:52:22", "2025-12-26 21:52:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766785942;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766785942;}", "9", "1", "2025-12-26 22:17:29", "2025-12-26 22:17:29", "161041", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57700", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 23:17:29", "2025-12-26 23:17:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766791049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766791049;}", "13", "1", "2025-12-26 23:56:15", "2025-12-26 23:56:15", "161066", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57701", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 22:17:29", "2025-12-26 22:17:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766787449;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766787449;}", "9", "1", "2025-12-26 22:21:57", "2025-12-26 22:21:57", "161043", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57702", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 22:21:57", "2025-12-26 22:21:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766787717;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766787717;}", "9", "1", "2025-12-26 22:28:49", "2025-12-26 22:28:49", "161045", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57703", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 22:28:49", "2025-12-26 22:28:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766788129;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766788129;}", "9", "1", "2025-12-26 22:28:49", "2025-12-26 22:28:49", "161047", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57704", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 22:28:50", "2025-12-26 22:28:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766788130;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766788130;}", "9", "1", "2025-12-26 22:28:54", "2025-12-26 22:28:54", "161049", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57705", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 22:32:13", "2025-12-26 22:32:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766788333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766788333;}", "9", "1", "2025-12-26 22:32:19", "2025-12-26 22:32:19", "161053", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57706", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 22:39:07", "2025-12-26 22:39:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766788747;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766788747;}", "9", "1", "2025-12-26 22:39:23", "2025-12-26 22:39:23", "161057", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57707", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 22:45:03", "2025-12-26 22:45:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766789103;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766789103;}", "9", "1", "2025-12-26 22:45:10", "2025-12-26 22:45:10", "161061", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57708", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 22:51:37", "2025-12-26 22:51:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766789497;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766789497;}", "9", "1", "2025-12-26 23:13:19", "2025-12-26 23:13:19", "161064", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57709", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 23:13:19", "2025-12-26 23:13:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766790799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766790799;}", "9", "1", "2025-12-26 23:56:15", "2025-12-26 23:56:15", "161066", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57710", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 23:56:15", "2025-12-26 23:56:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766793375;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766793375;}", "9", "1", "2025-12-26 23:56:15", "2025-12-26 23:56:15", "161066", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57711", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 00:56:15", "2025-12-27 00:56:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766796975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766796975;}", "13", "1", "2025-12-27 01:06:11", "2025-12-27 01:06:11", "161084", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57712", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-26 23:56:15", "2025-12-26 23:56:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766793375;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766793375;}", "9", "1", "2025-12-26 23:56:20", "2025-12-26 23:56:20", "161068", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57713", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-26 23:58:53", "2025-12-26 23:58:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766793533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766793533;}", "9", "1", "2025-12-26 23:59:24", "2025-12-26 23:59:24", "161072", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57714", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 00:03:53", "2025-12-27 00:03:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766793833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766793833;}", "9", "1", "2025-12-27 00:04:01", "2025-12-27 00:04:01", "161077", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57715", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 00:48:20", "2025-12-27 00:48:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766796500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766796500;}", "9", "1", "2025-12-27 00:51:26", "2025-12-27 00:51:26", "161081", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57716", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 00:48:20", "2025-12-27 00:48:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766796500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766796500;}", "9", "1", "2025-12-27 00:51:26", "2025-12-27 00:51:26", "161081", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57717", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 00:51:26", "2025-12-27 00:51:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766796686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766796686;}", "9", "1", "2025-12-27 00:51:26", "2025-12-27 00:51:26", "161081", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57718", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 02:06:11", "2025-12-27 02:06:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766801171;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766801171;}", "13", "1", "2025-12-27 02:16:55", "2025-12-27 02:16:55", "161096", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57719", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 01:06:11", "2025-12-27 01:06:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766797571;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766797571;}", "9", "1", "2025-12-27 01:06:16", "2025-12-27 01:06:16", "161086", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57720", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 01:11:05", "2025-12-27 01:11:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766797865;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766797865;}", "9", "1", "2025-12-27 01:11:12", "2025-12-27 01:11:12", "161090", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57721", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 01:32:36", "2025-12-27 01:32:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766799156;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766799156;}", "9", "1", "2025-12-27 01:32:54", "2025-12-27 01:32:54", "161094", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57722", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 01:32:36", "2025-12-27 01:32:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766799156;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766799156;}", "9", "1", "2025-12-27 01:32:54", "2025-12-27 01:32:54", "161094", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57723", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 03:16:55", "2025-12-27 03:16:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766805415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766805415;}", "13", "1", "2025-12-27 03:17:16", "2025-12-27 03:17:16", "161109", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57724", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 02:16:55", "2025-12-27 02:16:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766801815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766801815;}", "9", "1", "2025-12-27 02:17:02", "2025-12-27 02:17:02", "161098", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57725", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 02:32:21", "2025-12-27 02:32:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766802741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766802741;}", "9", "1", "2025-12-27 02:34:44", "2025-12-27 02:34:44", "161101", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57726", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 02:32:21", "2025-12-27 02:32:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766802741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766802741;}", "9", "1", "2025-12-27 02:34:44", "2025-12-27 02:34:44", "161101", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57727", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 02:34:44", "2025-12-27 02:34:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766802884;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766802884;}", "9", "1", "2025-12-27 02:41:29", "2025-12-27 02:41:29", "161103", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57728", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 02:41:29", "2025-12-27 02:41:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766803289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766803289;}", "9", "1", "2025-12-27 02:41:33", "2025-12-27 02:41:33", "161105", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57729", "gla/jobs/resubmit_expiring_products/start", "complete", "2025-12-28 03:00:00", "2025-12-28 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766890800;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1766890800;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2025-12-28 03:08:31", "2025-12-28 03:08:31", "161544", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57730", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:00:33", "2025-12-27 03:00:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766804433;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766804433;}", "9", "1", "2025-12-27 03:17:16", "2025-12-27 03:17:16", "161109", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57731", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 04:17:16", "2025-12-27 04:17:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766809036;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766809036;}", "13", "1", "2025-12-27 04:19:16", "2025-12-27 04:19:16", "161145", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57732", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:17:17", "2025-12-27 03:17:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766805437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766805437;}", "9", "1", "2025-12-27 03:20:25", "2025-12-27 03:20:25", "161111", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57733", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:20:25", "2025-12-27 03:20:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766805625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766805625;}", "9", "1", "2025-12-27 03:21:46", "2025-12-27 03:21:46", "161113", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57734", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:27:21", "2025-12-27 03:27:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766806041;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766806041;}", "9", "1", "2025-12-27 03:27:26", "2025-12-27 03:27:26", "161116", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57735", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:31:13", "2025-12-27 03:31:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766806273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766806273;}", "9", "1", "2025-12-27 03:35:20", "2025-12-27 03:35:20", "161119", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57736", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 03:31:13", "2025-12-27 03:31:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766806273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766806273;}", "9", "1", "2025-12-27 03:35:20", "2025-12-27 03:35:20", "161119", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57737", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:35:20", "2025-12-27 03:35:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766806520;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766806520;}", "9", "1", "2025-12-27 03:35:21", "2025-12-27 03:35:21", "161121", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57738", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:38:51", "2025-12-27 03:38:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766806731;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766806731;}", "9", "1", "2025-12-27 03:39:31", "2025-12-27 03:39:31", "161126", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57739", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 03:58:51", "2025-12-27 03:58:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766807931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766807931;}", "9", "1", "2025-12-27 04:01:37", "2025-12-27 04:01:37", "161134", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57740", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:05:29", "2025-12-27 04:05:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766808329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766808329;}", "9", "1", "2025-12-27 04:06:52", "2025-12-27 04:06:52", "161137", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57741", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:09:24", "2025-12-27 04:09:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766808564;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766808564;}", "9", "1", "2025-12-27 04:13:34", "2025-12-27 04:13:34", "161140", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57742", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:15:19", "2025-12-27 04:15:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766808919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766808919;}", "9", "1", "2025-12-27 04:15:19", "2025-12-27 04:15:19", "161142", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57743", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 05:19:16", "2025-12-27 05:19:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766812756;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766812756;}", "13", "1", "2025-12-27 05:19:34", "2025-12-27 05:19:34", "161189", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57744", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:19:16", "2025-12-27 04:19:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766809156;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766809156;}", "9", "1", "2025-12-27 04:21:08", "2025-12-27 04:21:08", "161147", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57745", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:24:14", "2025-12-27 04:24:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766809454;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766809454;}", "9", "1", "2025-12-27 04:24:17", "2025-12-27 04:24:17", "161151", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57746", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:29:00", "2025-12-27 04:29:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766809740;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766809740;}", "9", "1", "2025-12-27 04:29:07", "2025-12-27 04:29:07", "161156", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57747", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 04:30:58", "2025-12-27 04:30:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766809858;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766809858;}", "9", "1", "2025-12-27 04:31:38", "2025-12-27 04:31:38", "161160", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57748", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:36:52", "2025-12-27 04:36:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766810212;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766810212;}", "9", "1", "2025-12-27 04:36:52", "2025-12-27 04:36:52", "161163", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57749", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:43:21", "2025-12-27 04:43:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766810601;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766810601;}", "9", "1", "2025-12-27 04:46:40", "2025-12-27 04:46:40", "161166", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57750", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:46:40", "2025-12-27 04:46:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766810800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766810800;}", "9", "1", "2025-12-27 04:46:40", "2025-12-27 04:46:40", "161166", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57751", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:50:21", "2025-12-27 04:50:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766811021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766811021;}", "9", "1", "2025-12-27 04:51:53", "2025-12-27 04:51:53", "161170", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57752", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 04:54:45", "2025-12-27 04:54:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766811285;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766811285;}", "9", "1", "2025-12-27 04:54:45", "2025-12-27 04:54:45", "161173", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57753", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:00:24", "2025-12-27 05:00:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766811624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766811624;}", "9", "1", "2025-12-27 05:03:35", "2025-12-27 05:03:35", "161178", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57754", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:07:32", "2025-12-27 05:07:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766812052;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766812052;}", "9", "1", "2025-12-27 05:07:32", "2025-12-27 05:07:32", "161180", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57755", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:09:28", "2025-12-27 05:09:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766812168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766812168;}", "9", "1", "2025-12-27 05:09:28", "2025-12-27 05:09:28", "161183", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57756", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:16:36", "2025-12-27 05:16:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766812596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766812596;}", "9", "1", "2025-12-27 05:18:17", "2025-12-27 05:18:17", "161187", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57757", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:19:34", "2025-12-27 05:19:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766812774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766812774;}", "9", "1", "2025-12-27 05:19:34", "2025-12-27 05:19:34", "161189", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57758", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 06:19:34", "2025-12-27 06:19:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766816374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766816374;}", "13", "1", "2025-12-27 06:19:50", "2025-12-27 06:19:50", "161235", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57759", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:25:51", "2025-12-27 05:25:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766813151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766813151;}", "9", "1", "2025-12-27 05:25:51", "2025-12-27 05:25:51", "161192", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57760", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:30:53", "2025-12-27 05:30:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766813453;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766813453;}", "9", "1", "2025-12-27 05:33:59", "2025-12-27 05:33:59", "161196", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57761", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 05:30:53", "2025-12-27 05:30:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766813453;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766813453;}", "9", "1", "2025-12-27 05:33:59", "2025-12-27 05:33:59", "161196", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57762", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:33:59", "2025-12-27 05:33:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766813639;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766813639;}", "9", "1", "2025-12-27 05:39:45", "2025-12-27 05:39:45", "161198", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57763", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:39:45", "2025-12-27 05:39:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766813985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766813985;}", "9", "1", "2025-12-27 05:40:46", "2025-12-27 05:40:46", "161200", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57764", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:44:24", "2025-12-27 05:44:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766814264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766814264;}", "9", "1", "2025-12-27 05:48:10", "2025-12-27 05:48:10", "161204", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57765", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:51:20", "2025-12-27 05:51:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766814680;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766814680;}", "9", "1", "2025-12-27 05:51:23", "2025-12-27 05:51:23", "161207", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57766", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:55:08", "2025-12-27 05:55:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766814908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766814908;}", "9", "1", "2025-12-27 05:55:08", "2025-12-27 05:55:08", "161212", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57767", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 05:59:53", "2025-12-27 05:59:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766815193;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766815193;}", "9", "1", "2025-12-27 05:59:53", "2025-12-27 05:59:53", "161218", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57769", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 06:04:22", "2025-12-27 06:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766815462;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766815462;}", "9", "1", "2025-12-27 06:04:22", "2025-12-27 06:04:22", "161224", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57770", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 06:08:50", "2025-12-27 06:08:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766815730;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766815730;}", "9", "1", "2025-12-27 06:11:10", "2025-12-27 06:11:10", "161228", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57771", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 06:15:01", "2025-12-27 06:15:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766816101;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766816101;}", "9", "1", "2025-12-27 06:15:37", "2025-12-27 06:15:37", "161232", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57772", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 07:19:50", "2025-12-27 07:19:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766819990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766819990;}", "13", "1", "2025-12-27 07:22:21", "2025-12-27 07:22:21", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57773", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 06:19:50", "2025-12-27 06:19:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766816390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766816390;}", "9", "1", "2025-12-27 06:22:11", "2025-12-27 06:22:11", "161237", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57774", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 06:32:55", "2025-12-27 06:32:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766817175;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766817175;}", "9", "1", "2025-12-27 06:32:55", "2025-12-27 06:32:55", "161240", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57775", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 06:32:56", "2025-12-27 06:32:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766817176;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766817176;}", "9", "1", "2025-12-27 07:22:19", "2025-12-27 07:22:19", "161242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57776", "wc_admin_daily_wrapper", "complete", "2025-12-28 07:22:20", "2025-12-28 07:22:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766906540;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766906540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-28 07:22:23", "2025-12-28 07:22:23", "161629", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57777", "woocommerce_cleanup_personal_data", "complete", "2025-12-28 07:22:20", "2025-12-28 07:22:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766906540;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766906540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-28 07:22:24", "2025-12-28 07:22:24", "161629", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57778", "woocommerce_tracker_send_event_wrapper", "complete", "2025-12-28 07:22:20", "2025-12-28 07:22:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766906540;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766906540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-28 07:22:24", "2025-12-28 07:22:24", "161629", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57779", "woocommerce_cleanup_logs", "complete", "2025-12-28 07:22:20", "2025-12-28 07:22:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766906540;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766906540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-28 07:22:24", "2025-12-28 07:22:24", "161629", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57780", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-28 07:22:20", "2025-12-28 07:22:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766906540;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766906540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-28 07:22:24", "2025-12-28 07:22:24", "161629", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57781", "fetch_patterns", "complete", "2025-12-28 07:22:21", "2025-12-28 07:22:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766906541;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766906541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-28 07:22:24", "2025-12-28 07:22:24", "161629", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57782", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 08:22:21", "2025-12-27 08:22:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766823741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766823741;}", "13", "1", "2025-12-27 08:23:29", "2025-12-27 08:23:29", "161255", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57783", "woocommerce_cleanup_sessions", "complete", "2025-12-28 06:00:00", "2025-12-28 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766901600;s:18:\"\0*\0first_timestamp\";i:1766901600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766901600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2025-12-28 06:24:16", "2025-12-28 06:24:16", "161598", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57784", "generate_category_lookup_table_wrapper", "complete", "2025-12-27 07:22:31", "2025-12-27 07:22:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766820151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766820151;}", "13", "1", "2025-12-27 07:22:32", "2025-12-27 07:22:32", "161246", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57785", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-28 07:22:21", "2025-12-28 07:22:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766906541;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766906541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-28 07:22:24", "2025-12-28 07:22:24", "161629", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57786", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 07:22:21", "2025-12-27 07:22:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766820141;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766820141;}", "9", "1", "2025-12-27 07:22:26", "2025-12-27 07:22:26", "161244", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57787", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-27 07:22:21", "2025-12-27 07:22:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766820141;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766820141;}", "9", "1", "2025-12-27 07:22:26", "2025-12-27 07:22:26", "161244", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57788", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 07:24:20", "2025-12-27 07:24:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766820260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766820260;}", "9", "1", "2025-12-27 07:33:47", "2025-12-27 07:33:47", "161249", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57789", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 07:33:47", "2025-12-27 07:33:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766820827;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766820827;}", "9", "1", "2025-12-27 07:33:47", "2025-12-27 07:33:47", "161251", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57790", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 07:33:47", "2025-12-27 07:33:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766820827;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766820827;}", "9", "1", "2025-12-27 07:33:47", "2025-12-27 07:33:47", "161251", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57791", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 07:41:56", "2025-12-27 07:41:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766821316;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766821316;}", "9", "1", "2025-12-27 07:41:56", "2025-12-27 07:41:56", "161253", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57792", "woocommerce_refresh_order_count_cache", "complete", "2025-12-27 20:23:29", "2025-12-27 20:23:29", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766867009;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766867009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-27 20:25:55", "2025-12-27 20:25:55", "161488", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57793", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 09:23:29", "2025-12-27 09:23:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766827409;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766827409;}", "13", "1", "2025-12-27 09:32:34", "2025-12-27 09:32:34", "161280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57794", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 08:23:29", "2025-12-27 08:23:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766823809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766823809;}", "9", "1", "2025-12-27 08:23:38", "2025-12-27 08:23:38", "161257", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57795", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 08:27:40", "2025-12-27 08:27:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766824060;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766824060;}", "9", "1", "2025-12-27 08:27:40", "2025-12-27 08:27:40", "161259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57796", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 08:37:16", "2025-12-27 08:37:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766824636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766824636;}", "9", "1", "2025-12-27 08:37:23", "2025-12-27 08:37:23", "161262", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57797", "facebook_for_woocommerce_daily_heartbeat", "complete", "2025-12-27 08:37:17", "2025-12-27 08:37:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766824637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766824637;}", "9", "1", "2025-12-27 08:37:42", "2025-12-27 08:37:42", "161262", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57798", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 08:37:17", "2025-12-27 08:37:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766824637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766824637;}", "9", "1", "2025-12-27 08:37:47", "2025-12-27 08:37:47", "161263", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57799", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 08:56:18", "2025-12-27 08:56:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766825778;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766825778;}", "9", "1", "2025-12-27 08:56:27", "2025-12-27 08:56:27", "161266", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57800", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 08:59:28", "2025-12-27 08:59:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766825968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766825968;}", "9", "1", "2025-12-27 08:59:45", "2025-12-27 08:59:45", "161270", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57801", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:09:17", "2025-12-27 09:09:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766826557;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766826557;}", "9", "1", "2025-12-27 09:09:31", "2025-12-27 09:09:31", "161273", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57802", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:13:50", "2025-12-27 09:13:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766826830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766826830;}", "9", "1", "2025-12-27 09:21:02", "2025-12-27 09:21:02", "161276", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57803", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:21:02", "2025-12-27 09:21:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766827262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766827262;}", "9", "1", "2025-12-27 09:21:07", "2025-12-27 09:21:07", "161278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57804", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 10:32:34", "2025-12-27 10:32:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766831554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766831554;}", "13", "1", "2025-12-27 10:55:06", "2025-12-27 10:55:06", "161307", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57805", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:32:34", "2025-12-27 09:32:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766827954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766827954;}", "9", "1", "2025-12-27 09:32:41", "2025-12-27 09:32:41", "161282", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57806", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 09:32:34", "2025-12-27 09:32:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766827954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766827954;}", "9", "1", "2025-12-27 09:32:41", "2025-12-27 09:32:41", "161282", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57807", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:40:49", "2025-12-27 09:40:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766828449;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766828449;}", "9", "1", "2025-12-27 09:40:54", "2025-12-27 09:40:54", "161285", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57808", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:44:07", "2025-12-27 09:44:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766828647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766828647;}", "9", "1", "2025-12-27 09:44:13", "2025-12-27 09:44:13", "161288", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57809", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:49:25", "2025-12-27 09:49:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766828965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766828965;}", "9", "1", "2025-12-27 09:49:30", "2025-12-27 09:49:30", "161292", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57810", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 09:58:37", "2025-12-27 09:58:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766829517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766829517;}", "9", "1", "2025-12-27 09:58:43", "2025-12-27 09:58:43", "161295", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57811", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 10:08:18", "2025-12-27 10:08:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766830098;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766830098;}", "9", "1", "2025-12-27 10:08:18", "2025-12-27 10:08:18", "161297", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57812", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 10:13:08", "2025-12-27 10:13:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766830388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766830388;}", "9", "1", "2025-12-27 10:13:08", "2025-12-27 10:13:08", "161299", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57813", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 10:17:58", "2025-12-27 10:17:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766830678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766830678;}", "9", "1", "2025-12-27 10:18:06", "2025-12-27 10:18:06", "161302", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57814", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 10:31:19", "2025-12-27 10:31:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766831479;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766831479;}", "9", "1", "2025-12-27 10:31:29", "2025-12-27 10:31:29", "161305", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57815", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 10:31:19", "2025-12-27 10:31:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766831479;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766831479;}", "9", "1", "2025-12-27 10:31:29", "2025-12-27 10:31:29", "161305", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57816", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 11:55:06", "2025-12-27 11:55:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766836506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766836506;}", "13", "1", "2025-12-27 12:11:57", "2025-12-27 12:11:57", "161322", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57817", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 10:55:06", "2025-12-27 10:55:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766832906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766832906;}", "9", "1", "2025-12-27 10:55:12", "2025-12-27 10:55:12", "161309", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57818", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 11:15:17", "2025-12-27 11:15:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766834117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766834117;}", "9", "1", "2025-12-27 11:15:24", "2025-12-27 11:15:24", "161313", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57819", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 11:36:51", "2025-12-27 11:36:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766835411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766835411;}", "9", "1", "2025-12-27 11:36:57", "2025-12-27 11:36:57", "161316", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57820", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 11:36:51", "2025-12-27 11:36:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766835411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766835411;}", "9", "1", "2025-12-27 11:36:57", "2025-12-27 11:36:57", "161316", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57821", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 11:49:39", "2025-12-27 11:49:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766836179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766836179;}", "9", "1", "2025-12-27 11:49:47", "2025-12-27 11:49:47", "161319", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57822", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 13:11:57", "2025-12-27 13:11:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766841117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766841117;}", "13", "1", "2025-12-27 13:12:18", "2025-12-27 13:12:18", "161343", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57823", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 12:11:57", "2025-12-27 12:11:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766837517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766837517;}", "9", "1", "2025-12-27 12:12:04", "2025-12-27 12:12:04", "161324", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57824", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 12:16:41", "2025-12-27 12:16:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766837801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766837801;}", "9", "1", "2025-12-27 12:16:49", "2025-12-27 12:16:49", "161327", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57825", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 12:18:51", "2025-12-27 12:18:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766837931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766837931;}", "9", "1", "2025-12-27 12:23:41", "2025-12-27 12:23:41", "161330", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57826", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 12:23:55", "2025-12-27 12:23:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766838235;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766838235;}", "9", "1", "2025-12-27 12:25:05", "2025-12-27 12:25:05", "161332", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57827", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 12:29:21", "2025-12-27 12:29:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766838561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766838561;}", "9", "1", "2025-12-27 12:29:27", "2025-12-27 12:29:27", "161336", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57828", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 12:52:28", "2025-12-27 12:52:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766839948;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766839948;}", "9", "1", "2025-12-27 13:08:00", "2025-12-27 13:08:00", "161339", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57829", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 12:52:28", "2025-12-27 12:52:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766839948;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766839948;}", "9", "1", "2025-12-27 13:08:00", "2025-12-27 13:08:00", "161339", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57830", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 13:08:00", "2025-12-27 13:08:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766840880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766840880;}", "9", "1", "2025-12-27 13:08:05", "2025-12-27 13:08:05", "161341", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57831", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 14:12:18", "2025-12-27 14:12:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766844738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766844738;}", "13", "1", "2025-12-27 14:17:21", "2025-12-27 14:17:21", "161367", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57832", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 13:12:18", "2025-12-27 13:12:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766841138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766841138;}", "9", "1", "2025-12-27 13:12:25", "2025-12-27 13:12:25", "161345", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57833", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 13:16:30", "2025-12-27 13:16:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766841390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766841390;}", "9", "1", "2025-12-27 13:16:35", "2025-12-27 13:16:35", "161348", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57834", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 13:20:48", "2025-12-27 13:20:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766841648;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766841648;}", "9", "1", "2025-12-27 13:20:55", "2025-12-27 13:20:55", "161351", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57835", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 13:25:05", "2025-12-27 13:25:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766841905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766841905;}", "9", "1", "2025-12-27 13:25:12", "2025-12-27 13:25:12", "161355", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57836", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 13:36:18", "2025-12-27 13:36:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766842578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766842578;}", "9", "1", "2025-12-27 13:37:56", "2025-12-27 13:37:56", "161359", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57837", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 13:36:18", "2025-12-27 13:36:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766842578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766842578;}", "9", "1", "2025-12-27 13:37:56", "2025-12-27 13:37:56", "161359", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57838", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:02:41", "2025-12-27 14:02:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766844161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766844161;}", "9", "1", "2025-12-27 14:09:10", "2025-12-27 14:09:10", "161362", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57839", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:09:10", "2025-12-27 14:09:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766844550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766844550;}", "9", "1", "2025-12-27 14:09:17", "2025-12-27 14:09:17", "161364", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57840", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 15:17:21", "2025-12-27 15:17:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766848641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766848641;}", "13", "1", "2025-12-27 15:29:56", "2025-12-27 15:29:56", "161391", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57841", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:17:21", "2025-12-27 14:17:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766845041;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766845041;}", "9", "1", "2025-12-27 14:17:26", "2025-12-27 14:17:26", "161369", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57842", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:20:44", "2025-12-27 14:20:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766845244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766845244;}", "9", "1", "2025-12-27 14:20:48", "2025-12-27 14:20:48", "161372", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57843", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:24:30", "2025-12-27 14:24:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766845470;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766845470;}", "9", "1", "2025-12-27 14:24:37", "2025-12-27 14:24:37", "161376", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57844", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:40:39", "2025-12-27 14:40:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766846439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766846439;}", "9", "1", "2025-12-27 14:40:52", "2025-12-27 14:40:52", "161379", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57845", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 14:40:39", "2025-12-27 14:40:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766846439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766846439;}", "9", "1", "2025-12-27 14:40:52", "2025-12-27 14:40:52", "161379", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57846", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:45:40", "2025-12-27 14:45:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766846740;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766846740;}", "9", "1", "2025-12-27 14:45:48", "2025-12-27 14:45:48", "161382", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57847", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 14:48:59", "2025-12-27 14:48:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766846939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766846939;}", "9", "1", "2025-12-27 14:49:06", "2025-12-27 14:49:06", "161387", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57848", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 16:29:56", "2025-12-27 16:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766852996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766852996;}", "13", "1", "2025-12-27 16:37:17", "2025-12-27 16:37:17", "161408", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57849", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 15:29:56", "2025-12-27 15:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766849396;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766849396;}", "9", "1", "2025-12-27 15:37:34", "2025-12-27 15:37:34", "161393", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57850", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 15:37:34", "2025-12-27 15:37:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766849854;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766849854;}", "9", "1", "2025-12-27 15:58:29", "2025-12-27 15:58:29", "161395", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57851", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 15:37:34", "2025-12-27 15:37:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766849854;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766849854;}", "9", "1", "2025-12-27 15:58:29", "2025-12-27 15:58:29", "161395", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57852", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 15:58:29", "2025-12-27 15:58:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766851109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766851109;}", "9", "1", "2025-12-27 15:58:38", "2025-12-27 15:58:38", "161397", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57853", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:01:37", "2025-12-27 16:01:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766851297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766851297;}", "9", "1", "2025-12-27 16:01:37", "2025-12-27 16:01:37", "161399", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57854", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:08:18", "2025-12-27 16:08:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766851698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766851698;}", "9", "1", "2025-12-27 16:11:33", "2025-12-27 16:11:33", "161402", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57855", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:11:33", "2025-12-27 16:11:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766851893;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766851893;}", "9", "1", "2025-12-27 16:11:33", "2025-12-27 16:11:33", "161402", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57856", "woocommerce_scheduled_sales", "complete", "2025-12-28 16:18:30", "2025-12-28 16:18:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766938710;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766938710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-28 16:25:58", "2025-12-28 16:25:58", "161747", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57857", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:18:30", "2025-12-27 16:18:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766852310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766852310;}", "9", "1", "2025-12-27 16:18:35", "2025-12-27 16:18:35", "161406", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57858", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:37:17", "2025-12-27 16:37:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766853437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766853437;}", "9", "1", "2025-12-27 16:37:17", "2025-12-27 16:37:17", "161408", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57859", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 17:37:17", "2025-12-27 17:37:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766857037;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766857037;}", "13", "1", "2025-12-27 17:55:55", "2025-12-27 17:55:55", "161446", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57860", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 16:37:17", "2025-12-27 16:37:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766853437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766853437;}", "9", "1", "2025-12-27 16:37:23", "2025-12-27 16:37:23", "161410", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57861", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:39:12", "2025-12-27 16:39:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766853552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766853552;}", "9", "1", "2025-12-27 16:39:17", "2025-12-27 16:39:17", "161413", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57862", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:45:09", "2025-12-27 16:45:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766853909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766853909;}", "9", "1", "2025-12-27 16:45:15", "2025-12-27 16:45:15", "161416", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57863", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 16:54:16", "2025-12-27 16:54:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766854456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766854456;}", "9", "1", "2025-12-27 16:56:07", "2025-12-27 16:56:07", "161420", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57864", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 17:09:48", "2025-12-27 17:09:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766855388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766855388;}", "9", "1", "2025-12-27 17:13:09", "2025-12-27 17:13:09", "161424", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57865", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 17:14:04", "2025-12-27 17:14:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766855644;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766855644;}", "9", "1", "2025-12-27 17:14:08", "2025-12-27 17:14:08", "161427", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57866", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 17:19:30", "2025-12-27 17:19:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766855970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766855970;}", "9", "1", "2025-12-27 17:19:38", "2025-12-27 17:19:38", "161432", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57867", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 17:26:05", "2025-12-27 17:26:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766856365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766856365;}", "9", "1", "2025-12-27 17:26:12", "2025-12-27 17:26:12", "161436", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57868", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 17:30:21", "2025-12-27 17:30:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766856621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766856621;}", "9", "1", "2025-12-27 17:30:29", "2025-12-27 17:30:29", "161440", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57869", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 17:34:37", "2025-12-27 17:34:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766856877;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766856877;}", "9", "1", "2025-12-27 17:34:38", "2025-12-27 17:34:38", "161442", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57870", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 17:34:38", "2025-12-27 17:34:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766856878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766856878;}", "9", "1", "2025-12-27 17:34:45", "2025-12-27 17:34:45", "161444", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57871", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 18:55:55", "2025-12-27 18:55:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766861755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766861755;}", "13", "1", "2025-12-27 19:02:43", "2025-12-27 19:02:43", "161458", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57872", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 17:55:55", "2025-12-27 17:55:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766858155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766858155;}", "9", "1", "2025-12-27 17:56:08", "2025-12-27 17:56:08", "161448", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57873", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 18:23:43", "2025-12-27 18:23:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766859823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766859823;}", "9", "1", "2025-12-27 18:23:48", "2025-12-27 18:23:48", "161452", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57874", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 18:23:51", "2025-12-27 18:23:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766859831;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766859831;}", "9", "1", "2025-12-27 18:23:53", "2025-12-27 18:23:53", "161454", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57875", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 20:02:43", "2025-12-27 20:02:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766865763;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766865763;}", "13", "1", "2025-12-27 20:03:28", "2025-12-27 20:03:28", "161483", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57876", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 19:02:43", "2025-12-27 19:02:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766862163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766862163;}", "9", "1", "2025-12-27 19:02:47", "2025-12-27 19:02:47", "161460", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57877", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 19:02:43", "2025-12-27 19:02:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766862163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766862163;}", "9", "1", "2025-12-27 19:02:47", "2025-12-27 19:02:47", "161460", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57878", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-27 19:02:43", "2025-12-27 19:02:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766862163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766862163;}", "9", "1", "2025-12-27 19:02:47", "2025-12-27 19:02:47", "161460", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57879", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 19:03:50", "2025-12-27 19:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766862230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766862230;}", "9", "1", "2025-12-27 19:17:11", "2025-12-27 19:17:11", "161463", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57880", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 19:17:11", "2025-12-27 19:17:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766863031;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766863031;}", "9", "1", "2025-12-27 19:17:17", "2025-12-27 19:17:17", "161465", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57881", "woocommerce_cleanup_draft_orders", "complete", "2025-12-28 19:39:16", "2025-12-28 19:39:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766950756;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766950756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-12-28 19:50:26", "2025-12-28 19:50:26", "161785", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57882", "wc_gla_cron_daily_notes", "complete", "2025-12-28 19:39:16", "2025-12-28 19:39:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766950756;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766950756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-28 19:50:26", "2025-12-28 19:50:26", "161785", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57883", "wc_facebook_regenerate_feed", "complete", "2025-12-28 19:39:27", "2025-12-28 19:39:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766950767;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766950767;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-12-28 19:50:37", "2025-12-28 19:50:37", "161785", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57884", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 19:39:27", "2025-12-27 19:39:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766864367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766864367;}", "9", "1", "2025-12-27 19:39:31", "2025-12-27 19:39:31", "161469", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57885", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 19:39:27", "2025-12-27 19:39:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766864367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766864367;}", "9", "1", "2025-12-27 19:39:31", "2025-12-27 19:39:31", "161469", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57886", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 19:45:41", "2025-12-27 19:45:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766864741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766864741;}", "9", "1", "2025-12-27 19:45:41", "2025-12-27 19:45:41", "161474", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57887", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 19:55:35", "2025-12-27 19:55:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766865335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766865335;}", "9", "1", "2025-12-27 19:57:43", "2025-12-27 19:57:43", "161478", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57888", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 19:59:51", "2025-12-27 19:59:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766865591;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766865591;}", "9", "1", "2025-12-27 19:59:56", "2025-12-27 19:59:56", "161481", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57889", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 21:03:28", "2025-12-27 21:03:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766869408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766869408;}", "13", "1", "2025-12-27 21:07:01", "2025-12-27 21:07:01", "161490", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57890", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 20:14:18", "2025-12-27 20:14:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766866458;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766866458;}", "9", "1", "2025-12-27 20:14:18", "2025-12-27 20:14:18", "161485", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57891", "woocommerce_refresh_order_count_cache", "complete", "2025-12-28 08:25:55", "2025-12-28 08:25:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766910355;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766910355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-28 08:39:40", "2025-12-28 08:39:40", "161658", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57892", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 20:25:55", "2025-12-27 20:25:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766867155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766867155;}", "9", "1", "2025-12-27 21:07:01", "2025-12-27 21:07:01", "161490", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57893", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 22:07:01", "2025-12-27 22:07:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766873221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766873221;}", "13", "1", "2025-12-27 22:07:19", "2025-12-27 22:07:19", "161498", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57894", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 21:07:01", "2025-12-27 21:07:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766869621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766869621;}", "9", "1", "2025-12-27 21:08:08", "2025-12-27 21:08:08", "161492", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57895", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 21:07:02", "2025-12-27 21:07:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766869622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766869622;}", "9", "1", "2025-12-27 21:08:08", "2025-12-27 21:08:08", "161492", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57896", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 21:55:39", "2025-12-27 21:55:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766872539;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766872539;}", "9", "1", "2025-12-27 21:55:43", "2025-12-27 21:55:43", "161495", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57897", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 21:55:39", "2025-12-27 21:55:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766872539;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766872539;}", "9", "1", "2025-12-27 21:55:43", "2025-12-27 21:55:43", "161495", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57898", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 22:06:57", "2025-12-27 22:06:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766873217;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766873217;}", "9", "1", "2025-12-27 22:07:19", "2025-12-27 22:07:19", "161498", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57899", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 23:07:19", "2025-12-27 23:07:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766876839;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766876839;}", "13", "1", "2025-12-27 23:13:12", "2025-12-27 23:13:12", "161517", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57900", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 22:12:57", "2025-12-27 22:12:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766873577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766873577;}", "9", "1", "2025-12-27 22:18:46", "2025-12-27 22:18:46", "161502", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57901", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 22:18:46", "2025-12-27 22:18:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766873926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766873926;}", "9", "1", "2025-12-27 22:18:52", "2025-12-27 22:18:52", "161504", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57902", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 22:18:51", "2025-12-27 22:18:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766873931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766873931;}", "9", "1", "2025-12-27 22:18:52", "2025-12-27 22:18:52", "161504", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57903", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 22:26:44", "2025-12-27 22:26:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766874404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766874404;}", "9", "1", "2025-12-27 22:26:50", "2025-12-27 22:26:50", "161508", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57904", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 22:30:37", "2025-12-27 22:30:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766874637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766874637;}", "9", "1", "2025-12-27 22:30:42", "2025-12-27 22:30:42", "161511", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57905", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-27 22:30:47", "2025-12-27 22:30:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766874647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766874647;}", "9", "1", "2025-12-27 23:00:54", "2025-12-27 23:00:54", "161513", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57906", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 23:00:54", "2025-12-27 23:00:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766876454;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766876454;}", "9", "1", "2025-12-27 23:04:44", "2025-12-27 23:04:44", "161515", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57907", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 23:04:44", "2025-12-27 23:04:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766876684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766876684;}", "9", "1", "2025-12-27 23:13:12", "2025-12-27 23:13:12", "161517", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57908", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 00:13:12", "2025-12-28 00:13:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766880792;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766880792;}", "13", "1", "2025-12-28 00:17:00", "2025-12-28 00:17:00", "161519", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57909", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-27 23:13:12", "2025-12-27 23:13:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766877192;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766877192;}", "9", "1", "2025-12-28 00:17:00", "2025-12-28 00:17:00", "161519", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57910", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 01:17:00", "2025-12-28 01:17:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766884620;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766884620;}", "13", "1", "2025-12-28 01:28:00", "2025-12-28 01:28:00", "161526", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57911", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 00:17:00", "2025-12-28 00:17:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766881020;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766881020;}", "9", "1", "2025-12-28 00:17:16", "2025-12-28 00:17:16", "161521", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57912", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 00:17:01", "2025-12-28 00:17:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766881021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766881021;}", "9", "1", "2025-12-28 00:17:16", "2025-12-28 00:17:16", "161521", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57913", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 00:38:54", "2025-12-28 00:38:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766882334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766882334;}", "9", "1", "2025-12-28 01:01:56", "2025-12-28 01:01:56", "161524", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57914", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 00:38:54", "2025-12-28 00:38:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766882334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766882334;}", "9", "1", "2025-12-28 01:01:56", "2025-12-28 01:01:56", "161524", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57915", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 01:01:56", "2025-12-28 01:01:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766883716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766883716;}", "9", "1", "2025-12-28 01:28:00", "2025-12-28 01:28:00", "161526", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57916", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 02:28:00", "2025-12-28 02:28:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766888880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766888880;}", "13", "1", "2025-12-28 02:31:18", "2025-12-28 02:31:18", "161536", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57917", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 01:28:00", "2025-12-28 01:28:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766885280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766885280;}", "9", "1", "2025-12-28 01:28:16", "2025-12-28 01:28:16", "161528", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57918", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 02:13:10", "2025-12-28 02:13:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766887990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766887990;}", "9", "1", "2025-12-28 02:13:10", "2025-12-28 02:13:10", "161530", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57919", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 02:13:10", "2025-12-28 02:13:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766887990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766887990;}", "9", "1", "2025-12-28 02:13:25", "2025-12-28 02:13:25", "161532", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57920", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 02:16:21", "2025-12-28 02:16:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766888181;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766888181;}", "9", "1", "2025-12-28 02:16:21", "2025-12-28 02:16:21", "161534", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57921", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 03:31:18", "2025-12-28 03:31:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766892678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766892678;}", "13", "1", "2025-12-28 03:31:23", "2025-12-28 03:31:23", "161565", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57922", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 02:31:18", "2025-12-28 02:31:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766889078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766889078;}", "9", "1", "2025-12-28 02:48:38", "2025-12-28 02:48:38", "161538", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57923", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 02:31:18", "2025-12-28 02:31:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766889078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766889078;}", "9", "1", "2025-12-28 02:48:38", "2025-12-28 02:48:38", "161538", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57924", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 02:48:38", "2025-12-28 02:48:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766890118;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766890118;}", "9", "1", "2025-12-28 02:48:44", "2025-12-28 02:48:44", "161540", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57925", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 02:50:36", "2025-12-28 02:50:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766890236;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766890236;}", "9", "1", "2025-12-28 02:50:36", "2025-12-28 02:50:36", "161542", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57926", "gla/jobs/resubmit_expiring_products/start", "complete", "2025-12-29 03:00:00", "2025-12-29 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766977200;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1766977200;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2025-12-29 03:12:30", "2025-12-29 03:12:30", "161845", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57927", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 03:08:31", "2025-12-28 03:08:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766891311;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766891311;}", "9", "1", "2025-12-28 03:08:40", "2025-12-28 03:08:40", "161546", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57928", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 03:09:54", "2025-12-28 03:09:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766891394;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766891394;}", "9", "1", "2025-12-28 03:09:54", "2025-12-28 03:09:54", "161548", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57929", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 03:18:38", "2025-12-28 03:18:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766891918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766891918;}", "9", "1", "2025-12-28 03:18:47", "2025-12-28 03:18:47", "161552", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57930", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 03:18:53", "2025-12-28 03:18:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766891933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766891933;}", "9", "1", "2025-12-28 03:19:22", "2025-12-28 03:19:22", "161554", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57931", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 03:24:54", "2025-12-28 03:24:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766892294;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766892294;}", "9", "1", "2025-12-28 03:25:08", "2025-12-28 03:25:08", "161559", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57932", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 03:31:09", "2025-12-28 03:31:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766892669;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766892669;}", "9", "1", "2025-12-28 03:31:17", "2025-12-28 03:31:17", "161562", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57933", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 03:31:09", "2025-12-28 03:31:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766892669;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766892669;}", "9", "1", "2025-12-28 03:31:17", "2025-12-28 03:31:17", "161562", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57934", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 04:31:23", "2025-12-28 04:31:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766896283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766896283;}", "13", "1", "2025-12-28 04:44:52", "2025-12-28 04:44:52", "161567", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57935", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 05:44:52", "2025-12-28 05:44:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766900692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766900692;}", "13", "1", "2025-12-28 05:45:28", "2025-12-28 05:45:28", "161591", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57936", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 04:44:52", "2025-12-28 04:44:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766897092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766897092;}", "9", "1", "2025-12-28 04:49:03", "2025-12-28 04:49:03", "161569", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57937", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 04:44:52", "2025-12-28 04:44:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766897092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766897092;}", "9", "1", "2025-12-28 04:49:03", "2025-12-28 04:49:03", "161569", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57938", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 04:49:04", "2025-12-28 04:49:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766897344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766897344;}", "9", "1", "2025-12-28 04:49:06", "2025-12-28 04:49:06", "161571", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57939", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 04:56:10", "2025-12-28 04:56:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766897770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766897770;}", "9", "1", "2025-12-28 04:56:17", "2025-12-28 04:56:17", "161574", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57940", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 05:10:04", "2025-12-28 05:10:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766898604;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766898604;}", "9", "1", "2025-12-28 05:10:12", "2025-12-28 05:10:12", "161577", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57941", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 05:28:16", "2025-12-28 05:28:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766899696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766899696;}", "9", "1", "2025-12-28 05:28:21", "2025-12-28 05:28:21", "161581", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57942", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 05:35:33", "2025-12-28 05:35:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766900133;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766900133;}", "9", "1", "2025-12-28 05:35:33", "2025-12-28 05:35:33", "161583", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57943", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 05:35:33", "2025-12-28 05:35:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766900133;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766900133;}", "9", "1", "2025-12-28 05:35:51", "2025-12-28 05:35:51", "161585", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57944", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 05:41:49", "2025-12-28 05:41:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766900509;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766900509;}", "9", "1", "2025-12-28 05:41:55", "2025-12-28 05:41:55", "161588", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57945", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 06:45:28", "2025-12-28 06:45:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766904328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766904328;}", "13", "1", "2025-12-28 06:53:27", "2025-12-28 06:53:27", "161606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57946", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 05:45:28", "2025-12-28 05:45:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766900728;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766900728;}", "9", "1", "2025-12-28 05:45:33", "2025-12-28 05:45:33", "161593", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57947", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 05:59:50", "2025-12-28 05:59:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766901590;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766901590;}", "9", "1", "2025-12-28 05:59:52", "2025-12-28 05:59:52", "161596", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57949", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 06:24:18", "2025-12-28 06:24:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766903058;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766903058;}", "9", "1", "2025-12-28 06:35:33", "2025-12-28 06:35:33", "161600", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57950", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 06:35:34", "2025-12-28 06:35:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766903734;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766903734;}", "9", "1", "2025-12-28 06:35:44", "2025-12-28 06:35:44", "161602", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57951", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 06:35:34", "2025-12-28 06:35:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766903734;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766903734;}", "9", "1", "2025-12-28 06:35:44", "2025-12-28 06:35:44", "161602", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57952", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 06:41:52", "2025-12-28 06:41:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766904112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766904112;}", "9", "1", "2025-12-28 06:53:27", "2025-12-28 06:53:27", "161606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57953", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 07:53:27", "2025-12-28 07:53:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766908407;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766908407;}", "13", "1", "2025-12-28 07:54:37", "2025-12-28 07:54:37", "161649", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57954", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 06:53:27", "2025-12-28 06:53:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766904807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766904807;}", "9", "1", "2025-12-28 06:53:34", "2025-12-28 06:53:34", "161608", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57955", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 06:54:15", "2025-12-28 06:54:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766904855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766904855;}", "9", "1", "2025-12-28 06:56:04", "2025-12-28 06:56:04", "161610", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57956", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 06:58:52", "2025-12-28 06:58:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766905132;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766905132;}", "9", "1", "2025-12-28 06:58:58", "2025-12-28 06:58:58", "161614", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57957", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-28 07:06:20", "2025-12-28 07:06:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766905580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766905580;}", "9", "1", "2025-12-28 07:06:20", "2025-12-28 07:06:20", "161616", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57958", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:06:20", "2025-12-28 07:06:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766905580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766905580;}", "9", "1", "2025-12-28 07:08:33", "2025-12-28 07:08:33", "161618", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57959", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:10:47", "2025-12-28 07:10:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766905847;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766905847;}", "9", "1", "2025-12-28 07:10:47", "2025-12-28 07:10:47", "161620", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57960", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:15:50", "2025-12-28 07:15:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766906150;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766906150;}", "9", "1", "2025-12-28 07:15:58", "2025-12-28 07:15:58", "161623", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57961", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:19:08", "2025-12-28 07:19:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766906348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766906348;}", "9", "1", "2025-12-28 07:19:16", "2025-12-28 07:19:16", "161626", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57962", "wc_admin_daily_wrapper", "complete", "2025-12-29 07:22:23", "2025-12-29 07:22:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766992943;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766992943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-29 07:26:00", "2025-12-29 07:26:00", "161875", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57963", "woocommerce_cleanup_personal_data", "complete", "2025-12-29 07:22:24", "2025-12-29 07:22:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766992944;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766992944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-29 07:26:01", "2025-12-29 07:26:01", "161875", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57964", "woocommerce_tracker_send_event_wrapper", "complete", "2025-12-29 07:22:24", "2025-12-29 07:22:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766992944;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766992944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-29 07:26:01", "2025-12-29 07:26:01", "161875", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57965", "woocommerce_cleanup_logs", "complete", "2025-12-29 07:22:24", "2025-12-29 07:22:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766992944;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766992944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-29 07:26:01", "2025-12-29 07:26:01", "161875", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57966", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-29 07:22:24", "2025-12-29 07:22:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766992944;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766992944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-29 07:26:01", "2025-12-29 07:26:01", "161875", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57967", "fetch_patterns", "complete", "2025-12-29 07:22:24", "2025-12-29 07:22:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766992944;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766992944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-29 07:26:03", "2025-12-29 07:26:03", "161875", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57968", "woocommerce_cleanup_sessions", "complete", "2025-12-29 06:00:00", "2025-12-29 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766988000;s:18:\"\0*\0first_timestamp\";i:1766988000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766988000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2025-12-29 06:44:05", "2025-12-29 06:44:05", "161856", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57969", "generate_category_lookup_table_wrapper", "complete", "2025-12-28 07:22:34", "2025-12-28 07:22:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766906554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766906554;}", "13", "1", "2025-12-28 07:26:51", "2025-12-28 07:26:51", "161631", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57970", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-29 07:22:24", "2025-12-29 07:22:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766992944;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766992944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-29 07:26:03", "2025-12-29 07:26:03", "161875", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57971", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:26:51", "2025-12-28 07:26:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766906811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766906811;}", "9", "1", "2025-12-28 07:26:59", "2025-12-28 07:26:59", "161633", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57972", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:36:14", "2025-12-28 07:36:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766907374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766907374;}", "9", "1", "2025-12-28 07:36:25", "2025-12-28 07:36:25", "161636", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57973", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 07:36:14", "2025-12-28 07:36:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766907374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766907374;}", "9", "1", "2025-12-28 07:36:25", "2025-12-28 07:36:25", "161636", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57974", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:39:03", "2025-12-28 07:39:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766907543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766907543;}", "9", "1", "2025-12-28 07:39:17", "2025-12-28 07:39:17", "161640", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57975", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:44:25", "2025-12-28 07:44:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766907865;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766907865;}", "9", "1", "2025-12-28 07:44:32", "2025-12-28 07:44:32", "161646", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57976", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 08:54:37", "2025-12-28 08:54:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766912077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766912077;}", "13", "1", "2025-12-28 09:20:38", "2025-12-28 09:20:38", "161666", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57977", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 07:54:37", "2025-12-28 07:54:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766908477;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766908477;}", "9", "1", "2025-12-28 07:54:42", "2025-12-28 07:54:42", "161651", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57978", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 08:01:49", "2025-12-28 08:01:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766908909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766908909;}", "9", "1", "2025-12-28 08:20:54", "2025-12-28 08:20:54", "161654", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57979", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 08:20:54", "2025-12-28 08:20:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766910054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766910054;}", "9", "1", "2025-12-28 08:20:54", "2025-12-28 08:20:54", "161656", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57980", "woocommerce_refresh_order_count_cache", "complete", "2025-12-28 20:39:40", "2025-12-28 20:39:40", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766954380;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766954380;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-28 21:18:38", "2025-12-28 21:18:38", "161795", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57981", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 08:39:40", "2025-12-28 08:39:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766911180;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766911180;}", "9", "1", "2025-12-28 08:39:40", "2025-12-28 08:39:40", "161660", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57982", "facebook_for_woocommerce_daily_heartbeat", "complete", "2025-12-28 08:39:40", "2025-12-28 08:39:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766911180;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766911180;}", "9", "1", "2025-12-28 08:40:04", "2025-12-28 08:40:04", "161662", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57983", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 08:39:40", "2025-12-28 08:39:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766911180;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766911180;}", "9", "1", "2025-12-28 08:40:09", "2025-12-28 08:40:09", "161663", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57984", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 10:20:38", "2025-12-28 10:20:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766917238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766917238;}", "13", "1", "2025-12-28 10:59:23", "2025-12-28 10:59:23", "161678", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57985", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 09:20:39", "2025-12-28 09:20:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766913639;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766913639;}", "9", "1", "2025-12-28 09:21:21", "2025-12-28 09:21:21", "161668", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57986", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 09:25:31", "2025-12-28 09:25:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766913931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766913931;}", "9", "1", "2025-12-28 09:25:39", "2025-12-28 09:25:39", "161671", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57987", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 09:30:42", "2025-12-28 09:30:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766914242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766914242;}", "9", "1", "2025-12-28 09:30:42", "2025-12-28 09:30:42", "161676", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57988", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 09:30:46", "2025-12-28 09:30:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766914246;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766914246;}", "9", "1", "2025-12-28 10:59:23", "2025-12-28 10:59:23", "161678", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57989", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 11:59:23", "2025-12-28 11:59:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766923163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766923163;}", "13", "1", "2025-12-28 12:14:38", "2025-12-28 12:14:38", "161698", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57990", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 10:59:23", "2025-12-28 10:59:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766919563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766919563;}", "9", "1", "2025-12-28 10:59:30", "2025-12-28 10:59:30", "161680", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57991", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 10:59:23", "2025-12-28 10:59:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766919563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766919563;}", "9", "1", "2025-12-28 10:59:30", "2025-12-28 10:59:30", "161680", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57992", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 11:21:32", "2025-12-28 11:21:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766920892;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766920892;}", "9", "1", "2025-12-28 11:21:40", "2025-12-28 11:21:40", "161683", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57993", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 11:27:03", "2025-12-28 11:27:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766921223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766921223;}", "9", "1", "2025-12-28 11:41:24", "2025-12-28 11:41:24", "161686", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57994", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 11:41:24", "2025-12-28 11:41:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766922084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766922084;}", "9", "1", "2025-12-28 11:41:29", "2025-12-28 11:41:29", "161688", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57995", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 11:41:24", "2025-12-28 11:41:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766922084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766922084;}", "9", "1", "2025-12-28 11:41:29", "2025-12-28 11:41:29", "161688", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57996", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 11:46:48", "2025-12-28 11:46:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766922408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766922408;}", "9", "1", "2025-12-28 11:46:53", "2025-12-28 11:46:53", "161691", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57997", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 11:53:18", "2025-12-28 11:53:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766922798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766922798;}", "9", "1", "2025-12-28 11:53:25", "2025-12-28 11:53:25", "161694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57998", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 11:57:08", "2025-12-28 11:57:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766923028;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766923028;}", "9", "1", "2025-12-28 11:57:08", "2025-12-28 11:57:08", "161696", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("57999", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 13:14:38", "2025-12-28 13:14:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766927678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766927678;}", "13", "1", "2025-12-28 13:17:57", "2025-12-28 13:17:57", "161707", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58000", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 12:14:38", "2025-12-28 12:14:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766924078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766924078;}", "9", "1", "2025-12-28 12:18:51", "2025-12-28 12:18:51", "161700", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58001", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 12:18:51", "2025-12-28 12:18:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766924331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766924331;}", "9", "1", "2025-12-28 12:18:51", "2025-12-28 12:18:51", "161702", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58002", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 12:47:56", "2025-12-28 12:47:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766926076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766926076;}", "9", "1", "2025-12-28 12:48:05", "2025-12-28 12:48:05", "161705", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58003", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 12:47:56", "2025-12-28 12:47:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766926076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766926076;}", "9", "1", "2025-12-28 12:48:05", "2025-12-28 12:48:05", "161705", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58004", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 14:17:57", "2025-12-28 14:17:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766931477;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766931477;}", "13", "1", "2025-12-28 14:19:15", "2025-12-28 14:19:15", "161725", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58005", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 13:17:57", "2025-12-28 13:17:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766927877;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766927877;}", "9", "1", "2025-12-28 13:18:09", "2025-12-28 13:18:09", "161709", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58006", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 13:19:26", "2025-12-28 13:19:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766927966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766927966;}", "9", "1", "2025-12-28 13:43:07", "2025-12-28 13:43:07", "161712", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58007", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 13:43:07", "2025-12-28 13:43:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766929387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766929387;}", "9", "1", "2025-12-28 13:43:11", "2025-12-28 13:43:11", "161714", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58008", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 13:43:07", "2025-12-28 13:43:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766929387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766929387;}", "9", "1", "2025-12-28 13:43:11", "2025-12-28 13:43:11", "161714", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58009", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 13:45:09", "2025-12-28 13:45:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766929509;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766929509;}", "9", "1", "2025-12-28 13:45:09", "2025-12-28 13:45:09", "161717", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58010", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 14:08:51", "2025-12-28 14:08:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766930931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766930931;}", "9", "1", "2025-12-28 14:08:51", "2025-12-28 14:08:51", "161720", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58011", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 14:15:40", "2025-12-28 14:15:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766931340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766931340;}", "9", "1", "2025-12-28 14:15:46", "2025-12-28 14:15:46", "161723", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58012", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 15:19:15", "2025-12-28 15:19:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766935155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766935155;}", "13", "1", "2025-12-28 15:19:56", "2025-12-28 15:19:56", "161739", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58013", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 14:19:15", "2025-12-28 14:19:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766931555;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766931555;}", "9", "1", "2025-12-28 14:19:20", "2025-12-28 14:19:20", "161727", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58014", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 14:28:46", "2025-12-28 14:28:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766932126;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766932126;}", "9", "1", "2025-12-28 14:28:46", "2025-12-28 14:28:46", "161730", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58015", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 14:28:51", "2025-12-28 14:28:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766932131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766932131;}", "9", "1", "2025-12-28 14:28:52", "2025-12-28 14:28:52", "161732", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58016", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 14:37:10", "2025-12-28 14:37:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766932630;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766932630;}", "9", "1", "2025-12-28 14:37:14", "2025-12-28 14:37:14", "161735", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58017", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 14:37:10", "2025-12-28 14:37:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766932630;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766932630;}", "9", "1", "2025-12-28 14:37:15", "2025-12-28 14:37:15", "161735", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58018", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 15:13:40", "2025-12-28 15:13:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766934820;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766934820;}", "9", "1", "2025-12-28 15:19:56", "2025-12-28 15:19:56", "161739", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58019", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 15:13:56", "2025-12-28 15:13:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766934836;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766934836;}", "9", "1", "2025-12-28 15:19:56", "2025-12-28 15:19:56", "161739", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58020", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 16:19:56", "2025-12-28 16:19:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766938796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766938796;}", "13", "1", "2025-12-28 16:25:58", "2025-12-28 16:25:58", "161747", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58021", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 15:19:57", "2025-12-28 15:19:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766935197;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766935197;}", "9", "1", "2025-12-28 15:20:08", "2025-12-28 15:20:08", "161741", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58022", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 15:41:27", "2025-12-28 15:41:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766936487;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766936487;}", "9", "1", "2025-12-28 15:41:36", "2025-12-28 15:41:36", "161744", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58023", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 15:41:27", "2025-12-28 15:41:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766936487;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766936487;}", "9", "1", "2025-12-28 15:41:36", "2025-12-28 15:41:36", "161744", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58024", "woocommerce_scheduled_sales", "complete", "2025-12-29 16:25:58", "2025-12-29 16:25:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767025558;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767025558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-29 17:09:44", "2025-12-29 17:09:44", "161953", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58025", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 17:25:58", "2025-12-28 17:25:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766942758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766942758;}", "13", "1", "2025-12-28 17:58:32", "2025-12-28 17:58:32", "161773", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58026", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 16:25:58", "2025-12-28 16:25:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766939158;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766939158;}", "9", "1", "2025-12-28 16:25:59", "2025-12-28 16:25:59", "161749", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58027", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 16:34:53", "2025-12-28 16:34:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766939693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766939693;}", "9", "1", "2025-12-28 16:56:57", "2025-12-28 16:56:57", "161753", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58028", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 16:34:53", "2025-12-28 16:34:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766939693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766939693;}", "9", "1", "2025-12-28 16:56:58", "2025-12-28 16:56:58", "161753", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58029", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 16:56:58", "2025-12-28 16:56:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766941018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766941018;}", "9", "1", "2025-12-28 16:57:09", "2025-12-28 16:57:09", "161755", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58030", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 16:59:27", "2025-12-28 16:59:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766941167;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766941167;}", "9", "1", "2025-12-28 16:59:34", "2025-12-28 16:59:34", "161758", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58031", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 17:04:37", "2025-12-28 17:04:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766941477;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766941477;}", "9", "1", "2025-12-28 17:05:55", "2025-12-28 17:05:55", "161762", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58032", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 17:09:48", "2025-12-28 17:09:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766941788;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766941788;}", "9", "1", "2025-12-28 17:09:53", "2025-12-28 17:09:53", "161767", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58033", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 17:14:59", "2025-12-28 17:14:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766942099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766942099;}", "9", "1", "2025-12-28 17:15:06", "2025-12-28 17:15:06", "161771", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58034", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 18:58:32", "2025-12-28 18:58:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766948312;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766948312;}", "13", "1", "2025-12-28 19:10:46", "2025-12-28 19:10:46", "161780", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58035", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 17:58:32", "2025-12-28 17:58:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766944712;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766944712;}", "9", "1", "2025-12-28 18:04:30", "2025-12-28 18:04:30", "161775", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58036", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 17:58:32", "2025-12-28 17:58:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766944712;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766944712;}", "9", "1", "2025-12-28 18:04:31", "2025-12-28 18:04:31", "161775", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58037", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 18:04:30", "2025-12-28 18:04:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766945070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766945070;}", "9", "1", "2025-12-28 18:04:31", "2025-12-28 18:04:31", "161775", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58038", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 18:35:47", "2025-12-28 18:35:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766946947;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766946947;}", "9", "1", "2025-12-28 18:40:43", "2025-12-28 18:40:43", "161778", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58039", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 18:35:47", "2025-12-28 18:35:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766946947;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766946947;}", "9", "1", "2025-12-28 18:40:43", "2025-12-28 18:40:43", "161778", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58040", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 18:40:43", "2025-12-28 18:40:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766947243;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766947243;}", "9", "1", "2025-12-28 19:10:46", "2025-12-28 19:10:46", "161780", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58041", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 20:10:46", "2025-12-28 20:10:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766952646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766952646;}", "13", "1", "2025-12-28 20:30:45", "2025-12-28 20:30:45", "161789", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58042", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 19:10:46", "2025-12-28 19:10:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766949046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766949046;}", "9", "1", "2025-12-28 19:10:53", "2025-12-28 19:10:53", "161782", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58043", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-28 19:10:46", "2025-12-28 19:10:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766949046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766949046;}", "9", "1", "2025-12-28 19:10:53", "2025-12-28 19:10:53", "161782", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58044", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 19:31:52", "2025-12-28 19:31:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766950312;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766950312;}", "9", "1", "2025-12-28 19:50:26", "2025-12-28 19:50:26", "161785", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58045", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 19:31:52", "2025-12-28 19:31:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766950312;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766950312;}", "9", "1", "2025-12-28 19:50:26", "2025-12-28 19:50:26", "161785", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58046", "woocommerce_cleanup_draft_orders", "complete", "2025-12-29 19:50:26", "2025-12-29 19:50:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767037826;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767037826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-12-29 20:47:57", "2025-12-29 20:47:57", "161970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58047", "wc_gla_cron_daily_notes", "complete", "2025-12-29 19:50:26", "2025-12-29 19:50:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767037826;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767037826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-29 20:47:57", "2025-12-29 20:47:57", "161970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58048", "wc_facebook_regenerate_feed", "complete", "2025-12-29 19:50:37", "2025-12-29 19:50:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767037837;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767037837;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-12-29 20:48:08", "2025-12-29 20:48:08", "161970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58049", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 19:50:37", "2025-12-28 19:50:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766951437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766951437;}", "9", "1", "2025-12-28 19:51:22", "2025-12-28 19:51:22", "161787", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58050", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 21:30:45", "2025-12-28 21:30:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766957445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766957445;}", "13", "1", "2025-12-28 22:12:34", "2025-12-28 22:12:34", "161797", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58051", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 20:30:45", "2025-12-28 20:30:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766953845;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766953845;}", "9", "1", "2025-12-28 20:34:36", "2025-12-28 20:34:36", "161791", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58052", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 20:30:46", "2025-12-28 20:30:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766953846;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766953846;}", "9", "1", "2025-12-28 20:34:36", "2025-12-28 20:34:36", "161791", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58053", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 20:34:36", "2025-12-28 20:34:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766954076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766954076;}", "9", "1", "2025-12-28 20:36:26", "2025-12-28 20:36:26", "161793", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58054", "woocommerce_refresh_order_count_cache", "complete", "2025-12-29 09:18:38", "2025-12-29 09:18:38", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766999918;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766999918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-29 09:42:43", "2025-12-29 09:42:43", "161889", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58055", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 21:18:38", "2025-12-28 21:18:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766956718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766956718;}", "9", "1", "2025-12-28 22:12:34", "2025-12-28 22:12:34", "161797", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58056", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 22:12:34", "2025-12-28 22:12:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766959954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766959954;}", "9", "1", "2025-12-28 22:12:34", "2025-12-28 22:12:34", "161797", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58057", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 23:12:34", "2025-12-28 23:12:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766963554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766963554;}", "13", "1", "2025-12-28 23:37:42", "2025-12-28 23:37:42", "161806", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58058", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 22:12:34", "2025-12-28 22:12:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766959954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766959954;}", "9", "1", "2025-12-28 22:12:35", "2025-12-28 22:12:35", "161799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58059", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 22:14:37", "2025-12-28 22:14:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766960077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766960077;}", "9", "1", "2025-12-28 22:15:55", "2025-12-28 22:15:55", "161802", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58060", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 22:45:41", "2025-12-28 22:45:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766961941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766961941;}", "9", "1", "2025-12-28 23:37:42", "2025-12-28 23:37:42", "161806", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58061", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 22:45:41", "2025-12-28 22:45:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766961941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766961941;}", "9", "1", "2025-12-28 23:37:42", "2025-12-28 23:37:42", "161806", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58062", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 00:37:42", "2025-12-29 00:37:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766968662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766968662;}", "13", "1", "2025-12-29 00:44:24", "2025-12-29 00:44:24", "161819", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58063", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 23:37:42", "2025-12-28 23:37:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766965062;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766965062;}", "9", "1", "2025-12-28 23:37:43", "2025-12-28 23:37:43", "161808", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58064", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-28 23:37:42", "2025-12-28 23:37:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766965062;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766965062;}", "9", "1", "2025-12-28 23:37:43", "2025-12-28 23:37:43", "161808", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58065", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 23:51:46", "2025-12-28 23:51:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766965906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766965906;}", "9", "1", "2025-12-28 23:53:46", "2025-12-28 23:53:46", "161811", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58066", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-28 23:53:53", "2025-12-28 23:53:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766966033;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766966033;}", "9", "1", "2025-12-28 23:54:03", "2025-12-28 23:54:03", "161813", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58067", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 00:15:43", "2025-12-29 00:15:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766967343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766967343;}", "9", "1", "2025-12-29 00:15:49", "2025-12-29 00:15:49", "161816", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58068", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 01:44:24", "2025-12-29 01:44:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766972664;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766972664;}", "13", "1", "2025-12-29 01:45:06", "2025-12-29 01:45:06", "161833", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58069", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 00:44:24", "2025-12-29 00:44:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766969064;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766969064;}", "9", "1", "2025-12-29 00:44:24", "2025-12-29 00:44:24", "161821", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58070", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 00:44:24", "2025-12-29 00:44:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766969064;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766969064;}", "9", "1", "2025-12-29 00:44:25", "2025-12-29 00:44:25", "161821", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58071", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 01:19:22", "2025-12-29 01:19:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766971162;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766971162;}", "9", "1", "2025-12-29 01:32:06", "2025-12-29 01:32:06", "161824", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58072", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 01:32:06", "2025-12-29 01:32:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766971926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766971926;}", "9", "1", "2025-12-29 01:32:11", "2025-12-29 01:32:11", "161826", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58073", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 01:32:06", "2025-12-29 01:32:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766971926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766971926;}", "9", "1", "2025-12-29 01:32:11", "2025-12-29 01:32:11", "161826", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58074", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 01:34:18", "2025-12-29 01:34:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766972058;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766972058;}", "9", "1", "2025-12-29 01:34:28", "2025-12-29 01:34:28", "161830", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58075", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 01:43:37", "2025-12-29 01:43:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766972617;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766972617;}", "9", "1", "2025-12-29 01:45:06", "2025-12-29 01:45:06", "161833", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58076", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 01:45:06", "2025-12-29 01:45:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766972706;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766972706;}", "9", "1", "2025-12-29 01:45:06", "2025-12-29 01:45:06", "161833", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58077", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 02:45:06", "2025-12-29 02:45:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766976306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766976306;}", "13", "1", "2025-12-29 03:12:30", "2025-12-29 03:12:30", "161845", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58078", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 01:58:16", "2025-12-29 01:58:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766973496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766973496;}", "9", "1", "2025-12-29 01:58:21", "2025-12-29 01:58:21", "161837", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58079", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 02:33:20", "2025-12-29 02:33:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766975600;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766975600;}", "9", "1", "2025-12-29 02:33:20", "2025-12-29 02:33:20", "161839", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58080", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 02:33:20", "2025-12-29 02:33:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766975600;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766975600;}", "9", "1", "2025-12-29 02:44:14", "2025-12-29 02:44:14", "161841", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58081", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 02:33:50", "2025-12-29 02:33:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766975630;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766975630;}", "9", "1", "2025-12-29 02:44:14", "2025-12-29 02:44:14", "161841", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58082", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 02:44:14", "2025-12-29 02:44:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766976254;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766976254;}", "9", "1", "2025-12-29 02:44:18", "2025-12-29 02:44:18", "161843", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58083", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 04:12:30", "2025-12-29 04:12:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766981550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766981550;}", "13", "1", "2025-12-29 04:16:01", "2025-12-29 04:16:01", "161847", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58084", "gla/jobs/resubmit_expiring_products/start", "complete", "2025-12-30 03:00:00", "2025-12-30 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767063600;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767063600;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2025-12-30 03:08:33", "2025-12-30 03:08:33", "162018", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58085", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 03:12:30", "2025-12-29 03:12:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766977950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766977950;}", "9", "1", "2025-12-29 04:16:01", "2025-12-29 04:16:01", "161847", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58086", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 05:16:01", "2025-12-29 05:16:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766985361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766985361;}", "13", "1", "2025-12-29 05:18:56", "2025-12-29 05:18:56", "161852", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58087", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 04:16:01", "2025-12-29 04:16:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766981761;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766981761;}", "9", "1", "2025-12-29 04:17:01", "2025-12-29 04:17:01", "161849", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58088", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 04:16:01", "2025-12-29 04:16:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766981761;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766981761;}", "9", "1", "2025-12-29 04:17:01", "2025-12-29 04:17:01", "161849", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58089", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 06:18:56", "2025-12-29 06:18:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766989136;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766989136;}", "13", "1", "2025-12-29 06:44:05", "2025-12-29 06:44:05", "161856", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58090", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 05:18:56", "2025-12-29 05:18:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766985536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766985536;}", "9", "1", "2025-12-29 05:30:42", "2025-12-29 05:30:42", "161854", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58091", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 05:18:56", "2025-12-29 05:18:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766985536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766985536;}", "9", "1", "2025-12-29 05:30:43", "2025-12-29 05:30:43", "161854", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58092", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 05:30:43", "2025-12-29 05:30:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766986243;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766986243;}", "9", "1", "2025-12-29 06:44:05", "2025-12-29 06:44:05", "161856", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58093", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 06:44:05", "2025-12-29 06:44:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766990645;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766990645;}", "9", "1", "2025-12-29 06:44:05", "2025-12-29 06:44:05", "161856", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58095", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 07:44:05", "2025-12-29 07:44:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766994245;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766994245;}", "13", "1", "2025-12-29 07:59:09", "2025-12-29 07:59:09", "161879", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58096", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 06:44:05", "2025-12-29 06:44:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766990645;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766990645;}", "9", "1", "2025-12-29 06:44:19", "2025-12-29 06:44:19", "161858", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58097", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 06:48:57", "2025-12-29 06:48:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766990937;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766990937;}", "9", "1", "2025-12-29 06:49:05", "2025-12-29 06:49:05", "161862", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58098", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 06:54:24", "2025-12-29 06:54:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766991264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766991264;}", "9", "1", "2025-12-29 06:54:25", "2025-12-29 06:54:25", "161865", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58099", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 07:02:40", "2025-12-29 07:02:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766991760;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766991760;}", "9", "1", "2025-12-29 07:13:21", "2025-12-29 07:13:21", "161870", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58100", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-29 07:02:40", "2025-12-29 07:02:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766991760;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766991760;}", "9", "1", "2025-12-29 07:13:21", "2025-12-29 07:13:21", "161870", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58101", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 07:13:21", "2025-12-29 07:13:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766992401;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766992401;}", "9", "1", "2025-12-29 07:21:43", "2025-12-29 07:21:43", "161872", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58102", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 07:21:43", "2025-12-29 07:21:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766992903;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766992903;}", "9", "1", "2025-12-29 07:21:43", "2025-12-29 07:21:43", "161872", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58103", "wc_admin_daily_wrapper", "complete", "2025-12-30 07:26:00", "2025-12-30 07:26:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767079560;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767079560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-30 07:31:11", "2025-12-30 07:31:11", "162028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58104", "woocommerce_cleanup_personal_data", "complete", "2025-12-30 07:26:01", "2025-12-30 07:26:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767079561;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767079561;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-30 07:31:12", "2025-12-30 07:31:12", "162028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58105", "woocommerce_tracker_send_event_wrapper", "complete", "2025-12-30 07:26:01", "2025-12-30 07:26:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767079561;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767079561;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-30 07:31:12", "2025-12-30 07:31:12", "162028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58106", "woocommerce_cleanup_logs", "complete", "2025-12-30 07:26:01", "2025-12-30 07:26:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767079561;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767079561;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-30 07:31:12", "2025-12-30 07:31:12", "162028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58107", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-30 07:26:01", "2025-12-30 07:26:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767079561;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767079561;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-30 07:31:12", "2025-12-30 07:31:12", "162028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58108", "fetch_patterns", "complete", "2025-12-30 07:26:03", "2025-12-30 07:26:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767079563;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767079563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-30 07:31:13", "2025-12-30 07:31:13", "162028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58109", "woocommerce_cleanup_sessions", "complete", "2025-12-30 06:00:00", "2025-12-30 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767074400;s:18:\"\0*\0first_timestamp\";i:1767074400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767074400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2025-12-30 07:03:18", "2025-12-30 07:03:18", "162024", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58110", "generate_category_lookup_table_wrapper", "complete", "2025-12-29 07:26:13", "2025-12-29 07:26:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766993173;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766993173;}", "13", "1", "2025-12-29 07:26:50", "2025-12-29 07:26:50", "161877", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58111", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-30 07:26:03", "2025-12-30 07:26:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767079563;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767079563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-30 07:31:13", "2025-12-30 07:31:13", "162028", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58112", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 07:26:03", "2025-12-29 07:26:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766993163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766993163;}", "9", "1", "2025-12-29 07:26:50", "2025-12-29 07:26:50", "161877", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58113", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 08:59:09", "2025-12-29 08:59:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766998749;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766998749;}", "13", "1", "2025-12-29 09:00:48", "2025-12-29 09:00:48", "161887", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58114", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 07:59:09", "2025-12-29 07:59:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766995149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766995149;}", "9", "1", "2025-12-29 07:59:29", "2025-12-29 07:59:29", "161881", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58115", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 07:59:09", "2025-12-29 07:59:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766995149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766995149;}", "9", "1", "2025-12-29 07:59:29", "2025-12-29 07:59:29", "161881", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58116", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 08:22:51", "2025-12-29 08:22:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766996571;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766996571;}", "9", "1", "2025-12-29 08:46:04", "2025-12-29 08:46:04", "161884", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58117", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 08:46:04", "2025-12-29 08:46:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766997964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766997964;}", "9", "1", "2025-12-29 08:59:14", "2025-12-29 08:59:14", "161886", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58118", "facebook_for_woocommerce_daily_heartbeat", "complete", "2025-12-29 08:46:04", "2025-12-29 08:46:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766997964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766997964;}", "9", "1", "2025-12-29 08:59:32", "2025-12-29 08:59:32", "161886", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58119", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 08:46:04", "2025-12-29 08:46:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766997964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766997964;}", "9", "1", "2025-12-29 09:00:48", "2025-12-29 09:00:48", "161887", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58120", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 08:59:32", "2025-12-29 08:59:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766998772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766998772;}", "9", "1", "2025-12-29 09:00:49", "2025-12-29 09:00:49", "161887", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58121", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 10:00:48", "2025-12-29 10:00:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767002448;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767002448;}", "13", "1", "2025-12-29 10:01:08", "2025-12-29 10:01:08", "161893", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58122", "woocommerce_refresh_order_count_cache", "complete", "2025-12-29 21:42:43", "2025-12-29 21:42:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767044563;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767044563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-29 21:44:14", "2025-12-29 21:44:14", "161976", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58123", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 09:42:43", "2025-12-29 09:42:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767001363;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767001363;}", "9", "1", "2025-12-29 09:42:58", "2025-12-29 09:42:58", "161891", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58124", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 09:42:43", "2025-12-29 09:42:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767001363;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767001363;}", "9", "1", "2025-12-29 09:42:58", "2025-12-29 09:42:58", "161891", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58125", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 11:01:08", "2025-12-29 11:01:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767006068;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767006068;}", "13", "1", "2025-12-29 11:08:34", "2025-12-29 11:08:34", "161910", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58126", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 10:01:08", "2025-12-29 10:01:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767002468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767002468;}", "9", "1", "2025-12-29 10:03:59", "2025-12-29 10:03:59", "161895", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58127", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 10:03:59", "2025-12-29 10:03:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767002639;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767002639;}", "9", "1", "2025-12-29 10:17:53", "2025-12-29 10:17:53", "161897", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58128", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 10:17:53", "2025-12-29 10:17:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767003473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767003473;}", "9", "1", "2025-12-29 10:18:16", "2025-12-29 10:18:16", "161899", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58129", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 10:22:33", "2025-12-29 10:22:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767003753;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767003753;}", "9", "1", "2025-12-29 10:23:54", "2025-12-29 10:23:54", "161902", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58130", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 10:23:55", "2025-12-29 10:23:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767003835;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767003835;}", "9", "1", "2025-12-29 10:23:59", "2025-12-29 10:23:59", "161905", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58131", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 10:35:28", "2025-12-29 10:35:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767004528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767004528;}", "9", "1", "2025-12-29 10:35:34", "2025-12-29 10:35:34", "161908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58132", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 10:35:28", "2025-12-29 10:35:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767004528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767004528;}", "9", "1", "2025-12-29 10:35:34", "2025-12-29 10:35:34", "161908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58133", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 12:08:34", "2025-12-29 12:08:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767010114;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767010114;}", "13", "1", "2025-12-29 12:35:06", "2025-12-29 12:35:06", "161916", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58134", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 11:08:34", "2025-12-29 11:08:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767006514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767006514;}", "9", "1", "2025-12-29 11:34:44", "2025-12-29 11:34:44", "161912", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58135", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 11:08:50", "2025-12-29 11:08:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767006530;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767006530;}", "9", "1", "2025-12-29 11:34:44", "2025-12-29 11:34:44", "161912", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58136", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 11:34:44", "2025-12-29 11:34:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767008084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767008084;}", "9", "1", "2025-12-29 11:45:43", "2025-12-29 11:45:43", "161914", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58137", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 11:34:44", "2025-12-29 11:34:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767008084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767008084;}", "9", "1", "2025-12-29 11:45:44", "2025-12-29 11:45:44", "161914", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58138", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 11:45:44", "2025-12-29 11:45:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767008744;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767008744;}", "9", "1", "2025-12-29 12:35:06", "2025-12-29 12:35:06", "161916", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58139", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 13:35:06", "2025-12-29 13:35:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767015306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767015306;}", "13", "1", "2025-12-29 13:39:27", "2025-12-29 13:39:27", "161928", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58140", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 12:35:06", "2025-12-29 12:35:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767011706;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767011706;}", "9", "1", "2025-12-29 12:35:12", "2025-12-29 12:35:12", "161918", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58141", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 12:35:06", "2025-12-29 12:35:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767011706;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767011706;}", "9", "1", "2025-12-29 12:35:12", "2025-12-29 12:35:12", "161918", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58142", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 12:54:23", "2025-12-29 12:54:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767012863;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767012863;}", "9", "1", "2025-12-29 13:23:00", "2025-12-29 13:23:00", "161922", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58143", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 13:23:00", "2025-12-29 13:23:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767014580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767014580;}", "9", "1", "2025-12-29 13:23:16", "2025-12-29 13:23:16", "161924", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58144", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 13:28:21", "2025-12-29 13:28:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767014901;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767014901;}", "9", "1", "2025-12-29 13:28:21", "2025-12-29 13:28:21", "161926", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58145", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 13:39:27", "2025-12-29 13:39:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767015567;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767015567;}", "9", "1", "2025-12-29 13:39:27", "2025-12-29 13:39:27", "161928", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58146", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 14:39:27", "2025-12-29 14:39:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767019167;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767019167;}", "13", "1", "2025-12-29 14:52:55", "2025-12-29 14:52:55", "161936", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58147", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 13:39:27", "2025-12-29 13:39:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767015567;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767015567;}", "9", "1", "2025-12-29 14:23:38", "2025-12-29 14:23:38", "161930", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58148", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 14:23:38", "2025-12-29 14:23:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767018218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767018218;}", "9", "1", "2025-12-29 14:29:00", "2025-12-29 14:29:00", "161932", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58149", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 14:23:53", "2025-12-29 14:23:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767018233;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767018233;}", "9", "1", "2025-12-29 14:29:00", "2025-12-29 14:29:00", "161932", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58150", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 14:29:00", "2025-12-29 14:29:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767018540;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767018540;}", "9", "1", "2025-12-29 14:29:01", "2025-12-29 14:29:01", "161934", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58151", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 15:52:55", "2025-12-29 15:52:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767023575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767023575;}", "13", "1", "2025-12-29 16:05:41", "2025-12-29 16:05:41", "161948", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58152", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 14:52:55", "2025-12-29 14:52:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767019975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767019975;}", "9", "1", "2025-12-29 15:01:50", "2025-12-29 15:01:50", "161938", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58153", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 14:52:55", "2025-12-29 14:52:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767019975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767019975;}", "9", "1", "2025-12-29 15:01:50", "2025-12-29 15:01:50", "161938", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58154", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 15:01:50", "2025-12-29 15:01:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767020510;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767020510;}", "9", "1", "2025-12-29 15:01:50", "2025-12-29 15:01:50", "161940", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58155", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 15:04:50", "2025-12-29 15:04:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767020690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767020690;}", "9", "1", "2025-12-29 15:09:00", "2025-12-29 15:09:00", "161944", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58156", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 15:09:00", "2025-12-29 15:09:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767020940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767020940;}", "9", "1", "2025-12-29 15:09:04", "2025-12-29 15:09:04", "161946", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58157", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 17:05:41", "2025-12-29 17:05:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767027941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767027941;}", "13", "1", "2025-12-29 17:09:44", "2025-12-29 17:09:44", "161953", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58158", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 16:05:41", "2025-12-29 16:05:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767024341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767024341;}", "9", "1", "2025-12-29 16:05:47", "2025-12-29 16:05:47", "161950", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58159", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 16:05:41", "2025-12-29 16:05:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767024341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767024341;}", "9", "1", "2025-12-29 16:05:47", "2025-12-29 16:05:47", "161950", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58160", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 16:16:50", "2025-12-29 16:16:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767025010;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767025010;}", "9", "1", "2025-12-29 17:09:44", "2025-12-29 17:09:44", "161953", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58161", "woocommerce_scheduled_sales", "complete", "2025-12-30 17:09:44", "2025-12-30 17:09:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767114584;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767114584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-30 17:15:40", "2025-12-30 17:15:40", "162089", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58162", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 18:09:44", "2025-12-29 18:09:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767031784;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767031784;}", "13", "1", "2025-12-29 18:21:40", "2025-12-29 18:21:40", "161958", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58163", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 17:09:44", "2025-12-29 17:09:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767028184;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767028184;}", "9", "1", "2025-12-29 17:09:51", "2025-12-29 17:09:51", "161955", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58164", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 17:09:44", "2025-12-29 17:09:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767028184;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767028184;}", "9", "1", "2025-12-29 17:09:51", "2025-12-29 17:09:51", "161955", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58165", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 17:34:35", "2025-12-29 17:34:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767029675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767029675;}", "9", "1", "2025-12-29 18:21:40", "2025-12-29 18:21:40", "161958", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58166", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 17:34:35", "2025-12-29 17:34:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767029675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767029675;}", "9", "1", "2025-12-29 18:21:40", "2025-12-29 18:21:40", "161958", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58167", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 19:21:40", "2025-12-29 19:21:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767036100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767036100;}", "13", "1", "2025-12-29 19:28:52", "2025-12-29 19:28:52", "161968", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58168", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 18:21:41", "2025-12-29 18:21:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767032501;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767032501;}", "9", "1", "2025-12-29 18:21:46", "2025-12-29 18:21:46", "161961", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58169", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 18:48:51", "2025-12-29 18:48:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767034131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767034131;}", "9", "1", "2025-12-29 18:56:52", "2025-12-29 18:56:52", "161964", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58170", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 18:48:51", "2025-12-29 18:48:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767034131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767034131;}", "9", "1", "2025-12-29 18:56:52", "2025-12-29 18:56:52", "161964", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58171", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 18:56:52", "2025-12-29 18:56:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767034612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767034612;}", "9", "1", "2025-12-29 18:57:03", "2025-12-29 18:57:03", "161966", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58172", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 20:28:52", "2025-12-29 20:28:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767040132;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767040132;}", "13", "1", "2025-12-29 20:48:08", "2025-12-29 20:48:08", "161970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58173", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 19:28:52", "2025-12-29 19:28:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767036532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767036532;}", "9", "1", "2025-12-29 20:47:57", "2025-12-29 20:47:57", "161970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58174", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-29 19:28:52", "2025-12-29 19:28:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767036532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767036532;}", "9", "1", "2025-12-29 20:47:57", "2025-12-29 20:47:57", "161970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58175", "woocommerce_cleanup_draft_orders", "complete", "2025-12-30 20:47:57", "2025-12-30 20:47:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767127677;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767127677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-12-30 20:49:24", "2025-12-30 20:49:24", "162191", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58176", "wc_gla_cron_daily_notes", "complete", "2025-12-30 20:47:57", "2025-12-30 20:47:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767127677;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767127677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-30 20:49:24", "2025-12-30 20:49:24", "162191", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58177", "wc_facebook_regenerate_feed", "complete", "2025-12-30 20:48:08", "2025-12-30 20:48:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767127688;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767127688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-12-30 20:49:35", "2025-12-30 20:49:35", "162191", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58178", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 21:48:08", "2025-12-29 21:48:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767044888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767044888;}", "13", "1", "2025-12-29 21:51:51", "2025-12-29 21:51:51", "161980", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58179", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 20:48:08", "2025-12-29 20:48:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767041288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767041288;}", "9", "1", "2025-12-29 21:35:44", "2025-12-29 21:35:44", "161972", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58180", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 20:48:08", "2025-12-29 20:48:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767041288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767041288;}", "9", "1", "2025-12-29 21:35:44", "2025-12-29 21:35:44", "161972", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58181", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 21:35:44", "2025-12-29 21:35:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767044144;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767044144;}", "9", "1", "2025-12-29 21:36:25", "2025-12-29 21:36:25", "161974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58182", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 21:35:44", "2025-12-29 21:35:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767044144;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767044144;}", "9", "1", "2025-12-29 21:36:25", "2025-12-29 21:36:25", "161974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58183", "woocommerce_refresh_order_count_cache", "complete", "2025-12-30 09:44:14", "2025-12-30 09:44:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767087854;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767087854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-30 10:21:30", "2025-12-30 10:21:30", "162038", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58184", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 21:44:14", "2025-12-29 21:44:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767044654;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767044654;}", "9", "1", "2025-12-29 21:44:21", "2025-12-29 21:44:21", "161978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58185", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 22:51:51", "2025-12-29 22:51:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767048711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767048711;}", "13", "1", "2025-12-29 23:56:14", "2025-12-29 23:56:14", "161989", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58186", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 21:51:52", "2025-12-29 21:51:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767045112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767045112;}", "9", "1", "2025-12-29 21:51:56", "2025-12-29 21:51:56", "161983", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58187", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 21:55:59", "2025-12-29 21:55:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767045359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767045359;}", "9", "1", "2025-12-29 21:56:02", "2025-12-29 21:56:02", "161986", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58188", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 21:59:50", "2025-12-29 21:59:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767045590;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767045590;}", "9", "1", "2025-12-29 23:56:14", "2025-12-29 23:56:14", "161989", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58189", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 00:56:14", "2025-12-30 00:56:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767056174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767056174;}", "13", "1", "2025-12-30 02:26:15", "2025-12-30 02:26:15", "162012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58190", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-29 23:56:14", "2025-12-29 23:56:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767052574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767052574;}", "9", "1", "2025-12-29 23:56:23", "2025-12-29 23:56:23", "161991", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58191", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-29 23:56:14", "2025-12-29 23:56:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767052574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767052574;}", "9", "1", "2025-12-29 23:56:23", "2025-12-29 23:56:23", "161991", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58192", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 00:03:10", "2025-12-30 00:03:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767052990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767052990;}", "9", "1", "2025-12-30 00:04:13", "2025-12-30 00:04:13", "161995", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58193", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 00:04:14", "2025-12-30 00:04:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767053054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767053054;}", "9", "1", "2025-12-30 00:04:19", "2025-12-30 00:04:19", "161998", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58194", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 00:09:49", "2025-12-30 00:09:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767053389;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767053389;}", "9", "1", "2025-12-30 00:09:49", "2025-12-30 00:09:49", "162002", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58195", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 00:24:00", "2025-12-30 00:24:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767054240;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767054240;}", "9", "1", "2025-12-30 00:26:35", "2025-12-30 00:26:35", "162007", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58196", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 00:48:47", "2025-12-30 00:48:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767055727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767055727;}", "9", "1", "2025-12-30 00:48:55", "2025-12-30 00:48:55", "162010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58197", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 00:48:47", "2025-12-30 00:48:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767055727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767055727;}", "9", "1", "2025-12-30 00:48:55", "2025-12-30 00:48:55", "162010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58198", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 00:48:52", "2025-12-30 00:48:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767055732;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767055732;}", "9", "1", "2025-12-30 00:48:55", "2025-12-30 00:48:55", "162010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58199", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 03:26:15", "2025-12-30 03:26:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767065175;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767065175;}", "13", "1", "2025-12-30 04:24:56", "2025-12-30 04:24:56", "162020", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58200", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 02:26:15", "2025-12-30 02:26:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767061575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767061575;}", "9", "1", "2025-12-30 02:38:54", "2025-12-30 02:38:54", "162014", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58201", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 02:26:15", "2025-12-30 02:26:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767061575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767061575;}", "9", "1", "2025-12-30 02:38:54", "2025-12-30 02:38:54", "162014", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58202", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 02:38:54", "2025-12-30 02:38:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767062334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767062334;}", "9", "1", "2025-12-30 02:39:18", "2025-12-30 02:39:18", "162016", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58203", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 02:38:55", "2025-12-30 02:38:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767062335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767062335;}", "9", "1", "2025-12-30 02:39:18", "2025-12-30 02:39:18", "162016", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58204", "gla/jobs/resubmit_expiring_products/start", "complete", "2025-12-31 03:00:00", "2025-12-31 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767150000;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767150000;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2025-12-31 03:17:32", "2025-12-31 03:17:32", "162239", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58205", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 03:08:33", "2025-12-30 03:08:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767064113;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767064113;}", "9", "1", "2025-12-30 04:24:56", "2025-12-30 04:24:56", "162020", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58206", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 04:24:56", "2025-12-30 04:24:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767068696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767068696;}", "9", "1", "2025-12-30 04:24:56", "2025-12-30 04:24:56", "162020", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58207", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 05:24:56", "2025-12-30 05:24:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767072296;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767072296;}", "13", "1", "2025-12-30 07:03:18", "2025-12-30 07:03:18", "162024", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58208", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 04:24:56", "2025-12-30 04:24:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767068696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767068696;}", "9", "1", "2025-12-30 05:20:55", "2025-12-30 05:20:55", "162022", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58209", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 05:20:56", "2025-12-30 05:20:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767072056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767072056;}", "9", "1", "2025-12-30 07:03:18", "2025-12-30 07:03:18", "162024", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58210", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 05:20:56", "2025-12-30 05:20:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767072056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767072056;}", "9", "1", "2025-12-30 07:03:18", "2025-12-30 07:03:18", "162024", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58211", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 08:03:18", "2025-12-30 08:03:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767081798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767081798;}", "13", "1", "2025-12-30 08:27:15", "2025-12-30 08:27:15", "162034", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58213", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 07:03:18", "2025-12-30 07:03:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767078198;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767078198;}", "9", "1", "2025-12-30 07:21:45", "2025-12-30 07:21:45", "162026", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58214", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 07:03:18", "2025-12-30 07:03:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767078198;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767078198;}", "9", "1", "2025-12-30 07:21:45", "2025-12-30 07:21:45", "162026", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58215", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-30 07:03:29", "2025-12-30 07:03:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767078209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767078209;}", "9", "1", "2025-12-30 07:21:45", "2025-12-30 07:21:45", "162026", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58216", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 07:21:44", "2025-12-30 07:21:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767079304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767079304;}", "9", "1", "2025-12-30 07:21:45", "2025-12-30 07:21:45", "162026", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58217", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 07:21:44", "2025-12-30 07:21:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767079304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767079304;}", "9", "1", "2025-12-30 07:21:45", "2025-12-30 07:21:45", "162026", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58218", "wc_admin_daily_wrapper", "complete", "2025-12-31 07:31:11", "2025-12-31 07:31:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166271;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-31 07:31:17", "2025-12-31 07:31:17", "162280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58219", "woocommerce_cleanup_personal_data", "complete", "2025-12-31 07:31:12", "2025-12-31 07:31:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166272;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "162280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58220", "woocommerce_tracker_send_event_wrapper", "complete", "2025-12-31 07:31:12", "2025-12-31 07:31:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166272;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "162280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58221", "woocommerce_cleanup_logs", "complete", "2025-12-31 07:31:12", "2025-12-31 07:31:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166272;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "162280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58222", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-31 07:31:12", "2025-12-31 07:31:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166272;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "162280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58223", "fetch_patterns", "complete", "2025-12-31 07:31:13", "2025-12-31 07:31:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166273;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "162280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58224", "woocommerce_cleanup_sessions", "complete", "2025-12-31 06:00:00", "2025-12-31 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767160800;s:18:\"\0*\0first_timestamp\";i:1767160800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767160800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2025-12-31 07:18:39", "2025-12-31 07:18:39", "162274", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58225", "generate_category_lookup_table_wrapper", "complete", "2025-12-30 07:31:23", "2025-12-30 07:31:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767079883;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767079883;}", "13", "1", "2025-12-30 07:58:28", "2025-12-30 07:58:28", "162032", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58226", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-31 07:31:13", "2025-12-31 07:31:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166273;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "162280", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58227", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 07:31:13", "2025-12-30 07:31:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767079873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767079873;}", "9", "1", "2025-12-30 07:31:17", "2025-12-30 07:31:17", "162030", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58228", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 07:31:13", "2025-12-30 07:31:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767079873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767079873;}", "9", "1", "2025-12-30 07:31:17", "2025-12-30 07:31:17", "162030", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58229", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 07:58:28", "2025-12-30 07:58:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767081508;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767081508;}", "9", "1", "2025-12-30 08:27:15", "2025-12-30 08:27:15", "162034", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58230", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 08:27:15", "2025-12-30 08:27:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767083235;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767083235;}", "9", "1", "2025-12-30 08:27:15", "2025-12-30 08:27:15", "162034", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58231", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 09:27:15", "2025-12-30 09:27:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767086835;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767086835;}", "13", "1", "2025-12-30 10:21:30", "2025-12-30 10:21:30", "162038", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58232", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 09:04:49", "2025-12-30 09:04:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767085489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767085489;}", "9", "1", "2025-12-30 10:00:52", "2025-12-30 10:00:52", "162037", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58233", "facebook_for_woocommerce_daily_heartbeat", "complete", "2025-12-30 09:04:49", "2025-12-30 09:04:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767085489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767085489;}", "9", "1", "2025-12-30 10:01:11", "2025-12-30 10:01:11", "162037", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58234", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 09:04:49", "2025-12-30 09:04:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767085489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767085489;}", "9", "1", "2025-12-30 10:21:30", "2025-12-30 10:21:30", "162038", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58235", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 10:01:09", "2025-12-30 10:01:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767088869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767088869;}", "9", "1", "2025-12-30 10:21:31", "2025-12-30 10:21:31", "162038", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58236", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 10:01:09", "2025-12-30 10:01:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767088869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767088869;}", "9", "1", "2025-12-30 10:21:31", "2025-12-30 10:21:31", "162038", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58237", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 11:21:30", "2025-12-30 11:21:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767093690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767093690;}", "13", "1", "2025-12-30 11:42:26", "2025-12-30 11:42:26", "162052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58238", "woocommerce_refresh_order_count_cache", "complete", "2025-12-30 22:21:30", "2025-12-30 22:21:30", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767133290;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767133290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-30 22:22:19", "2025-12-30 22:22:19", "162202", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58239", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 10:21:31", "2025-12-30 10:21:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767090091;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767090091;}", "9", "1", "2025-12-30 10:25:06", "2025-12-30 10:25:06", "162040", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58240", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 10:25:06", "2025-12-30 10:25:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767090306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767090306;}", "9", "1", "2025-12-30 10:27:22", "2025-12-30 10:27:22", "162042", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58241", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 10:37:36", "2025-12-30 10:37:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767091056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767091056;}", "9", "1", "2025-12-30 10:37:41", "2025-12-30 10:37:41", "162045", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58242", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 10:37:36", "2025-12-30 10:37:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767091056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767091056;}", "9", "1", "2025-12-30 10:37:41", "2025-12-30 10:37:41", "162045", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58243", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 10:39:24", "2025-12-30 10:39:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767091164;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767091164;}", "9", "1", "2025-12-30 10:41:22", "2025-12-30 10:41:22", "162048", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58244", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 10:46:23", "2025-12-30 10:46:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767091583;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767091583;}", "9", "1", "2025-12-30 11:42:26", "2025-12-30 11:42:26", "162052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58245", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 12:42:26", "2025-12-30 12:42:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767098546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767098546;}", "13", "1", "2025-12-30 12:44:52", "2025-12-30 12:44:52", "162062", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58246", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 11:42:27", "2025-12-30 11:42:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767094947;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767094947;}", "9", "1", "2025-12-30 11:42:32", "2025-12-30 11:42:32", "162055", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58247", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 11:42:27", "2025-12-30 11:42:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767094947;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767094947;}", "9", "1", "2025-12-30 11:42:32", "2025-12-30 11:42:32", "162055", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58248", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 11:56:55", "2025-12-30 11:56:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767095815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767095815;}", "9", "1", "2025-12-30 12:29:31", "2025-12-30 12:29:31", "162058", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58249", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 12:29:31", "2025-12-30 12:29:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767097771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767097771;}", "9", "1", "2025-12-30 12:29:37", "2025-12-30 12:29:37", "162060", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58250", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 13:44:52", "2025-12-30 13:44:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767102292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767102292;}", "13", "1", "2025-12-30 13:55:59", "2025-12-30 13:55:59", "162069", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58251", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 12:44:52", "2025-12-30 12:44:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767098692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767098692;}", "9", "1", "2025-12-30 12:46:43", "2025-12-30 12:46:43", "162064", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58252", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 12:44:52", "2025-12-30 12:44:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767098692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767098692;}", "9", "1", "2025-12-30 12:46:43", "2025-12-30 12:46:43", "162064", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58253", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 13:01:03", "2025-12-30 13:01:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767099663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767099663;}", "9", "1", "2025-12-30 13:17:21", "2025-12-30 13:17:21", "162067", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58254", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 13:17:21", "2025-12-30 13:17:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767100641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767100641;}", "9", "1", "2025-12-30 13:55:59", "2025-12-30 13:55:59", "162069", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58255", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 14:55:59", "2025-12-30 14:55:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767106559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767106559;}", "13", "1", "2025-12-30 15:18:16", "2025-12-30 15:18:16", "162081", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58256", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 13:55:59", "2025-12-30 13:55:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767102959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767102959;}", "9", "1", "2025-12-30 14:06:25", "2025-12-30 14:06:25", "162071", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58257", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 13:55:59", "2025-12-30 13:55:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767102959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767102959;}", "9", "1", "2025-12-30 14:06:26", "2025-12-30 14:06:26", "162071", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58258", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 14:06:27", "2025-12-30 14:06:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767103587;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767103587;}", "9", "1", "2025-12-30 14:16:15", "2025-12-30 14:16:15", "162073", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58259", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 14:16:15", "2025-12-30 14:16:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767104175;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767104175;}", "9", "1", "2025-12-30 14:16:38", "2025-12-30 14:16:38", "162075", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58260", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 14:24:34", "2025-12-30 14:24:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767104674;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767104674;}", "9", "1", "2025-12-30 14:38:07", "2025-12-30 14:38:07", "162079", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58261", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 14:38:07", "2025-12-30 14:38:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767105487;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767105487;}", "9", "1", "2025-12-30 15:18:16", "2025-12-30 15:18:16", "162081", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58262", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 14:38:07", "2025-12-30 14:38:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767105487;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767105487;}", "9", "1", "2025-12-30 15:18:16", "2025-12-30 15:18:16", "162081", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58263", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 16:18:16", "2025-12-30 16:18:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767111496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767111496;}", "13", "1", "2025-12-30 16:46:55", "2025-12-30 16:46:55", "162087", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58264", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 15:18:16", "2025-12-30 15:18:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767107896;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767107896;}", "9", "1", "2025-12-30 15:18:22", "2025-12-30 15:18:22", "162083", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58265", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 15:41:05", "2025-12-30 15:41:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767109265;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767109265;}", "9", "1", "2025-12-30 15:41:05", "2025-12-30 15:41:05", "162085", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58266", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 15:41:05", "2025-12-30 15:41:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767109265;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767109265;}", "9", "1", "2025-12-30 16:46:55", "2025-12-30 16:46:55", "162087", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58267", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 17:46:55", "2025-12-30 17:46:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767116815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767116815;}", "13", "1", "2025-12-30 17:57:56", "2025-12-30 17:57:56", "162091", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58268", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 16:46:55", "2025-12-30 16:46:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767113215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767113215;}", "9", "1", "2025-12-30 17:15:39", "2025-12-30 17:15:39", "162089", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58269", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 16:46:55", "2025-12-30 16:46:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767113215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767113215;}", "9", "1", "2025-12-30 17:15:40", "2025-12-30 17:15:40", "162089", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58270", "woocommerce_scheduled_sales", "complete", "2025-12-31 17:15:40", "2025-12-31 17:15:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767201340;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767201340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2025-12-31 17:18:26", "2025-12-31 17:18:26", "162386", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58271", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 17:15:40", "2025-12-30 17:15:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767114940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767114940;}", "9", "1", "2025-12-30 17:57:56", "2025-12-30 17:57:56", "162091", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58272", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 18:57:56", "2025-12-30 18:57:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767121076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767121076;}", "13", "1", "2025-12-30 19:07:02", "2025-12-30 19:07:02", "162136", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58273", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 17:57:56", "2025-12-30 17:57:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767117476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767117476;}", "9", "1", "2025-12-30 17:58:01", "2025-12-30 17:58:01", "162093", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58274", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 17:57:56", "2025-12-30 17:57:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767117476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767117476;}", "9", "1", "2025-12-30 17:58:01", "2025-12-30 17:58:01", "162093", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58275", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:08:58", "2025-12-30 18:08:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767118138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767118138;}", "9", "1", "2025-12-30 18:11:29", "2025-12-30 18:11:29", "162096", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58276", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:15:23", "2025-12-30 18:15:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767118523;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767118523;}", "9", "1", "2025-12-30 18:19:36", "2025-12-30 18:19:36", "162099", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58277", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:19:36", "2025-12-30 18:19:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767118776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767118776;}", "9", "1", "2025-12-30 18:20:16", "2025-12-30 18:20:16", "162101", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58278", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:23:50", "2025-12-30 18:23:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767119030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767119030;}", "9", "1", "2025-12-30 18:24:17", "2025-12-30 18:24:17", "162106", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58279", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:28:50", "2025-12-30 18:28:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767119330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767119330;}", "9", "1", "2025-12-30 18:29:17", "2025-12-30 18:29:17", "162112", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58280", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 18:33:52", "2025-12-30 18:33:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767119632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767119632;}", "9", "1", "2025-12-30 18:33:52", "2025-12-30 18:33:52", "162115", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58281", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:33:52", "2025-12-30 18:33:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767119632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767119632;}", "9", "1", "2025-12-30 18:36:47", "2025-12-30 18:36:47", "162117", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58282", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:41:13", "2025-12-30 18:41:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767120073;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767120073;}", "9", "1", "2025-12-30 18:41:31", "2025-12-30 18:41:31", "162121", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58283", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:45:06", "2025-12-30 18:45:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767120306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767120306;}", "9", "1", "2025-12-30 18:45:06", "2025-12-30 18:45:06", "162125", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58284", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:49:33", "2025-12-30 18:49:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767120573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767120573;}", "9", "1", "2025-12-30 18:51:46", "2025-12-30 18:51:46", "162130", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58285", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 18:54:07", "2025-12-30 18:54:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767120847;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767120847;}", "9", "1", "2025-12-30 18:55:54", "2025-12-30 18:55:54", "162133", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58286", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 20:07:02", "2025-12-30 20:07:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767125222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767125222;}", "13", "1", "2025-12-30 20:08:07", "2025-12-30 20:08:07", "162173", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58287", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:07:02", "2025-12-30 19:07:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767121622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767121622;}", "9", "1", "2025-12-30 19:09:36", "2025-12-30 19:09:36", "162138", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58288", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-30 19:07:02", "2025-12-30 19:07:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767121622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767121622;}", "9", "1", "2025-12-30 19:09:36", "2025-12-30 19:09:36", "162138", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58289", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:09:36", "2025-12-30 19:09:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767121776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767121776;}", "9", "1", "2025-12-30 19:10:27", "2025-12-30 19:10:27", "162140", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58290", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:15:30", "2025-12-30 19:15:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767122130;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767122130;}", "9", "1", "2025-12-30 19:15:30", "2025-12-30 19:15:30", "162143", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58291", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:21:36", "2025-12-30 19:21:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767122496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767122496;}", "9", "1", "2025-12-30 19:23:08", "2025-12-30 19:23:08", "162146", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58292", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:27:36", "2025-12-30 19:27:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767122856;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767122856;}", "9", "1", "2025-12-30 19:27:36", "2025-12-30 19:27:36", "162149", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58293", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:28:59", "2025-12-30 19:28:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767122939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767122939;}", "9", "1", "2025-12-30 19:29:41", "2025-12-30 19:29:41", "162152", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58294", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 19:31:51", "2025-12-30 19:31:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767123111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767123111;}", "9", "1", "2025-12-30 19:31:51", "2025-12-30 19:31:51", "162155", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58295", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:33:57", "2025-12-30 19:33:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767123237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767123237;}", "9", "1", "2025-12-30 19:38:34", "2025-12-30 19:38:34", "162158", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58296", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:42:09", "2025-12-30 19:42:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767123729;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767123729;}", "9", "1", "2025-12-30 19:42:09", "2025-12-30 19:42:09", "162160", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58297", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:44:25", "2025-12-30 19:44:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767123865;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767123865;}", "9", "1", "2025-12-30 19:47:09", "2025-12-30 19:47:09", "162164", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58298", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:49:32", "2025-12-30 19:49:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767124172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767124172;}", "9", "1", "2025-12-30 19:51:43", "2025-12-30 19:51:43", "162167", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58299", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 19:59:09", "2025-12-30 19:59:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767124749;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767124749;}", "9", "1", "2025-12-30 19:59:09", "2025-12-30 19:59:09", "162170", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58300", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:08:07", "2025-12-30 20:08:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767125287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767125287;}", "9", "1", "2025-12-30 20:08:07", "2025-12-30 20:08:07", "162173", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58301", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 21:08:07", "2025-12-30 21:08:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767128887;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767128887;}", "13", "1", "2025-12-30 21:17:46", "2025-12-30 21:17:46", "162193", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58302", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:08:57", "2025-12-30 20:08:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767125337;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767125337;}", "9", "1", "2025-12-30 20:09:56", "2025-12-30 20:09:56", "162176", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58303", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:15:55", "2025-12-30 20:15:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767125755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767125755;}", "9", "1", "2025-12-30 20:19:21", "2025-12-30 20:19:21", "162180", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58304", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:19:21", "2025-12-30 20:19:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767125961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767125961;}", "9", "1", "2025-12-30 20:21:19", "2025-12-30 20:21:19", "162182", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58305", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:24:53", "2025-12-30 20:24:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767126293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767126293;}", "9", "1", "2025-12-30 20:37:18", "2025-12-30 20:37:18", "162185", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58306", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:37:18", "2025-12-30 20:37:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767127038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767127038;}", "9", "1", "2025-12-30 20:38:25", "2025-12-30 20:38:25", "162187", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58307", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 20:37:18", "2025-12-30 20:37:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767127038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767127038;}", "9", "1", "2025-12-30 20:38:25", "2025-12-30 20:38:25", "162187", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58308", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:42:58", "2025-12-30 20:42:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767127378;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767127378;}", "9", "1", "2025-12-30 20:42:59", "2025-12-30 20:42:59", "162189", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58309", "woocommerce_cleanup_draft_orders", "complete", "2025-12-31 20:49:24", "2025-12-31 20:49:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767214164;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767214164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-12-31 20:57:39", "2025-12-31 20:57:39", "162424", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58310", "wc_gla_cron_daily_notes", "complete", "2025-12-31 20:49:24", "2025-12-31 20:49:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767214164;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767214164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-31 20:57:39", "2025-12-31 20:57:39", "162424", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58311", "wc_facebook_regenerate_feed", "complete", "2025-12-31 20:49:35", "2025-12-31 20:49:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767214175;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767214175;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-12-31 20:57:49", "2025-12-31 20:57:49", "162424", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58312", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 20:49:35", "2025-12-30 20:49:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767127775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767127775;}", "9", "1", "2025-12-30 21:17:46", "2025-12-30 21:17:46", "162193", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58313", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 22:17:46", "2025-12-30 22:17:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767133066;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767133066;}", "13", "1", "2025-12-30 22:22:19", "2025-12-30 22:22:19", "162202", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58314", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 21:17:46", "2025-12-30 21:17:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767129466;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767129466;}", "9", "1", "2025-12-30 21:55:20", "2025-12-30 21:55:20", "162195", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58315", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 21:55:20", "2025-12-30 21:55:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767131720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767131720;}", "9", "1", "2025-12-30 22:06:18", "2025-12-30 22:06:18", "162197", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58316", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 21:55:20", "2025-12-30 21:55:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767131720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767131720;}", "9", "1", "2025-12-30 22:06:18", "2025-12-30 22:06:18", "162197", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58317", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 22:06:18", "2025-12-30 22:06:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767132378;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767132378;}", "9", "1", "2025-12-30 22:06:19", "2025-12-30 22:06:19", "162199", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58318", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 22:15:39", "2025-12-30 22:15:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767132939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767132939;}", "9", "1", "2025-12-30 22:22:19", "2025-12-30 22:22:19", "162202", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58319", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 23:22:19", "2025-12-30 23:22:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767136939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767136939;}", "13", "1", "2025-12-30 23:26:18", "2025-12-30 23:26:18", "162212", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58320", "woocommerce_refresh_order_count_cache", "complete", "2025-12-31 10:22:19", "2025-12-31 10:22:19", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767176539;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767176539;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-31 11:04:41", "2025-12-31 11:04:41", "162307", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58321", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 22:22:20", "2025-12-30 22:22:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767133340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767133340;}", "9", "1", "2025-12-30 22:22:24", "2025-12-30 22:22:24", "162205", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58322", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 22:30:49", "2025-12-30 22:30:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767133849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767133849;}", "9", "1", "2025-12-30 22:41:03", "2025-12-30 22:41:03", "162208", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58323", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 22:30:49", "2025-12-30 22:30:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767133849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767133849;}", "9", "1", "2025-12-30 22:41:03", "2025-12-30 22:41:03", "162208", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58324", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 22:41:03", "2025-12-30 22:41:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767134463;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767134463;}", "9", "1", "2025-12-30 22:41:03", "2025-12-30 22:41:03", "162210", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58325", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 00:26:18", "2025-12-31 00:26:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767140778;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767140778;}", "13", "1", "2025-12-31 00:37:40", "2025-12-31 00:37:40", "162221", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58326", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 23:26:18", "2025-12-30 23:26:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767137178;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767137178;}", "9", "1", "2025-12-30 23:26:22", "2025-12-30 23:26:22", "162214", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58327", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-30 23:57:57", "2025-12-30 23:57:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767139077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767139077;}", "9", "1", "2025-12-31 00:01:13", "2025-12-31 00:01:13", "162217", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58328", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-30 23:57:57", "2025-12-30 23:57:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767139077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767139077;}", "9", "1", "2025-12-31 00:01:13", "2025-12-31 00:01:13", "162217", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58329", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 00:01:13", "2025-12-31 00:01:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767139273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767139273;}", "9", "1", "2025-12-31 00:01:19", "2025-12-31 00:01:19", "162219", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58330", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 01:37:40", "2025-12-31 01:37:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767145060;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767145060;}", "13", "1", "2025-12-31 01:52:40", "2025-12-31 01:52:40", "162229", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58331", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 00:37:40", "2025-12-31 00:37:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767141460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767141460;}", "9", "1", "2025-12-31 00:56:42", "2025-12-31 00:56:42", "162223", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58332", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 00:37:40", "2025-12-31 00:37:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767141460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767141460;}", "9", "1", "2025-12-31 00:56:42", "2025-12-31 00:56:42", "162223", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58333", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 00:56:42", "2025-12-31 00:56:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767142602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767142602;}", "9", "1", "2025-12-31 01:14:58", "2025-12-31 01:14:58", "162225", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58334", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 01:14:58", "2025-12-31 01:14:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767143698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767143698;}", "9", "1", "2025-12-31 01:32:26", "2025-12-31 01:32:26", "162227", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58335", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 01:32:26", "2025-12-31 01:32:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767144746;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767144746;}", "9", "1", "2025-12-31 01:52:40", "2025-12-31 01:52:40", "162229", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58336", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 01:32:26", "2025-12-31 01:32:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767144746;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767144746;}", "9", "1", "2025-12-31 01:52:40", "2025-12-31 01:52:40", "162229", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58337", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 02:52:40", "2025-12-31 02:52:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767149560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767149560;}", "13", "1", "2025-12-31 02:54:14", "2025-12-31 02:54:14", "162235", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58338", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 01:52:40", "2025-12-31 01:52:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767145960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767145960;}", "9", "1", "2025-12-31 02:10:44", "2025-12-31 02:10:44", "162231", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58339", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 02:10:44", "2025-12-31 02:10:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767147044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767147044;}", "9", "1", "2025-12-31 02:30:31", "2025-12-31 02:30:31", "162233", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58340", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 02:30:31", "2025-12-31 02:30:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767148231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767148231;}", "9", "1", "2025-12-31 02:54:14", "2025-12-31 02:54:14", "162235", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58341", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 02:30:44", "2025-12-31 02:30:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767148244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767148244;}", "9", "1", "2025-12-31 02:54:14", "2025-12-31 02:54:14", "162235", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58342", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 03:54:14", "2025-12-31 03:54:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767153254;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767153254;}", "13", "1", "2025-12-31 03:57:03", "2025-12-31 03:57:03", "162252", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58343", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 02:54:14", "2025-12-31 02:54:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767149654;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767149654;}", "9", "1", "2025-12-31 02:54:29", "2025-12-31 02:54:29", "162237", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58344", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-01 03:00:00", "2026-01-01 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767236400;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767236400;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-01 03:01:15", "2026-01-01 03:01:15", "162505", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58345", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 03:17:32", "2025-12-31 03:17:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767151052;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767151052;}", "9", "1", "2025-12-31 03:17:54", "2025-12-31 03:17:54", "162241", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58346", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 03:29:51", "2025-12-31 03:29:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767151791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767151791;}", "9", "1", "2025-12-31 03:32:25", "2025-12-31 03:32:25", "162244", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58347", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 03:32:25", "2025-12-31 03:32:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767151945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767151945;}", "9", "1", "2025-12-31 03:32:25", "2025-12-31 03:32:25", "162246", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58348", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 03:34:15", "2025-12-31 03:34:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767152055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767152055;}", "9", "1", "2025-12-31 03:34:20", "2025-12-31 03:34:20", "162249", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58349", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 04:57:03", "2025-12-31 04:57:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767157023;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767157023;}", "13", "1", "2025-12-31 04:59:28", "2025-12-31 04:59:28", "162261", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58350", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 03:57:03", "2025-12-31 03:57:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767153423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767153423;}", "9", "1", "2025-12-31 03:58:03", "2025-12-31 03:58:03", "162254", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58351", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 04:06:33", "2025-12-31 04:06:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767153993;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767153993;}", "9", "1", "2025-12-31 04:49:18", "2025-12-31 04:49:18", "162257", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58352", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 04:49:18", "2025-12-31 04:49:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767156558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767156558;}", "9", "1", "2025-12-31 04:49:35", "2025-12-31 04:49:35", "162259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58353", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 04:49:18", "2025-12-31 04:49:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767156558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767156558;}", "9", "1", "2025-12-31 04:49:35", "2025-12-31 04:49:35", "162259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58354", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 05:59:28", "2025-12-31 05:59:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767160768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767160768;}", "13", "1", "2025-12-31 07:18:39", "2025-12-31 07:18:39", "162274", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58355", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 04:59:28", "2025-12-31 04:59:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767157168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767157168;}", "9", "1", "2025-12-31 04:59:44", "2025-12-31 04:59:44", "162263", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58356", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 05:13:39", "2025-12-31 05:13:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767158019;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767158019;}", "9", "1", "2025-12-31 05:14:56", "2025-12-31 05:14:56", "162266", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58357", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 05:14:56", "2025-12-31 05:14:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767158096;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767158096;}", "9", "1", "2025-12-31 05:14:56", "2025-12-31 05:14:56", "162266", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58358", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 05:25:50", "2025-12-31 05:25:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767158750;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767158750;}", "9", "1", "2025-12-31 05:27:42", "2025-12-31 05:27:42", "162270", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58359", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 05:43:19", "2025-12-31 05:43:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767159799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767159799;}", "9", "1", "2025-12-31 07:18:39", "2025-12-31 07:18:39", "162274", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58360", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 05:43:19", "2025-12-31 05:43:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767159799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767159799;}", "9", "1", "2025-12-31 07:18:39", "2025-12-31 07:18:39", "162274", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58361", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 07:18:39", "2025-12-31 07:18:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767165519;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767165519;}", "9", "1", "2025-12-31 07:18:39", "2025-12-31 07:18:39", "162274", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58362", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 08:18:39", "2025-12-31 08:18:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767169119;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767169119;}", "13", "1", "2025-12-31 09:50:44", "2025-12-31 09:50:44", "162290", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58364", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 07:18:49", "2025-12-31 07:18:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767165529;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767165529;}", "9", "1", "2025-12-31 07:18:56", "2025-12-31 07:18:56", "162276", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58365", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-31 07:18:49", "2025-12-31 07:18:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767165529;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767165529;}", "9", "1", "2025-12-31 07:18:56", "2025-12-31 07:18:56", "162276", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58366", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 07:18:56", "2025-12-31 07:18:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767165536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767165536;}", "9", "1", "2025-12-31 07:19:02", "2025-12-31 07:19:02", "162278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58367", "wc_admin_daily_wrapper", "complete", "2026-01-01 07:31:17", "2026-01-01 07:31:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767252677;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767252677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-01 08:13:35", "2026-01-01 08:13:35", "162559", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58368", "woocommerce_cleanup_personal_data", "complete", "2026-01-01 07:31:18", "2026-01-01 07:31:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767252678;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767252678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-01 08:13:36", "2026-01-01 08:13:36", "162559", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58369", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-01 07:31:18", "2026-01-01 07:31:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767252678;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767252678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-01 08:13:38", "2026-01-01 08:13:38", "162559", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58370", "woocommerce_cleanup_logs", "complete", "2026-01-01 07:31:18", "2026-01-01 07:31:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767252678;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767252678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-01 08:13:39", "2026-01-01 08:13:39", "162559", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58371", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-01 07:31:18", "2026-01-01 07:31:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767252678;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767252678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-01 08:13:39", "2026-01-01 08:13:39", "162559", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58372", "fetch_patterns", "complete", "2026-01-01 07:31:18", "2026-01-01 07:31:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767252678;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767252678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-01 08:13:39", "2026-01-01 08:13:39", "162559", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58373", "woocommerce_cleanup_sessions", "complete", "2026-01-01 06:00:00", "2026-01-01 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767247200;s:18:\"\0*\0first_timestamp\";i:1767247200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767247200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-01 07:21:38", "2026-01-01 07:21:38", "162555", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58374", "generate_category_lookup_table_wrapper", "complete", "2025-12-31 07:31:28", "2025-12-31 07:31:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767166288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767166288;}", "13", "1", "2025-12-31 08:02:48", "2025-12-31 08:02:48", "162284", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58375", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-01 07:31:18", "2026-01-01 07:31:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767252678;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767252678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-01 08:13:39", "2026-01-01 08:13:39", "162559", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58376", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767166278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767166278;}", "9", "1", "2025-12-31 07:31:22", "2025-12-31 07:31:22", "162282", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58377", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 07:31:18", "2025-12-31 07:31:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767166278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767166278;}", "9", "1", "2025-12-31 07:31:22", "2025-12-31 07:31:22", "162282", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58378", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 08:02:48", "2025-12-31 08:02:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767168168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767168168;}", "9", "1", "2025-12-31 08:02:53", "2025-12-31 08:02:53", "162287", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58379", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 08:16:08", "2025-12-31 08:16:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767168968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767168968;}", "9", "1", "2025-12-31 09:50:44", "2025-12-31 09:50:44", "162290", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58380", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 10:50:44", "2025-12-31 10:50:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767178244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767178244;}", "13", "1", "2025-12-31 11:04:41", "2025-12-31 11:04:41", "162307", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58381", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 09:50:44", "2025-12-31 09:50:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767174644;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767174644;}", "9", "1", "2025-12-31 09:53:28", "2025-12-31 09:53:28", "162292", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58382", "facebook_for_woocommerce_daily_heartbeat", "complete", "2025-12-31 09:50:46", "2025-12-31 09:50:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767174646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767174646;}", "9", "1", "2025-12-31 09:53:29", "2025-12-31 09:53:29", "162292", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58383", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 09:50:46", "2025-12-31 09:50:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767174646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767174646;}", "9", "1", "2025-12-31 09:53:29", "2025-12-31 09:53:29", "162292", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58384", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 09:54:15", "2025-12-31 09:54:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767174855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767174855;}", "9", "1", "2025-12-31 09:54:30", "2025-12-31 09:54:30", "162294", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58385", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 09:59:04", "2025-12-31 09:59:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767175144;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767175144;}", "9", "1", "2025-12-31 10:01:24", "2025-12-31 10:01:24", "162300", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58386", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 10:04:15", "2025-12-31 10:04:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767175455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767175455;}", "9", "1", "2025-12-31 10:04:36", "2025-12-31 10:04:36", "162303", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58387", "woocommerce_refresh_order_count_cache", "complete", "2025-12-31 23:04:41", "2025-12-31 23:04:41", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767222281;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767222281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-31 23:13:46", "2025-12-31 23:13:46", "162445", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58388", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 12:04:41", "2025-12-31 12:04:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767182681;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767182681;}", "13", "1", "2025-12-31 12:07:36", "2025-12-31 12:07:36", "162322", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58389", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 11:04:41", "2025-12-31 11:04:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179081;}", "9", "1", "2025-12-31 11:04:58", "2025-12-31 11:04:58", "162309", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58390", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 11:04:41", "2025-12-31 11:04:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179081;}", "9", "1", "2025-12-31 11:04:58", "2025-12-31 11:04:58", "162309", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58391", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 11:11:29", "2025-12-31 11:11:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179489;}", "9", "1", "2025-12-31 11:11:37", "2025-12-31 11:11:37", "162312", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58392", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 11:34:55", "2025-12-31 11:34:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767180895;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767180895;}", "9", "1", "2025-12-31 11:35:08", "2025-12-31 11:35:08", "162315", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58393", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 11:34:55", "2025-12-31 11:34:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767180895;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767180895;}", "9", "1", "2025-12-31 11:35:08", "2025-12-31 11:35:08", "162315", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58394", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 11:55:02", "2025-12-31 11:55:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767182102;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767182102;}", "9", "1", "2025-12-31 11:55:12", "2025-12-31 11:55:12", "162319", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58395", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 13:07:36", "2025-12-31 13:07:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767186456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767186456;}", "13", "1", "2025-12-31 13:19:59", "2025-12-31 13:19:59", "162334", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58396", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 12:07:36", "2025-12-31 12:07:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767182856;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767182856;}", "9", "1", "2025-12-31 12:07:48", "2025-12-31 12:07:48", "162324", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58397", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 12:19:11", "2025-12-31 12:19:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767183551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767183551;}", "9", "1", "2025-12-31 12:19:18", "2025-12-31 12:19:18", "162327", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58398", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 12:41:11", "2025-12-31 12:41:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767184871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767184871;}", "9", "1", "2025-12-31 12:41:17", "2025-12-31 12:41:17", "162331", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58399", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 12:41:11", "2025-12-31 12:41:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767184871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767184871;}", "9", "1", "2025-12-31 12:41:17", "2025-12-31 12:41:17", "162331", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58400", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 14:19:59", "2025-12-31 14:19:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767190799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767190799;}", "13", "1", "2025-12-31 14:34:47", "2025-12-31 14:34:47", "162352", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58401", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 13:19:59", "2025-12-31 13:19:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767187199;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767187199;}", "9", "1", "2025-12-31 13:20:00", "2025-12-31 13:20:00", "162336", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58402", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 13:46:25", "2025-12-31 13:46:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767188785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767188785;}", "9", "1", "2025-12-31 13:46:31", "2025-12-31 13:46:31", "162339", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58403", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 13:46:25", "2025-12-31 13:46:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767188785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767188785;}", "9", "1", "2025-12-31 13:46:31", "2025-12-31 13:46:31", "162339", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58404", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 13:55:44", "2025-12-31 13:55:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767189344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767189344;}", "9", "1", "2025-12-31 14:06:28", "2025-12-31 14:06:28", "162342", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58405", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 14:06:28", "2025-12-31 14:06:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767189988;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767189988;}", "9", "1", "2025-12-31 14:06:34", "2025-12-31 14:06:34", "162344", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58406", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 14:11:37", "2025-12-31 14:11:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767190297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767190297;}", "9", "1", "2025-12-31 14:14:28", "2025-12-31 14:14:28", "162347", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58407", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 14:14:28", "2025-12-31 14:14:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767190468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767190468;}", "9", "1", "2025-12-31 14:15:17", "2025-12-31 14:15:17", "162349", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58408", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 15:34:47", "2025-12-31 15:34:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767195287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767195287;}", "13", "1", "2025-12-31 16:01:22", "2025-12-31 16:01:22", "162365", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58409", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 14:34:47", "2025-12-31 14:34:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767191687;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767191687;}", "9", "1", "2025-12-31 14:34:52", "2025-12-31 14:34:52", "162354", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58410", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 14:34:47", "2025-12-31 14:34:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767191687;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767191687;}", "9", "1", "2025-12-31 14:34:52", "2025-12-31 14:34:52", "162354", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58411", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 14:43:30", "2025-12-31 14:43:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767192210;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767192210;}", "9", "1", "2025-12-31 14:43:37", "2025-12-31 14:43:37", "162357", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58412", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 15:01:09", "2025-12-31 15:01:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767193269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767193269;}", "9", "1", "2025-12-31 15:01:09", "2025-12-31 15:01:09", "162359", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58413", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 15:26:18", "2025-12-31 15:26:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767194778;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767194778;}", "9", "1", "2025-12-31 15:26:25", "2025-12-31 15:26:25", "162362", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58414", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 15:28:53", "2025-12-31 15:28:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767194933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767194933;}", "9", "1", "2025-12-31 16:01:22", "2025-12-31 16:01:22", "162365", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58415", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 17:01:22", "2025-12-31 17:01:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767200482;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767200482;}", "13", "1", "2025-12-31 17:18:26", "2025-12-31 17:18:26", "162386", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58416", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 16:01:22", "2025-12-31 16:01:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767196882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767196882;}", "9", "1", "2025-12-31 16:01:22", "2025-12-31 16:01:22", "162367", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58417", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 16:01:22", "2025-12-31 16:01:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767196882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767196882;}", "9", "1", "2025-12-31 16:01:23", "2025-12-31 16:01:23", "162367", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58418", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 16:04:29", "2025-12-31 16:04:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767197069;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767197069;}", "9", "1", "2025-12-31 16:04:37", "2025-12-31 16:04:37", "162370", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58419", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 16:36:04", "2025-12-31 16:36:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767198964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767198964;}", "9", "1", "2025-12-31 16:36:10", "2025-12-31 16:36:10", "162373", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58420", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 16:36:04", "2025-12-31 16:36:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767198964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767198964;}", "9", "1", "2025-12-31 16:36:10", "2025-12-31 16:36:10", "162373", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58421", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 16:39:41", "2025-12-31 16:39:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767199181;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767199181;}", "9", "1", "2025-12-31 16:44:28", "2025-12-31 16:44:28", "162377", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58422", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 16:44:28", "2025-12-31 16:44:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767199468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767199468;}", "9", "1", "2025-12-31 16:44:54", "2025-12-31 16:44:54", "162379", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58423", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 16:59:08", "2025-12-31 16:59:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767200348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767200348;}", "9", "1", "2025-12-31 16:59:16", "2025-12-31 16:59:16", "162382", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58424", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 18:18:26", "2025-12-31 18:18:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767205106;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767205106;}", "13", "1", "2025-12-31 18:28:03", "2025-12-31 18:28:03", "162399", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58425", "woocommerce_scheduled_sales", "complete", "2026-01-01 17:18:26", "2026-01-01 17:18:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767287906;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767287906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-01 17:41:37", "2026-01-01 17:41:37", "162600", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58426", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 17:18:26", "2025-12-31 17:18:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767201506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767201506;}", "9", "1", "2025-12-31 17:18:32", "2025-12-31 17:18:32", "162388", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58427", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 17:25:56", "2025-12-31 17:25:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767201956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767201956;}", "9", "1", "2025-12-31 17:25:56", "2025-12-31 17:25:56", "162390", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58428", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 17:35:30", "2025-12-31 17:35:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767202530;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767202530;}", "9", "1", "2025-12-31 17:51:42", "2025-12-31 17:51:42", "162394", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58429", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 17:35:30", "2025-12-31 17:35:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767202530;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767202530;}", "9", "1", "2025-12-31 17:51:42", "2025-12-31 17:51:42", "162394", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58430", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 17:51:42", "2025-12-31 17:51:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767203502;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767203502;}", "9", "1", "2025-12-31 17:51:49", "2025-12-31 17:51:49", "162396", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58431", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 17:58:13", "2025-12-31 17:58:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767203893;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767203893;}", "9", "1", "2025-12-31 18:28:03", "2025-12-31 18:28:03", "162399", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58432", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 19:28:03", "2025-12-31 19:28:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767209283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767209283;}", "13", "1", "2025-12-31 19:34:35", "2025-12-31 19:34:35", "162414", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58433", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 18:28:04", "2025-12-31 18:28:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767205684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767205684;}", "9", "1", "2025-12-31 18:28:09", "2025-12-31 18:28:09", "162402", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58434", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 18:33:58", "2025-12-31 18:33:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767206038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767206038;}", "9", "1", "2025-12-31 18:33:58", "2025-12-31 18:33:58", "162405", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58435", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 18:33:58", "2025-12-31 18:33:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767206038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767206038;}", "9", "1", "2025-12-31 19:16:33", "2025-12-31 19:16:33", "162407", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58436", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 19:16:33", "2025-12-31 19:16:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767208593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767208593;}", "9", "1", "2025-12-31 19:16:41", "2025-12-31 19:16:41", "162409", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58437", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-31 19:16:33", "2025-12-31 19:16:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767208593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767208593;}", "9", "1", "2025-12-31 19:16:41", "2025-12-31 19:16:41", "162409", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58438", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 19:24:37", "2025-12-31 19:24:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767209077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767209077;}", "9", "1", "2025-12-31 19:24:45", "2025-12-31 19:24:45", "162412", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58439", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 20:34:35", "2025-12-31 20:34:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767213275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767213275;}", "13", "1", "2025-12-31 20:57:39", "2025-12-31 20:57:39", "162424", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58440", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 19:34:35", "2025-12-31 19:34:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767209675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767209675;}", "9", "1", "2025-12-31 19:34:35", "2025-12-31 19:34:35", "162416", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58441", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 19:34:35", "2025-12-31 19:34:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767209675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767209675;}", "9", "1", "2025-12-31 19:34:35", "2025-12-31 19:34:35", "162416", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58442", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 19:56:25", "2025-12-31 19:56:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767210985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767210985;}", "9", "1", "2025-12-31 19:56:31", "2025-12-31 19:56:31", "162419", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58443", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 20:20:31", "2025-12-31 20:20:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767212431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767212431;}", "9", "1", "2025-12-31 20:20:48", "2025-12-31 20:20:48", "162422", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58444", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 21:57:39", "2025-12-31 21:57:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767218259;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767218259;}", "13", "1", "2025-12-31 22:03:45", "2025-12-31 22:03:45", "162436", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58445", "woocommerce_cleanup_draft_orders", "complete", "2026-01-01 20:57:39", "2026-01-01 20:57:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767301059;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767301059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-01 21:07:41", "2026-01-01 21:07:41", "162606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58446", "wc_gla_cron_daily_notes", "complete", "2026-01-01 20:57:39", "2026-01-01 20:57:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767301059;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767301059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-01 21:07:41", "2026-01-01 21:07:41", "162606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58447", "wc_facebook_regenerate_feed", "complete", "2026-01-01 20:57:49", "2026-01-01 20:57:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767301069;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767301069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-01 21:07:50", "2026-01-01 21:07:50", "162606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58448", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 20:57:49", "2025-12-31 20:57:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767214669;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767214669;}", "9", "1", "2025-12-31 20:59:14", "2025-12-31 20:59:14", "162426", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58449", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 20:57:49", "2025-12-31 20:57:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767214669;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767214669;}", "9", "1", "2025-12-31 20:59:14", "2025-12-31 20:59:14", "162426", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58450", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 20:59:14", "2025-12-31 20:59:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767214754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767214754;}", "9", "1", "2025-12-31 20:59:18", "2025-12-31 20:59:18", "162428", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58451", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 21:04:58", "2025-12-31 21:04:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767215098;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767215098;}", "9", "1", "2025-12-31 21:11:35", "2025-12-31 21:11:35", "162432", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58452", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 21:11:35", "2025-12-31 21:11:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767215495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767215495;}", "9", "1", "2025-12-31 21:11:40", "2025-12-31 21:11:40", "162434", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58453", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 23:03:45", "2025-12-31 23:03:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767222225;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767222225;}", "13", "1", "2025-12-31 23:13:46", "2025-12-31 23:13:46", "162445", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58454", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 22:03:45", "2025-12-31 22:03:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767218625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767218625;}", "9", "1", "2025-12-31 22:48:11", "2025-12-31 22:48:11", "162438", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58455", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 22:03:45", "2025-12-31 22:03:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767218625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767218625;}", "9", "1", "2025-12-31 22:48:11", "2025-12-31 22:48:11", "162438", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58456", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 22:04:03", "2025-12-31 22:04:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767218643;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767218643;}", "9", "1", "2025-12-31 22:48:11", "2025-12-31 22:48:11", "162438", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58457", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 22:48:11", "2025-12-31 22:48:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767221291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767221291;}", "9", "1", "2025-12-31 22:48:17", "2025-12-31 22:48:17", "162440", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58458", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 22:48:11", "2025-12-31 22:48:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767221291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767221291;}", "9", "1", "2025-12-31 22:48:17", "2025-12-31 22:48:17", "162440", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58459", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 22:51:54", "2025-12-31 22:51:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767221514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767221514;}", "9", "1", "2025-12-31 22:51:54", "2025-12-31 22:51:54", "162443", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58460", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 00:13:46", "2026-01-01 00:13:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767226426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767226426;}", "13", "1", "2026-01-01 00:36:16", "2026-01-01 00:36:16", "162450", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58461", "woocommerce_refresh_order_count_cache", "complete", "2026-01-01 11:13:46", "2026-01-01 11:13:46", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266026;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-01 12:06:00", "2026-01-01 12:06:00", "162577", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58462", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 23:13:46", "2025-12-31 23:13:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767222826;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767222826;}", "9", "1", "2025-12-31 23:13:55", "2025-12-31 23:13:55", "162447", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58463", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 23:13:55", "2025-12-31 23:13:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767222835;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767222835;}", "9", "1", "2025-12-31 23:13:55", "2025-12-31 23:13:55", "162447", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58464", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2025-12-31 23:51:01", "2025-12-31 23:51:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767225061;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767225061;}", "9", "1", "2026-01-01 00:36:16", "2026-01-01 00:36:16", "162450", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58465", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2025-12-31 23:51:01", "2025-12-31 23:51:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767225061;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767225061;}", "9", "1", "2026-01-01 00:36:16", "2026-01-01 00:36:16", "162450", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58466", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 01:36:16", "2026-01-01 01:36:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767231376;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767231376;}", "13", "1", "2026-01-01 01:42:01", "2026-01-01 01:42:01", "162454", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58467", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 00:36:17", "2026-01-01 00:36:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767227777;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767227777;}", "9", "1", "2026-01-01 01:29:44", "2026-01-01 01:29:44", "162452", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58468", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 00:36:17", "2026-01-01 00:36:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767227777;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767227777;}", "9", "1", "2026-01-01 01:29:44", "2026-01-01 01:29:44", "162452", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58469", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 01:29:44", "2026-01-01 01:29:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767230984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767230984;}", "9", "1", "2026-01-01 01:42:01", "2026-01-01 01:42:01", "162454", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58470", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 02:42:01", "2026-01-01 02:42:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767235321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767235321;}", "13", "1", "2026-01-01 02:49:24", "2026-01-01 02:49:24", "162501", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58471", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 01:42:01", "2026-01-01 01:42:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767231721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767231721;}", "9", "1", "2026-01-01 01:42:42", "2026-01-01 01:42:42", "162457", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58472", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 01:42:01", "2026-01-01 01:42:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767231721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767231721;}", "9", "1", "2026-01-01 01:42:42", "2026-01-01 01:42:42", "162457", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58473", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 01:43:57", "2026-01-01 01:43:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767231837;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767231837;}", "9", "1", "2026-01-01 01:44:23", "2026-01-01 01:44:23", "162460", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58474", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 01:55:55", "2026-01-01 01:55:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767232555;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767232555;}", "9", "1", "2026-01-01 01:58:48", "2026-01-01 01:58:48", "162464", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58475", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:01:14", "2026-01-01 02:01:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767232874;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767232874;}", "9", "1", "2026-01-01 02:01:14", "2026-01-01 02:01:14", "162466", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58476", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:07:51", "2026-01-01 02:07:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767233271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767233271;}", "9", "1", "2026-01-01 02:07:51", "2026-01-01 02:07:51", "162471", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58477", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:09:45", "2026-01-01 02:09:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767233385;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767233385;}", "9", "1", "2026-01-01 02:09:45", "2026-01-01 02:09:45", "162474", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58478", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:14:53", "2026-01-01 02:14:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767233693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767233693;}", "9", "1", "2026-01-01 02:17:28", "2026-01-01 02:17:28", "162478", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58479", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:19:32", "2026-01-01 02:19:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767233972;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767233972;}", "9", "1", "2026-01-01 02:21:22", "2026-01-01 02:21:22", "162481", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58480", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:24:19", "2026-01-01 02:24:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767234259;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767234259;}", "9", "1", "2026-01-01 02:24:19", "2026-01-01 02:24:19", "162484", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58481", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:30:27", "2026-01-01 02:30:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767234627;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767234627;}", "9", "1", "2026-01-01 02:30:27", "2026-01-01 02:30:27", "162488", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58482", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 02:30:45", "2026-01-01 02:30:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767234645;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767234645;}", "9", "1", "2026-01-01 02:31:19", "2026-01-01 02:31:19", "162490", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58483", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:34:16", "2026-01-01 02:34:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767234856;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767234856;}", "9", "1", "2026-01-01 02:34:16", "2026-01-01 02:34:16", "162494", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58484", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:39:29", "2026-01-01 02:39:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767235169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767235169;}", "9", "1", "2026-01-01 02:39:29", "2026-01-01 02:39:29", "162497", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58485", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 03:49:24", "2026-01-01 03:49:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767239364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767239364;}", "13", "1", "2026-01-01 03:49:56", "2026-01-01 03:49:56", "162529", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58486", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:49:24", "2026-01-01 02:49:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767235764;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767235764;}", "9", "1", "2026-01-01 02:57:55", "2026-01-01 02:57:55", "162503", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58487", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 02:57:55", "2026-01-01 02:57:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767236275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767236275;}", "9", "1", "2026-01-01 03:01:15", "2026-01-01 03:01:15", "162505", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58488", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-02 03:00:00", "2026-01-02 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767322800;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767322800;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-02 03:06:20", "2026-01-02 03:06:20", "162657", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58489", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:01:15", "2026-01-01 03:01:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767236475;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767236475;}", "9", "1", "2026-01-01 03:02:21", "2026-01-01 03:02:21", "162507", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58490", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:09:51", "2026-01-01 03:09:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767236991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767236991;}", "9", "1", "2026-01-01 03:10:39", "2026-01-01 03:10:39", "162510", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58491", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:15:56", "2026-01-01 03:15:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767237356;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767237356;}", "9", "1", "2026-01-01 03:19:26", "2026-01-01 03:19:26", "162514", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58492", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:19:26", "2026-01-01 03:19:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767237566;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767237566;}", "9", "1", "2026-01-01 03:19:27", "2026-01-01 03:19:27", "162516", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58493", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:23:53", "2026-01-01 03:23:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767237833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767237833;}", "9", "1", "2026-01-01 03:26:03", "2026-01-01 03:26:03", "162519", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58494", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:33:52", "2026-01-01 03:33:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767238432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767238432;}", "9", "1", "2026-01-01 03:35:41", "2026-01-01 03:35:41", "162523", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58495", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 03:33:52", "2026-01-01 03:33:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767238432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767238432;}", "9", "1", "2026-01-01 03:35:41", "2026-01-01 03:35:41", "162523", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58496", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:40:09", "2026-01-01 03:40:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767238809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767238809;}", "9", "1", "2026-01-01 03:42:37", "2026-01-01 03:42:37", "162527", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58497", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 04:49:56", "2026-01-01 04:49:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767242996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767242996;}", "13", "1", "2026-01-01 05:06:18", "2026-01-01 05:06:18", "162542", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58498", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:49:56", "2026-01-01 03:49:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767239396;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767239396;}", "9", "1", "2026-01-01 03:51:49", "2026-01-01 03:51:49", "162531", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58499", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 03:54:42", "2026-01-01 03:54:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767239682;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767239682;}", "9", "1", "2026-01-01 04:00:07", "2026-01-01 04:00:07", "162534", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58500", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 04:00:07", "2026-01-01 04:00:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767240007;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767240007;}", "9", "1", "2026-01-01 04:01:05", "2026-01-01 04:01:05", "162536", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58501", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 04:17:01", "2026-01-01 04:17:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767241021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767241021;}", "9", "1", "2026-01-01 04:17:01", "2026-01-01 04:17:01", "162540", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58502", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 06:06:18", "2026-01-01 06:06:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767247578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767247578;}", "13", "1", "2026-01-01 07:21:38", "2026-01-01 07:21:38", "162555", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58503", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 05:06:18", "2026-01-01 05:06:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767243978;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767243978;}", "9", "1", "2026-01-01 05:06:25", "2026-01-01 05:06:25", "162544", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58504", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 05:06:18", "2026-01-01 05:06:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767243978;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767243978;}", "9", "1", "2026-01-01 05:06:25", "2026-01-01 05:06:25", "162544", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58505", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 05:10:27", "2026-01-01 05:10:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767244227;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767244227;}", "9", "1", "2026-01-01 05:10:32", "2026-01-01 05:10:32", "162547", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58506", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 05:26:21", "2026-01-01 05:26:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767245181;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767245181;}", "9", "1", "2026-01-01 05:29:30", "2026-01-01 05:29:30", "162550", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58507", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 05:29:30", "2026-01-01 05:29:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767245370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767245370;}", "9", "1", "2026-01-01 05:29:30", "2026-01-01 05:29:30", "162552", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58508", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 05:32:33", "2026-01-01 05:32:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767245553;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767245553;}", "9", "1", "2026-01-01 07:21:38", "2026-01-01 07:21:38", "162555", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58510", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 08:21:38", "2026-01-01 08:21:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767255698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767255698;}", "13", "1", "2026-01-01 08:41:08", "2026-01-01 08:41:08", "162561", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58511", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 07:21:39", "2026-01-01 07:21:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767252099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767252099;}", "9", "1", "2026-01-01 07:21:52", "2026-01-01 07:21:52", "162557", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58512", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 07:21:48", "2026-01-01 07:21:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767252108;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767252108;}", "9", "1", "2026-01-01 07:21:52", "2026-01-01 07:21:52", "162557", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58513", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-01 07:21:48", "2026-01-01 07:21:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767252108;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767252108;}", "9", "1", "2026-01-01 07:21:52", "2026-01-01 07:21:52", "162557", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58514", "wc_admin_daily_wrapper", "complete", "2026-01-02 08:13:35", "2026-01-02 08:13:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767341615;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767341615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-02 08:26:42", "2026-01-02 08:26:42", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58515", "woocommerce_cleanup_personal_data", "complete", "2026-01-02 08:13:36", "2026-01-02 08:13:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767341616;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767341616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58516", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-02 08:13:39", "2026-01-02 08:13:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767341619;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767341619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58517", "woocommerce_cleanup_logs", "complete", "2026-01-02 08:13:39", "2026-01-02 08:13:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767341619;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767341619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58518", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-02 08:13:39", "2026-01-02 08:13:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767341619;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767341619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58519", "fetch_patterns", "complete", "2026-01-02 08:13:39", "2026-01-02 08:13:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767341619;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767341619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58520", "woocommerce_cleanup_sessions", "complete", "2026-01-02 06:00:00", "2026-01-02 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767333600;s:18:\"\0*\0first_timestamp\";i:1767333600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767333600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-02 06:25:16", "2026-01-02 06:25:16", "162679", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58521", "generate_category_lookup_table_wrapper", "complete", "2026-01-01 08:13:49", "2026-01-01 08:13:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767255229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767255229;}", "13", "1", "2026-01-01 08:41:08", "2026-01-01 08:41:08", "162561", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58522", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-02 08:13:39", "2026-01-02 08:13:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767341619;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767341619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "162694", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58523", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 08:13:39", "2026-01-01 08:13:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767255219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767255219;}", "9", "1", "2026-01-01 08:41:08", "2026-01-01 08:41:08", "162561", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58524", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 08:13:40", "2026-01-01 08:13:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767255220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767255220;}", "9", "1", "2026-01-01 08:41:08", "2026-01-01 08:41:08", "162561", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58525", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 08:41:08", "2026-01-01 08:41:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767256868;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767256868;}", "9", "1", "2026-01-01 08:41:09", "2026-01-01 08:41:09", "162561", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58526", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 09:41:08", "2026-01-01 09:41:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767260468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767260468;}", "13", "1", "2026-01-01 10:10:17", "2026-01-01 10:10:17", "162569", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58527", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-01 08:41:10", "2026-01-01 08:41:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767256870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767256870;}", "9", "1", "2026-01-01 08:41:29", "2026-01-01 08:41:29", "162563", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58528", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 08:41:10", "2026-01-01 08:41:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767256870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767256870;}", "9", "1", "2026-01-01 08:41:34", "2026-01-01 08:41:34", "162564", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58529", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 09:35:23", "2026-01-01 09:35:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767260123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767260123;}", "9", "1", "2026-01-01 09:35:32", "2026-01-01 09:35:32", "162567", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58530", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 09:35:23", "2026-01-01 09:35:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767260123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767260123;}", "9", "1", "2026-01-01 09:35:32", "2026-01-01 09:35:32", "162567", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58531", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 11:10:17", "2026-01-01 11:10:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767265817;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767265817;}", "13", "1", "2026-01-01 12:06:00", "2026-01-01 12:06:00", "162577", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58532", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 10:10:17", "2026-01-01 10:10:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767262217;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767262217;}", "9", "1", "2026-01-01 10:10:24", "2026-01-01 10:10:24", "162571", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58533", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 10:24:55", "2026-01-01 10:24:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767263095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767263095;}", "9", "1", "2026-01-01 10:26:10", "2026-01-01 10:26:10", "162574", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58534", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 10:54:43", "2026-01-01 10:54:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767264883;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767264883;}", "9", "1", "2026-01-01 12:06:00", "2026-01-01 12:06:00", "162577", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58535", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 10:54:43", "2026-01-01 10:54:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767264883;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767264883;}", "9", "1", "2026-01-01 12:06:00", "2026-01-01 12:06:00", "162577", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58536", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 13:06:00", "2026-01-01 13:06:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767272760;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767272760;}", "13", "1", "2026-01-01 13:14:34", "2026-01-01 13:14:34", "162581", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58537", "woocommerce_refresh_order_count_cache", "complete", "2026-01-02 00:06:00", "2026-01-02 00:06:00", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767312360;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767312360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-02 00:36:44", "2026-01-02 00:36:44", "162618", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58538", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 12:06:00", "2026-01-01 12:06:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767269160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767269160;}", "9", "1", "2026-01-01 12:06:10", "2026-01-01 12:06:10", "162579", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58539", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 12:06:01", "2026-01-01 12:06:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767269161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767269161;}", "9", "1", "2026-01-01 12:06:10", "2026-01-01 12:06:10", "162579", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58540", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 14:14:34", "2026-01-01 14:14:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767276874;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767276874;}", "13", "1", "2026-01-01 14:26:55", "2026-01-01 14:26:55", "162585", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58541", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 13:14:34", "2026-01-01 13:14:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767273274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767273274;}", "9", "1", "2026-01-01 13:41:07", "2026-01-01 13:41:07", "162583", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58542", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 13:14:34", "2026-01-01 13:14:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767273274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767273274;}", "9", "1", "2026-01-01 13:41:07", "2026-01-01 13:41:07", "162583", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58543", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 13:41:07", "2026-01-01 13:41:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767274867;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767274867;}", "9", "1", "2026-01-01 14:26:55", "2026-01-01 14:26:55", "162585", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58544", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 13:41:07", "2026-01-01 13:41:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767274867;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767274867;}", "9", "1", "2026-01-01 14:26:55", "2026-01-01 14:26:55", "162585", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58545", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 15:26:55", "2026-01-01 15:26:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767281215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767281215;}", "13", "1", "2026-01-01 15:36:09", "2026-01-01 15:36:09", "162590", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58546", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 14:26:55", "2026-01-01 14:26:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767277615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767277615;}", "9", "1", "2026-01-01 14:26:55", "2026-01-01 14:26:55", "162587", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58547", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 15:11:24", "2026-01-01 15:11:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767280284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767280284;}", "9", "1", "2026-01-01 15:36:08", "2026-01-01 15:36:08", "162590", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58548", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 15:11:24", "2026-01-01 15:11:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767280284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767280284;}", "9", "1", "2026-01-01 15:36:09", "2026-01-01 15:36:09", "162590", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58549", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 16:36:09", "2026-01-01 16:36:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767285369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767285369;}", "13", "1", "2026-01-01 17:11:41", "2026-01-01 17:11:41", "162594", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58550", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 15:36:09", "2026-01-01 15:36:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767281769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767281769;}", "9", "1", "2026-01-01 15:36:14", "2026-01-01 15:36:14", "162592", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58551", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 15:36:09", "2026-01-01 15:36:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767281769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767281769;}", "9", "1", "2026-01-01 15:36:14", "2026-01-01 15:36:14", "162592", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58552", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 18:11:41", "2026-01-01 18:11:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767291101;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767291101;}", "13", "1", "2026-01-01 21:07:41", "2026-01-01 21:07:41", "162606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58553", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 17:11:41", "2026-01-01 17:11:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767287501;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767287501;}", "9", "1", "2026-01-01 17:17:03", "2026-01-01 17:17:03", "162596", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58554", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 17:11:41", "2026-01-01 17:11:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767287501;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767287501;}", "9", "1", "2026-01-01 17:17:03", "2026-01-01 17:17:03", "162596", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58555", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 17:17:03", "2026-01-01 17:17:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767287823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767287823;}", "9", "1", "2026-01-01 17:17:17", "2026-01-01 17:17:17", "162598", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58556", "woocommerce_scheduled_sales", "complete", "2026-01-02 17:41:37", "2026-01-02 17:41:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767375697;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767375697;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-02 18:04:23", "2026-01-02 18:04:23", "162768", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58557", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 17:41:37", "2026-01-01 17:41:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767289297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767289297;}", "9", "1", "2026-01-01 17:41:38", "2026-01-01 17:41:38", "162602", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58558", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 17:41:37", "2026-01-01 17:41:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767289297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767289297;}", "9", "1", "2026-01-01 17:41:38", "2026-01-01 17:41:38", "162602", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58559", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 17:54:09", "2026-01-01 17:54:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767290049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767290049;}", "9", "1", "2026-01-01 21:07:41", "2026-01-01 21:07:41", "162606", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58560", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 22:07:41", "2026-01-01 22:07:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767305261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767305261;}", "13", "1", "2026-01-02 00:03:50", "2026-01-02 00:03:50", "162616", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58561", "woocommerce_cleanup_draft_orders", "complete", "2026-01-02 21:07:41", "2026-01-02 21:07:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767388061;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767388061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-02 22:16:38", "2026-01-02 22:16:38", "162786", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58562", "wc_gla_cron_daily_notes", "complete", "2026-01-02 21:07:41", "2026-01-02 21:07:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767388061;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767388061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-02 22:16:38", "2026-01-02 22:16:38", "162786", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58563", "wc_facebook_regenerate_feed", "complete", "2026-01-02 21:07:50", "2026-01-02 21:07:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767388070;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767388070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-02 22:16:49", "2026-01-02 22:16:49", "162786", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58564", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 21:07:50", "2026-01-01 21:07:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767301670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767301670;}", "9", "1", "2026-01-01 21:21:28", "2026-01-01 21:21:28", "162608", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58565", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 21:07:50", "2026-01-01 21:07:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767301670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767301670;}", "9", "1", "2026-01-01 21:21:29", "2026-01-01 21:21:29", "162608", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58566", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-01 21:07:50", "2026-01-01 21:07:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767301670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767301670;}", "9", "1", "2026-01-01 21:21:29", "2026-01-01 21:21:29", "162608", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58567", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 21:21:29", "2026-01-01 21:21:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767302489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767302489;}", "9", "1", "2026-01-01 21:37:09", "2026-01-01 21:37:09", "162610", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58568", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-01 21:37:10", "2026-01-01 21:37:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767303430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767303430;}", "9", "1", "2026-01-01 21:37:15", "2026-01-01 21:37:15", "162613", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58569", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-01 21:37:10", "2026-01-01 21:37:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767303430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767303430;}", "9", "1", "2026-01-01 21:37:15", "2026-01-01 21:37:15", "162613", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58570", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 01:03:50", "2026-01-02 01:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767315830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767315830;}", "13", "1", "2026-01-02 01:56:10", "2026-01-02 01:56:10", "162620", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58571", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 00:03:50", "2026-01-02 00:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767312230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767312230;}", "9", "1", "2026-01-02 00:36:43", "2026-01-02 00:36:43", "162618", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58572", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 00:03:50", "2026-01-02 00:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767312230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767312230;}", "9", "1", "2026-01-02 00:36:44", "2026-01-02 00:36:44", "162618", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58573", "woocommerce_refresh_order_count_cache", "complete", "2026-01-02 12:36:44", "2026-01-02 12:36:44", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767357404;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767357404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-02 13:05:20", "2026-01-02 13:05:20", "162735", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58574", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 00:36:44", "2026-01-02 00:36:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767314204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767314204;}", "9", "1", "2026-01-02 01:56:10", "2026-01-02 01:56:10", "162620", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58575", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 00:36:44", "2026-01-02 00:36:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767314204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767314204;}", "9", "1", "2026-01-02 01:56:10", "2026-01-02 01:56:10", "162620", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58576", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 02:56:10", "2026-01-02 02:56:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767322570;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767322570;}", "13", "1", "2026-01-02 02:56:43", "2026-01-02 02:56:43", "162653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58577", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 01:56:10", "2026-01-02 01:56:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767318970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767318970;}", "9", "1", "2026-01-02 01:56:13", "2026-01-02 01:56:13", "162622", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58578", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 01:56:10", "2026-01-02 01:56:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767318970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767318970;}", "9", "1", "2026-01-02 01:56:13", "2026-01-02 01:56:13", "162622", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58579", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:01:20", "2026-01-02 02:01:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767319280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767319280;}", "9", "1", "2026-01-02 02:18:44", "2026-01-02 02:18:44", "162626", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58580", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:18:44", "2026-01-02 02:18:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767320324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767320324;}", "9", "1", "2026-01-02 02:18:44", "2026-01-02 02:18:44", "162628", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58581", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:25:21", "2026-01-02 02:25:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767320721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767320721;}", "9", "1", "2026-01-02 02:25:21", "2026-01-02 02:25:21", "162630", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58582", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:29:11", "2026-01-02 02:29:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767320951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767320951;}", "9", "1", "2026-01-02 02:29:48", "2026-01-02 02:29:48", "162634", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58583", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 02:33:06", "2026-01-02 02:33:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767321186;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767321186;}", "9", "1", "2026-01-02 02:35:54", "2026-01-02 02:35:54", "162637", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58584", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:35:54", "2026-01-02 02:35:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767321354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767321354;}", "9", "1", "2026-01-02 02:36:26", "2026-01-02 02:36:26", "162639", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58585", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:45:10", "2026-01-02 02:45:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767321910;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767321910;}", "9", "1", "2026-01-02 02:45:10", "2026-01-02 02:45:10", "162643", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58586", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:49:55", "2026-01-02 02:49:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767322195;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767322195;}", "9", "1", "2026-01-02 02:55:15", "2026-01-02 02:55:15", "162648", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58587", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:55:15", "2026-01-02 02:55:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767322515;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767322515;}", "9", "1", "2026-01-02 02:55:15", "2026-01-02 02:55:15", "162650", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58588", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 03:56:43", "2026-01-02 03:56:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767326203;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767326203;}", "13", "1", "2026-01-02 04:19:06", "2026-01-02 04:19:06", "162659", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58589", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 02:59:31", "2026-01-02 02:59:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767322771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767322771;}", "9", "1", "2026-01-02 03:06:20", "2026-01-02 03:06:20", "162657", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58590", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-03 03:00:00", "2026-01-03 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767409200;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767409200;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-03 03:37:22", "2026-01-03 03:37:22", "162800", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58591", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 03:06:20", "2026-01-02 03:06:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767323180;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767323180;}", "9", "1", "2026-01-02 04:19:06", "2026-01-02 04:19:06", "162659", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58592", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 05:19:06", "2026-01-02 05:19:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767331146;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767331146;}", "13", "1", "2026-01-02 05:35:11", "2026-01-02 05:35:11", "162674", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58593", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 04:19:06", "2026-01-02 04:19:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767327546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767327546;}", "9", "1", "2026-01-02 04:27:06", "2026-01-02 04:27:06", "162661", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58594", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 04:19:06", "2026-01-02 04:19:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767327546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767327546;}", "9", "1", "2026-01-02 04:27:06", "2026-01-02 04:27:06", "162661", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58595", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 04:27:06", "2026-01-02 04:27:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767328026;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767328026;}", "9", "1", "2026-01-02 04:27:13", "2026-01-02 04:27:13", "162663", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58596", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 04:42:20", "2026-01-02 04:42:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767328940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767328940;}", "9", "1", "2026-01-02 04:42:20", "2026-01-02 04:42:20", "162667", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58597", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 04:42:20", "2026-01-02 04:42:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767328940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767328940;}", "9", "1", "2026-01-02 04:59:43", "2026-01-02 04:59:43", "162669", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58598", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 04:59:43", "2026-01-02 04:59:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767329983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767329983;}", "9", "1", "2026-01-02 05:00:39", "2026-01-02 05:00:39", "162671", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58599", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 05:18:33", "2026-01-02 05:18:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767331113;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767331113;}", "9", "1", "2026-01-02 05:35:11", "2026-01-02 05:35:11", "162674", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58600", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 05:35:11", "2026-01-02 05:35:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767332111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767332111;}", "9", "1", "2026-01-02 05:35:11", "2026-01-02 05:35:11", "162674", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58601", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 06:35:11", "2026-01-02 06:35:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767335711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767335711;}", "13", "1", "2026-01-02 06:46:55", "2026-01-02 06:46:55", "162683", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58602", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 05:35:11", "2026-01-02 05:35:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767332111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767332111;}", "9", "1", "2026-01-02 05:35:22", "2026-01-02 05:35:22", "162676", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58603", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 05:39:33", "2026-01-02 05:39:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767332373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767332373;}", "9", "1", "2026-01-02 06:25:16", "2026-01-02 06:25:16", "162679", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58605", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 06:25:16", "2026-01-02 06:25:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767335116;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767335116;}", "9", "1", "2026-01-02 06:25:28", "2026-01-02 06:25:28", "162681", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58606", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 07:46:55", "2026-01-02 07:46:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767340015;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767340015;}", "13", "1", "2026-01-02 08:26:42", "2026-01-02 08:26:42", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58607", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 06:46:55", "2026-01-02 06:46:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767336415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767336415;}", "9", "1", "2026-01-02 06:47:09", "2026-01-02 06:47:09", "162685", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58608", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 06:46:55", "2026-01-02 06:46:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767336415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767336415;}", "9", "1", "2026-01-02 06:47:09", "2026-01-02 06:47:09", "162685", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58609", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 06:55:59", "2026-01-02 06:55:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767336959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767336959;}", "9", "1", "2026-01-02 07:12:04", "2026-01-02 07:12:04", "162688", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58610", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 07:12:04", "2026-01-02 07:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767337924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767337924;}", "9", "1", "2026-01-02 07:15:28", "2026-01-02 07:15:28", "162690", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58611", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-02 07:12:04", "2026-01-02 07:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767337924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767337924;}", "9", "1", "2026-01-02 07:15:28", "2026-01-02 07:15:28", "162690", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58612", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 07:15:28", "2026-01-02 07:15:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767338128;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767338128;}", "9", "1", "2026-01-02 07:19:26", "2026-01-02 07:19:26", "162692", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58613", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 07:19:26", "2026-01-02 07:19:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767338366;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767338366;}", "9", "1", "2026-01-02 08:26:42", "2026-01-02 08:26:42", "162694", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58614", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 09:26:42", "2026-01-02 09:26:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767346002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767346002;}", "13", "1", "2026-01-02 09:48:55", "2026-01-02 09:48:55", "162706", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58615", "wc_admin_daily_wrapper", "complete", "2026-01-03 08:26:42", "2026-01-03 08:26:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767428802;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767428802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-03 09:39:08", "2026-01-03 09:39:08", "162908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58616", "woocommerce_cleanup_personal_data", "complete", "2026-01-03 08:26:43", "2026-01-03 08:26:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767428803;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767428803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "162908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58617", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-03 08:26:43", "2026-01-03 08:26:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767428803;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767428803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "162908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58618", "woocommerce_cleanup_logs", "complete", "2026-01-03 08:26:43", "2026-01-03 08:26:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767428803;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767428803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "162908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58619", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-03 08:26:43", "2026-01-03 08:26:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767428803;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767428803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "162908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58620", "fetch_patterns", "complete", "2026-01-03 08:26:43", "2026-01-03 08:26:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767428803;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767428803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "162908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58621", "woocommerce_cleanup_sessions", "complete", "2026-01-03 06:00:00", "2026-01-03 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767420000;s:18:\"\0*\0first_timestamp\";i:1767420000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767420000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-03 06:04:29", "2026-01-03 06:04:29", "162880", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58622", "generate_category_lookup_table_wrapper", "complete", "2026-01-02 08:26:53", "2026-01-02 08:26:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767342413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767342413;}", "13", "1", "2026-01-02 08:27:22", "2026-01-02 08:27:22", "162696", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58623", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-03 08:26:43", "2026-01-03 08:26:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767428803;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767428803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "162908", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58624", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767342403;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767342403;}", "9", "1", "2026-01-02 08:27:22", "2026-01-02 08:27:22", "162696", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58625", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 08:26:43", "2026-01-02 08:26:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767342403;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767342403;}", "9", "1", "2026-01-02 08:27:22", "2026-01-02 08:27:22", "162696", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58626", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 08:33:19", "2026-01-02 08:33:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767342799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767342799;}", "9", "1", "2026-01-02 09:02:58", "2026-01-02 09:02:58", "162699", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58627", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-02 08:33:20", "2026-01-02 08:33:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767342800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767342800;}", "9", "1", "2026-01-02 09:03:13", "2026-01-02 09:03:13", "162699", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58628", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 08:33:20", "2026-01-02 08:33:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767342800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767342800;}", "9", "1", "2026-01-02 09:14:24", "2026-01-02 09:14:24", "162700", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58629", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 09:02:58", "2026-01-02 09:02:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767344578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767344578;}", "9", "1", "2026-01-02 09:14:24", "2026-01-02 09:14:24", "162700", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58630", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 09:14:24", "2026-01-02 09:14:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767345264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767345264;}", "9", "1", "2026-01-02 09:19:01", "2026-01-02 09:19:01", "162702", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58631", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 09:19:01", "2026-01-02 09:19:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767345541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767345541;}", "9", "1", "2026-01-02 09:23:41", "2026-01-02 09:23:41", "162704", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58632", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 09:48:55", "2026-01-02 09:48:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767347335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767347335;}", "9", "1", "2026-01-02 09:48:55", "2026-01-02 09:48:55", "162706", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58633", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 10:48:55", "2026-01-02 10:48:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767350935;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767350935;}", "13", "1", "2026-01-02 10:52:06", "2026-01-02 10:52:06", "162720", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58634", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 09:48:55", "2026-01-02 09:48:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767347335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767347335;}", "9", "1", "2026-01-02 09:53:33", "2026-01-02 09:53:33", "162708", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58635", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 09:56:47", "2026-01-02 09:56:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767347807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767347807;}", "9", "1", "2026-01-02 09:56:48", "2026-01-02 09:56:48", "162710", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58636", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 09:59:04", "2026-01-02 09:59:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767347944;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767347944;}", "9", "1", "2026-01-02 10:00:51", "2026-01-02 10:00:51", "162713", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58637", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 10:05:21", "2026-01-02 10:05:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767348321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767348321;}", "9", "1", "2026-01-02 10:05:21", "2026-01-02 10:05:21", "162716", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58638", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 10:47:42", "2026-01-02 10:47:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767350862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767350862;}", "9", "1", "2026-01-02 10:52:06", "2026-01-02 10:52:06", "162720", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58639", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 10:47:42", "2026-01-02 10:47:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767350862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767350862;}", "9", "1", "2026-01-02 10:52:06", "2026-01-02 10:52:06", "162720", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58640", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 11:52:06", "2026-01-02 11:52:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767354726;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767354726;}", "13", "1", "2026-01-02 12:05:15", "2026-01-02 12:05:15", "162724", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58641", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 10:52:06", "2026-01-02 10:52:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767351126;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767351126;}", "9", "1", "2026-01-02 11:12:48", "2026-01-02 11:12:48", "162722", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58642", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 11:12:48", "2026-01-02 11:12:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767352368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767352368;}", "9", "1", "2026-01-02 12:05:15", "2026-01-02 12:05:15", "162724", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58643", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 13:05:15", "2026-01-02 13:05:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767359115;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767359115;}", "13", "1", "2026-01-02 13:05:20", "2026-01-02 13:05:20", "162735", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58644", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 12:05:15", "2026-01-02 12:05:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767355515;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767355515;}", "9", "1", "2026-01-02 12:05:17", "2026-01-02 12:05:17", "162726", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58645", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 12:05:15", "2026-01-02 12:05:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767355515;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767355515;}", "9", "1", "2026-01-02 12:05:18", "2026-01-02 12:05:18", "162726", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58646", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 12:09:56", "2026-01-02 12:09:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767355796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767355796;}", "9", "1", "2026-01-02 12:31:53", "2026-01-02 12:31:53", "162731", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58647", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 12:31:53", "2026-01-02 12:31:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767357113;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767357113;}", "9", "1", "2026-01-02 12:34:52", "2026-01-02 12:34:52", "162733", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58648", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 12:31:53", "2026-01-02 12:31:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767357113;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767357113;}", "9", "1", "2026-01-02 12:34:52", "2026-01-02 12:34:52", "162733", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58649", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 12:34:52", "2026-01-02 12:34:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767357292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767357292;}", "9", "1", "2026-01-02 13:05:20", "2026-01-02 13:05:20", "162735", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58650", "woocommerce_refresh_order_count_cache", "complete", "2026-01-03 01:05:20", "2026-01-03 01:05:20", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767402320;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767402320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-03 01:57:24", "2026-01-03 01:57:24", "162793", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58651", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 14:05:20", "2026-01-02 14:05:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767362720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767362720;}", "13", "1", "2026-01-02 14:57:18", "2026-01-02 14:57:18", "162746", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58652", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 13:05:20", "2026-01-02 13:05:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767359120;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767359120;}", "9", "1", "2026-01-02 13:05:20", "2026-01-02 13:05:20", "162737", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58653", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 13:19:48", "2026-01-02 13:19:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767359988;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767359988;}", "9", "1", "2026-01-02 13:22:14", "2026-01-02 13:22:14", "162740", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58654", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 13:29:44", "2026-01-02 13:29:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767360584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767360584;}", "9", "1", "2026-01-02 13:42:19", "2026-01-02 13:42:19", "162744", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58655", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 13:42:19", "2026-01-02 13:42:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767361339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767361339;}", "9", "1", "2026-01-02 14:57:18", "2026-01-02 14:57:18", "162746", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58656", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 13:42:19", "2026-01-02 13:42:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767361339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767361339;}", "9", "1", "2026-01-02 14:57:18", "2026-01-02 14:57:18", "162746", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58657", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 15:57:18", "2026-01-02 15:57:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767369438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767369438;}", "13", "1", "2026-01-02 17:07:01", "2026-01-02 17:07:01", "162755", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58658", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 14:57:18", "2026-01-02 14:57:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767365838;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767365838;}", "9", "1", "2026-01-02 15:13:59", "2026-01-02 15:13:59", "162748", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58659", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 14:57:18", "2026-01-02 14:57:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767365838;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767365838;}", "9", "1", "2026-01-02 15:13:59", "2026-01-02 15:13:59", "162748", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58660", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 15:13:59", "2026-01-02 15:13:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767366839;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767366839;}", "9", "1", "2026-01-02 15:21:30", "2026-01-02 15:21:30", "162750", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58661", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 15:21:30", "2026-01-02 15:21:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767367290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767367290;}", "9", "1", "2026-01-02 15:21:31", "2026-01-02 15:21:31", "162752", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58662", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 15:39:06", "2026-01-02 15:39:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767368346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767368346;}", "9", "1", "2026-01-02 17:07:01", "2026-01-02 17:07:01", "162755", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58663", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 15:39:06", "2026-01-02 15:39:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767368346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767368346;}", "9", "1", "2026-01-02 17:07:01", "2026-01-02 17:07:01", "162755", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58664", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 18:07:01", "2026-01-02 18:07:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767377221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767377221;}", "13", "1", "2026-01-02 18:14:30", "2026-01-02 18:14:30", "162772", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58665", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 17:07:01", "2026-01-02 17:07:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767373621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767373621;}", "9", "1", "2026-01-02 17:07:10", "2026-01-02 17:07:10", "162757", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58666", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 17:07:01", "2026-01-02 17:07:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767373621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767373621;}", "9", "1", "2026-01-02 17:07:10", "2026-01-02 17:07:10", "162757", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58667", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 17:12:07", "2026-01-02 17:12:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767373927;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767373927;}", "9", "1", "2026-01-02 17:29:35", "2026-01-02 17:29:35", "162761", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58668", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 17:29:35", "2026-01-02 17:29:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767374975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767374975;}", "9", "1", "2026-01-02 17:29:41", "2026-01-02 17:29:41", "162764", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58669", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 17:35:33", "2026-01-02 17:35:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767375333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767375333;}", "9", "1", "2026-01-02 18:04:23", "2026-01-02 18:04:23", "162768", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58670", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 17:35:33", "2026-01-02 17:35:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767375333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767375333;}", "9", "1", "2026-01-02 18:04:23", "2026-01-02 18:04:23", "162768", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58671", "woocommerce_scheduled_sales", "complete", "2026-01-03 18:04:23", "2026-01-03 18:04:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767463463;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767463463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-03 18:31:00", "2026-01-03 18:31:00", "162985", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58672", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 18:04:23", "2026-01-02 18:04:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767377063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767377063;}", "9", "1", "2026-01-02 18:04:23", "2026-01-02 18:04:23", "162770", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58673", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 19:14:30", "2026-01-02 19:14:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767381270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767381270;}", "13", "1", "2026-01-02 20:39:17", "2026-01-02 20:39:17", "162782", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58674", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 18:14:30", "2026-01-02 18:14:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767377670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767377670;}", "9", "1", "2026-01-02 18:14:37", "2026-01-02 18:14:37", "162774", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58675", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 18:55:45", "2026-01-02 18:55:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767380145;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767380145;}", "9", "1", "2026-01-02 18:55:50", "2026-01-02 18:55:50", "162777", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58676", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 18:55:45", "2026-01-02 18:55:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767380145;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767380145;}", "9", "1", "2026-01-02 18:55:50", "2026-01-02 18:55:50", "162777", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58677", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 18:59:41", "2026-01-02 18:59:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767380381;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767380381;}", "9", "1", "2026-01-02 18:59:47", "2026-01-02 18:59:47", "162780", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58678", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-02 18:59:41", "2026-01-02 18:59:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767380381;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767380381;}", "9", "1", "2026-01-02 18:59:47", "2026-01-02 18:59:47", "162780", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58679", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 21:39:17", "2026-01-02 21:39:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767389957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767389957;}", "13", "1", "2026-01-02 22:16:49", "2026-01-02 22:16:49", "162786", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58680", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 20:39:17", "2026-01-02 20:39:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767386357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767386357;}", "9", "1", "2026-01-02 20:39:22", "2026-01-02 20:39:22", "162784", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58681", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 20:39:17", "2026-01-02 20:39:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767386357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767386357;}", "9", "1", "2026-01-02 20:39:22", "2026-01-02 20:39:22", "162784", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58682", "woocommerce_cleanup_draft_orders", "complete", "2026-01-03 22:16:38", "2026-01-03 22:16:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767478598;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767478598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-04 00:12:37", "2026-01-04 00:12:37", "162996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58683", "wc_gla_cron_daily_notes", "complete", "2026-01-03 22:16:38", "2026-01-03 22:16:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767478598;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767478598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-04 00:12:37", "2026-01-04 00:12:37", "162996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58684", "wc_facebook_regenerate_feed", "complete", "2026-01-03 22:16:49", "2026-01-03 22:16:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767478609;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767478609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-04 00:12:49", "2026-01-04 00:12:49", "162996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58685", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 23:16:49", "2026-01-02 23:16:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767395809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767395809;}", "13", "1", "2026-01-03 01:57:24", "2026-01-03 01:57:24", "162793", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58686", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 22:16:49", "2026-01-02 22:16:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767392209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767392209;}", "9", "1", "2026-01-02 22:16:57", "2026-01-02 22:16:57", "162788", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58687", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 22:16:49", "2026-01-02 22:16:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767392209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767392209;}", "9", "1", "2026-01-02 22:16:58", "2026-01-02 22:16:58", "162788", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58688", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-02 22:59:36", "2026-01-02 22:59:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767394776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767394776;}", "9", "1", "2026-01-02 23:01:05", "2026-01-02 23:01:05", "162791", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58689", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-02 22:59:36", "2026-01-02 22:59:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767394776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767394776;}", "9", "1", "2026-01-02 23:01:05", "2026-01-02 23:01:05", "162791", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58690", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 02:57:24", "2026-01-03 02:57:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767409044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767409044;}", "13", "1", "2026-01-03 03:37:22", "2026-01-03 03:37:22", "162800", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58691", "woocommerce_refresh_order_count_cache", "complete", "2026-01-03 13:57:24", "2026-01-03 13:57:24", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767448644;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767448644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-03 13:57:31", "2026-01-03 13:57:31", "162948", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58692", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 01:57:24", "2026-01-03 01:57:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767405444;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767405444;}", "9", "1", "2026-01-03 01:57:30", "2026-01-03 01:57:30", "162795", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58693", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 01:57:24", "2026-01-03 01:57:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767405444;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767405444;}", "9", "1", "2026-01-03 01:57:30", "2026-01-03 01:57:30", "162795", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58694", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 02:33:52", "2026-01-03 02:33:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767407632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767407632;}", "9", "1", "2026-01-03 02:34:17", "2026-01-03 02:34:17", "162798", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58695", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 02:33:52", "2026-01-03 02:33:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767407632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767407632;}", "9", "1", "2026-01-03 02:34:17", "2026-01-03 02:34:17", "162798", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58696", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 04:37:22", "2026-01-03 04:37:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767415042;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767415042;}", "13", "1", "2026-01-03 04:38:14", "2026-01-03 04:38:14", "162832", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58697", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-04 03:00:00", "2026-01-04 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767495600;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767495600;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-04 03:19:07", "2026-01-04 03:19:07", "163022", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58698", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 03:37:22", "2026-01-03 03:37:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767411442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767411442;}", "9", "1", "2026-01-03 03:51:41", "2026-01-03 03:51:41", "162802", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58699", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 03:37:22", "2026-01-03 03:37:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767411442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767411442;}", "9", "1", "2026-01-03 03:51:41", "2026-01-03 03:51:41", "162802", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58700", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 03:51:41", "2026-01-03 03:51:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767412301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767412301;}", "9", "1", "2026-01-03 03:51:42", "2026-01-03 03:51:42", "162804", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58701", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 03:54:03", "2026-01-03 03:54:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767412443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767412443;}", "9", "1", "2026-01-03 03:54:27", "2026-01-03 03:54:27", "162807", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58702", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:00:16", "2026-01-03 04:00:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767412816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767412816;}", "9", "1", "2026-01-03 04:04:44", "2026-01-03 04:04:44", "162811", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58703", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:04:44", "2026-01-03 04:04:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767413084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767413084;}", "9", "1", "2026-01-03 04:17:05", "2026-01-03 04:17:05", "162813", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58704", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:17:05", "2026-01-03 04:17:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767413825;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767413825;}", "9", "1", "2026-01-03 04:21:53", "2026-01-03 04:21:53", "162815", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58705", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:21:53", "2026-01-03 04:21:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767414113;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767414113;}", "9", "1", "2026-01-03 04:22:55", "2026-01-03 04:22:55", "162817", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58706", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:24:59", "2026-01-03 04:24:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767414299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767414299;}", "9", "1", "2026-01-03 04:24:59", "2026-01-03 04:24:59", "162820", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58707", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:30:11", "2026-01-03 04:30:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767414611;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767414611;}", "9", "1", "2026-01-03 04:30:18", "2026-01-03 04:30:18", "162826", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58708", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 04:33:20", "2026-01-03 04:33:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767414800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767414800;}", "9", "1", "2026-01-03 04:33:20", "2026-01-03 04:33:20", "162828", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58709", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:36:03", "2026-01-03 04:36:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767414963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767414963;}", "9", "1", "2026-01-03 04:36:03", "2026-01-03 04:36:03", "162830", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58710", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 05:38:14", "2026-01-03 05:38:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767418694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767418694;}", "13", "1", "2026-01-03 05:38:30", "2026-01-03 05:38:30", "162865", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58711", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:40:22", "2026-01-03 04:40:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767415222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767415222;}", "9", "1", "2026-01-03 04:41:38", "2026-01-03 04:41:38", "162835", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58712", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:45:05", "2026-01-03 04:45:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767415505;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767415505;}", "9", "1", "2026-01-03 04:52:45", "2026-01-03 04:52:45", "162838", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58713", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 04:52:45", "2026-01-03 04:52:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767415965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767415965;}", "9", "1", "2026-01-03 05:02:33", "2026-01-03 05:02:33", "162840", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58714", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:02:33", "2026-01-03 05:02:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767416553;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767416553;}", "9", "1", "2026-01-03 05:02:37", "2026-01-03 05:02:37", "162842", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58715", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:06:59", "2026-01-03 05:06:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767416819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767416819;}", "9", "1", "2026-01-03 05:10:02", "2026-01-03 05:10:02", "162845", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58716", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:10:02", "2026-01-03 05:10:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767417002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767417002;}", "9", "1", "2026-01-03 05:10:39", "2026-01-03 05:10:39", "162847", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58717", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:14:44", "2026-01-03 05:14:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767417284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767417284;}", "9", "1", "2026-01-03 05:14:44", "2026-01-03 05:14:44", "162851", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58718", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:19:55", "2026-01-03 05:19:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767417595;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767417595;}", "9", "1", "2026-01-03 05:21:22", "2026-01-03 05:21:22", "162855", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58719", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:26:45", "2026-01-03 05:26:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767418005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767418005;}", "9", "1", "2026-01-03 05:26:45", "2026-01-03 05:26:45", "162858", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58720", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:34:05", "2026-01-03 05:34:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767418445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767418445;}", "9", "1", "2026-01-03 05:34:45", "2026-01-03 05:34:45", "162861", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58721", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 05:34:05", "2026-01-03 05:34:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767418445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767418445;}", "9", "1", "2026-01-03 05:34:45", "2026-01-03 05:34:45", "162861", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58722", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 06:38:30", "2026-01-03 06:38:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767422310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767422310;}", "13", "1", "2026-01-03 06:39:15", "2026-01-03 06:39:15", "162897", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58723", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:42:47", "2026-01-03 05:42:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767418967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767418967;}", "9", "1", "2026-01-03 05:42:47", "2026-01-03 05:42:47", "162867", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58724", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:44:16", "2026-01-03 05:44:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767419056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767419056;}", "9", "1", "2026-01-03 05:46:17", "2026-01-03 05:46:17", "162870", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58725", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:49:59", "2026-01-03 05:49:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767419399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767419399;}", "9", "1", "2026-01-03 05:50:04", "2026-01-03 05:50:04", "162873", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58726", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:58:15", "2026-01-03 05:58:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767419895;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767419895;}", "9", "1", "2026-01-03 05:59:28", "2026-01-03 05:59:28", "162878", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58727", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 05:59:28", "2026-01-03 05:59:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767419968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767419968;}", "9", "1", "2026-01-03 06:04:29", "2026-01-03 06:04:29", "162880", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58729", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 06:04:31", "2026-01-03 06:04:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767420271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767420271;}", "9", "1", "2026-01-03 06:05:41", "2026-01-03 06:05:41", "162882", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58730", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 06:12:04", "2026-01-03 06:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767420724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767420724;}", "9", "1", "2026-01-03 06:14:49", "2026-01-03 06:14:49", "162885", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58731", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 06:14:49", "2026-01-03 06:14:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767420889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767420889;}", "9", "1", "2026-01-03 06:18:23", "2026-01-03 06:18:23", "162887", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58732", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 06:23:54", "2026-01-03 06:23:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767421434;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767421434;}", "9", "1", "2026-01-03 06:23:54", "2026-01-03 06:23:54", "162889", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58733", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 06:32:01", "2026-01-03 06:32:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767421921;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767421921;}", "9", "1", "2026-01-03 06:32:01", "2026-01-03 06:32:01", "162893", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58734", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 06:32:01", "2026-01-03 06:32:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767421921;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767421921;}", "9", "1", "2026-01-03 06:34:26", "2026-01-03 06:34:26", "162895", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58735", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 06:34:26", "2026-01-03 06:34:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767422066;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767422066;}", "9", "1", "2026-01-03 06:39:15", "2026-01-03 06:39:15", "162897", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58736", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 07:39:15", "2026-01-03 07:39:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767425955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767425955;}", "13", "1", "2026-01-03 09:39:08", "2026-01-03 09:39:08", "162908", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58737", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 06:39:15", "2026-01-03 06:39:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767422355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767422355;}", "9", "1", "2026-01-03 06:39:15", "2026-01-03 06:39:15", "162899", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58738", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 07:23:15", "2026-01-03 07:23:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767424995;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767424995;}", "9", "1", "2026-01-03 07:23:21", "2026-01-03 07:23:21", "162903", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58739", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-03 07:23:15", "2026-01-03 07:23:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767424995;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767424995;}", "9", "1", "2026-01-03 07:23:21", "2026-01-03 07:23:21", "162903", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58740", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 07:25:01", "2026-01-03 07:25:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767425101;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767425101;}", "9", "1", "2026-01-03 07:25:01", "2026-01-03 07:25:01", "162906", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58741", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 10:39:08", "2026-01-03 10:39:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767436748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767436748;}", "13", "1", "2026-01-03 11:00:44", "2026-01-03 11:00:44", "162919", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58742", "wc_admin_daily_wrapper", "complete", "2026-01-04 09:39:08", "2026-01-04 09:39:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519548;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-04 09:54:05", "2026-01-04 09:54:05", "163052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58743", "woocommerce_cleanup_personal_data", "complete", "2026-01-04 09:39:09", "2026-01-04 09:39:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519549;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "163052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58744", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-04 09:39:09", "2026-01-04 09:39:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519549;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "163052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58745", "woocommerce_cleanup_logs", "complete", "2026-01-04 09:39:09", "2026-01-04 09:39:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519549;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "163052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58746", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-04 09:39:09", "2026-01-04 09:39:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519549;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "163052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58747", "fetch_patterns", "complete", "2026-01-04 09:39:09", "2026-01-04 09:39:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519549;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "163052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58748", "woocommerce_cleanup_sessions", "complete", "2026-01-04 06:00:00", "2026-01-04 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767506400;s:18:\"\0*\0first_timestamp\";i:1767506400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767506400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-04 06:56:55", "2026-01-04 06:56:55", "163034", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58749", "generate_category_lookup_table_wrapper", "complete", "2026-01-03 09:39:19", "2026-01-03 09:39:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767433159;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767433159;}", "13", "1", "2026-01-03 09:42:09", "2026-01-03 09:42:09", "162911", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58750", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-04 09:39:09", "2026-01-04 09:39:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519549;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "163052", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58751", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767433149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767433149;}", "9", "1", "2026-01-03 09:39:55", "2026-01-03 09:39:55", "162910", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58752", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 09:39:09", "2026-01-03 09:39:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767433149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767433149;}", "9", "1", "2026-01-03 09:39:55", "2026-01-03 09:39:55", "162910", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58753", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-03 09:39:10", "2026-01-03 09:39:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767433150;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767433150;}", "9", "1", "2026-01-03 09:40:12", "2026-01-03 09:40:12", "162910", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58754", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 09:47:22", "2026-01-03 09:47:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767433642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767433642;}", "9", "1", "2026-01-03 09:51:56", "2026-01-03 09:51:56", "162914", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58755", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 09:51:56", "2026-01-03 09:51:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767433916;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767433916;}", "9", "1", "2026-01-03 09:52:24", "2026-01-03 09:52:24", "162916", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58756", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 09:59:58", "2026-01-03 09:59:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767434398;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767434398;}", "9", "1", "2026-01-03 11:00:44", "2026-01-03 11:00:44", "162919", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58757", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 12:00:44", "2026-01-03 12:00:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767441644;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767441644;}", "13", "1", "2026-01-03 12:08:14", "2026-01-03 12:08:14", "162926", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58758", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 11:00:44", "2026-01-03 11:00:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767438044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767438044;}", "9", "1", "2026-01-03 11:00:52", "2026-01-03 11:00:52", "162921", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58759", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 11:00:44", "2026-01-03 11:00:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767438044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767438044;}", "9", "1", "2026-01-03 11:00:52", "2026-01-03 11:00:52", "162921", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58760", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 11:17:22", "2026-01-03 11:17:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767439042;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767439042;}", "9", "1", "2026-01-03 11:17:28", "2026-01-03 11:17:28", "162924", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58761", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 13:08:14", "2026-01-03 13:08:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767445694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767445694;}", "13", "1", "2026-01-03 13:16:41", "2026-01-03 13:16:41", "162932", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58762", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 12:08:14", "2026-01-03 12:08:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767442094;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767442094;}", "9", "1", "2026-01-03 12:08:35", "2026-01-03 12:08:35", "162928", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58763", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 12:08:19", "2026-01-03 12:08:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767442099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767442099;}", "9", "1", "2026-01-03 12:08:35", "2026-01-03 12:08:35", "162928", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58764", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 12:25:43", "2026-01-03 12:25:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767443143;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767443143;}", "9", "1", "2026-01-03 12:25:43", "2026-01-03 12:25:43", "162930", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58765", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 14:16:41", "2026-01-03 14:16:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767449801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767449801;}", "13", "1", "2026-01-03 15:25:28", "2026-01-03 15:25:28", "162952", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58766", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 13:16:42", "2026-01-03 13:16:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767446202;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767446202;}", "9", "1", "2026-01-03 13:16:47", "2026-01-03 13:16:47", "162935", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58767", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 13:16:42", "2026-01-03 13:16:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767446202;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767446202;}", "9", "1", "2026-01-03 13:16:47", "2026-01-03 13:16:47", "162935", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58768", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 13:22:42", "2026-01-03 13:22:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767446562;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767446562;}", "9", "1", "2026-01-03 13:22:50", "2026-01-03 13:22:50", "162938", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58769", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 13:29:46", "2026-01-03 13:29:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767446986;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767446986;}", "9", "1", "2026-01-03 13:29:51", "2026-01-03 13:29:51", "162941", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58770", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 13:41:03", "2026-01-03 13:41:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767447663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767447663;}", "9", "1", "2026-01-03 13:41:11", "2026-01-03 13:41:11", "162944", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58771", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 13:41:03", "2026-01-03 13:41:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767447663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767447663;}", "9", "1", "2026-01-03 13:41:11", "2026-01-03 13:41:11", "162944", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58772", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 13:50:16", "2026-01-03 13:50:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767448216;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767448216;}", "9", "1", "2026-01-03 13:57:31", "2026-01-03 13:57:31", "162948", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58773", "woocommerce_refresh_order_count_cache", "complete", "2026-01-04 01:57:31", "2026-01-04 01:57:31", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767491851;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767491851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-04 01:58:17", "2026-01-04 01:58:17", "163008", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58774", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 13:57:31", "2026-01-03 13:57:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767448651;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767448651;}", "9", "1", "2026-01-03 13:57:37", "2026-01-03 13:57:37", "162950", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58775", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 16:25:28", "2026-01-03 16:25:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767457528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767457528;}", "13", "1", "2026-01-03 16:25:31", "2026-01-03 16:25:31", "162969", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58776", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 15:25:28", "2026-01-03 15:25:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767453928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767453928;}", "9", "1", "2026-01-03 15:25:34", "2026-01-03 15:25:34", "162954", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58777", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 15:25:28", "2026-01-03 15:25:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767453928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767453928;}", "9", "1", "2026-01-03 15:25:34", "2026-01-03 15:25:34", "162954", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58778", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 15:40:24", "2026-01-03 15:40:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767454824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767454824;}", "9", "1", "2026-01-03 15:40:31", "2026-01-03 15:40:31", "162957", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58779", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 15:40:24", "2026-01-03 15:40:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767454824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767454824;}", "9", "1", "2026-01-03 15:40:31", "2026-01-03 15:40:31", "162957", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58780", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 15:50:12", "2026-01-03 15:50:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767455412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767455412;}", "9", "1", "2026-01-03 15:55:25", "2026-01-03 15:55:25", "162960", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58781", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 15:55:25", "2026-01-03 15:55:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767455725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767455725;}", "9", "1", "2026-01-03 15:55:29", "2026-01-03 15:55:29", "162962", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58782", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 16:02:32", "2026-01-03 16:02:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767456152;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767456152;}", "9", "1", "2026-01-03 16:10:23", "2026-01-03 16:10:23", "162965", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58783", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 16:10:23", "2026-01-03 16:10:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767456623;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767456623;}", "9", "1", "2026-01-03 16:10:28", "2026-01-03 16:10:28", "162967", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58784", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 17:25:31", "2026-01-03 17:25:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767461131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767461131;}", "13", "1", "2026-01-03 17:45:33", "2026-01-03 17:45:33", "162981", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58785", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 16:25:31", "2026-01-03 16:25:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767457531;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767457531;}", "9", "1", "2026-01-03 16:25:38", "2026-01-03 16:25:38", "162971", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58786", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 16:38:29", "2026-01-03 16:38:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767458309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767458309;}", "9", "1", "2026-01-03 16:42:08", "2026-01-03 16:42:08", "162974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58787", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 16:38:29", "2026-01-03 16:38:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767458309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767458309;}", "9", "1", "2026-01-03 16:42:08", "2026-01-03 16:42:08", "162974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58788", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 16:42:08", "2026-01-03 16:42:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767458528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767458528;}", "9", "1", "2026-01-03 16:42:09", "2026-01-03 16:42:09", "162974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58789", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 17:06:08", "2026-01-03 17:06:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767459968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767459968;}", "9", "1", "2026-01-03 17:06:15", "2026-01-03 17:06:15", "162978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58790", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 18:45:33", "2026-01-03 18:45:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767465933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767465933;}", "13", "1", "2026-01-03 20:03:41", "2026-01-03 20:03:41", "162989", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58791", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 17:45:33", "2026-01-03 17:45:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767462333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767462333;}", "9", "1", "2026-01-03 17:45:35", "2026-01-03 17:45:35", "162983", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58792", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 17:45:34", "2026-01-03 17:45:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767462334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767462334;}", "9", "1", "2026-01-03 17:45:35", "2026-01-03 17:45:35", "162983", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58793", "woocommerce_scheduled_sales", "complete", "2026-01-04 18:31:00", "2026-01-04 18:31:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767551460;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767551460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-04 19:53:46", "2026-01-04 19:53:46", "163113", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58794", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 18:31:02", "2026-01-03 18:31:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767465062;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767465062;}", "9", "1", "2026-01-03 18:44:26", "2026-01-03 18:44:26", "162987", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58795", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 18:31:02", "2026-01-03 18:31:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767465062;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767465062;}", "9", "1", "2026-01-03 18:44:26", "2026-01-03 18:44:26", "162987", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58796", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 18:44:26", "2026-01-03 18:44:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767465866;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767465866;}", "9", "1", "2026-01-03 20:03:41", "2026-01-03 20:03:41", "162989", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58797", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 21:03:41", "2026-01-03 21:03:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767474221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767474221;}", "13", "1", "2026-01-03 21:38:17", "2026-01-03 21:38:17", "162994", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58798", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 20:03:42", "2026-01-03 20:03:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767470622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767470622;}", "9", "1", "2026-01-03 20:03:47", "2026-01-03 20:03:47", "162992", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58799", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-03 20:03:42", "2026-01-03 20:03:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767470622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767470622;}", "9", "1", "2026-01-03 20:03:47", "2026-01-03 20:03:47", "162992", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58800", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 20:03:42", "2026-01-03 20:03:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767470622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767470622;}", "9", "1", "2026-01-03 20:03:47", "2026-01-03 20:03:47", "162992", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58801", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 20:03:53", "2026-01-03 20:03:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767470633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767470633;}", "9", "1", "2026-01-03 21:38:17", "2026-01-03 21:38:17", "162994", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58802", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 22:38:17", "2026-01-03 22:38:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767479897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767479897;}", "13", "1", "2026-01-04 00:12:49", "2026-01-04 00:12:49", "162996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58803", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-03 21:38:17", "2026-01-03 21:38:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767476297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767476297;}", "9", "1", "2026-01-04 00:12:37", "2026-01-04 00:12:37", "162996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58804", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-03 21:38:18", "2026-01-03 21:38:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767476298;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767476298;}", "9", "1", "2026-01-04 00:12:37", "2026-01-04 00:12:37", "162996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58805", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 00:12:37", "2026-01-04 00:12:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767485557;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767485557;}", "9", "1", "2026-01-04 00:12:50", "2026-01-04 00:12:50", "162996", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58806", "woocommerce_cleanup_draft_orders", "complete", "2026-01-05 00:12:37", "2026-01-05 00:12:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767571957;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767571957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-05 00:20:50", "2026-01-05 00:20:50", "163215", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58807", "wc_gla_cron_daily_notes", "complete", "2026-01-05 00:12:37", "2026-01-05 00:12:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767571957;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767571957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-05 00:20:50", "2026-01-05 00:20:50", "163215", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58808", "wc_facebook_regenerate_feed", "complete", "2026-01-05 00:12:49", "2026-01-05 00:12:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767571969;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767571969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-05 00:21:02", "2026-01-05 00:21:02", "163215", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58809", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 01:12:49", "2026-01-04 01:12:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767489169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767489169;}", "13", "1", "2026-01-04 01:44:06", "2026-01-04 01:44:06", "163003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58810", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 00:12:50", "2026-01-04 00:12:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767485570;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767485570;}", "9", "1", "2026-01-04 00:55:54", "2026-01-04 00:55:54", "162998", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58811", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 00:55:54", "2026-01-04 00:55:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767488154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767488154;}", "9", "1", "2026-01-04 00:55:55", "2026-01-04 00:55:55", "163000", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58812", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 00:55:54", "2026-01-04 00:55:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767488154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767488154;}", "9", "1", "2026-01-04 00:55:55", "2026-01-04 00:55:55", "163000", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58813", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 02:44:06", "2026-01-04 02:44:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767494646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767494646;}", "13", "1", "2026-01-04 03:19:07", "2026-01-04 03:19:07", "163022", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58814", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 01:44:06", "2026-01-04 01:44:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767491046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767491046;}", "9", "1", "2026-01-04 01:44:22", "2026-01-04 01:44:22", "163005", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58815", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 01:44:06", "2026-01-04 01:44:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767491046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767491046;}", "9", "1", "2026-01-04 01:44:22", "2026-01-04 01:44:22", "163005", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58816", "woocommerce_refresh_order_count_cache", "complete", "2026-01-04 13:58:17", "2026-01-04 13:58:17", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767535097;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767535097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-04 14:27:11", "2026-01-04 14:27:11", "163093", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58817", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 01:58:17", "2026-01-04 01:58:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767491897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767491897;}", "9", "1", "2026-01-04 01:58:27", "2026-01-04 01:58:27", "163010", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58818", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 02:12:28", "2026-01-04 02:12:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767492748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767492748;}", "9", "1", "2026-01-04 02:12:28", "2026-01-04 02:12:28", "163012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58819", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 02:24:55", "2026-01-04 02:24:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767493495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767493495;}", "9", "1", "2026-01-04 02:34:23", "2026-01-04 02:34:23", "163015", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58820", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 02:34:23", "2026-01-04 02:34:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767494063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767494063;}", "9", "1", "2026-01-04 02:38:52", "2026-01-04 02:38:52", "163017", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58821", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 02:34:23", "2026-01-04 02:34:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767494063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767494063;}", "9", "1", "2026-01-04 02:38:52", "2026-01-04 02:38:52", "163017", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58822", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 02:38:52", "2026-01-04 02:38:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767494332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767494332;}", "9", "1", "2026-01-04 02:39:34", "2026-01-04 02:39:34", "163019", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58823", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 04:19:07", "2026-01-04 04:19:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767500347;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767500347;}", "13", "1", "2026-01-04 05:40:29", "2026-01-04 05:40:29", "163028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58824", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-05 03:00:00", "2026-01-05 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767582000;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767582000;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-05 03:08:11", "2026-01-05 03:08:11", "163245", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58825", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 03:19:07", "2026-01-04 03:19:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767496747;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767496747;}", "9", "1", "2026-01-04 03:19:13", "2026-01-04 03:19:13", "163024", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58826", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 03:36:47", "2026-01-04 03:36:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767497807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767497807;}", "9", "1", "2026-01-04 05:40:29", "2026-01-04 05:40:29", "163028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58827", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 03:36:47", "2026-01-04 03:36:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767497807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767497807;}", "9", "1", "2026-01-04 05:40:29", "2026-01-04 05:40:29", "163028", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58828", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 06:40:29", "2026-01-04 06:40:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767508829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767508829;}", "13", "1", "2026-01-04 06:56:55", "2026-01-04 06:56:55", "163034", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58829", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 05:40:29", "2026-01-04 05:40:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767505229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767505229;}", "9", "1", "2026-01-04 05:59:34", "2026-01-04 05:59:34", "163030", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58830", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 05:40:29", "2026-01-04 05:40:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767505229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767505229;}", "9", "1", "2026-01-04 05:59:34", "2026-01-04 05:59:34", "163030", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58831", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 05:59:34", "2026-01-04 05:59:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767506374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767506374;}", "9", "1", "2026-01-04 05:59:43", "2026-01-04 05:59:43", "163032", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58833", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 07:56:55", "2026-01-04 07:56:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767513415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767513415;}", "13", "1", "2026-01-04 08:08:27", "2026-01-04 08:08:27", "163040", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58834", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 06:56:58", "2026-01-04 06:56:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767509818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767509818;}", "9", "1", "2026-01-04 06:57:01", "2026-01-04 06:57:01", "163037", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58835", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 06:56:58", "2026-01-04 06:56:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767509818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767509818;}", "9", "1", "2026-01-04 06:57:01", "2026-01-04 06:57:01", "163037", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58836", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 07:13:24", "2026-01-04 07:13:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767510804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767510804;}", "9", "1", "2026-01-04 08:08:27", "2026-01-04 08:08:27", "163040", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58837", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-04 07:13:24", "2026-01-04 07:13:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767510804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767510804;}", "9", "1", "2026-01-04 08:08:27", "2026-01-04 08:08:27", "163040", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58838", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 08:08:26", "2026-01-04 08:08:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767514106;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767514106;}", "9", "1", "2026-01-04 08:08:27", "2026-01-04 08:08:27", "163040", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58839", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 09:08:27", "2026-01-04 09:08:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767517707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767517707;}", "13", "1", "2026-01-04 09:21:56", "2026-01-04 09:21:56", "163050", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58840", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 08:08:27", "2026-01-04 08:08:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767514107;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767514107;}", "9", "1", "2026-01-04 08:08:27", "2026-01-04 08:08:27", "163042", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58841", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 08:14:22", "2026-01-04 08:14:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767514462;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767514462;}", "9", "1", "2026-01-04 08:14:22", "2026-01-04 08:14:22", "163044", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58842", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 08:57:38", "2026-01-04 08:57:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767517058;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767517058;}", "9", "1", "2026-01-04 08:57:44", "2026-01-04 08:57:44", "163047", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58843", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-04 08:57:39", "2026-01-04 08:57:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767517059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767517059;}", "9", "1", "2026-01-04 08:57:45", "2026-01-04 08:57:45", "163047", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58844", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 08:57:39", "2026-01-04 08:57:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767517059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767517059;}", "9", "1", "2026-01-04 08:57:45", "2026-01-04 08:57:45", "163047", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58845", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 09:21:56", "2026-01-04 09:21:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767518516;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767518516;}", "9", "1", "2026-01-04 09:21:56", "2026-01-04 09:21:56", "163050", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58846", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 10:21:56", "2026-01-04 10:21:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767522116;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767522116;}", "13", "1", "2026-01-04 10:36:39", "2026-01-04 10:36:39", "163070", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58847", "wc_admin_daily_wrapper", "complete", "2026-01-05 09:54:05", "2026-01-05 09:54:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606845;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-05 10:12:27", "2026-01-05 10:12:27", "163278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58848", "woocommerce_cleanup_personal_data", "complete", "2026-01-05 09:54:06", "2026-01-05 09:54:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606846;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-05 10:12:28", "2026-01-05 10:12:28", "163278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58849", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-05 09:54:06", "2026-01-05 09:54:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606846;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-05 10:12:28", "2026-01-05 10:12:28", "163278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58850", "woocommerce_cleanup_logs", "complete", "2026-01-05 09:54:06", "2026-01-05 09:54:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606846;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-05 10:12:28", "2026-01-05 10:12:28", "163278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58851", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-05 09:54:06", "2026-01-05 09:54:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606846;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-05 10:12:28", "2026-01-05 10:12:28", "163278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58852", "fetch_patterns", "complete", "2026-01-05 09:54:06", "2026-01-05 09:54:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606846;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-05 10:12:29", "2026-01-05 10:12:29", "163278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58853", "woocommerce_cleanup_sessions", "complete", "2026-01-05 06:00:00", "2026-01-05 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767592800;s:18:\"\0*\0first_timestamp\";i:1767592800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767592800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-05 07:07:39", "2026-01-05 07:07:39", "163262", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58854", "generate_category_lookup_table_wrapper", "complete", "2026-01-04 09:54:16", "2026-01-04 09:54:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767520456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767520456;}", "13", "1", "2026-01-04 09:54:20", "2026-01-04 09:54:20", "163054", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58855", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-05 09:54:06", "2026-01-05 09:54:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606846;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-05 10:12:29", "2026-01-05 10:12:29", "163278", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58856", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767520446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767520446;}", "9", "1", "2026-01-04 09:54:20", "2026-01-04 09:54:20", "163054", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58857", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 09:54:06", "2026-01-04 09:54:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767520446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767520446;}", "9", "1", "2026-01-04 09:54:20", "2026-01-04 09:54:20", "163054", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58858", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 09:59:42", "2026-01-04 09:59:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767520782;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767520782;}", "9", "1", "2026-01-04 10:03:50", "2026-01-04 10:03:50", "163058", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58859", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 10:03:50", "2026-01-04 10:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767521030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767521030;}", "9", "1", "2026-01-04 10:06:10", "2026-01-04 10:06:10", "163060", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58860", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 10:09:51", "2026-01-04 10:09:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767521391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767521391;}", "9", "1", "2026-01-04 10:12:14", "2026-01-04 10:12:14", "163064", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58861", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 10:14:25", "2026-01-04 10:14:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767521665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767521665;}", "9", "1", "2026-01-04 10:17:37", "2026-01-04 10:17:37", "163067", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58862", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 10:20:28", "2026-01-04 10:20:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767522028;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767522028;}", "9", "1", "2026-01-04 10:36:39", "2026-01-04 10:36:39", "163070", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58863", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 11:36:39", "2026-01-04 11:36:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767526599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767526599;}", "13", "1", "2026-01-04 12:15:21", "2026-01-04 12:15:21", "163076", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58864", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 10:36:39", "2026-01-04 10:36:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767522999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767522999;}", "9", "1", "2026-01-04 11:12:42", "2026-01-04 11:12:42", "163072", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58865", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 10:36:39", "2026-01-04 10:36:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767522999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767522999;}", "9", "1", "2026-01-04 11:12:42", "2026-01-04 11:12:42", "163072", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58866", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 11:12:42", "2026-01-04 11:12:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767525162;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767525162;}", "9", "1", "2026-01-04 11:27:16", "2026-01-04 11:27:16", "163074", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58867", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 11:27:16", "2026-01-04 11:27:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767526036;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767526036;}", "9", "1", "2026-01-04 12:15:21", "2026-01-04 12:15:21", "163076", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58868", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 13:15:21", "2026-01-04 13:15:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767532521;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767532521;}", "13", "1", "2026-01-04 14:27:11", "2026-01-04 14:27:11", "163093", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58869", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 12:15:21", "2026-01-04 12:15:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767528921;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767528921;}", "9", "1", "2026-01-04 12:21:21", "2026-01-04 12:21:21", "163078", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58870", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 12:15:21", "2026-01-04 12:15:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767528921;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767528921;}", "9", "1", "2026-01-04 12:21:21", "2026-01-04 12:21:21", "163078", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58871", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 12:21:21", "2026-01-04 12:21:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767529281;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767529281;}", "9", "1", "2026-01-04 12:23:15", "2026-01-04 12:23:15", "163080", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58872", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 12:55:25", "2026-01-04 12:55:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767531325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767531325;}", "9", "1", "2026-01-04 12:55:25", "2026-01-04 12:55:25", "163083", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58873", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 12:55:25", "2026-01-04 12:55:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767531325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767531325;}", "9", "1", "2026-01-04 12:55:47", "2026-01-04 12:55:47", "163085", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58874", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 13:08:09", "2026-01-04 13:08:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767532089;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767532089;}", "9", "1", "2026-01-04 13:08:25", "2026-01-04 13:08:25", "163090", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58875", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 14:27:11", "2026-01-04 14:27:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767536831;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767536831;}", "9", "1", "2026-01-04 14:27:11", "2026-01-04 14:27:11", "163093", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58876", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 15:27:11", "2026-01-04 15:27:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767540431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767540431;}", "13", "1", "2026-01-04 16:37:43", "2026-01-04 16:37:43", "163098", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58877", "woocommerce_refresh_order_count_cache", "complete", "2026-01-05 02:27:11", "2026-01-05 02:27:11", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767580031;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767580031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-05 02:35:42", "2026-01-05 02:35:42", "163237", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58878", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 14:27:11", "2026-01-04 14:27:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767536831;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767536831;}", "9", "1", "2026-01-04 14:27:27", "2026-01-04 14:27:27", "163095", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58879", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 15:15:43", "2026-01-04 15:15:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767539743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767539743;}", "9", "1", "2026-01-04 16:37:43", "2026-01-04 16:37:43", "163098", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58880", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 15:15:43", "2026-01-04 15:15:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767539743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767539743;}", "9", "1", "2026-01-04 16:37:43", "2026-01-04 16:37:43", "163098", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58881", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 17:37:43", "2026-01-04 17:37:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767548263;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767548263;}", "13", "1", "2026-01-04 17:47:52", "2026-01-04 17:47:52", "163102", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58882", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 16:37:43", "2026-01-04 16:37:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767544663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767544663;}", "9", "1", "2026-01-04 16:38:22", "2026-01-04 16:38:22", "163100", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58883", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 16:37:43", "2026-01-04 16:37:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767544663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767544663;}", "9", "1", "2026-01-04 16:38:22", "2026-01-04 16:38:22", "163100", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58884", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 17:47:52", "2026-01-04 17:47:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767548872;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767548872;}", "9", "1", "2026-01-04 17:47:52", "2026-01-04 17:47:52", "163102", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58885", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 18:47:52", "2026-01-04 18:47:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767552472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767552472;}", "13", "1", "2026-01-04 19:53:46", "2026-01-04 19:53:46", "163113", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58886", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 17:47:52", "2026-01-04 17:47:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767548872;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767548872;}", "9", "1", "2026-01-04 17:50:20", "2026-01-04 17:50:20", "163104", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58887", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 17:50:20", "2026-01-04 17:50:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767549020;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767549020;}", "9", "1", "2026-01-04 18:07:49", "2026-01-04 18:07:49", "163106", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58888", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 18:07:49", "2026-01-04 18:07:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767550069;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767550069;}", "9", "1", "2026-01-04 18:07:49", "2026-01-04 18:07:49", "163108", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58889", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 18:09:06", "2026-01-04 18:09:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767550146;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767550146;}", "9", "1", "2026-01-04 18:09:34", "2026-01-04 18:09:34", "163111", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58890", "woocommerce_scheduled_sales", "complete", "2026-01-05 19:53:46", "2026-01-05 19:53:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767642826;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767642826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-05 20:46:24", "2026-01-05 20:46:24", "163329", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58891", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 20:53:46", "2026-01-04 20:53:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767560026;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767560026;}", "13", "1", "2026-01-04 20:59:57", "2026-01-04 20:59:57", "163127", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58892", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 19:53:46", "2026-01-04 19:53:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767556426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767556426;}", "9", "1", "2026-01-04 19:56:22", "2026-01-04 19:56:22", "163115", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58893", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 19:53:46", "2026-01-04 19:53:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767556426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767556426;}", "9", "1", "2026-01-04 19:56:22", "2026-01-04 19:56:22", "163115", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58894", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-04 19:53:46", "2026-01-04 19:53:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767556426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767556426;}", "9", "1", "2026-01-04 19:56:22", "2026-01-04 19:56:22", "163115", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58895", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 19:54:03", "2026-01-04 19:54:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767556443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767556443;}", "9", "1", "2026-01-04 19:56:23", "2026-01-04 19:56:23", "163115", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58896", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 20:30:33", "2026-01-04 20:30:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767558633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767558633;}", "9", "1", "2026-01-04 20:37:23", "2026-01-04 20:37:23", "163118", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58897", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 20:37:23", "2026-01-04 20:37:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767559043;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767559043;}", "9", "1", "2026-01-04 20:37:23", "2026-01-04 20:37:23", "163118", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58898", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 20:37:23", "2026-01-04 20:37:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767559043;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767559043;}", "9", "1", "2026-01-04 20:37:37", "2026-01-04 20:37:37", "163120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58899", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 20:46:38", "2026-01-04 20:46:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767559598;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767559598;}", "9", "1", "2026-01-04 20:48:36", "2026-01-04 20:48:36", "163123", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58900", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 20:50:59", "2026-01-04 20:50:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767559859;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767559859;}", "9", "1", "2026-01-04 20:50:59", "2026-01-04 20:50:59", "163125", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58901", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 21:59:57", "2026-01-04 21:59:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767563997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767563997;}", "13", "1", "2026-01-04 22:03:00", "2026-01-04 22:03:00", "163163", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58902", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 20:59:57", "2026-01-04 20:59:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767560397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767560397;}", "9", "1", "2026-01-04 21:07:34", "2026-01-04 21:07:34", "163129", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58903", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:07:34", "2026-01-04 21:07:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767560854;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767560854;}", "9", "1", "2026-01-04 21:10:05", "2026-01-04 21:10:05", "163131", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58904", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:10:05", "2026-01-04 21:10:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767561005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767561005;}", "9", "1", "2026-01-04 21:12:43", "2026-01-04 21:12:43", "163133", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58905", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:14:14", "2026-01-04 21:14:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767561254;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767561254;}", "9", "1", "2026-01-04 21:15:47", "2026-01-04 21:15:47", "163136", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58906", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:21:32", "2026-01-04 21:21:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767561692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767561692;}", "9", "1", "2026-01-04 21:23:19", "2026-01-04 21:23:19", "163139", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58907", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:23:59", "2026-01-04 21:23:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767561839;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767561839;}", "9", "1", "2026-01-04 21:24:52", "2026-01-04 21:24:52", "163141", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58908", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:29:16", "2026-01-04 21:29:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767562156;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767562156;}", "9", "1", "2026-01-04 21:31:58", "2026-01-04 21:31:58", "163146", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58909", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 21:31:58", "2026-01-04 21:31:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767562318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767562318;}", "9", "1", "2026-01-04 21:33:02", "2026-01-04 21:33:02", "163148", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58910", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:36:22", "2026-01-04 21:36:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767562582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767562582;}", "9", "1", "2026-01-04 21:43:32", "2026-01-04 21:43:32", "163151", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58911", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:43:32", "2026-01-04 21:43:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767563012;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767563012;}", "9", "1", "2026-01-04 21:45:12", "2026-01-04 21:45:12", "163153", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58912", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:45:12", "2026-01-04 21:45:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767563112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767563112;}", "9", "1", "2026-01-04 21:45:12", "2026-01-04 21:45:12", "163153", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58913", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:50:27", "2026-01-04 21:50:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767563427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767563427;}", "9", "1", "2026-01-04 21:52:01", "2026-01-04 21:52:01", "163158", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58914", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 21:54:53", "2026-01-04 21:54:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767563693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767563693;}", "9", "1", "2026-01-04 21:56:19", "2026-01-04 21:56:19", "163161", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58915", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 23:03:00", "2026-01-04 23:03:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767567780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767567780;}", "13", "1", "2026-01-04 23:03:22", "2026-01-04 23:03:22", "163203", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58916", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:03:00", "2026-01-04 22:03:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767564180;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767564180;}", "9", "1", "2026-01-04 22:03:54", "2026-01-04 22:03:54", "163165", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58917", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:03:54", "2026-01-04 22:03:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767564234;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767564234;}", "9", "1", "2026-01-04 22:08:56", "2026-01-04 22:08:56", "163167", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58918", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:08:56", "2026-01-04 22:08:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767564536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767564536;}", "9", "1", "2026-01-04 22:09:00", "2026-01-04 22:09:00", "163169", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58919", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:13:53", "2026-01-04 22:13:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767564833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767564833;}", "9", "1", "2026-01-04 22:14:58", "2026-01-04 22:14:58", "163173", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58920", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:20:34", "2026-01-04 22:20:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767565234;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767565234;}", "9", "1", "2026-01-04 22:21:49", "2026-01-04 22:21:49", "163177", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58921", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:25:29", "2026-01-04 22:25:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767565529;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767565529;}", "9", "1", "2026-01-04 22:26:41", "2026-01-04 22:26:41", "163181", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58922", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:29:39", "2026-01-04 22:29:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767565779;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767565779;}", "9", "1", "2026-01-04 22:29:39", "2026-01-04 22:29:39", "163184", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58923", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-04 22:33:02", "2026-01-04 22:33:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767565982;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767565982;}", "9", "1", "2026-01-04 22:33:24", "2026-01-04 22:33:24", "163187", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58924", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:34:04", "2026-01-04 22:34:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767566044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767566044;}", "9", "1", "2026-01-04 22:34:53", "2026-01-04 22:34:53", "163189", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58925", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:40:16", "2026-01-04 22:40:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767566416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767566416;}", "9", "1", "2026-01-04 22:42:20", "2026-01-04 22:42:20", "163193", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58926", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:44:06", "2026-01-04 22:44:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767566646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767566646;}", "9", "1", "2026-01-04 22:51:33", "2026-01-04 22:51:33", "163196", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58927", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 22:51:33", "2026-01-04 22:51:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767567093;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767567093;}", "9", "1", "2026-01-04 23:00:13", "2026-01-04 23:00:13", "163198", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58928", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 23:00:13", "2026-01-04 23:00:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767567613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767567613;}", "9", "1", "2026-01-04 23:00:58", "2026-01-04 23:00:58", "163200", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58929", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 00:03:22", "2026-01-05 00:03:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767571402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767571402;}", "13", "1", "2026-01-05 00:20:50", "2026-01-05 00:20:50", "163215", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58930", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 23:04:41", "2026-01-04 23:04:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767567881;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767567881;}", "9", "1", "2026-01-04 23:04:41", "2026-01-04 23:04:41", "163205", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58931", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 23:09:51", "2026-01-04 23:09:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767568191;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767568191;}", "9", "1", "2026-01-04 23:11:47", "2026-01-04 23:11:47", "163209", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58932", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-04 23:15:51", "2026-01-04 23:15:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767568551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767568551;}", "9", "1", "2026-01-04 23:15:51", "2026-01-04 23:15:51", "163212", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58933", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 01:20:50", "2026-01-05 01:20:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767576050;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767576050;}", "13", "1", "2026-01-05 01:29:40", "2026-01-05 01:29:40", "163232", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58934", "woocommerce_cleanup_draft_orders", "complete", "2026-01-06 00:20:50", "2026-01-06 00:20:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767658850;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767658850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-06 01:09:56", "2026-01-06 01:09:56", "163344", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58935", "wc_gla_cron_daily_notes", "complete", "2026-01-06 00:20:50", "2026-01-06 00:20:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767658850;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767658850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-06 01:09:56", "2026-01-06 01:09:56", "163344", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58936", "wc_facebook_regenerate_feed", "complete", "2026-01-06 00:21:02", "2026-01-06 00:21:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767658862;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767658862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-06 01:10:08", "2026-01-06 01:10:08", "163344", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58937", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 00:21:02", "2026-01-05 00:21:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767572462;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767572462;}", "9", "1", "2026-01-05 00:24:00", "2026-01-05 00:24:00", "163217", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58938", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 00:21:02", "2026-01-05 00:21:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767572462;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767572462;}", "9", "1", "2026-01-05 00:24:01", "2026-01-05 00:24:01", "163217", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58939", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 00:24:01", "2026-01-05 00:24:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767572641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767572641;}", "9", "1", "2026-01-05 00:24:09", "2026-01-05 00:24:09", "163219", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58940", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 00:36:35", "2026-01-05 00:36:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767573395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767573395;}", "9", "1", "2026-01-05 00:36:40", "2026-01-05 00:36:40", "163222", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58941", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 00:36:35", "2026-01-05 00:36:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767573395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767573395;}", "9", "1", "2026-01-05 00:36:40", "2026-01-05 00:36:40", "163222", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58942", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 00:44:52", "2026-01-05 00:44:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767573892;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767573892;}", "9", "1", "2026-01-05 00:51:23", "2026-01-05 00:51:23", "163225", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58943", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 00:51:24", "2026-01-05 00:51:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767574284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767574284;}", "9", "1", "2026-01-05 01:03:11", "2026-01-05 01:03:11", "163227", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58944", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 01:03:11", "2026-01-05 01:03:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767574991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767574991;}", "9", "1", "2026-01-05 01:03:15", "2026-01-05 01:03:15", "163229", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58945", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 01:29:40", "2026-01-05 01:29:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767576580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767576580;}", "9", "1", "2026-01-05 01:29:40", "2026-01-05 01:29:40", "163232", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58946", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 02:29:40", "2026-01-05 02:29:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767580180;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767580180;}", "13", "1", "2026-01-05 02:35:42", "2026-01-05 02:35:42", "163237", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58947", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 01:55:24", "2026-01-05 01:55:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767578124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767578124;}", "9", "1", "2026-01-05 01:55:31", "2026-01-05 01:55:31", "163235", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58948", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 01:55:24", "2026-01-05 01:55:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767578124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767578124;}", "9", "1", "2026-01-05 01:55:31", "2026-01-05 01:55:31", "163235", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58949", "woocommerce_refresh_order_count_cache", "complete", "2026-01-05 14:35:42", "2026-01-05 14:35:42", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767623742;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767623742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-05 16:36:22", "2026-01-05 16:36:22", "163322", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58950", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 03:35:42", "2026-01-05 03:35:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767584142;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767584142;}", "13", "1", "2026-01-05 04:05:31", "2026-01-05 04:05:31", "163247", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58951", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 02:35:42", "2026-01-05 02:35:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767580542;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767580542;}", "9", "1", "2026-01-05 02:36:19", "2026-01-05 02:36:19", "163239", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58952", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 02:35:42", "2026-01-05 02:35:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767580542;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767580542;}", "9", "1", "2026-01-05 02:36:19", "2026-01-05 02:36:19", "163239", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58953", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 02:50:47", "2026-01-05 02:50:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767581447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767581447;}", "9", "1", "2026-01-05 02:52:08", "2026-01-05 02:52:08", "163242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58954", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-06 03:00:00", "2026-01-06 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767668400;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767668400;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-06 03:02:11", "2026-01-06 03:02:11", "163391", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58955", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 03:08:11", "2026-01-05 03:08:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767582491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767582491;}", "9", "1", "2026-01-05 04:05:31", "2026-01-05 04:05:31", "163247", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58956", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 05:05:31", "2026-01-05 05:05:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767589531;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767589531;}", "13", "1", "2026-01-05 05:10:19", "2026-01-05 05:10:19", "163255", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58957", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 04:05:31", "2026-01-05 04:05:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767585931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767585931;}", "9", "1", "2026-01-05 04:36:35", "2026-01-05 04:36:35", "163249", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58958", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 04:05:32", "2026-01-05 04:05:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767585932;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767585932;}", "9", "1", "2026-01-05 04:36:35", "2026-01-05 04:36:35", "163249", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58959", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 04:36:35", "2026-01-05 04:36:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767587795;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767587795;}", "9", "1", "2026-01-05 04:36:45", "2026-01-05 04:36:45", "163251", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58960", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 04:37:35", "2026-01-05 04:37:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767587855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767587855;}", "9", "1", "2026-01-05 04:37:35", "2026-01-05 04:37:35", "163253", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58961", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 05:10:19", "2026-01-05 05:10:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767589819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767589819;}", "9", "1", "2026-01-05 05:10:19", "2026-01-05 05:10:19", "163255", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58962", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 06:10:19", "2026-01-05 06:10:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767593419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767593419;}", "13", "1", "2026-01-05 07:07:39", "2026-01-05 07:07:39", "163262", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58963", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 05:10:19", "2026-01-05 05:10:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767589819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767589819;}", "9", "1", "2026-01-05 05:10:23", "2026-01-05 05:10:23", "163257", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58964", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 05:46:37", "2026-01-05 05:46:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767591997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767591997;}", "9", "1", "2026-01-05 07:07:39", "2026-01-05 07:07:39", "163262", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58965", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 05:46:37", "2026-01-05 05:46:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767591997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767591997;}", "9", "1", "2026-01-05 07:07:39", "2026-01-05 07:07:39", "163262", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58967", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 08:07:39", "2026-01-05 08:07:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767600459;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767600459;}", "13", "1", "2026-01-05 09:03:14", "2026-01-05 09:03:14", "163266", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58968", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 07:07:44", "2026-01-05 07:07:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767596864;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767596864;}", "9", "1", "2026-01-05 07:21:47", "2026-01-05 07:21:47", "163264", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58969", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 07:07:47", "2026-01-05 07:07:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767596867;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767596867;}", "9", "1", "2026-01-05 07:21:47", "2026-01-05 07:21:47", "163264", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58970", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-05 07:07:47", "2026-01-05 07:07:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767596867;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767596867;}", "9", "1", "2026-01-05 07:21:47", "2026-01-05 07:21:47", "163264", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58971", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 07:21:47", "2026-01-05 07:21:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767597707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767597707;}", "9", "1", "2026-01-05 09:03:14", "2026-01-05 09:03:14", "163266", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58972", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 10:03:14", "2026-01-05 10:03:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767607394;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767607394;}", "13", "1", "2026-01-05 10:12:29", "2026-01-05 10:12:29", "163278", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58973", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 09:03:14", "2026-01-05 09:03:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767603794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767603794;}", "9", "1", "2026-01-05 09:03:24", "2026-01-05 09:03:24", "163268", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58974", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 09:03:14", "2026-01-05 09:03:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767603794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767603794;}", "9", "1", "2026-01-05 09:03:24", "2026-01-05 09:03:24", "163268", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58975", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-05 09:03:15", "2026-01-05 09:03:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767603795;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767603795;}", "9", "1", "2026-01-05 09:03:40", "2026-01-05 09:03:40", "163268", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58976", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 09:15:06", "2026-01-05 09:15:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767604506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767604506;}", "9", "1", "2026-01-05 09:15:07", "2026-01-05 09:15:07", "163269", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58977", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 09:38:06", "2026-01-05 09:38:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767605886;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767605886;}", "9", "1", "2026-01-05 09:38:10", "2026-01-05 09:38:10", "163272", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58978", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 09:38:06", "2026-01-05 09:38:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767605886;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767605886;}", "9", "1", "2026-01-05 09:38:10", "2026-01-05 09:38:10", "163272", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58979", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 09:51:30", "2026-01-05 09:51:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767606690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767606690;}", "9", "1", "2026-01-05 09:51:30", "2026-01-05 09:51:30", "163275", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58980", "wc_admin_daily_wrapper", "complete", "2026-01-06 10:12:27", "2026-01-06 10:12:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767694347;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767694347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-06 10:28:32", "2026-01-06 10:28:32", "163477", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58981", "woocommerce_cleanup_personal_data", "complete", "2026-01-06 10:12:28", "2026-01-06 10:12:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767694348;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767694348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-06 10:28:33", "2026-01-06 10:28:33", "163477", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58982", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-06 10:12:28", "2026-01-06 10:12:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767694348;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767694348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-06 10:28:33", "2026-01-06 10:28:33", "163477", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58983", "woocommerce_cleanup_logs", "complete", "2026-01-06 10:12:28", "2026-01-06 10:12:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767694348;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767694348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-06 10:28:33", "2026-01-06 10:28:33", "163477", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58984", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-06 10:12:28", "2026-01-06 10:12:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767694348;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767694348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-06 10:28:33", "2026-01-06 10:28:33", "163477", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58985", "fetch_patterns", "complete", "2026-01-06 10:12:29", "2026-01-06 10:12:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767694349;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767694349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-06 10:28:33", "2026-01-06 10:28:33", "163477", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58986", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 11:12:29", "2026-01-05 11:12:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767611549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767611549;}", "13", "1", "2026-01-05 11:16:55", "2026-01-05 11:16:55", "163302", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58987", "woocommerce_cleanup_sessions", "complete", "2026-01-06 06:00:00", "2026-01-06 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767679200;s:18:\"\0*\0first_timestamp\";i:1767679200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767679200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-06 06:42:52", "2026-01-06 06:42:52", "163441", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58988", "generate_category_lookup_table_wrapper", "complete", "2026-01-05 10:12:39", "2026-01-05 10:12:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767607959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767607959;}", "13", "1", "2026-01-05 10:13:44", "2026-01-05 10:13:44", "163280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58989", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-06 10:12:29", "2026-01-06 10:12:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767694349;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767694349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-06 10:28:33", "2026-01-06 10:28:33", "163477", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58990", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 10:12:29", "2026-01-05 10:12:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767607949;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767607949;}", "9", "1", "2026-01-05 10:13:44", "2026-01-05 10:13:44", "163280", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58991", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 10:18:53", "2026-01-05 10:18:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767608333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767608333;}", "9", "1", "2026-01-05 10:18:53", "2026-01-05 10:18:53", "163282", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58992", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 10:24:13", "2026-01-05 10:24:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767608653;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767608653;}", "9", "1", "2026-01-05 10:25:11", "2026-01-05 10:25:11", "163288", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58993", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 10:33:02", "2026-01-05 10:33:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767609182;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767609182;}", "9", "1", "2026-01-05 10:33:08", "2026-01-05 10:33:08", "163291", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58994", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 10:33:02", "2026-01-05 10:33:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767609182;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767609182;}", "9", "1", "2026-01-05 10:33:08", "2026-01-05 10:33:08", "163291", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58995", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 10:42:36", "2026-01-05 10:42:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767609756;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767609756;}", "9", "1", "2026-01-05 10:42:40", "2026-01-05 10:42:40", "163294", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58996", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 10:44:21", "2026-01-05 10:44:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767609861;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767609861;}", "9", "1", "2026-01-05 10:44:29", "2026-01-05 10:44:29", "163297", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58997", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 10:56:01", "2026-01-05 10:56:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767610561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767610561;}", "9", "1", "2026-01-05 10:56:17", "2026-01-05 10:56:17", "163300", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58998", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 12:16:55", "2026-01-05 12:16:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767615415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767615415;}", "13", "1", "2026-01-05 12:30:23", "2026-01-05 12:30:23", "163310", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("58999", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 11:16:55", "2026-01-05 11:16:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767611815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767611815;}", "9", "1", "2026-01-05 11:17:02", "2026-01-05 11:17:02", "163304", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59000", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 11:55:12", "2026-01-05 11:55:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767614112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767614112;}", "9", "1", "2026-01-05 11:55:23", "2026-01-05 11:55:23", "163307", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59001", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 11:55:12", "2026-01-05 11:55:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767614112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767614112;}", "9", "1", "2026-01-05 11:55:24", "2026-01-05 11:55:24", "163307", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59002", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 13:30:23", "2026-01-05 13:30:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767619823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767619823;}", "13", "1", "2026-01-05 16:36:22", "2026-01-05 16:36:22", "163322", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59003", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 12:30:23", "2026-01-05 12:30:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767616223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767616223;}", "9", "1", "2026-01-05 12:30:32", "2026-01-05 12:30:32", "163312", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59004", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 12:32:29", "2026-01-05 12:32:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767616349;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767616349;}", "9", "1", "2026-01-05 12:32:29", "2026-01-05 12:32:29", "163314", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59005", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 12:55:25", "2026-01-05 12:55:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767617725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767617725;}", "9", "1", "2026-01-05 12:55:30", "2026-01-05 12:55:30", "163317", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59006", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 13:11:39", "2026-01-05 13:11:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767618699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767618699;}", "9", "1", "2026-01-05 13:26:59", "2026-01-05 13:26:59", "163320", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59007", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 13:26:59", "2026-01-05 13:26:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767619619;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767619619;}", "9", "1", "2026-01-05 16:36:22", "2026-01-05 16:36:22", "163322", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59008", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 17:36:22", "2026-01-05 17:36:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767634582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767634582;}", "13", "1", "2026-01-05 20:46:24", "2026-01-05 20:46:24", "163329", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59009", "woocommerce_refresh_order_count_cache", "complete", "2026-01-06 04:36:22", "2026-01-06 04:36:22", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767674182;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767674182;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-06 04:47:57", "2026-01-06 04:47:57", "163437", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59010", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 16:36:22", "2026-01-05 16:36:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767630982;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767630982;}", "9", "1", "2026-01-05 17:18:43", "2026-01-05 17:18:43", "163324", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59011", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 16:36:22", "2026-01-05 16:36:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767630982;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767630982;}", "9", "1", "2026-01-05 17:18:43", "2026-01-05 17:18:43", "163324", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59012", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 17:18:43", "2026-01-05 17:18:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767633523;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767633523;}", "9", "1", "2026-01-05 17:21:56", "2026-01-05 17:21:56", "163326", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59013", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 17:21:55", "2026-01-05 17:21:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767633715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767633715;}", "9", "1", "2026-01-05 17:21:56", "2026-01-05 17:21:56", "163326", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59014", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 21:46:24", "2026-01-05 21:46:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767649584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767649584;}", "13", "1", "2026-01-05 22:07:59", "2026-01-05 22:07:59", "163331", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59015", "woocommerce_scheduled_sales", "complete", "2026-01-06 20:46:24", "2026-01-06 20:46:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767732384;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767732384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-06 20:50:40", "2026-01-06 20:50:40", "163569", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59016", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 20:46:24", "2026-01-05 20:46:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767645984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767645984;}", "9", "1", "2026-01-05 22:07:58", "2026-01-05 22:07:58", "163331", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59017", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 20:46:24", "2026-01-05 20:46:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767645984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767645984;}", "9", "1", "2026-01-05 22:07:59", "2026-01-05 22:07:59", "163331", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59018", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-05 20:46:26", "2026-01-05 20:46:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767645986;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767645986;}", "9", "1", "2026-01-05 22:07:59", "2026-01-05 22:07:59", "163331", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59019", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 23:07:59", "2026-01-05 23:07:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767654479;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767654479;}", "13", "1", "2026-01-05 23:30:04", "2026-01-05 23:30:04", "163337", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59020", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 22:07:59", "2026-01-05 22:07:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767650879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767650879;}", "9", "1", "2026-01-05 22:08:05", "2026-01-05 22:08:05", "163334", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59021", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 22:07:59", "2026-01-05 22:07:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767650879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767650879;}", "9", "1", "2026-01-05 22:08:05", "2026-01-05 22:08:05", "163334", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59022", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 22:20:18", "2026-01-05 22:20:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767651618;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767651618;}", "9", "1", "2026-01-05 23:30:04", "2026-01-05 23:30:04", "163337", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59023", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 00:30:04", "2026-01-06 00:30:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767659404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767659404;}", "13", "1", "2026-01-06 01:10:08", "2026-01-06 01:10:08", "163344", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59024", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-05 23:30:04", "2026-01-05 23:30:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767655804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767655804;}", "9", "1", "2026-01-05 23:31:00", "2026-01-05 23:31:00", "163339", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59025", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 23:30:04", "2026-01-05 23:30:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767655804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767655804;}", "9", "1", "2026-01-05 23:31:00", "2026-01-05 23:31:00", "163339", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59026", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-05 23:31:00", "2026-01-05 23:31:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767655860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767655860;}", "9", "1", "2026-01-05 23:31:00", "2026-01-05 23:31:00", "163341", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59027", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 00:05:40", "2026-01-06 00:05:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767657940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767657940;}", "9", "1", "2026-01-06 01:09:56", "2026-01-06 01:09:56", "163344", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59028", "woocommerce_cleanup_draft_orders", "complete", "2026-01-07 01:09:56", "2026-01-07 01:09:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767748196;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767748196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-07 01:11:25", "2026-01-07 01:11:25", "163596", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59029", "wc_gla_cron_daily_notes", "complete", "2026-01-07 01:09:56", "2026-01-07 01:09:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767748196;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767748196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-07 01:11:25", "2026-01-07 01:11:25", "163596", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59030", "wc_facebook_regenerate_feed", "complete", "2026-01-07 01:10:08", "2026-01-07 01:10:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767748208;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767748208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-07 01:11:37", "2026-01-07 01:11:37", "163596", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59031", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 02:10:08", "2026-01-06 02:10:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767665408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767665408;}", "13", "1", "2026-01-06 02:10:09", "2026-01-06 02:10:09", "163359", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59032", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 01:10:08", "2026-01-06 01:10:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767661808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767661808;}", "9", "1", "2026-01-06 01:38:41", "2026-01-06 01:38:41", "163346", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59033", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 01:10:08", "2026-01-06 01:10:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767661808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767661808;}", "9", "1", "2026-01-06 01:38:41", "2026-01-06 01:38:41", "163346", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59034", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 01:38:41", "2026-01-06 01:38:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767663521;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767663521;}", "9", "1", "2026-01-06 01:43:39", "2026-01-06 01:43:39", "163348", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59035", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 01:38:41", "2026-01-06 01:38:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767663521;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767663521;}", "9", "1", "2026-01-06 01:43:39", "2026-01-06 01:43:39", "163348", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59036", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 01:43:39", "2026-01-06 01:43:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767663819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767663819;}", "9", "1", "2026-01-06 01:43:39", "2026-01-06 01:43:39", "163348", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59037", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 01:50:20", "2026-01-06 01:50:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767664220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767664220;}", "9", "1", "2026-01-06 01:50:20", "2026-01-06 01:50:20", "163350", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59038", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 01:56:26", "2026-01-06 01:56:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767664586;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767664586;}", "9", "1", "2026-01-06 01:56:26", "2026-01-06 01:56:26", "163353", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59039", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:02:40", "2026-01-06 02:02:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767664960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767664960;}", "9", "1", "2026-01-06 02:02:40", "2026-01-06 02:02:40", "163356", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59040", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:06:37", "2026-01-06 02:06:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767665197;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767665197;}", "9", "1", "2026-01-06 02:10:09", "2026-01-06 02:10:09", "163359", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59041", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 03:10:09", "2026-01-06 03:10:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767669009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767669009;}", "13", "1", "2026-01-06 03:10:27", "2026-01-06 03:10:27", "163399", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59042", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:10:09", "2026-01-06 02:10:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767665409;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767665409;}", "9", "1", "2026-01-06 02:15:15", "2026-01-06 02:15:15", "163361", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59043", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:15:15", "2026-01-06 02:15:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767665715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767665715;}", "9", "1", "2026-01-06 02:15:41", "2026-01-06 02:15:41", "163363", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59044", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:21:46", "2026-01-06 02:21:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767666106;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767666106;}", "9", "1", "2026-01-06 02:21:46", "2026-01-06 02:21:46", "163367", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59045", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:32:23", "2026-01-06 02:32:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767666743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767666743;}", "9", "1", "2026-01-06 02:32:23", "2026-01-06 02:32:23", "163371", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59046", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 02:32:24", "2026-01-06 02:32:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767666744;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767666744;}", "9", "1", "2026-01-06 02:33:55", "2026-01-06 02:33:55", "163373", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59047", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:33:55", "2026-01-06 02:33:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767666835;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767666835;}", "9", "1", "2026-01-06 02:37:46", "2026-01-06 02:37:46", "163375", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59048", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:40:28", "2026-01-06 02:40:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767667228;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767667228;}", "9", "1", "2026-01-06 02:44:13", "2026-01-06 02:44:13", "163378", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59049", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:44:13", "2026-01-06 02:44:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767667453;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767667453;}", "9", "1", "2026-01-06 02:46:35", "2026-01-06 02:46:35", "163380", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59050", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:50:39", "2026-01-06 02:50:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767667839;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767667839;}", "9", "1", "2026-01-06 02:50:39", "2026-01-06 02:50:39", "163384", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59051", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 02:56:22", "2026-01-06 02:56:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767668182;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767668182;}", "9", "1", "2026-01-06 02:58:04", "2026-01-06 02:58:04", "163388", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59052", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:02:11", "2026-01-06 03:02:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767668531;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767668531;}", "9", "1", "2026-01-06 03:02:11", "2026-01-06 03:02:11", "163391", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59053", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-07 03:00:00", "2026-01-07 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767754800;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767754800;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-07 03:12:45", "2026-01-07 03:12:45", "163614", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59054", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:05:16", "2026-01-06 03:05:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767668716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767668716;}", "9", "1", "2026-01-06 03:05:16", "2026-01-06 03:05:16", "163395", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59055", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:10:02", "2026-01-06 03:10:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767669002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767669002;}", "9", "1", "2026-01-06 03:10:27", "2026-01-06 03:10:27", "163399", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59056", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 04:10:27", "2026-01-06 04:10:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767672627;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767672627;}", "13", "1", "2026-01-06 04:47:57", "2026-01-06 04:47:57", "163437", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59057", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:14:50", "2026-01-06 03:14:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767669290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767669290;}", "9", "1", "2026-01-06 03:14:50", "2026-01-06 03:14:50", "163403", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59058", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:19:54", "2026-01-06 03:19:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767669594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767669594;}", "9", "1", "2026-01-06 03:19:54", "2026-01-06 03:19:54", "163409", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59059", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:28:51", "2026-01-06 03:28:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767670131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767670131;}", "9", "1", "2026-01-06 03:30:19", "2026-01-06 03:30:19", "163413", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59060", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 03:31:11", "2026-01-06 03:31:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767670271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767670271;}", "9", "1", "2026-01-06 03:31:41", "2026-01-06 03:31:41", "163415", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59061", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:34:51", "2026-01-06 03:34:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767670491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767670491;}", "9", "1", "2026-01-06 03:36:20", "2026-01-06 03:36:20", "163419", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59062", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:38:56", "2026-01-06 03:38:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767670736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767670736;}", "9", "1", "2026-01-06 03:39:34", "2026-01-06 03:39:34", "163423", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59063", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:43:50", "2026-01-06 03:43:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767671030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767671030;}", "9", "1", "2026-01-06 03:45:49", "2026-01-06 03:45:49", "163427", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59064", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 03:53:56", "2026-01-06 03:53:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767671636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767671636;}", "9", "1", "2026-01-06 04:02:34", "2026-01-06 04:02:34", "163431", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59065", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 04:02:34", "2026-01-06 04:02:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767672154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767672154;}", "9", "1", "2026-01-06 04:06:10", "2026-01-06 04:06:10", "163433", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59066", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 04:06:11", "2026-01-06 04:06:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767672371;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767672371;}", "9", "1", "2026-01-06 04:08:12", "2026-01-06 04:08:12", "163435", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59067", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 05:47:57", "2026-01-06 05:47:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767678477;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767678477;}", "13", "1", "2026-01-06 06:42:52", "2026-01-06 06:42:52", "163441", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59068", "woocommerce_refresh_order_count_cache", "complete", "2026-01-06 16:47:57", "2026-01-06 16:47:57", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767718077;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767718077;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-06 16:59:32", "2026-01-06 16:59:32", "163553", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59069", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 04:47:57", "2026-01-06 04:47:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767674877;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767674877;}", "9", "1", "2026-01-06 05:00:12", "2026-01-06 05:00:12", "163439", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59070", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 04:47:57", "2026-01-06 04:47:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767674877;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767674877;}", "9", "1", "2026-01-06 05:00:12", "2026-01-06 05:00:12", "163439", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59071", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 05:00:12", "2026-01-06 05:00:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767675612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767675612;}", "9", "1", "2026-01-06 06:42:52", "2026-01-06 06:42:52", "163441", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59072", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 07:42:52", "2026-01-06 07:42:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767685372;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767685372;}", "13", "1", "2026-01-06 07:51:15", "2026-01-06 07:51:15", "163456", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59074", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 06:42:52", "2026-01-06 06:42:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767681772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767681772;}", "9", "1", "2026-01-06 06:42:52", "2026-01-06 06:42:52", "163443", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59075", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 06:42:52", "2026-01-06 06:42:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767681772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767681772;}", "9", "1", "2026-01-06 06:42:53", "2026-01-06 06:42:53", "163443", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59076", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 06:51:49", "2026-01-06 06:51:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767682309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767682309;}", "9", "1", "2026-01-06 06:51:57", "2026-01-06 06:51:57", "163446", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59077", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 07:00:14", "2026-01-06 07:00:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767682814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767682814;}", "9", "1", "2026-01-06 07:14:43", "2026-01-06 07:14:43", "163449", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59078", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-06 07:00:14", "2026-01-06 07:00:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767682814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767682814;}", "9", "1", "2026-01-06 07:14:43", "2026-01-06 07:14:43", "163449", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59079", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 07:14:43", "2026-01-06 07:14:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767683683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767683683;}", "9", "1", "2026-01-06 07:20:20", "2026-01-06 07:20:20", "163451", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59080", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 07:20:20", "2026-01-06 07:20:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767684020;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767684020;}", "9", "1", "2026-01-06 07:20:20", "2026-01-06 07:20:20", "163453", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59081", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 07:35:20", "2026-01-06 07:35:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767684920;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767684920;}", "9", "1", "2026-01-06 07:51:15", "2026-01-06 07:51:15", "163456", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59082", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 07:35:20", "2026-01-06 07:35:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767684920;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767684920;}", "9", "1", "2026-01-06 07:51:15", "2026-01-06 07:51:15", "163456", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59083", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 08:51:15", "2026-01-06 08:51:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767689475;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767689475;}", "13", "1", "2026-01-06 09:53:29", "2026-01-06 09:53:29", "163463", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59084", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 07:51:15", "2026-01-06 07:51:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767685875;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767685875;}", "9", "1", "2026-01-06 07:52:19", "2026-01-06 07:52:19", "163458", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59085", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 08:01:45", "2026-01-06 08:01:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767686505;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767686505;}", "9", "1", "2026-01-06 08:10:14", "2026-01-06 08:10:14", "163461", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59086", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 08:10:14", "2026-01-06 08:10:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767687014;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767687014;}", "9", "1", "2026-01-06 09:53:29", "2026-01-06 09:53:29", "163463", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59087", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 10:53:29", "2026-01-06 10:53:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767696809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767696809;}", "13", "1", "2026-01-06 11:17:22", "2026-01-06 11:17:22", "163489", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59088", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 09:53:29", "2026-01-06 09:53:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767693209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767693209;}", "9", "1", "2026-01-06 09:53:34", "2026-01-06 09:53:34", "163465", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59089", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-06 09:53:30", "2026-01-06 09:53:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767693210;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767693210;}", "9", "1", "2026-01-06 09:53:51", "2026-01-06 09:53:51", "163465", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59090", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 09:53:30", "2026-01-06 09:53:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767693210;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767693210;}", "9", "1", "2026-01-06 09:53:56", "2026-01-06 09:53:56", "163466", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59091", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 09:54:50", "2026-01-06 09:54:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767693290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767693290;}", "9", "1", "2026-01-06 09:54:50", "2026-01-06 09:54:50", "163468", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59092", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 10:00:18", "2026-01-06 10:00:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767693618;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767693618;}", "9", "1", "2026-01-06 10:00:25", "2026-01-06 10:00:25", "163473", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59093", "wc_admin_daily_wrapper", "complete", "2026-01-07 10:28:32", "2026-01-07 10:28:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767781712;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767781712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-07 10:29:49", "2026-01-07 10:29:49", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59094", "woocommerce_cleanup_personal_data", "complete", "2026-01-07 10:28:33", "2026-01-07 10:28:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767781713;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767781713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-07 10:29:50", "2026-01-07 10:29:50", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59095", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-07 10:28:33", "2026-01-07 10:28:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767781713;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767781713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-07 10:29:50", "2026-01-07 10:29:50", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59096", "woocommerce_cleanup_logs", "complete", "2026-01-07 10:28:33", "2026-01-07 10:28:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767781713;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767781713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-07 10:29:50", "2026-01-07 10:29:50", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59097", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-07 10:28:33", "2026-01-07 10:28:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767781713;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767781713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-07 10:29:50", "2026-01-07 10:29:50", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59098", "fetch_patterns", "complete", "2026-01-07 10:28:33", "2026-01-07 10:28:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767781713;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767781713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-07 10:29:50", "2026-01-07 10:29:50", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59099", "woocommerce_cleanup_sessions", "complete", "2026-01-07 06:00:00", "2026-01-07 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767765600;s:18:\"\0*\0first_timestamp\";i:1767765600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767765600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-07 06:02:45", "2026-01-07 06:02:45", "163631", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59100", "generate_category_lookup_table_wrapper", "complete", "2026-01-06 10:28:43", "2026-01-06 10:28:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767695323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767695323;}", "13", "1", "2026-01-06 10:29:47", "2026-01-06 10:29:47", "163479", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59101", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-07 10:28:33", "2026-01-07 10:28:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767781713;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767781713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-07 10:29:50", "2026-01-07 10:29:50", "163653", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59102", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 10:28:33", "2026-01-06 10:28:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767695313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767695313;}", "9", "1", "2026-01-06 10:29:47", "2026-01-06 10:29:47", "163479", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59103", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 10:29:47", "2026-01-06 10:29:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767695387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767695387;}", "9", "1", "2026-01-06 10:29:47", "2026-01-06 10:29:47", "163479", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59104", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 10:43:26", "2026-01-06 10:43:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767696206;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767696206;}", "9", "1", "2026-01-06 10:43:26", "2026-01-06 10:43:26", "163482", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59105", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 10:43:26", "2026-01-06 10:43:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767696206;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767696206;}", "9", "1", "2026-01-06 10:43:37", "2026-01-06 10:43:37", "163484", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59106", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 10:51:47", "2026-01-06 10:51:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767696707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767696707;}", "9", "1", "2026-01-06 10:51:47", "2026-01-06 10:51:47", "163486", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59107", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 12:17:22", "2026-01-06 12:17:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767701842;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767701842;}", "13", "1", "2026-01-06 12:30:35", "2026-01-06 12:30:35", "163510", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59108", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 11:17:22", "2026-01-06 11:17:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767698242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767698242;}", "9", "1", "2026-01-06 11:17:28", "2026-01-06 11:17:28", "163491", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59109", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 11:21:35", "2026-01-06 11:21:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767698495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767698495;}", "9", "1", "2026-01-06 11:43:03", "2026-01-06 11:43:03", "163494", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59110", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 11:43:04", "2026-01-06 11:43:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767699784;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767699784;}", "9", "1", "2026-01-06 11:43:09", "2026-01-06 11:43:09", "163497", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59111", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 11:43:04", "2026-01-06 11:43:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767699784;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767699784;}", "9", "1", "2026-01-06 11:43:09", "2026-01-06 11:43:09", "163497", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59112", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 11:44:08", "2026-01-06 11:44:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767699848;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767699848;}", "9", "1", "2026-01-06 11:45:10", "2026-01-06 11:45:10", "163500", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59113", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 11:57:45", "2026-01-06 11:57:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767700665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767700665;}", "9", "1", "2026-01-06 11:57:51", "2026-01-06 11:57:51", "163504", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59114", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 12:09:03", "2026-01-06 12:09:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767701343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767701343;}", "9", "1", "2026-01-06 12:09:13", "2026-01-06 12:09:13", "163507", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59115", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 13:30:35", "2026-01-06 13:30:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767706235;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767706235;}", "13", "1", "2026-01-06 13:37:00", "2026-01-06 13:37:00", "163525", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59116", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 12:30:35", "2026-01-06 12:30:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767702635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767702635;}", "9", "1", "2026-01-06 12:30:44", "2026-01-06 12:30:44", "163512", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59117", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 12:30:45", "2026-01-06 12:30:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767702645;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767702645;}", "9", "1", "2026-01-06 12:30:50", "2026-01-06 12:30:50", "163514", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59118", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 12:37:46", "2026-01-06 12:37:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767703066;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767703066;}", "9", "1", "2026-01-06 12:37:59", "2026-01-06 12:37:59", "163517", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59119", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 12:44:20", "2026-01-06 12:44:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767703460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767703460;}", "9", "1", "2026-01-06 13:03:18", "2026-01-06 13:03:18", "163520", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59120", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 13:03:18", "2026-01-06 13:03:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767704598;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767704598;}", "9", "1", "2026-01-06 13:10:08", "2026-01-06 13:10:08", "163522", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59121", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 13:10:08", "2026-01-06 13:10:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767705008;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767705008;}", "9", "1", "2026-01-06 13:10:08", "2026-01-06 13:10:08", "163522", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59122", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 14:37:00", "2026-01-06 14:37:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767710220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767710220;}", "13", "1", "2026-01-06 15:15:17", "2026-01-06 15:15:17", "163536", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59123", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 13:37:00", "2026-01-06 13:37:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767706620;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767706620;}", "9", "1", "2026-01-06 13:50:08", "2026-01-06 13:50:08", "163527", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59124", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 13:37:00", "2026-01-06 13:37:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767706620;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767706620;}", "9", "1", "2026-01-06 13:50:08", "2026-01-06 13:50:08", "163527", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59125", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 13:50:08", "2026-01-06 13:50:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767707408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767707408;}", "9", "1", "2026-01-06 14:26:48", "2026-01-06 14:26:48", "163529", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59126", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 14:26:48", "2026-01-06 14:26:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767709608;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767709608;}", "9", "1", "2026-01-06 14:33:11", "2026-01-06 14:33:11", "163531", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59127", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 14:33:11", "2026-01-06 14:33:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767709991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767709991;}", "9", "1", "2026-01-06 14:33:17", "2026-01-06 14:33:17", "163533", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59128", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 14:33:11", "2026-01-06 14:33:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767709991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767709991;}", "9", "1", "2026-01-06 14:33:17", "2026-01-06 14:33:17", "163533", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59129", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 15:15:17", "2026-01-06 15:15:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767712517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767712517;}", "9", "1", "2026-01-06 15:15:17", "2026-01-06 15:15:17", "163536", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59130", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 16:15:17", "2026-01-06 16:15:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767716117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767716117;}", "13", "1", "2026-01-06 16:22:22", "2026-01-06 16:22:22", "163547", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59131", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 15:19:45", "2026-01-06 15:19:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767712785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767712785;}", "9", "1", "2026-01-06 15:39:22", "2026-01-06 15:39:22", "163539", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59132", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 15:39:22", "2026-01-06 15:39:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767713962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767713962;}", "9", "1", "2026-01-06 15:41:41", "2026-01-06 15:41:41", "163541", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59133", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 15:39:22", "2026-01-06 15:39:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767713962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767713962;}", "9", "1", "2026-01-06 15:41:41", "2026-01-06 15:41:41", "163541", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59134", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 16:09:21", "2026-01-06 16:09:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767715761;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767715761;}", "9", "1", "2026-01-06 16:09:22", "2026-01-06 16:09:22", "163545", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59135", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 17:22:22", "2026-01-06 17:22:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767720142;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767720142;}", "13", "1", "2026-01-06 17:55:43", "2026-01-06 17:55:43", "163556", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59136", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 16:22:22", "2026-01-06 16:22:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767716542;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767716542;}", "9", "1", "2026-01-06 16:43:09", "2026-01-06 16:43:09", "163549", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59137", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 16:43:09", "2026-01-06 16:43:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767717789;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767717789;}", "9", "1", "2026-01-06 16:43:25", "2026-01-06 16:43:25", "163551", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59138", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 16:43:09", "2026-01-06 16:43:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767717789;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767717789;}", "9", "1", "2026-01-06 16:43:25", "2026-01-06 16:43:25", "163551", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59139", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 16:59:32", "2026-01-06 16:59:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767718772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767718772;}", "9", "1", "2026-01-06 16:59:33", "2026-01-06 16:59:33", "163553", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59140", "woocommerce_refresh_order_count_cache", "complete", "2026-01-07 04:59:32", "2026-01-07 04:59:32", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767761972;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767761972;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-07 05:10:42", "2026-01-07 05:10:42", "163624", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59141", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 17:08:40", "2026-01-06 17:08:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767719320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767719320;}", "9", "1", "2026-01-06 17:55:43", "2026-01-06 17:55:43", "163556", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59142", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 17:55:43", "2026-01-06 17:55:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767722143;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767722143;}", "9", "1", "2026-01-06 17:55:43", "2026-01-06 17:55:43", "163556", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59143", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 18:55:43", "2026-01-06 18:55:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767725743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767725743;}", "13", "1", "2026-01-06 19:23:19", "2026-01-06 19:23:19", "163561", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59144", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 17:55:43", "2026-01-06 17:55:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767722143;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767722143;}", "9", "1", "2026-01-06 17:55:48", "2026-01-06 17:55:48", "163558", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59145", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 18:13:53", "2026-01-06 18:13:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767723233;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767723233;}", "9", "1", "2026-01-06 19:23:19", "2026-01-06 19:23:19", "163561", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59146", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 20:23:19", "2026-01-06 20:23:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767730999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767730999;}", "13", "1", "2026-01-06 20:50:40", "2026-01-06 20:50:40", "163569", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59147", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 19:23:19", "2026-01-06 19:23:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767727399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767727399;}", "9", "1", "2026-01-06 19:23:24", "2026-01-06 19:23:24", "163563", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59148", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 19:23:19", "2026-01-06 19:23:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767727399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767727399;}", "9", "1", "2026-01-06 19:23:24", "2026-01-06 19:23:24", "163563", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59149", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-06 19:23:19", "2026-01-06 19:23:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767727399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767727399;}", "9", "1", "2026-01-06 19:23:24", "2026-01-06 19:23:24", "163563", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59150", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 19:36:00", "2026-01-06 19:36:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767728160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767728160;}", "9", "1", "2026-01-06 19:36:00", "2026-01-06 19:36:00", "163565", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59151", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 19:36:00", "2026-01-06 19:36:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767728160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767728160;}", "9", "1", "2026-01-06 19:36:00", "2026-01-06 19:36:00", "163565", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59152", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 19:36:00", "2026-01-06 19:36:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767728160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767728160;}", "9", "1", "2026-01-06 19:37:24", "2026-01-06 19:37:24", "163567", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59153", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 21:50:40", "2026-01-06 21:50:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767736240;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767736240;}", "13", "1", "2026-01-06 22:26:24", "2026-01-06 22:26:24", "163582", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59154", "woocommerce_scheduled_sales", "complete", "2026-01-07 20:50:40", "2026-01-07 20:50:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767819040;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767819040;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-07 21:13:43", "2026-01-07 21:13:43", "163701", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59155", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 20:50:40", "2026-01-06 20:50:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767732640;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767732640;}", "9", "1", "2026-01-06 20:50:58", "2026-01-06 20:50:58", "163571", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59156", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 20:50:41", "2026-01-06 20:50:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767732641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767732641;}", "9", "1", "2026-01-06 20:50:58", "2026-01-06 20:50:58", "163571", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59157", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 21:16:28", "2026-01-06 21:16:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767734188;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767734188;}", "9", "1", "2026-01-06 21:18:53", "2026-01-06 21:18:53", "163574", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59158", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 21:18:53", "2026-01-06 21:18:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767734333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767734333;}", "9", "1", "2026-01-06 21:19:15", "2026-01-06 21:19:15", "163576", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59159", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 21:44:19", "2026-01-06 21:44:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767735859;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767735859;}", "9", "1", "2026-01-06 21:47:00", "2026-01-06 21:47:00", "163580", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59160", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 21:44:19", "2026-01-06 21:44:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767735859;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767735859;}", "9", "1", "2026-01-06 21:47:00", "2026-01-06 21:47:00", "163580", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59161", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 23:26:24", "2026-01-06 23:26:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767741984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767741984;}", "13", "1", "2026-01-06 23:39:47", "2026-01-06 23:39:47", "163592", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59162", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 22:26:25", "2026-01-06 22:26:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767738385;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767738385;}", "9", "1", "2026-01-06 22:26:30", "2026-01-06 22:26:30", "163585", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59163", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 22:42:06", "2026-01-06 22:42:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767739326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767739326;}", "9", "1", "2026-01-06 22:45:15", "2026-01-06 22:45:15", "163588", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59164", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 22:42:06", "2026-01-06 22:42:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767739326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767739326;}", "9", "1", "2026-01-06 22:45:15", "2026-01-06 22:45:15", "163588", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59165", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 22:45:15", "2026-01-06 22:45:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767739515;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767739515;}", "9", "1", "2026-01-06 22:45:18", "2026-01-06 22:45:18", "163590", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59166", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 00:39:47", "2026-01-07 00:39:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767746387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767746387;}", "13", "1", "2026-01-07 01:11:25", "2026-01-07 01:11:25", "163596", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59167", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-06 23:39:47", "2026-01-06 23:39:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767742787;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767742787;}", "9", "1", "2026-01-06 23:39:55", "2026-01-06 23:39:55", "163594", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59168", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-06 23:39:47", "2026-01-06 23:39:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767742787;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767742787;}", "9", "1", "2026-01-06 23:39:55", "2026-01-06 23:39:55", "163594", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59169", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 02:11:25", "2026-01-07 02:11:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767751885;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767751885;}", "13", "1", "2026-01-07 02:27:18", "2026-01-07 02:27:18", "163608", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59170", "woocommerce_cleanup_draft_orders", "complete", "2026-01-08 01:11:25", "2026-01-08 01:11:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767834685;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767834685;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-08 01:27:46", "2026-01-08 01:27:46", "163738", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59171", "wc_gla_cron_daily_notes", "complete", "2026-01-08 01:11:25", "2026-01-08 01:11:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767834685;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767834685;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-08 01:27:46", "2026-01-08 01:27:46", "163738", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59172", "wc_facebook_regenerate_feed", "complete", "2026-01-08 01:11:37", "2026-01-08 01:11:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767834697;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767834697;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-08 01:27:56", "2026-01-08 01:27:56", "163738", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59173", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 01:11:37", "2026-01-07 01:11:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767748297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767748297;}", "9", "1", "2026-01-07 01:31:51", "2026-01-07 01:31:51", "163598", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59174", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 01:11:37", "2026-01-07 01:11:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767748297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767748297;}", "9", "1", "2026-01-07 01:31:51", "2026-01-07 01:31:51", "163598", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59175", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 01:31:51", "2026-01-07 01:31:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767749511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767749511;}", "9", "1", "2026-01-07 01:33:15", "2026-01-07 01:33:15", "163600", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59176", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 01:31:51", "2026-01-07 01:31:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767749511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767749511;}", "9", "1", "2026-01-07 01:33:15", "2026-01-07 01:33:15", "163600", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59177", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 01:33:53", "2026-01-07 01:33:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767749633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767749633;}", "9", "1", "2026-01-07 01:47:13", "2026-01-07 01:47:13", "163603", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59178", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 01:47:13", "2026-01-07 01:47:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767750433;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767750433;}", "9", "1", "2026-01-07 01:47:29", "2026-01-07 01:47:29", "163605", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59179", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 01:56:54", "2026-01-07 01:56:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767751014;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767751014;}", "9", "1", "2026-01-07 02:27:18", "2026-01-07 02:27:18", "163608", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59180", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 03:27:18", "2026-01-07 03:27:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767756438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767756438;}", "13", "1", "2026-01-07 04:44:19", "2026-01-07 04:44:19", "163618", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59181", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 02:27:18", "2026-01-07 02:27:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767752838;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767752838;}", "9", "1", "2026-01-07 02:29:43", "2026-01-07 02:29:43", "163610", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59182", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 02:29:43", "2026-01-07 02:29:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767752983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767752983;}", "9", "1", "2026-01-07 02:29:43", "2026-01-07 02:29:43", "163612", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59183", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-08 03:00:00", "2026-01-08 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767841200;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767841200;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-08 03:07:16", "2026-01-08 03:07:16", "163760", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59184", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 03:12:45", "2026-01-07 03:12:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767755565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767755565;}", "9", "1", "2026-01-07 03:12:45", "2026-01-07 03:12:45", "163616", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59185", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 03:12:45", "2026-01-07 03:12:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767755565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767755565;}", "9", "1", "2026-01-07 03:12:45", "2026-01-07 03:12:45", "163616", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59186", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 05:44:19", "2026-01-07 05:44:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767764659;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767764659;}", "13", "1", "2026-01-07 06:02:45", "2026-01-07 06:02:45", "163631", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59187", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 04:44:19", "2026-01-07 04:44:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767761059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767761059;}", "9", "1", "2026-01-07 04:44:19", "2026-01-07 04:44:19", "163620", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59188", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 04:44:19", "2026-01-07 04:44:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767761059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767761059;}", "9", "1", "2026-01-07 04:44:19", "2026-01-07 04:44:19", "163620", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59189", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 04:51:28", "2026-01-07 04:51:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767761488;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767761488;}", "9", "1", "2026-01-07 05:10:42", "2026-01-07 05:10:42", "163624", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59190", "woocommerce_refresh_order_count_cache", "complete", "2026-01-07 17:10:42", "2026-01-07 17:10:42", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767805842;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767805842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-07 19:49:55", "2026-01-07 19:49:55", "163691", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59191", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 05:10:42", "2026-01-07 05:10:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767762642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767762642;}", "9", "1", "2026-01-07 05:21:00", "2026-01-07 05:21:00", "163626", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59192", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 05:21:00", "2026-01-07 05:21:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767763260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767763260;}", "9", "1", "2026-01-07 05:21:12", "2026-01-07 05:21:12", "163628", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59193", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 07:02:45", "2026-01-07 07:02:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767769365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767769365;}", "13", "1", "2026-01-07 07:03:40", "2026-01-07 07:03:40", "163635", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59195", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 06:02:45", "2026-01-07 06:02:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767765765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767765765;}", "9", "1", "2026-01-07 06:02:57", "2026-01-07 06:02:57", "163633", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59196", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 06:02:45", "2026-01-07 06:02:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767765765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767765765;}", "9", "1", "2026-01-07 06:02:57", "2026-01-07 06:02:57", "163633", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59197", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 08:03:40", "2026-01-07 08:03:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767773020;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767773020;}", "13", "1", "2026-01-07 09:57:08", "2026-01-07 09:57:08", "163644", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59198", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 07:03:40", "2026-01-07 07:03:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767769420;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767769420;}", "9", "1", "2026-01-07 07:04:17", "2026-01-07 07:04:17", "163637", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59199", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 07:03:40", "2026-01-07 07:03:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767769420;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767769420;}", "9", "1", "2026-01-07 07:04:17", "2026-01-07 07:04:17", "163637", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59200", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-07 07:03:40", "2026-01-07 07:03:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767769420;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767769420;}", "9", "1", "2026-01-07 07:04:17", "2026-01-07 07:04:17", "163637", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59201", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 07:04:17", "2026-01-07 07:04:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767769457;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767769457;}", "9", "1", "2026-01-07 07:04:18", "2026-01-07 07:04:18", "163637", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59202", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 07:14:26", "2026-01-07 07:14:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767770066;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767770066;}", "9", "1", "2026-01-07 07:14:58", "2026-01-07 07:14:58", "163640", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59203", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 07:27:22", "2026-01-07 07:27:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767770842;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767770842;}", "9", "1", "2026-01-07 09:57:08", "2026-01-07 09:57:08", "163644", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59204", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 10:57:08", "2026-01-07 10:57:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767783428;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767783428;}", "13", "1", "2026-01-07 11:32:52", "2026-01-07 11:32:52", "163664", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59205", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 09:57:08", "2026-01-07 09:57:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767779828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767779828;}", "9", "1", "2026-01-07 09:57:09", "2026-01-07 09:57:09", "163646", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59206", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 09:57:08", "2026-01-07 09:57:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767779828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767779828;}", "9", "1", "2026-01-07 09:57:09", "2026-01-07 09:57:09", "163646", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59207", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-07 09:57:09", "2026-01-07 09:57:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767779829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767779829;}", "9", "1", "2026-01-07 09:57:32", "2026-01-07 09:57:32", "163648", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59208", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 10:20:35", "2026-01-07 10:20:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767781235;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767781235;}", "9", "1", "2026-01-07 10:21:54", "2026-01-07 10:21:54", "163650", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59209", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 10:28:21", "2026-01-07 10:28:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767781701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767781701;}", "9", "1", "2026-01-07 10:29:49", "2026-01-07 10:29:49", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59210", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 10:29:49", "2026-01-07 10:29:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767781789;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767781789;}", "9", "1", "2026-01-07 10:29:50", "2026-01-07 10:29:50", "163653", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59211", "wc_admin_daily_wrapper", "complete", "2026-01-08 10:29:49", "2026-01-08 10:29:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767868189;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767868189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-08 11:37:48", "2026-01-08 11:37:48", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59212", "woocommerce_cleanup_personal_data", "complete", "2026-01-08 10:29:50", "2026-01-08 10:29:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767868190;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-08 11:37:49", "2026-01-08 11:37:49", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59213", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-08 10:29:50", "2026-01-08 10:29:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767868190;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-08 11:37:49", "2026-01-08 11:37:49", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59214", "woocommerce_cleanup_logs", "complete", "2026-01-08 10:29:50", "2026-01-08 10:29:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767868190;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-08 11:37:49", "2026-01-08 11:37:49", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59215", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-08 10:29:50", "2026-01-08 10:29:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767868190;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-08 11:37:49", "2026-01-08 11:37:49", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59216", "fetch_patterns", "complete", "2026-01-08 10:29:50", "2026-01-08 10:29:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767868190;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-08 11:37:50", "2026-01-08 11:37:50", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59217", "woocommerce_cleanup_sessions", "complete", "2026-01-08 06:00:00", "2026-01-08 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767852000;s:18:\"\0*\0first_timestamp\";i:1767852000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767852000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-08 06:03:50", "2026-01-08 06:03:50", "163769", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59218", "generate_category_lookup_table_wrapper", "complete", "2026-01-07 10:30:00", "2026-01-07 10:30:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767781800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767781800;}", "13", "1", "2026-01-07 10:30:35", "2026-01-07 10:30:35", "163655", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59219", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-08 10:29:50", "2026-01-08 10:29:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767868190;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-08 11:37:50", "2026-01-08 11:37:50", "163799", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59220", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 10:31:52", "2026-01-07 10:31:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767781912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767781912;}", "9", "1", "2026-01-07 10:31:52", "2026-01-07 10:31:52", "163657", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59221", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 10:34:36", "2026-01-07 10:34:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767782076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767782076;}", "9", "1", "2026-01-07 10:34:36", "2026-01-07 10:34:36", "163661", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59222", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 12:32:52", "2026-01-07 12:32:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767789172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767789172;}", "13", "1", "2026-01-07 12:54:24", "2026-01-07 12:54:24", "163671", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59223", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 11:32:52", "2026-01-07 11:32:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767785572;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767785572;}", "9", "1", "2026-01-07 11:32:54", "2026-01-07 11:32:54", "163666", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59224", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 11:32:52", "2026-01-07 11:32:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767785572;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767785572;}", "9", "1", "2026-01-07 11:32:54", "2026-01-07 11:32:54", "163666", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59225", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 11:55:45", "2026-01-07 11:55:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767786945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767786945;}", "9", "1", "2026-01-07 12:18:41", "2026-01-07 12:18:41", "163669", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59226", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 12:18:41", "2026-01-07 12:18:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767788321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767788321;}", "9", "1", "2026-01-07 12:54:24", "2026-01-07 12:54:24", "163671", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59227", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 12:54:24", "2026-01-07 12:54:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767790464;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767790464;}", "9", "1", "2026-01-07 12:54:24", "2026-01-07 12:54:24", "163671", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59228", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 13:54:24", "2026-01-07 13:54:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767794064;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767794064;}", "13", "1", "2026-01-07 14:25:35", "2026-01-07 14:25:35", "163673", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59229", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 12:54:24", "2026-01-07 12:54:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767790464;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767790464;}", "9", "1", "2026-01-07 14:25:35", "2026-01-07 14:25:35", "163673", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59230", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 15:25:35", "2026-01-07 15:25:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767799535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767799535;}", "13", "1", "2026-01-07 16:21:36", "2026-01-07 16:21:36", "163678", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59231", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 14:25:35", "2026-01-07 14:25:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767795935;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767795935;}", "9", "1", "2026-01-07 14:25:43", "2026-01-07 14:25:43", "163675", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59232", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 14:25:35", "2026-01-07 14:25:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767795935;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767795935;}", "9", "1", "2026-01-07 14:25:43", "2026-01-07 14:25:43", "163675", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59233", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 14:48:53", "2026-01-07 14:48:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767797333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767797333;}", "9", "1", "2026-01-07 16:21:36", "2026-01-07 16:21:36", "163678", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59234", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 14:48:53", "2026-01-07 14:48:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767797333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767797333;}", "9", "1", "2026-01-07 16:21:36", "2026-01-07 16:21:36", "163678", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59235", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 17:21:36", "2026-01-07 17:21:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767806496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767806496;}", "13", "1", "2026-01-07 19:49:55", "2026-01-07 19:49:55", "163691", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59236", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 16:21:36", "2026-01-07 16:21:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767802896;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767802896;}", "9", "1", "2026-01-07 16:21:41", "2026-01-07 16:21:41", "163680", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59237", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 16:21:36", "2026-01-07 16:21:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767802896;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767802896;}", "9", "1", "2026-01-07 16:21:41", "2026-01-07 16:21:41", "163680", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59238", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 16:30:15", "2026-01-07 16:30:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767803415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767803415;}", "9", "1", "2026-01-07 16:54:40", "2026-01-07 16:54:40", "163683", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59239", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 16:54:40", "2026-01-07 16:54:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767804880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767804880;}", "9", "1", "2026-01-07 16:54:50", "2026-01-07 16:54:50", "163685", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59240", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 16:54:40", "2026-01-07 16:54:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767804880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767804880;}", "9", "1", "2026-01-07 16:54:50", "2026-01-07 16:54:50", "163685", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59241", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 17:02:47", "2026-01-07 17:02:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767805367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767805367;}", "9", "1", "2026-01-07 17:03:13", "2026-01-07 17:03:13", "163688", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59242", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 19:49:55", "2026-01-07 19:49:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767815395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767815395;}", "9", "1", "2026-01-07 19:49:55", "2026-01-07 19:49:55", "163691", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59243", "woocommerce_refresh_order_count_cache", "complete", "2026-01-08 07:49:55", "2026-01-08 07:49:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767858595;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767858595;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-08 08:09:53", "2026-01-08 08:09:53", "163777", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59244", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 20:49:55", "2026-01-07 20:49:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767818995;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767818995;}", "13", "1", "2026-01-07 21:13:43", "2026-01-07 21:13:43", "163701", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59245", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 19:49:55", "2026-01-07 19:49:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767815395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767815395;}", "9", "1", "2026-01-07 19:50:01", "2026-01-07 19:50:01", "163693", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59246", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-07 19:49:58", "2026-01-07 19:49:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767815398;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767815398;}", "9", "1", "2026-01-07 19:50:01", "2026-01-07 19:50:01", "163693", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59247", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 20:27:47", "2026-01-07 20:27:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767817667;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767817667;}", "9", "1", "2026-01-07 20:44:51", "2026-01-07 20:44:51", "163696", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59248", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 20:44:51", "2026-01-07 20:44:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767818691;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767818691;}", "9", "1", "2026-01-07 20:44:51", "2026-01-07 20:44:51", "163697", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59249", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 20:44:51", "2026-01-07 20:44:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767818691;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767818691;}", "9", "1", "2026-01-07 20:44:57", "2026-01-07 20:44:57", "163699", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59250", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 22:13:43", "2026-01-07 22:13:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767824023;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767824023;}", "13", "1", "2026-01-07 22:41:32", "2026-01-07 22:41:32", "163715", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59251", "woocommerce_scheduled_sales", "complete", "2026-01-08 21:13:43", "2026-01-08 21:13:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767906823;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767906823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-08 21:25:37", "2026-01-08 21:25:37", "163859", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59252", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 21:13:43", "2026-01-07 21:13:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767820423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767820423;}", "9", "1", "2026-01-07 21:16:56", "2026-01-07 21:16:56", "163703", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59253", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 21:13:59", "2026-01-07 21:13:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767820439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767820439;}", "9", "1", "2026-01-07 21:16:56", "2026-01-07 21:16:56", "163703", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59254", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 21:20:11", "2026-01-07 21:20:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767820811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767820811;}", "9", "1", "2026-01-07 21:35:39", "2026-01-07 21:35:39", "163707", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59255", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 21:35:39", "2026-01-07 21:35:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767821739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767821739;}", "9", "1", "2026-01-07 21:37:41", "2026-01-07 21:37:41", "163709", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59256", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 21:35:39", "2026-01-07 21:35:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767821739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767821739;}", "9", "1", "2026-01-07 21:37:41", "2026-01-07 21:37:41", "163709", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59257", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 21:39:06", "2026-01-07 21:39:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767821946;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767821946;}", "9", "1", "2026-01-07 21:40:05", "2026-01-07 21:40:05", "163712", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59258", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 23:41:32", "2026-01-07 23:41:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767829292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767829292;}", "13", "1", "2026-01-07 23:42:53", "2026-01-07 23:42:53", "163719", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59259", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 22:41:32", "2026-01-07 22:41:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767825692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767825692;}", "9", "1", "2026-01-07 22:41:38", "2026-01-07 22:41:38", "163717", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59260", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 22:41:33", "2026-01-07 22:41:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767825693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767825693;}", "9", "1", "2026-01-07 22:41:38", "2026-01-07 22:41:38", "163717", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59261", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 00:42:53", "2026-01-08 00:42:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767832973;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767832973;}", "13", "1", "2026-01-08 00:43:28", "2026-01-08 00:43:28", "163729", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59262", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 23:42:53", "2026-01-07 23:42:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767829373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767829373;}", "9", "1", "2026-01-07 23:44:21", "2026-01-07 23:44:21", "163721", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59263", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-07 23:42:53", "2026-01-07 23:42:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767829373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767829373;}", "9", "1", "2026-01-07 23:44:22", "2026-01-07 23:44:22", "163721", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59264", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 23:44:22", "2026-01-07 23:44:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767829462;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767829462;}", "9", "1", "2026-01-07 23:44:27", "2026-01-07 23:44:27", "163723", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59265", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 23:51:38", "2026-01-07 23:51:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767829898;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767829898;}", "9", "1", "2026-01-07 23:51:43", "2026-01-07 23:51:43", "163726", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59266", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-07 23:59:16", "2026-01-07 23:59:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767830356;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767830356;}", "9", "1", "2026-01-08 00:43:28", "2026-01-08 00:43:28", "163729", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59267", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 01:43:28", "2026-01-08 01:43:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767836608;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767836608;}", "13", "1", "2026-01-08 01:49:26", "2026-01-08 01:49:26", "163741", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59268", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 00:43:28", "2026-01-08 00:43:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767833008;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767833008;}", "9", "1", "2026-01-08 00:45:43", "2026-01-08 00:45:43", "163731", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59269", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 00:43:28", "2026-01-08 00:43:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767833008;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767833008;}", "9", "1", "2026-01-08 00:45:43", "2026-01-08 00:45:43", "163731", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59270", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 00:45:44", "2026-01-08 00:45:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767833144;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767833144;}", "9", "1", "2026-01-08 00:45:44", "2026-01-08 00:45:44", "163733", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59271", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 01:11:05", "2026-01-08 01:11:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767834665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767834665;}", "9", "1", "2026-01-08 01:11:05", "2026-01-08 01:11:05", "163736", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59272", "woocommerce_cleanup_draft_orders", "complete", "2026-01-09 01:27:46", "2026-01-09 01:27:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767922066;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767922066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-09 01:53:27", "2026-01-09 01:53:27", "163943", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59273", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 01:27:46", "2026-01-08 01:27:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767835666;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767835666;}", "9", "1", "2026-01-08 01:27:56", "2026-01-08 01:27:56", "163739", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59274", "wc_gla_cron_daily_notes", "complete", "2026-01-09 01:27:46", "2026-01-09 01:27:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767922066;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767922066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-09 01:53:27", "2026-01-09 01:53:27", "163943", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59275", "wc_facebook_regenerate_feed", "complete", "2026-01-09 01:27:56", "2026-01-09 01:27:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767922076;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767922076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-09 01:53:37", "2026-01-09 01:53:37", "163943", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59276", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 02:49:26", "2026-01-08 02:49:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767840566;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767840566;}", "13", "1", "2026-01-08 03:07:16", "2026-01-08 03:07:16", "163760", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59277", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 01:49:26", "2026-01-08 01:49:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767836966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767836966;}", "9", "1", "2026-01-08 02:06:24", "2026-01-08 02:06:24", "163743", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59278", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 01:49:26", "2026-01-08 01:49:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767836966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767836966;}", "9", "1", "2026-01-08 02:06:24", "2026-01-08 02:06:24", "163743", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59279", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 02:06:24", "2026-01-08 02:06:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767837984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767837984;}", "9", "1", "2026-01-08 02:06:31", "2026-01-08 02:06:31", "163745", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59280", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 02:12:00", "2026-01-08 02:12:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767838320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767838320;}", "9", "1", "2026-01-08 02:12:17", "2026-01-08 02:12:17", "163748", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59281", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 02:17:16", "2026-01-08 02:17:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767838636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767838636;}", "9", "1", "2026-01-08 02:26:14", "2026-01-08 02:26:14", "163752", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59282", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 02:26:14", "2026-01-08 02:26:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767839174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767839174;}", "9", "1", "2026-01-08 02:26:22", "2026-01-08 02:26:22", "163754", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59283", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 02:29:46", "2026-01-08 02:29:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767839386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767839386;}", "9", "1", "2026-01-08 02:30:16", "2026-01-08 02:30:16", "163758", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59284", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 03:07:16", "2026-01-08 03:07:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767841636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767841636;}", "9", "1", "2026-01-08 03:07:17", "2026-01-08 03:07:17", "163760", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59285", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 04:07:16", "2026-01-08 04:07:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767845236;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767845236;}", "13", "1", "2026-01-08 06:03:50", "2026-01-08 06:03:50", "163769", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59286", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-09 03:00:00", "2026-01-09 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767927600;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1767927600;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-09 03:04:40", "2026-01-09 03:04:40", "163951", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59287", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 03:07:17", "2026-01-08 03:07:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767841637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767841637;}", "9", "1", "2026-01-08 03:18:07", "2026-01-08 03:18:07", "163762", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59288", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 03:18:07", "2026-01-08 03:18:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767842287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767842287;}", "9", "1", "2026-01-08 03:18:25", "2026-01-08 03:18:25", "163764", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59289", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 03:46:59", "2026-01-08 03:46:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767844019;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767844019;}", "9", "1", "2026-01-08 03:46:59", "2026-01-08 03:46:59", "163767", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59290", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 03:46:59", "2026-01-08 03:46:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767844019;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767844019;}", "9", "1", "2026-01-08 06:03:50", "2026-01-08 06:03:50", "163769", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59291", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 07:03:50", "2026-01-08 07:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767855830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767855830;}", "13", "1", "2026-01-08 07:12:04", "2026-01-08 07:12:04", "163775", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59293", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 06:03:50", "2026-01-08 06:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767852230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767852230;}", "9", "1", "2026-01-08 06:04:02", "2026-01-08 06:04:02", "163771", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59294", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 06:03:50", "2026-01-08 06:03:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767852230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767852230;}", "9", "1", "2026-01-08 06:04:02", "2026-01-08 06:04:02", "163771", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59295", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 07:01:23", "2026-01-08 07:01:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767855683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767855683;}", "9", "1", "2026-01-08 07:12:03", "2026-01-08 07:12:03", "163775", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59296", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 07:01:23", "2026-01-08 07:01:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767855683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767855683;}", "9", "1", "2026-01-08 07:12:04", "2026-01-08 07:12:04", "163775", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59297", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-08 07:01:23", "2026-01-08 07:01:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767855683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767855683;}", "9", "1", "2026-01-08 07:12:04", "2026-01-08 07:12:04", "163775", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59298", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 08:12:04", "2026-01-08 08:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767859924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767859924;}", "13", "1", "2026-01-08 08:22:23", "2026-01-08 08:22:23", "163779", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59299", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 07:12:04", "2026-01-08 07:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767856324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767856324;}", "9", "1", "2026-01-08 08:09:53", "2026-01-08 08:09:53", "163777", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59300", "woocommerce_refresh_order_count_cache", "complete", "2026-01-08 20:09:53", "2026-01-08 20:09:53", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767902993;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767902993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-08 20:35:44", "2026-01-08 20:35:44", "163849", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59301", "wpo_ips_semaphore_lock_cleanup", "pending", "2026-02-07 08:09:53", "2026-02-07 08:09:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770451793;s:18:\"\0*\0first_timestamp\";i:1728973198;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770451793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59302", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 08:09:53", "2026-01-08 08:09:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767859793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767859793;}", "9", "1", "2026-01-08 08:22:23", "2026-01-08 08:22:23", "163779", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59303", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 08:09:53", "2026-01-08 08:09:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767859793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767859793;}", "9", "1", "2026-01-08 08:22:23", "2026-01-08 08:22:23", "163779", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59304", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 09:22:23", "2026-01-08 09:22:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767864143;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767864143;}", "13", "1", "2026-01-08 09:40:33", "2026-01-08 09:40:33", "163784", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59305", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 08:22:23", "2026-01-08 08:22:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767860543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767860543;}", "9", "1", "2026-01-08 08:22:24", "2026-01-08 08:22:24", "163782", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59306", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 10:40:33", "2026-01-08 10:40:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767868833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767868833;}", "13", "1", "2026-01-08 11:37:50", "2026-01-08 11:37:50", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59307", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 09:40:33", "2026-01-08 09:40:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767865233;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767865233;}", "9", "1", "2026-01-08 09:41:40", "2026-01-08 09:41:40", "163786", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59308", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-08 09:40:33", "2026-01-08 09:40:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767865233;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767865233;}", "9", "1", "2026-01-08 09:41:41", "2026-01-08 09:41:41", "163786", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59309", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 09:40:33", "2026-01-08 09:40:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767865233;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767865233;}", "9", "1", "2026-01-08 09:41:41", "2026-01-08 09:41:41", "163786", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59310", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 09:47:57", "2026-01-08 09:47:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767865677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767865677;}", "9", "1", "2026-01-08 09:49:27", "2026-01-08 09:49:27", "163789", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59311", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 09:49:27", "2026-01-08 09:49:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767865767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767865767;}", "9", "1", "2026-01-08 09:56:38", "2026-01-08 09:56:38", "163791", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59312", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 09:56:39", "2026-01-08 09:56:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767866199;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767866199;}", "9", "1", "2026-01-08 09:57:46", "2026-01-08 09:57:46", "163793", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59313", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 10:20:43", "2026-01-08 10:20:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767867643;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767867643;}", "9", "1", "2026-01-08 10:20:48", "2026-01-08 10:20:48", "163796", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59314", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 10:26:24", "2026-01-08 10:26:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767867984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767867984;}", "9", "1", "2026-01-08 11:37:48", "2026-01-08 11:37:48", "163799", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59315", "wc_admin_daily_wrapper", "complete", "2026-01-09 11:37:48", "2026-01-09 11:37:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958668;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-09 11:41:09", "2026-01-09 11:41:09", "164003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59316", "woocommerce_cleanup_personal_data", "complete", "2026-01-09 11:37:49", "2026-01-09 11:37:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958669;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-09 11:41:10", "2026-01-09 11:41:10", "164003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59317", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-09 11:37:49", "2026-01-09 11:37:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958669;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-09 11:41:10", "2026-01-09 11:41:10", "164003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59318", "woocommerce_cleanup_logs", "complete", "2026-01-09 11:37:49", "2026-01-09 11:37:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958669;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-09 11:41:10", "2026-01-09 11:41:10", "164003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59319", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-09 11:37:49", "2026-01-09 11:37:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958669;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-09 11:41:10", "2026-01-09 11:41:10", "164003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59320", "fetch_patterns", "complete", "2026-01-09 11:37:50", "2026-01-09 11:37:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958670;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958670;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-09 11:41:11", "2026-01-09 11:41:11", "164003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59321", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 12:37:50", "2026-01-08 12:37:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767875870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767875870;}", "13", "1", "2026-01-08 12:54:36", "2026-01-08 12:54:36", "163811", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59322", "woocommerce_geoip_updater", "complete", "2026-01-23 11:37:50", "2026-01-23 11:37:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769168270;s:18:\"\0*\0first_timestamp\";i:1756196768;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769168270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "13", "1", "2026-01-23 11:45:42", "2026-01-23 11:45:42", "166422", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59323", "woocommerce_cleanup_sessions", "complete", "2026-01-09 06:00:00", "2026-01-09 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767938400;s:18:\"\0*\0first_timestamp\";i:1767938400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767938400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-09 06:04:28", "2026-01-09 06:04:28", "163963", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59324", "generate_category_lookup_table_wrapper", "complete", "2026-01-08 11:38:00", "2026-01-08 11:38:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767872280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767872280;}", "13", "1", "2026-01-08 11:54:43", "2026-01-08 11:54:43", "163801", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59325", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-09 11:37:50", "2026-01-09 11:37:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958670;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958670;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-09 11:41:11", "2026-01-09 11:41:11", "164003", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59326", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 11:37:50", "2026-01-08 11:37:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767872270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767872270;}", "9", "1", "2026-01-08 11:54:43", "2026-01-08 11:54:43", "163801", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59327", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 11:37:50", "2026-01-08 11:37:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767872270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767872270;}", "9", "1", "2026-01-08 11:54:43", "2026-01-08 11:54:43", "163801", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59328", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 11:54:43", "2026-01-08 11:54:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767873283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767873283;}", "9", "1", "2026-01-08 11:54:47", "2026-01-08 11:54:47", "163803", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59329", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 12:01:16", "2026-01-08 12:01:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767873676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767873676;}", "9", "1", "2026-01-08 12:01:27", "2026-01-08 12:01:27", "163806", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59330", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 12:25:21", "2026-01-08 12:25:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767875121;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767875121;}", "9", "1", "2026-01-08 12:25:21", "2026-01-08 12:25:21", "163809", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59331", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 13:54:36", "2026-01-08 13:54:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767880476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767880476;}", "13", "1", "2026-01-08 14:00:37", "2026-01-08 14:00:37", "163813", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59332", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 12:54:36", "2026-01-08 12:54:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767876876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767876876;}", "9", "1", "2026-01-08 14:00:37", "2026-01-08 14:00:37", "163813", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59333", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 12:54:36", "2026-01-08 12:54:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767876876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767876876;}", "9", "1", "2026-01-08 14:00:37", "2026-01-08 14:00:37", "163813", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59334", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 15:00:37", "2026-01-08 15:00:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767884437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767884437;}", "13", "1", "2026-01-08 15:12:32", "2026-01-08 15:12:32", "163820", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59335", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 14:00:37", "2026-01-08 14:00:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767880837;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767880837;}", "9", "1", "2026-01-08 14:00:46", "2026-01-08 14:00:46", "163815", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59336", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 14:00:37", "2026-01-08 14:00:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767880837;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767880837;}", "9", "1", "2026-01-08 14:00:46", "2026-01-08 14:00:46", "163815", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59337", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 14:49:51", "2026-01-08 14:49:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767883791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767883791;}", "9", "1", "2026-01-08 14:51:38", "2026-01-08 14:51:38", "163818", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59338", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 14:49:52", "2026-01-08 14:49:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767883792;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767883792;}", "9", "1", "2026-01-08 14:51:38", "2026-01-08 14:51:38", "163818", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59339", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 16:12:32", "2026-01-08 16:12:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767888752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767888752;}", "13", "1", "2026-01-08 16:29:29", "2026-01-08 16:29:29", "163824", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59340", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 15:12:32", "2026-01-08 15:12:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767885152;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767885152;}", "9", "1", "2026-01-08 15:12:33", "2026-01-08 15:12:33", "163822", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59341", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 17:29:29", "2026-01-08 17:29:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767893369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767893369;}", "13", "1", "2026-01-08 17:39:05", "2026-01-08 17:39:05", "163835", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59342", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 16:29:29", "2026-01-08 16:29:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767889769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767889769;}", "9", "1", "2026-01-08 16:30:33", "2026-01-08 16:30:33", "163826", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59343", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 16:29:29", "2026-01-08 16:29:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767889769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767889769;}", "9", "1", "2026-01-08 16:30:33", "2026-01-08 16:30:33", "163826", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59344", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 17:13:52", "2026-01-08 17:13:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767892432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767892432;}", "9", "1", "2026-01-08 17:13:52", "2026-01-08 17:13:52", "163828", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59345", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 17:13:52", "2026-01-08 17:13:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767892432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767892432;}", "9", "1", "2026-01-08 17:26:44", "2026-01-08 17:26:44", "163830", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59346", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 17:26:44", "2026-01-08 17:26:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767893204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767893204;}", "9", "1", "2026-01-08 17:26:49", "2026-01-08 17:26:49", "163833", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59347", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 18:39:05", "2026-01-08 18:39:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767897545;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767897545;}", "13", "1", "2026-01-08 20:04:13", "2026-01-08 20:04:13", "163845", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59348", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 17:39:05", "2026-01-08 17:39:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767893945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767893945;}", "9", "1", "2026-01-08 18:24:14", "2026-01-08 18:24:14", "163837", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59349", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 17:39:05", "2026-01-08 17:39:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767893945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767893945;}", "9", "1", "2026-01-08 18:24:14", "2026-01-08 18:24:14", "163837", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59350", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 18:24:14", "2026-01-08 18:24:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767896654;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767896654;}", "9", "1", "2026-01-08 18:24:20", "2026-01-08 18:24:20", "163839", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59351", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 18:29:51", "2026-01-08 18:29:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767896991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767896991;}", "9", "1", "2026-01-08 18:29:51", "2026-01-08 18:29:51", "163843", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59352", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 21:04:13", "2026-01-08 21:04:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767906253;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767906253;}", "13", "1", "2026-01-08 21:25:37", "2026-01-08 21:25:37", "163859", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59353", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 20:04:13", "2026-01-08 20:04:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767902653;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767902653;}", "9", "1", "2026-01-08 20:04:17", "2026-01-08 20:04:17", "163847", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59354", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 20:04:13", "2026-01-08 20:04:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767902653;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767902653;}", "9", "1", "2026-01-08 20:04:17", "2026-01-08 20:04:17", "163847", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59355", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-08 20:04:13", "2026-01-08 20:04:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767902653;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767902653;}", "9", "1", "2026-01-08 20:04:17", "2026-01-08 20:04:17", "163847", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59356", "woocommerce_refresh_order_count_cache", "complete", "2026-01-09 08:35:44", "2026-01-09 08:35:44", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767947744;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767947744;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-09 08:41:38", "2026-01-09 08:41:38", "163978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59357", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 20:35:44", "2026-01-08 20:35:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767904544;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767904544;}", "9", "1", "2026-01-08 20:43:17", "2026-01-08 20:43:17", "163854", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59358", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 20:35:46", "2026-01-08 20:35:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767904546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767904546;}", "9", "1", "2026-01-08 20:43:17", "2026-01-08 20:43:17", "163854", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59359", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 20:43:17", "2026-01-08 20:43:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767904997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767904997;}", "9", "1", "2026-01-08 21:03:36", "2026-01-08 21:03:36", "163856", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59360", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:03:36", "2026-01-08 21:03:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767906216;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767906216;}", "9", "1", "2026-01-08 21:03:36", "2026-01-08 21:03:36", "163856", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59361", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:25:37", "2026-01-08 21:25:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767907537;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767907537;}", "9", "1", "2026-01-08 21:25:37", "2026-01-08 21:25:37", "163859", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59362", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 22:25:37", "2026-01-08 22:25:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767911137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767911137;}", "13", "1", "2026-01-08 22:29:21", "2026-01-08 22:29:21", "163890", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59363", "woocommerce_scheduled_sales", "complete", "2026-01-09 21:25:37", "2026-01-09 21:25:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767993937;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767993937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-09 22:23:12", "2026-01-09 22:23:12", "164039", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59364", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:33:41", "2026-01-08 21:33:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767908021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767908021;}", "9", "1", "2026-01-08 21:34:28", "2026-01-08 21:34:28", "163862", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59365", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 21:33:41", "2026-01-08 21:33:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767908021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767908021;}", "9", "1", "2026-01-08 21:34:28", "2026-01-08 21:34:28", "163862", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59366", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:33:57", "2026-01-08 21:33:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767908037;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767908037;}", "9", "1", "2026-01-08 21:34:28", "2026-01-08 21:34:28", "163862", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59367", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:38:58", "2026-01-08 21:38:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767908338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767908338;}", "9", "1", "2026-01-08 21:44:09", "2026-01-08 21:44:09", "163866", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59368", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:44:09", "2026-01-08 21:44:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767908649;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767908649;}", "9", "1", "2026-01-08 21:49:40", "2026-01-08 21:49:40", "163868", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59369", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:49:40", "2026-01-08 21:49:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767908980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767908980;}", "9", "1", "2026-01-08 21:53:22", "2026-01-08 21:53:22", "163870", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59370", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 21:55:55", "2026-01-08 21:55:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767909355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767909355;}", "9", "1", "2026-01-08 21:55:55", "2026-01-08 21:55:55", "163872", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59371", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:00:12", "2026-01-08 22:00:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767909612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767909612;}", "9", "1", "2026-01-08 22:00:48", "2026-01-08 22:00:48", "163876", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59372", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:05:07", "2026-01-08 22:05:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767909907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767909907;}", "9", "1", "2026-01-08 22:06:31", "2026-01-08 22:06:31", "163880", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59373", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:13:46", "2026-01-08 22:13:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767910426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767910426;}", "9", "1", "2026-01-08 22:15:23", "2026-01-08 22:15:23", "163883", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59374", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:14:03", "2026-01-08 22:14:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767910443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767910443;}", "9", "1", "2026-01-08 22:15:23", "2026-01-08 22:15:23", "163883", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59375", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:19:17", "2026-01-08 22:19:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767910757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767910757;}", "9", "1", "2026-01-08 22:20:21", "2026-01-08 22:20:21", "163887", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59376", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 23:29:21", "2026-01-08 23:29:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767914961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767914961;}", "13", "1", "2026-01-08 23:30:34", "2026-01-08 23:30:34", "163929", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59377", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:29:22", "2026-01-08 22:29:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767911362;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767911362;}", "9", "1", "2026-01-08 22:29:22", "2026-01-08 22:29:22", "163892", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59378", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 22:31:21", "2026-01-08 22:31:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767911481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767911481;}", "9", "1", "2026-01-08 22:32:25", "2026-01-08 22:32:25", "163895", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59379", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:37:51", "2026-01-08 22:37:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767911871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767911871;}", "9", "1", "2026-01-08 22:39:57", "2026-01-08 22:39:57", "163898", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59380", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:39:57", "2026-01-08 22:39:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767911997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767911997;}", "9", "1", "2026-01-08 22:42:18", "2026-01-08 22:42:18", "163900", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59381", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:44:45", "2026-01-08 22:44:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767912285;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767912285;}", "9", "1", "2026-01-08 22:47:01", "2026-01-08 22:47:01", "163903", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59382", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:50:50", "2026-01-08 22:50:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767912650;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767912650;}", "9", "1", "2026-01-08 22:52:12", "2026-01-08 22:52:12", "163906", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59383", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 22:54:42", "2026-01-08 22:54:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767912882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767912882;}", "9", "1", "2026-01-08 22:54:42", "2026-01-08 22:54:42", "163909", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59384", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:06:42", "2026-01-08 23:06:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767913602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767913602;}", "9", "1", "2026-01-08 23:09:52", "2026-01-08 23:09:52", "163914", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59385", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:09:52", "2026-01-08 23:09:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767913792;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767913792;}", "9", "1", "2026-01-08 23:13:47", "2026-01-08 23:13:47", "163916", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59386", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:14:15", "2026-01-08 23:14:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767914055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767914055;}", "9", "1", "2026-01-08 23:17:24", "2026-01-08 23:17:24", "163918", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59387", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:20:04", "2026-01-08 23:20:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767914404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767914404;}", "9", "1", "2026-01-08 23:21:39", "2026-01-08 23:21:39", "163921", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59388", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:25:09", "2026-01-08 23:25:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767914709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767914709;}", "9", "1", "2026-01-08 23:25:09", "2026-01-08 23:25:09", "163924", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59389", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:28:53", "2026-01-08 23:28:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767914933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767914933;}", "9", "1", "2026-01-08 23:30:34", "2026-01-08 23:30:34", "163929", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59390", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 00:30:34", "2026-01-09 00:30:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767918634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767918634;}", "13", "1", "2026-01-09 01:53:27", "2026-01-09 01:53:27", "163943", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59391", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-08 23:42:01", "2026-01-08 23:42:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767915721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767915721;}", "9", "1", "2026-01-08 23:42:02", "2026-01-08 23:42:02", "163931", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59392", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:42:02", "2026-01-08 23:42:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767915722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767915722;}", "9", "1", "2026-01-08 23:42:09", "2026-01-08 23:42:09", "163933", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59393", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-08 23:47:11", "2026-01-08 23:47:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767916031;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767916031;}", "9", "1", "2026-01-08 23:47:11", "2026-01-08 23:47:11", "163937", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59394", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 00:04:40", "2026-01-09 00:04:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767917080;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767917080;}", "9", "1", "2026-01-09 00:06:57", "2026-01-09 00:06:57", "163941", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59395", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 02:53:27", "2026-01-09 02:53:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767927207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767927207;}", "13", "1", "2026-01-09 03:04:40", "2026-01-09 03:04:40", "163951", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59396", "woocommerce_cleanup_draft_orders", "complete", "2026-01-10 01:53:27", "2026-01-10 01:53:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768010007;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768010007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-10 02:00:47", "2026-01-10 02:00:47", "164061", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59397", "wc_gla_cron_daily_notes", "complete", "2026-01-10 01:53:27", "2026-01-10 01:53:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768010007;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768010007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-10 02:00:47", "2026-01-10 02:00:47", "164061", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59398", "wc_facebook_regenerate_feed", "complete", "2026-01-10 01:53:37", "2026-01-10 01:53:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768010017;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768010017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-10 02:00:57", "2026-01-10 02:00:57", "164061", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59399", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 01:53:37", "2026-01-09 01:53:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767923617;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767923617;}", "9", "1", "2026-01-09 02:21:48", "2026-01-09 02:21:48", "163945", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59400", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 01:53:37", "2026-01-09 01:53:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767923617;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767923617;}", "9", "1", "2026-01-09 02:21:48", "2026-01-09 02:21:48", "163945", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59401", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 02:21:48", "2026-01-09 02:21:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767925308;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767925308;}", "9", "1", "2026-01-09 02:21:48", "2026-01-09 02:21:48", "163945", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59402", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 02:41:47", "2026-01-09 02:41:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767926507;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767926507;}", "9", "1", "2026-01-09 02:43:19", "2026-01-09 02:43:19", "163949", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59403", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 02:41:47", "2026-01-09 02:41:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767926507;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767926507;}", "9", "1", "2026-01-09 02:43:19", "2026-01-09 02:43:19", "163949", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59404", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 03:04:40", "2026-01-09 03:04:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767927880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767927880;}", "9", "1", "2026-01-09 03:04:40", "2026-01-09 03:04:40", "163951", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59405", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 04:04:40", "2026-01-09 04:04:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767931480;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767931480;}", "13", "1", "2026-01-09 05:13:45", "2026-01-09 05:13:45", "163957", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59406", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-10 03:00:00", "2026-01-10 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768014000;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1768014000;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-10 03:46:52", "2026-01-10 03:46:52", "164075", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59407", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 03:55:59", "2026-01-09 03:55:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767930959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767930959;}", "9", "1", "2026-01-09 03:57:30", "2026-01-09 03:57:30", "163955", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59408", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 03:55:59", "2026-01-09 03:55:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767930959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767930959;}", "9", "1", "2026-01-09 03:57:30", "2026-01-09 03:57:30", "163955", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59409", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 06:13:45", "2026-01-09 06:13:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767939225;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767939225;}", "13", "1", "2026-01-09 06:14:33", "2026-01-09 06:14:33", "163965", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59410", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 05:13:45", "2026-01-09 05:13:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767935625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767935625;}", "9", "1", "2026-01-09 05:55:36", "2026-01-09 05:55:36", "163959", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59411", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 05:13:45", "2026-01-09 05:13:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767935625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767935625;}", "9", "1", "2026-01-09 05:55:37", "2026-01-09 05:55:37", "163959", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59412", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 05:14:01", "2026-01-09 05:14:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767935641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767935641;}", "9", "1", "2026-01-09 05:55:37", "2026-01-09 05:55:37", "163959", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59413", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 05:55:37", "2026-01-09 05:55:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767938137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767938137;}", "9", "1", "2026-01-09 05:55:41", "2026-01-09 05:55:41", "163961", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59414", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 05:55:37", "2026-01-09 05:55:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767938137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767938137;}", "9", "1", "2026-01-09 05:55:41", "2026-01-09 05:55:41", "163961", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59416", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 06:04:28", "2026-01-09 06:04:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767938668;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767938668;}", "9", "1", "2026-01-09 06:14:33", "2026-01-09 06:14:33", "163965", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59417", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 07:14:33", "2026-01-09 07:14:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767942873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767942873;}", "13", "1", "2026-01-09 07:19:21", "2026-01-09 07:19:21", "163974", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59418", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 06:14:33", "2026-01-09 06:14:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767939273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767939273;}", "9", "1", "2026-01-09 06:14:34", "2026-01-09 06:14:34", "163967", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59419", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 06:24:24", "2026-01-09 06:24:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767939864;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767939864;}", "9", "1", "2026-01-09 06:54:54", "2026-01-09 06:54:54", "163970", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59420", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 06:54:54", "2026-01-09 06:54:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767941694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767941694;}", "9", "1", "2026-01-09 06:55:31", "2026-01-09 06:55:31", "163972", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59421", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 06:54:54", "2026-01-09 06:54:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767941694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767941694;}", "9", "1", "2026-01-09 06:55:31", "2026-01-09 06:55:31", "163972", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59422", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 08:19:21", "2026-01-09 08:19:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767946761;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767946761;}", "13", "1", "2026-01-09 08:41:38", "2026-01-09 08:41:38", "163978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59423", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 07:19:21", "2026-01-09 07:19:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767943161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767943161;}", "9", "1", "2026-01-09 07:56:13", "2026-01-09 07:56:13", "163976", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59424", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-09 07:19:21", "2026-01-09 07:19:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767943161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767943161;}", "9", "1", "2026-01-09 07:56:13", "2026-01-09 07:56:13", "163976", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59425", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 07:56:13", "2026-01-09 07:56:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767945373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767945373;}", "9", "1", "2026-01-09 08:41:38", "2026-01-09 08:41:38", "163978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59426", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 07:56:13", "2026-01-09 07:56:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767945373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767945373;}", "9", "1", "2026-01-09 08:41:38", "2026-01-09 08:41:38", "163978", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59427", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 09:41:38", "2026-01-09 09:41:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767951698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767951698;}", "13", "1", "2026-01-09 09:42:13", "2026-01-09 09:42:13", "163981", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59428", "woocommerce_refresh_order_count_cache", "complete", "2026-01-09 20:41:38", "2026-01-09 20:41:38", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767991298;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767991298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-09 22:23:12", "2026-01-09 22:23:12", "164039", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59429", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 08:41:38", "2026-01-09 08:41:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767948098;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767948098;}", "9", "1", "2026-01-09 09:40:17", "2026-01-09 09:40:17", "163980", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59430", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-09 08:41:39", "2026-01-09 08:41:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767948099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767948099;}", "9", "1", "2026-01-09 09:40:33", "2026-01-09 09:40:33", "163980", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59431", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 08:41:39", "2026-01-09 08:41:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767948099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767948099;}", "9", "1", "2026-01-09 09:42:13", "2026-01-09 09:42:13", "163981", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59432", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 09:40:32", "2026-01-09 09:40:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767951632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767951632;}", "9", "1", "2026-01-09 09:42:13", "2026-01-09 09:42:13", "163981", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59433", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 09:40:32", "2026-01-09 09:40:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767951632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767951632;}", "9", "1", "2026-01-09 09:42:13", "2026-01-09 09:42:13", "163981", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59434", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 10:42:13", "2026-01-09 10:42:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767955333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767955333;}", "13", "1", "2026-01-09 10:50:00", "2026-01-09 10:50:00", "164001", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59435", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 09:45:39", "2026-01-09 09:45:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767951939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767951939;}", "9", "1", "2026-01-09 09:46:42", "2026-01-09 09:46:42", "163984", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59436", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 09:49:05", "2026-01-09 09:49:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767952145;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767952145;}", "9", "1", "2026-01-09 09:49:54", "2026-01-09 09:49:54", "163988", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59437", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 09:54:31", "2026-01-09 09:54:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767952471;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767952471;}", "9", "1", "2026-01-09 09:59:46", "2026-01-09 09:59:46", "163992", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59438", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 09:59:46", "2026-01-09 09:59:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767952786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767952786;}", "9", "1", "2026-01-09 10:01:14", "2026-01-09 10:01:14", "163994", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59439", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 10:23:18", "2026-01-09 10:23:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767954198;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767954198;}", "9", "1", "2026-01-09 10:35:30", "2026-01-09 10:35:30", "163997", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59440", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 10:35:30", "2026-01-09 10:35:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767954930;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767954930;}", "9", "1", "2026-01-09 10:35:30", "2026-01-09 10:35:30", "163997", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59441", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 10:35:30", "2026-01-09 10:35:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767954930;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767954930;}", "9", "1", "2026-01-09 10:35:30", "2026-01-09 10:35:30", "163999", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59442", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 11:50:00", "2026-01-09 11:50:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767959400;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767959400;}", "13", "1", "2026-01-09 13:56:34", "2026-01-09 13:56:34", "164007", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59443", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 10:50:00", "2026-01-09 10:50:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767955800;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767955800;}", "9", "1", "2026-01-09 11:41:09", "2026-01-09 11:41:09", "164003", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59444", "wc_admin_daily_wrapper", "complete", "2026-01-10 11:41:09", "2026-01-10 11:41:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045269;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045269;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-10 12:28:19", "2026-01-10 12:28:19", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59445", "woocommerce_cleanup_personal_data", "complete", "2026-01-10 11:41:10", "2026-01-10 11:41:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045270;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59446", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-10 11:41:10", "2026-01-10 11:41:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045270;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59447", "woocommerce_cleanup_logs", "complete", "2026-01-10 11:41:10", "2026-01-10 11:41:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045270;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59448", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-10 11:41:10", "2026-01-10 11:41:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045270;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59449", "fetch_patterns", "complete", "2026-01-10 11:41:11", "2026-01-10 11:41:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045271;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59450", "woocommerce_cleanup_sessions", "complete", "2026-01-10 06:00:00", "2026-01-10 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768024800;s:18:\"\0*\0first_timestamp\";i:1768024800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768024800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-10 06:21:29", "2026-01-10 06:21:29", "164094", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59451", "generate_category_lookup_table_wrapper", "complete", "2026-01-09 11:41:21", "2026-01-09 11:41:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767958881;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767958881;}", "13", "1", "2026-01-09 11:41:26", "2026-01-09 11:41:26", "164005", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59452", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-10 11:41:11", "2026-01-10 11:41:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768045271;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768045271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "164120", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59453", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 11:41:11", "2026-01-09 11:41:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767958871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767958871;}", "9", "1", "2026-01-09 11:41:25", "2026-01-09 11:41:25", "164005", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59454", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 11:41:11", "2026-01-09 11:41:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767958871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767958871;}", "9", "1", "2026-01-09 11:41:25", "2026-01-09 11:41:25", "164005", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59455", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 14:56:34", "2026-01-09 14:56:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767970594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767970594;}", "13", "1", "2026-01-09 15:04:23", "2026-01-09 15:04:23", "164012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59456", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 13:56:34", "2026-01-09 13:56:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767966994;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767966994;}", "9", "1", "2026-01-09 13:56:42", "2026-01-09 13:56:42", "164009", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59457", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 13:56:35", "2026-01-09 13:56:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767966995;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767966995;}", "9", "1", "2026-01-09 13:56:42", "2026-01-09 13:56:42", "164009", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59458", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 14:06:52", "2026-01-09 14:06:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767967612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767967612;}", "9", "1", "2026-01-09 15:04:23", "2026-01-09 15:04:23", "164012", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59459", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 16:04:23", "2026-01-09 16:04:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767974663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767974663;}", "13", "1", "2026-01-09 16:31:49", "2026-01-09 16:31:49", "164023", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59460", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 15:04:23", "2026-01-09 15:04:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767971063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767971063;}", "9", "1", "2026-01-09 15:24:27", "2026-01-09 15:24:27", "164014", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59461", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 15:04:23", "2026-01-09 15:04:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767971063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767971063;}", "9", "1", "2026-01-09 15:24:27", "2026-01-09 15:24:27", "164014", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59462", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 15:24:27", "2026-01-09 15:24:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767972267;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767972267;}", "9", "1", "2026-01-09 15:37:34", "2026-01-09 15:37:34", "164016", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59463", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 15:37:34", "2026-01-09 15:37:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767973054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767973054;}", "9", "1", "2026-01-09 15:40:07", "2026-01-09 15:40:07", "164018", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59464", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 15:37:34", "2026-01-09 15:37:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767973054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767973054;}", "9", "1", "2026-01-09 15:40:07", "2026-01-09 15:40:07", "164018", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59465", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 15:40:07", "2026-01-09 15:40:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767973207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767973207;}", "9", "1", "2026-01-09 15:40:51", "2026-01-09 15:40:51", "164020", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59466", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 15:50:12", "2026-01-09 15:50:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767973812;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767973812;}", "9", "1", "2026-01-09 16:31:49", "2026-01-09 16:31:49", "164023", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59467", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 17:31:49", "2026-01-09 17:31:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767979909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767979909;}", "13", "1", "2026-01-09 19:28:47", "2026-01-09 19:28:47", "164033", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59468", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 16:31:49", "2026-01-09 16:31:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767976309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767976309;}", "9", "1", "2026-01-09 16:31:57", "2026-01-09 16:31:57", "164025", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59469", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 16:31:49", "2026-01-09 16:31:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767976309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767976309;}", "9", "1", "2026-01-09 16:31:57", "2026-01-09 16:31:57", "164025", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59470", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 16:33:51", "2026-01-09 16:33:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767976431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767976431;}", "9", "1", "2026-01-09 17:30:14", "2026-01-09 17:30:14", "164029", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59471", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 17:30:14", "2026-01-09 17:30:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767979814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767979814;}", "9", "1", "2026-01-09 17:30:17", "2026-01-09 17:30:17", "164031", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59472", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 19:28:47", "2026-01-09 19:28:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767986927;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767986927;}", "9", "1", "2026-01-09 19:28:48", "2026-01-09 19:28:48", "164033", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59473", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 20:28:47", "2026-01-09 20:28:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767990527;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767990527;}", "13", "1", "2026-01-09 22:23:12", "2026-01-09 22:23:12", "164039", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59474", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 19:28:48", "2026-01-09 19:28:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767986928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767986928;}", "9", "1", "2026-01-09 19:28:48", "2026-01-09 19:28:48", "164035", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59475", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-09 19:28:50", "2026-01-09 19:28:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767986930;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767986930;}", "9", "1", "2026-01-09 19:28:54", "2026-01-09 19:28:54", "164037", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59476", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 19:28:53", "2026-01-09 19:28:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767986933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767986933;}", "9", "1", "2026-01-09 19:28:54", "2026-01-09 19:28:54", "164037", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59477", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 23:23:12", "2026-01-09 23:23:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768000992;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768000992;}", "13", "1", "2026-01-10 00:06:19", "2026-01-10 00:06:19", "164050", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59478", "woocommerce_refresh_order_count_cache", "complete", "2026-01-10 10:23:12", "2026-01-10 10:23:12", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768040592;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768040592;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-10 12:28:19", "2026-01-10 12:28:19", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59479", "woocommerce_scheduled_sales", "complete", "2026-01-10 22:23:12", "2026-01-10 22:23:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768083792;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768083792;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-10 22:26:39", "2026-01-10 22:26:39", "164159", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59480", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 22:23:12", "2026-01-09 22:23:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767997392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767997392;}", "9", "1", "2026-01-09 22:23:13", "2026-01-09 22:23:13", "164041", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59481", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 22:23:12", "2026-01-09 22:23:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767997392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767997392;}", "9", "1", "2026-01-09 22:23:13", "2026-01-09 22:23:13", "164041", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59482", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 22:39:47", "2026-01-09 22:39:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767998387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767998387;}", "9", "1", "2026-01-09 22:39:47", "2026-01-09 22:39:47", "164044", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59483", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 22:39:47", "2026-01-09 22:39:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767998387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767998387;}", "9", "1", "2026-01-09 22:39:47", "2026-01-09 22:39:47", "164044", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59484", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-09 22:39:47", "2026-01-09 22:39:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767998387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767998387;}", "9", "1", "2026-01-09 22:58:25", "2026-01-09 22:58:25", "164046", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59485", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-09 22:58:25", "2026-01-09 22:58:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767999505;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767999505;}", "9", "1", "2026-01-09 22:58:28", "2026-01-09 22:58:28", "164048", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59486", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 00:06:18", "2026-01-10 00:06:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768003578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768003578;}", "9", "1", "2026-01-10 00:06:19", "2026-01-10 00:06:19", "164050", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59487", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 00:06:19", "2026-01-10 00:06:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768003579;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768003579;}", "9", "1", "2026-01-10 00:06:19", "2026-01-10 00:06:19", "164050", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59488", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 01:06:19", "2026-01-10 01:06:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768007179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768007179;}", "13", "1", "2026-01-10 01:07:40", "2026-01-10 01:07:40", "164057", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59489", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 00:06:19", "2026-01-10 00:06:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768003579;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768003579;}", "9", "1", "2026-01-10 00:06:23", "2026-01-10 00:06:23", "164052", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59490", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 00:59:08", "2026-01-10 00:59:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768006748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768006748;}", "9", "1", "2026-01-10 00:59:24", "2026-01-10 00:59:24", "164055", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59491", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 00:59:08", "2026-01-10 00:59:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768006748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768006748;}", "9", "1", "2026-01-10 00:59:24", "2026-01-10 00:59:24", "164055", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59492", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 02:07:40", "2026-01-10 02:07:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768010860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768010860;}", "13", "1", "2026-01-10 02:27:59", "2026-01-10 02:27:59", "164065", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59493", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 01:07:41", "2026-01-10 01:07:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768007261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768007261;}", "9", "1", "2026-01-10 01:07:41", "2026-01-10 01:07:41", "164059", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59494", "woocommerce_cleanup_draft_orders", "complete", "2026-01-11 02:00:47", "2026-01-11 02:00:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768096847;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768096847;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-11 02:23:14", "2026-01-11 02:23:14", "164190", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59495", "wc_gla_cron_daily_notes", "complete", "2026-01-11 02:00:47", "2026-01-11 02:00:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768096847;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768096847;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-11 02:23:14", "2026-01-11 02:23:14", "164190", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59496", "wc_facebook_regenerate_feed", "complete", "2026-01-11 02:00:57", "2026-01-11 02:00:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768096857;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768096857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-11 02:23:24", "2026-01-11 02:23:24", "164190", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59497", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 02:00:57", "2026-01-10 02:00:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768010457;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768010457;}", "9", "1", "2026-01-10 02:01:02", "2026-01-10 02:01:02", "164063", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59498", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 02:00:57", "2026-01-10 02:00:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768010457;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768010457;}", "9", "1", "2026-01-10 02:01:02", "2026-01-10 02:01:02", "164063", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59499", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 03:27:59", "2026-01-10 03:27:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768015679;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768015679;}", "13", "1", "2026-01-10 03:46:52", "2026-01-10 03:46:52", "164075", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59500", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 02:27:59", "2026-01-10 02:27:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768012079;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768012079;}", "9", "1", "2026-01-10 02:28:17", "2026-01-10 02:28:17", "164067", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59501", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 02:29:09", "2026-01-10 02:29:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768012149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768012149;}", "9", "1", "2026-01-10 02:29:26", "2026-01-10 02:29:26", "164069", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59502", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 02:49:47", "2026-01-10 02:49:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768013387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768013387;}", "9", "1", "2026-01-10 02:49:51", "2026-01-10 02:49:51", "164073", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59503", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 02:49:47", "2026-01-10 02:49:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768013387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768013387;}", "9", "1", "2026-01-10 02:49:51", "2026-01-10 02:49:51", "164073", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59504", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-11 03:00:00", "2026-01-11 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768100400;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1768100400;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-11 03:04:59", "2026-01-11 03:04:59", "164196", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59505", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 04:46:52", "2026-01-10 04:46:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768020412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768020412;}", "13", "1", "2026-01-10 05:56:04", "2026-01-10 05:56:04", "164084", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59506", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 03:46:52", "2026-01-10 03:46:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768016812;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768016812;}", "9", "1", "2026-01-10 04:02:12", "2026-01-10 04:02:12", "164077", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59507", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 03:46:52", "2026-01-10 03:46:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768016812;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768016812;}", "9", "1", "2026-01-10 04:02:12", "2026-01-10 04:02:12", "164077", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59508", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 04:02:12", "2026-01-10 04:02:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768017732;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768017732;}", "9", "1", "2026-01-10 04:02:49", "2026-01-10 04:02:49", "164079", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59509", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 04:43:10", "2026-01-10 04:43:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768020190;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768020190;}", "9", "1", "2026-01-10 04:43:24", "2026-01-10 04:43:24", "164082", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59510", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 04:43:10", "2026-01-10 04:43:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768020190;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768020190;}", "9", "1", "2026-01-10 04:43:24", "2026-01-10 04:43:24", "164082", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59511", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 06:56:04", "2026-01-10 06:56:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768028164;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768028164;}", "13", "1", "2026-01-10 06:58:47", "2026-01-10 06:58:47", "164098", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59512", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 05:56:05", "2026-01-10 05:56:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768024565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768024565;}", "9", "1", "2026-01-10 05:56:05", "2026-01-10 05:56:05", "164086", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59513", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 05:56:05", "2026-01-10 05:56:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768024565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768024565;}", "9", "1", "2026-01-10 05:56:10", "2026-01-10 05:56:10", "164088", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59514", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 05:58:51", "2026-01-10 05:58:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768024731;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768024731;}", "9", "1", "2026-01-10 05:58:59", "2026-01-10 05:58:59", "164092", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59516", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 06:21:31", "2026-01-10 06:21:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768026091;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768026091;}", "9", "1", "2026-01-10 06:34:38", "2026-01-10 06:34:38", "164096", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59517", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 06:34:38", "2026-01-10 06:34:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768026878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768026878;}", "9", "1", "2026-01-10 06:58:47", "2026-01-10 06:58:47", "164098", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59518", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 06:34:38", "2026-01-10 06:34:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768026878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768026878;}", "9", "1", "2026-01-10 06:58:47", "2026-01-10 06:58:47", "164098", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59519", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 07:58:47", "2026-01-10 07:58:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768031927;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768031927;}", "13", "1", "2026-01-10 08:49:51", "2026-01-10 08:49:51", "164102", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59520", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 06:58:47", "2026-01-10 06:58:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768028327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768028327;}", "9", "1", "2026-01-10 07:04:03", "2026-01-10 07:04:03", "164100", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59521", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 07:04:02", "2026-01-10 07:04:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768028642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768028642;}", "9", "1", "2026-01-10 07:04:03", "2026-01-10 07:04:03", "164100", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59522", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-10 07:04:02", "2026-01-10 07:04:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768028642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768028642;}", "9", "1", "2026-01-10 07:04:03", "2026-01-10 07:04:03", "164100", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59523", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 09:49:51", "2026-01-10 09:49:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768038591;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768038591;}", "13", "1", "2026-01-10 09:52:03", "2026-01-10 09:52:03", "164106", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59524", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 08:49:51", "2026-01-10 08:49:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768034991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768034991;}", "9", "1", "2026-01-10 09:35:41", "2026-01-10 09:35:41", "164104", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59525", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 08:49:51", "2026-01-10 08:49:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768034991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768034991;}", "9", "1", "2026-01-10 09:35:41", "2026-01-10 09:35:41", "164104", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59526", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-10 08:49:52", "2026-01-10 08:49:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768034992;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768034992;}", "9", "1", "2026-01-10 09:35:41", "2026-01-10 09:35:41", "164104", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59527", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 09:35:41", "2026-01-10 09:35:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768037741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768037741;}", "9", "1", "2026-01-10 09:52:03", "2026-01-10 09:52:03", "164106", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59528", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 09:35:41", "2026-01-10 09:35:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768037741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768037741;}", "9", "1", "2026-01-10 09:52:03", "2026-01-10 09:52:03", "164106", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59529", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 10:52:03", "2026-01-10 10:52:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768042323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768042323;}", "13", "1", "2026-01-10 12:28:19", "2026-01-10 12:28:19", "164120", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59530", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 09:52:03", "2026-01-10 09:52:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768038723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768038723;}", "9", "1", "2026-01-10 09:52:22", "2026-01-10 09:52:22", "164108", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59531", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 10:03:16", "2026-01-10 10:03:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768039396;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768039396;}", "9", "1", "2026-01-10 10:05:54", "2026-01-10 10:05:54", "164111", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59532", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 10:05:54", "2026-01-10 10:05:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768039554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768039554;}", "9", "1", "2026-01-10 10:05:54", "2026-01-10 10:05:54", "164111", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59533", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 10:19:59", "2026-01-10 10:19:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768040399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768040399;}", "9", "1", "2026-01-10 10:20:38", "2026-01-10 10:20:38", "164116", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59534", "woocommerce_refresh_order_count_cache", "complete", "2026-01-11 00:28:19", "2026-01-11 00:28:19", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768091299;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768091299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-11 00:35:37", "2026-01-11 00:35:37", "164182", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59535", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 13:28:19", "2026-01-10 13:28:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768051699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768051699;}", "13", "1", "2026-01-10 15:12:04", "2026-01-10 15:12:04", "164130", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59536", "wc_admin_daily_wrapper", "complete", "2026-01-11 12:28:19", "2026-01-11 12:28:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134499;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-11 13:18:50", "2026-01-11 13:18:50", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59537", "woocommerce_cleanup_personal_data", "complete", "2026-01-11 12:28:20", "2026-01-11 12:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134500;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-11 13:18:51", "2026-01-11 13:18:51", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59538", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-11 12:28:20", "2026-01-11 12:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134500;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-11 13:18:51", "2026-01-11 13:18:51", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59539", "woocommerce_cleanup_logs", "complete", "2026-01-11 12:28:20", "2026-01-11 12:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134500;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-11 13:18:51", "2026-01-11 13:18:51", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59540", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-11 12:28:20", "2026-01-11 12:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134500;s:18:\"\0*\0first_timestamp\";i:1756207508;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-11 13:18:51", "2026-01-11 13:18:51", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59541", "fetch_patterns", "complete", "2026-01-11 12:28:20", "2026-01-11 12:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134500;s:18:\"\0*\0first_timestamp\";i:1765851691;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-11 13:18:51", "2026-01-11 13:18:51", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59542", "woocommerce_cleanup_sessions", "complete", "2026-01-11 06:00:00", "2026-01-11 06:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768111200;s:18:\"\0*\0first_timestamp\";i:1768111200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768111200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "13", "1", "2026-01-11 06:16:40", "2026-01-11 06:16:40", "164222", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59543", "generate_category_lookup_table_wrapper", "complete", "2026-01-10 12:28:30", "2026-01-10 12:28:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768048110;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768048110;}", "13", "1", "2026-01-10 13:08:10", "2026-01-10 13:08:10", "164122", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59544", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-11 12:28:20", "2026-01-11 12:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134500;s:18:\"\0*\0first_timestamp\";i:1755502212;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-11 13:18:51", "2026-01-11 13:18:51", "164259", NULL, "20");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59545", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768048100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768048100;}", "9", "1", "2026-01-10 13:08:10", "2026-01-10 13:08:10", "164122", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59546", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 12:28:20", "2026-01-10 12:28:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768048100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768048100;}", "9", "1", "2026-01-10 13:08:10", "2026-01-10 13:08:10", "164122", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59547", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 13:08:10", "2026-01-10 13:08:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768050490;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768050490;}", "9", "1", "2026-01-10 13:08:10", "2026-01-10 13:08:10", "164122", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59548", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 13:08:11", "2026-01-10 13:08:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768050491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768050491;}", "9", "1", "2026-01-10 13:08:16", "2026-01-10 13:08:16", "164124", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59549", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 13:12:30", "2026-01-10 13:12:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768050750;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768050750;}", "9", "1", "2026-01-10 13:12:30", "2026-01-10 13:12:30", "164127", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59550", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 13:22:32", "2026-01-10 13:22:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768051352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768051352;}", "9", "1", "2026-01-10 15:12:04", "2026-01-10 15:12:04", "164130", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59551", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 16:12:04", "2026-01-10 16:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768061524;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768061524;}", "13", "1", "2026-01-10 16:31:14", "2026-01-10 16:31:14", "164134", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59552", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 15:12:04", "2026-01-10 15:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768057924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768057924;}", "9", "1", "2026-01-10 15:12:08", "2026-01-10 15:12:08", "164132", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59553", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 15:12:04", "2026-01-10 15:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768057924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768057924;}", "9", "1", "2026-01-10 15:12:08", "2026-01-10 15:12:08", "164132", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59554", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 17:31:14", "2026-01-10 17:31:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768066274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768066274;}", "13", "1", "2026-01-10 17:36:45", "2026-01-10 17:36:45", "164143", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59555", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 16:31:14", "2026-01-10 16:31:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768062674;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768062674;}", "9", "1", "2026-01-10 16:31:30", "2026-01-10 16:31:30", "164136", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59556", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 16:31:14", "2026-01-10 16:31:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768062674;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768062674;}", "9", "1", "2026-01-10 16:31:30", "2026-01-10 16:31:30", "164136", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59557", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 16:46:14", "2026-01-10 16:46:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768063574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768063574;}", "9", "1", "2026-01-10 16:46:22", "2026-01-10 16:46:22", "164139", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59558", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 17:03:24", "2026-01-10 17:03:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768064604;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768064604;}", "9", "1", "2026-01-10 17:36:45", "2026-01-10 17:36:45", "164143", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59559", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 17:36:45", "2026-01-10 17:36:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768066605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768066605;}", "9", "1", "2026-01-10 17:36:45", "2026-01-10 17:36:45", "164143", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59560", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 18:36:45", "2026-01-10 18:36:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768070205;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768070205;}", "13", "1", "2026-01-10 18:58:34", "2026-01-10 18:58:34", "164148", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59561", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 17:36:45", "2026-01-10 17:36:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768066605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768066605;}", "9", "1", "2026-01-10 17:36:56", "2026-01-10 17:36:56", "164145", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59562", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 18:16:52", "2026-01-10 18:16:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768069012;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768069012;}", "9", "1", "2026-01-10 18:58:34", "2026-01-10 18:58:34", "164148", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59563", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 19:58:34", "2026-01-10 19:58:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768075114;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768075114;}", "13", "1", "2026-01-10 21:13:33", "2026-01-10 21:13:33", "164155", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59564", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 18:58:34", "2026-01-10 18:58:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768071514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768071514;}", "9", "1", "2026-01-10 19:06:53", "2026-01-10 19:06:53", "164150", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59565", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 18:58:34", "2026-01-10 18:58:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768071514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768071514;}", "9", "1", "2026-01-10 19:06:53", "2026-01-10 19:06:53", "164150", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59566", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 18:59:04", "2026-01-10 18:59:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768071544;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768071544;}", "9", "1", "2026-01-10 19:06:53", "2026-01-10 19:06:53", "164150", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59567", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-10 19:06:53", "2026-01-10 19:06:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768072013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768072013;}", "9", "1", "2026-01-10 19:06:53", "2026-01-10 19:06:53", "164150", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59568", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 19:06:53", "2026-01-10 19:06:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768072013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768072013;}", "9", "1", "2026-01-10 19:07:18", "2026-01-10 19:07:18", "164152", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59569", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 19:09:14", "2026-01-10 19:09:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768072154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768072154;}", "9", "1", "2026-01-10 21:13:33", "2026-01-10 21:13:33", "164155", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59570", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 22:13:33", "2026-01-10 22:13:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768083213;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768083213;}", "13", "1", "2026-01-10 22:26:39", "2026-01-10 22:26:39", "164159", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59571", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 21:13:33", "2026-01-10 21:13:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768079613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768079613;}", "9", "1", "2026-01-10 22:00:21", "2026-01-10 22:00:21", "164157", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59572", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 21:13:33", "2026-01-10 21:13:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768079613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768079613;}", "9", "1", "2026-01-10 22:00:21", "2026-01-10 22:00:21", "164157", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59573", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 22:00:21", "2026-01-10 22:00:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768082421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768082421;}", "9", "1", "2026-01-10 22:00:21", "2026-01-10 22:00:21", "164157", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59574", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 22:00:21", "2026-01-10 22:00:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768082421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768082421;}", "9", "1", "2026-01-10 22:26:39", "2026-01-10 22:26:39", "164159", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59575", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 23:26:39", "2026-01-10 23:26:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768087599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768087599;}", "13", "1", "2026-01-10 23:27:17", "2026-01-10 23:27:17", "164175", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59576", "woocommerce_scheduled_sales", "complete", "2026-01-11 22:26:39", "2026-01-11 22:26:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768170399;s:18:\"\0*\0first_timestamp\";i:1756252800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768170399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-11 22:40:43", "2026-01-11 22:40:43", "164292", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59577", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 22:26:39", "2026-01-10 22:26:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768083999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768083999;}", "9", "1", "2026-01-10 22:26:47", "2026-01-10 22:26:47", "164161", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59578", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 22:35:32", "2026-01-10 22:35:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768084532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768084532;}", "9", "1", "2026-01-10 22:35:50", "2026-01-10 22:35:50", "164164", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59579", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 22:35:32", "2026-01-10 22:35:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768084532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768084532;}", "9", "1", "2026-01-10 22:35:50", "2026-01-10 22:35:50", "164164", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59580", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 22:51:26", "2026-01-10 22:51:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768085486;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768085486;}", "9", "1", "2026-01-10 22:51:26", "2026-01-10 22:51:26", "164167", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59581", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 23:08:43", "2026-01-10 23:08:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768086523;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768086523;}", "9", "1", "2026-01-10 23:08:54", "2026-01-10 23:08:54", "164170", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59582", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 23:08:53", "2026-01-10 23:08:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768086533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768086533;}", "9", "1", "2026-01-10 23:08:54", "2026-01-10 23:08:54", "164170", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59583", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 23:17:10", "2026-01-10 23:17:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768087030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768087030;}", "9", "1", "2026-01-10 23:25:56", "2026-01-10 23:25:56", "164173", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59584", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 23:25:56", "2026-01-10 23:25:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768087556;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768087556;}", "9", "1", "2026-01-10 23:27:17", "2026-01-10 23:27:17", "164175", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59585", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 00:27:17", "2026-01-11 00:27:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768091237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768091237;}", "13", "1", "2026-01-11 00:35:37", "2026-01-11 00:35:37", "164182", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59586", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 23:39:33", "2026-01-10 23:39:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768088373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768088373;}", "9", "1", "2026-01-10 23:39:40", "2026-01-10 23:39:40", "164179", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59587", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-10 23:39:33", "2026-01-10 23:39:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768088373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768088373;}", "9", "1", "2026-01-10 23:39:40", "2026-01-10 23:39:40", "164179", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59588", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-10 23:47:43", "2026-01-10 23:47:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768088863;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768088863;}", "9", "1", "2026-01-11 00:35:37", "2026-01-11 00:35:37", "164182", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59589", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 01:35:37", "2026-01-11 01:35:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768095337;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768095337;}", "13", "1", "2026-01-11 02:23:14", "2026-01-11 02:23:14", "164190", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59590", "woocommerce_refresh_order_count_cache", "complete", "2026-01-11 12:35:37", "2026-01-11 12:35:37", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768134937;s:18:\"\0*\0first_timestamp\";i:1749581954;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768134937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-11 13:18:51", "2026-01-11 13:18:51", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59591", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 00:35:37", "2026-01-11 00:35:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768091737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768091737;}", "9", "1", "2026-01-11 00:35:37", "2026-01-11 00:35:37", "164184", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59592", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 00:35:37", "2026-01-11 00:35:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768091737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768091737;}", "9", "1", "2026-01-11 00:35:37", "2026-01-11 00:35:37", "164184", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59593", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 00:58:06", "2026-01-11 00:58:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768093086;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768093086;}", "9", "1", "2026-01-11 00:58:14", "2026-01-11 00:58:14", "164187", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59594", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 02:23:14", "2026-01-11 02:23:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768098194;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768098194;}", "9", "1", "2026-01-11 02:23:24", "2026-01-11 02:23:24", "164190", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59595", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 03:23:14", "2026-01-11 03:23:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768101794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768101794;}", "13", "1", "2026-01-11 03:32:22", "2026-01-11 03:32:22", "164200", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59596", "woocommerce_cleanup_draft_orders", "complete", "2026-01-12 02:23:14", "2026-01-12 02:23:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768184594;s:18:\"\0*\0first_timestamp\";i:1658821924;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768184594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-12 02:58:12", "2026-01-12 02:58:12", "164321", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59597", "wc_gla_cron_daily_notes", "complete", "2026-01-12 02:23:14", "2026-01-12 02:23:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768184594;s:18:\"\0*\0first_timestamp\";i:1649397704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768184594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2026-01-12 02:58:12", "2026-01-12 02:58:12", "164321", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59598", "wc_facebook_regenerate_feed", "complete", "2026-01-12 02:23:24", "2026-01-12 02:23:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768184604;s:18:\"\0*\0first_timestamp\";i:1662881502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768184604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-01-12 02:58:22", "2026-01-12 02:58:22", "164321", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59599", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 02:23:24", "2026-01-11 02:23:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768098204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768098204;}", "9", "1", "2026-01-11 02:23:28", "2026-01-11 02:23:28", "164192", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59600", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 02:41:47", "2026-01-11 02:41:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768099307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768099307;}", "9", "1", "2026-01-11 02:41:47", "2026-01-11 02:41:47", "164194", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59601", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 02:41:47", "2026-01-11 02:41:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768099307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768099307;}", "9", "1", "2026-01-11 03:04:59", "2026-01-11 03:04:59", "164196", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59602", "gla/jobs/resubmit_expiring_products/start", "complete", "2026-01-12 03:00:00", "2026-01-12 03:00:00", "[]", "O:28:\"ActionScheduler_CronSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768186800;s:18:\"\0*\0first_timestamp\";i:1753412400;s:13:\"\0*\0recurrence\";O:14:\"CronExpression\":2:{s:25:\"\0CronExpression\0cronParts\";a:5:{i:0;s:1:\"0\";i:1;s:1:\"3\";i:2;s:1:\"*\";i:3;s:1:\"*\";i:4;s:1:\"*\";}s:28:\"\0CronExpression\0fieldFactory\";O:27:\"CronExpression_FieldFactory\":1:{s:35:\"\0CronExpression_FieldFactory\0fields\";a:5:{i:0;O:27:\"CronExpression_MinutesField\":0:{}i:1;O:25:\"CronExpression_HoursField\":0:{}i:2;O:30:\"CronExpression_DayOfMonthField\":0:{}i:3;O:25:\"CronExpression_MonthField\":0:{}i:4;O:29:\"CronExpression_DayOfWeekField\":0:{}}}}s:45:\"\0ActionScheduler_CronSchedule\0start_timestamp\";i:1768186800;s:34:\"\0ActionScheduler_CronSchedule\0cron\";r:4;}", "2", "1", "2026-01-12 03:02:18", "2026-01-12 03:02:18", "164325", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59603", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 03:04:59", "2026-01-11 03:04:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768100699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768100699;}", "9", "1", "2026-01-11 03:05:02", "2026-01-11 03:05:02", "164198", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59604", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 04:32:22", "2026-01-11 04:32:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768105942;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768105942;}", "13", "1", "2026-01-11 04:50:54", "2026-01-11 04:50:54", "164207", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59605", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 03:32:22", "2026-01-11 03:32:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768102342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768102342;}", "9", "1", "2026-01-11 04:09:23", "2026-01-11 04:09:23", "164202", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59606", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 03:32:22", "2026-01-11 03:32:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768102342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768102342;}", "9", "1", "2026-01-11 04:09:23", "2026-01-11 04:09:23", "164202", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59607", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 04:09:23", "2026-01-11 04:09:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768104563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768104563;}", "9", "1", "2026-01-11 04:24:06", "2026-01-11 04:24:06", "164204", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59608", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 04:24:06", "2026-01-11 04:24:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768105446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768105446;}", "9", "1", "2026-01-11 04:24:06", "2026-01-11 04:24:06", "164205", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59609", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 05:50:54", "2026-01-11 05:50:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768110654;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768110654;}", "13", "1", "2026-01-11 05:50:54", "2026-01-11 05:50:54", "164220", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59610", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 04:50:54", "2026-01-11 04:50:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768107054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768107054;}", "9", "1", "2026-01-11 05:08:11", "2026-01-11 05:08:11", "164209", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59611", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 04:50:54", "2026-01-11 04:50:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768107054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768107054;}", "9", "1", "2026-01-11 05:08:11", "2026-01-11 05:08:11", "164209", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59612", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 05:08:11", "2026-01-11 05:08:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768108091;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768108091;}", "9", "1", "2026-01-11 05:10:24", "2026-01-11 05:10:24", "164211", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59613", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 05:10:24", "2026-01-11 05:10:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768108224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768108224;}", "9", "1", "2026-01-11 05:46:26", "2026-01-11 05:46:26", "164213", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59614", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 05:46:26", "2026-01-11 05:46:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768110386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768110386;}", "9", "1", "2026-01-11 05:48:10", "2026-01-11 05:48:10", "164215", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59615", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 05:46:26", "2026-01-11 05:46:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768110386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768110386;}", "9", "1", "2026-01-11 05:48:11", "2026-01-11 05:48:11", "164215", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59616", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 05:49:21", "2026-01-11 05:49:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768110561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768110561;}", "9", "1", "2026-01-11 05:49:24", "2026-01-11 05:49:24", "164218", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59617", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 06:50:54", "2026-01-11 06:50:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768114254;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768114254;}", "13", "1", "2026-01-11 06:51:49", "2026-01-11 06:51:49", "164229", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59619", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 06:16:40", "2026-01-11 06:16:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768112200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768112200;}", "9", "1", "2026-01-11 06:16:43", "2026-01-11 06:16:43", "164224", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59620", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 06:42:32", "2026-01-11 06:42:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768113752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768113752;}", "9", "1", "2026-01-11 06:45:31", "2026-01-11 06:45:31", "164227", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59621", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 06:42:32", "2026-01-11 06:42:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768113752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768113752;}", "9", "1", "2026-01-11 06:45:31", "2026-01-11 06:45:31", "164227", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59622", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 06:45:31", "2026-01-11 06:45:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768113931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768113931;}", "9", "1", "2026-01-11 06:51:49", "2026-01-11 06:51:49", "164229", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59623", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 07:51:49", "2026-01-11 07:51:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768117909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768117909;}", "13", "1", "2026-01-11 09:09:40", "2026-01-11 09:09:40", "164235", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59624", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 06:51:50", "2026-01-11 06:51:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768114310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768114310;}", "9", "1", "2026-01-11 07:27:12", "2026-01-11 07:27:12", "164231", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59625", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 07:27:12", "2026-01-11 07:27:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768116432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768116432;}", "9", "1", "2026-01-11 07:27:12", "2026-01-11 07:27:12", "164233", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59626", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-11 07:27:12", "2026-01-11 07:27:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768116432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768116432;}", "9", "1", "2026-01-11 07:27:12", "2026-01-11 07:27:12", "164233", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59627", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 10:09:40", "2026-01-11 10:09:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768126180;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768126180;}", "13", "1", "2026-01-11 10:10:04", "2026-01-11 10:10:04", "164250", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59628", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 09:09:40", "2026-01-11 09:09:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768122580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768122580;}", "9", "1", "2026-01-11 09:34:54", "2026-01-11 09:34:54", "164237", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59629", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 09:09:40", "2026-01-11 09:09:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768122580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768122580;}", "9", "1", "2026-01-11 09:34:54", "2026-01-11 09:34:54", "164237", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59630", "facebook_for_woocommerce_daily_heartbeat", "complete", "2026-01-11 09:09:41", "2026-01-11 09:09:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768122581;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768122581;}", "9", "1", "2026-01-11 09:35:11", "2026-01-11 09:35:11", "164237", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59631", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 09:35:11", "2026-01-11 09:35:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768124111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768124111;}", "9", "1", "2026-01-11 09:58:05", "2026-01-11 09:58:05", "164238", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59632", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 09:35:11", "2026-01-11 09:35:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768124111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768124111;}", "9", "1", "2026-01-11 09:58:05", "2026-01-11 09:58:05", "164238", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59633", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 09:58:05", "2026-01-11 09:58:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768125485;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768125485;}", "9", "1", "2026-01-11 09:59:46", "2026-01-11 09:59:46", "164240", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59634", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 09:59:46", "2026-01-11 09:59:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768125586;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768125586;}", "9", "1", "2026-01-11 10:04:15", "2026-01-11 10:04:15", "164242", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59635", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 10:04:15", "2026-01-11 10:04:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768125855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768125855;}", "9", "1", "2026-01-11 10:06:20", "2026-01-11 10:06:20", "164244", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59636", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 10:09:07", "2026-01-11 10:09:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768126147;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768126147;}", "9", "1", "2026-01-11 10:09:30", "2026-01-11 10:09:30", "164248", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59637", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 11:10:04", "2026-01-11 11:10:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768129804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768129804;}", "13", "1", "2026-01-11 13:18:50", "2026-01-11 13:18:50", "164259", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59638", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 10:25:23", "2026-01-11 10:25:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768127123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768127123;}", "9", "1", "2026-01-11 10:25:28", "2026-01-11 10:25:28", "164254", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59639", "facebook_for_woocommerce_5_minute_heartbeat", "complete", "2026-01-11 10:55:19", "2026-01-11 10:55:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768128919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768128919;}", "9", "1", "2026-01-11 10:55:23", "2026-01-11 10:55:23", "164257", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59640", "facebook_for_woocommerce_hourly_heartbeat", "complete", "2026-01-11 10:55:19", "2026-01-11 10:55:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768128919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768128919;}", "9", "1", "2026-01-11 10:55:23", "2026-01-11 10:55:23", "164257", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59641", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 14:18:50", "2026-01-11 14:18:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768141130;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768141130;}", "13", "1", "2026-01-11 14:48:31", "2026-01-11 14:48:31", "164266", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59642", "wc_admin_daily_wrapper", "complete", "2026-01-12 13:18:50", "2026-01-12 13:18:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768223930;s:18:\"\0*\0first_timestamp\";i:1756196708;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768223930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-12 13:20:28", "2026-01-12 13:20:28", "164419", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59643", "woocommerce_cleanup_personal_data", "complete", "2026-01-12 13:18:51", "2026-01-12 13:18:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768223931;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768223931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-12 13:20:29", "2026-01-12 13:20:29", "164419", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59644", "woocommerce_tracker_send_event_wrapper", "complete", "2026-01-12 13:18:51", "2026-01-12 13:18:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768223931;s:18:\"\0*\0first_timestamp\";i:1756196718;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768223931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "13", "1", "2026-01-12 13:20:29", "2026-01-12 13:20:29", "164419", NULL, "10");
INSERT INTO `m6ffNYNjzU_actionscheduler_actions` VALUES("59645", "woocommerce_cleanup_logs"