<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_FGO_Premium_Settings {
    /**
     * Bootstraps the class and hooks required actions & filters.
     *
     */
    public static function init() {
        add_filter( 'woocommerce_settings_tabs_array', __CLASS__ . '::add_settings_tab', 50 );
        add_action( 'woocommerce_settings_tabs_settings_tab_fgo', __CLASS__ . '::settings_tab' );
        add_action( 'woocommerce_update_options_settings_tab_fgo', __CLASS__ . '::update_settings' );

        add_action('wp_ajax_woocommerce_fgo_check_credentials', 'woocommerce_fgo_check_credentials');
        add_action('wp_ajax_nopriv_woocommerce_fgo_check_credentials', 'woocommerce_fgo_check_credentials');
        if ( ! function_exists( 'woocommerce_fgo_check_credentials' ) )
        {
            WC_FGO_Premium_Settings::checkCredentials();
        }

        function loadFGOScripts()
        {
            wp_register_script( 'fgo-check-script', '/wp-content/plugins/woocommerce-fgo-premium/includes/assets/js/fgo-premium-settings.js', array ( 'jquery' ), 1.1, true);
            wp_enqueue_script( 'fgo-check-script');
            $params = array(
                'ajax_url' => admin_url('admin-ajax.php', 'woocommerce_check_fgo_premium'),
            );
            wp_localize_script( 'fgo-check-script', 'woocommerce_check_fgo_premium', $params );
        }

        add_action( 'admin_enqueue_scripts','loadFGOScripts' );
    }

    /**
     * Add a new settings tab to the WooCommerce settings tabs array.
     */
    public static function add_settings_tab( $settings_tabs ) {
        $settings_tabs['settings_tab_fgo'] = __( 'FGO', 'woocommerce-settings-tab-fgo' );
        return $settings_tabs;
    }

    /**
     * Uses the WooCommerce admin fields API to output settings via the @see woocommerce_admin_fields() function.
     */
    public static function settings_tab() {
        $fgo_is_working = get_option('wc_settings_tab_fgo_is_working');
        $class = 'notice notice-error';
        $message = $fgo_is_working === '' ?  'Nu s-a putut finaliza conectarea. Asigura-te ca serverul tau are conexiune cu serverul FGO.' : '';
        if ($fgo_is_working != '' && $fgo_is_working == '1')
        {
            $class = 'updated inline';
            $message = 'Modul functional';
        }
        else if($fgo_is_working != '' && $fgo_is_working == '0')
        {
            $class = 'notice notice-error';
            $message = 'Modulul nu este functional. Te rugam sa salvezi din nou setarile.';
        }
        printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );

        woocommerce_admin_fields( self::get_settings() );

         printf( '<div class = "woocommerce-check"><div class="button woocommerce-fgo-check-connection">Verifica conexiunea cu serverul FGO</div></div>');
    }
    /**
     * Uses the WooCommerce options API to save settings via the @see woocommerce_update_options() function.
     *
     * @uses woocommerce_update_options()
     * @uses self::get_settings()
     */
    public static function update_settings() {
		$settings = self::get_settings();
		if (WC_FGO_Premium_Settings::check_fgo_credentials($settings))
        {
			woocommerce_update_options($settings);
        }
        woocommerce_update_options($settings);
    }
    /**
     * Get all the settings for this plugin for @see woocommerce_admin_fields() function.
     */
    public static function get_settings() {
        global $FGO_SETTINGS_ARRAY;

        $users = get_users( [ 'role__not_in' => [ 'customer'] ] );
        $site_name = get_site_url();
        $atrReadonly =  array('readonly' => 'readonly');
        if($site_name === "" || $site_name === '0' || $site_name === NULL){
            if (defined( 'WP_HOME')) {
                $site_name = WP_HOME;
           }          
        }

        if($site_name === "" || $site_name === '0' || $site_name === NULL){
            $atrReadonly = ''; 
        }

        $settings =  array(
            'section_title' => array(
                'name'     => __( 'FGO Premium', 'woocommerce-settings-tab-fgo' ),
                'type'     => 'title',
                'desc'     => '',
                'id'       => 'wc_settings_tab_fgo_section_title'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_site_url'] => array(
                'name' => __( 'Site url (in caz ca valoarea afisata este 0, este necesar sa completati dvs adresa magazinului (ex https://www.magazin.ro), care va trebui sa corespunda cu adresa magazinului trecuta in sectiunea eCommerce -> setari API din FGO)', 'woocommerce-settings-tab-fgo' ),
                'type' => 'text',
                'desc' => __( 'Site url.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_site_url',
                'default' => $site_name,
                'custom_attributes' => $atrReadonly
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_private_key'] => array(
                'name' => __( 'Parola user API:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'text',
                'desc' => __( 'In contul FGO, mergi in pagina Setari – Utilizatori si apasa butonul Adauga / Vezi user API. Copiaza parola afisata si insereaz-o aici.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_private_key'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_client_code'] => array(
                'name' => __( 'CUI (cod unic):', 'woocommerce-settings-tab-fgo' ),
                'type' => 'text',
                'desc' => __( 'Completeaza codul unic de identificare al firmei (CUI).', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_client_code'
            ),
			$FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_sandbox'] => array(
                'name' => __( 'Mod de test:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Alege Da numai daca userul API este generat in platforma FGO de test (testapp.fgo.ro).', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_sandbox',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '1'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_client_vat'] => array(
                'name' => __( 'Cod TVA clienti la finalizarea comenzii:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Alege DA in cazul in care ai nevoie de codul de TVA al clientilor; acesta le va fi cerut in momentul finalizarii comenzii.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_client_vat',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '0'
            ),
            $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_client_vat_external'] => array(
                'name' => __( 'Folosesti plugin-ul "Facturare WooCommerce" pentru preluarea codului de TVA al clientilor:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Daca bifezi "DA", vom prelua automat codul de TVA al clientului din campurile modulului.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_client_vat_external',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '0'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_client_vat_field'] => array(
                'name' => __( 'Camp pentru Cod TVA clienti din pagina de comanda:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'text',
                'desc' => __( 'In cazul in care ai nevoie de codul de TVA al clientilor si ai deja un plugin care preia aceasta informatie in momentul finalizarii comenzii, il poti completa.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_client_vat_field',
				'default' => ''
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_client_nrRegCom_field'] => array(
                'name' => __( 'Camp pentru numarul de ordine in registrul comertului al clientilor din pagina de comanda:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'text',
                'desc' => __( 'In cazul in care ai nevoie de numarul de ordine in registrul comertului al clientilor si ai deja un plugin care preia aceasta informatie in momentul finalizarii comenzii, il poti completa.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_client_nrRegCom_field',
				'default' => ''
            ), 
            $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_client_vat_sanitize'] => array(
                'name' => __( 'Validare Cod TVA clienti pt clientii din Romania:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
                'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Daca slectezi Da, se va face validarea codului unic doar pentru clientii pentru care tara transmisa este Romania.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_client_vat_sanitize',
				'default' => '0'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_insert_cc'] => array(
                'name' => __( 'Comentarii clienti pe factura:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Afiseaza comentariile clientilor pe factura.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_insert_cc',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '1'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_insert_shipping'] => array(
                'name' => __( 'Cost de livrare pe factura:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Afiseaza costul de livrare pe factura.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_insert_shipping',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '1'
            ),
			$FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_shipping_vat'] => array(
                'name' => __( 'Cost de livrare cu TVA 19%:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Selecteaza DA pentru a adauga TVA 19% la costul de livrare. Selecteaza nu pentru cost de livrare cu TVA 0%.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_shipping_vat',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '1'
            ),	
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_shipping_vat_type'] => array(
                'name' => __( 'Costul de livrare afisat include TVA:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Selecteaza DA daca pretul articolului cost de transport afisat este pretul total (cu TVA); selecteaza NU daca pretul articolului este pretul unitar.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_shipping_vat_type',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '1'
            ),	
			$FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_product_mapping'] => array(
                'name' => __( 'Cod articol:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Selecteaza DA daca codul articolelor din magazinul online corespunde cu codul articolelor din FGO (codul preluat din SAGA).', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_product_mapping',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '0'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_stock_management'] => array(
                'name' => __( 'Actualizeaza stocul:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Selecteaza DA daca doresti ca stocul produselor din site-ul tau sa fie actualizat pe baza stocurilor din FGO dupa emiterea facturii.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_stock_management',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '0'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_product_description'] => array(
                'name' => __( 'Afiseaza codul SKU al produsului in descrierea acestuia pe factura:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
				'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'In cazul in care doresti ca in descrierea produsului ce va aparea pe factura sa apara codul SKU selecteaza DA; in cazul in care doresti ca descrierea ce apare pe factura sa fie descrierea produsului asa cum apare in FGO, selecteaza NU.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_product_description',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'default' => '0'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_product_management'] => array(
                'name' => __( 'Cod gestiune:', 'woocommerce-settings-tab-fgo' ),
                'type'     => 'text',
                'desc' => __( 'Logheaza-te in FGO si copiaza codul de gestiune pe care il doresti. Codul se va trimite pentru fiecare din produsele comenzii.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_product_management'
            ),
            $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_product_management_shipping'] => array(
                'name' => __( 'Cod gestiune articol transport:', 'woocommerce-settings-tab-fgo' ),
                'type'     => 'text',
                'desc' => __( 'Logheaza-te in FGO si copiaza codul de gestiune pe care il doresti transmis pentru articolul de transport. Daca nu completezi acest camp, se va trimite codul de gestiune de mai sus, in cazul in care l-ai completat.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_product_management_shipping'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_shipping_mapping'] => array(
                'name' => __( 'Cod de articol pentru costul de transport:', 'woocommerce-settings-tab-fgo' ),
                'type'     => 'text',
                'desc' => __( 'Completeaza in cazul in care ai deja un cod generat pe care doresti sa il asociezi cu articolul de transport.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_shipping_mapping'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_discount_mapping'] => array(
                'name' => __( 'Cod de articol pentru articolul Reducere:', 'woocommerce-settings-tab-fgo' ),
                'type'     => 'text',
                'desc' => __( 'Completeaza in cazul in care ai deja un cod pe care doresti sa il ascoiezi cu articolul "Reducere".', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_discount_mapping'
            ),
			$FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_invoice_type'] => array(
               'name' => __( 'Tip document generat:', 'woocommerce-settings-tab-fgo' ),
               'type' => 'select',
               'options' => array(
                   'invoice' => __('Factura'),
                   'order' => __('Proforma'),
				   'notice' => __('Aviz')
               ),
               'desc' => __( 'Alege tipul de document generat la finalizarea comenzii (Factura, Proforma etc.)', 'woocommerce-settings-tab-fgo'),
               'id'   => 'wc_settings_tab_fgo_invoice_type',
               'css'      => 'min-width: 350px;',
               'class'    => 'wc-enhanced-select',
               'default' => 'invoice'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_desc_items'] => array(
                'name' => __( 'Ce informatii doresti sa apara suplimentar pe factura:', 'woocommerce-settings-tab-fgo' ),
                'type' => 'multiselect',
                'options' => array(
                    CONFIG::$FGO_DESC_ORDERID => __('Numarul comenzii'),
                    CONFIG::$FGO_DESC_PAYMENT => __('Modalitate plata'),
                    CONFIG::$FGO_DESC_SHIPPING => __('Modalitate livrare')
                ),
                'desc' => __( 'Alege daca doresti ca aceste informatii suplimentare doresti sa apara pe factura (numar comanda, modalitate plata, modalitate livrare)', 'woocommerce-settings-tab-fgo'),
                'id'   => 'wc_settings_tab_fgo_desc_items',
                'css'      => 'min-width: 350px;',
                'class'    => 'wc-enhanced-select'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_api_call'] => array(
               'name' => __( 'Generarea facturii FGO:', 'woocommerce-settings-tab-fgo' ),
               'type' => 'select',
               'options' => array(
                   'onOrder' => __('La plasarea comenzii - status "in procesare"/"processing"'),
                   'onPayment' => __('La confirmarea platii - status ""/"payment complete"'),
                   'onCompleted' => __('La finalizarea comenzii'),
                   'manual' => __('Manual')
               ),
               'desc' => __( 'Alege cand vrei sa se emita factura (documentul) FGO', 'woocommerce-settings-tab-fgo' ),
               'id'   => 'wc_settings_tab_fgo_api_call',
               'css'      => 'min-width: 350px;',
               'class'    => 'wc-enhanced-select',
               'default' => 'manual'
            ),
           $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_discount_invoice'] => array(
                'name' => __( 'Afisarea reducerilor in factura (se refera la produsele cu pret redus)', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
                'options' => array(
					'1' => __('Da'),
					'0' => __('Nu')
				),
                'desc' => __( 'Alege "Da" pentru a afisa in factura produsul la pret intreg + reducerea aferenta ca articol separat; altfel se va afisa doar produsul la pretul final(redus).', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_discount_invoice',
                'css'      => 'min-width: 350px;',
                'class'    => 'wc-enhanced-select'
             ),
             $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_series_option'] => array(
                'name' => __( 'Seria pe care se va genera factura in FGO', 'woocommerce-settings-tab-fgo' ),
                'type' => 'select',
                'options' => array(
                    '0' => __('O singura serie (transmisa de modul FGO-Woocommerce)'),
                    '1' => __('Serii diferite pentru roluri diferite (transmise de modulul FGO-Woocommerce)')
				),
                'desc' => __( '"O singura serie" foloseste seria trecuta de tine mai jos(aceeasi pentru toate rolurile); "Serii diferite pentru roluri diferite" in cazul in care este necesara generarea de facturi pe serii diferite, in functie de rol', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_series_option',
                'css'      => 'min-width: 350px;',
                'class'    => 'wc-enhanced-select',
                'default' => '0',
                
             ),
             $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_invoice_series'] => array(
                'name' => __( 'Seria pe care se vor genera documentele', 'woocommerce-settings-tab-fgo' ),
                'type' => 'text',
                'desc' => __( 'Daca ai selectat "O singura serie setata" la optiunea de mai sus trece aici serie pe care doresti sa se genereze facturile.', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_invoice_series'
             ),
            'section_end' => array(
                'type' => 'sectionend',
                'id' => 'wc_settings_tab_fgo_section_end'
            ),
            'section_title2' => array(
                'name'     => __( '', 'woocommerce-settings-tab-fgo' ),
                'type'     => 'title',
                'desc'     => 'In cazul in care ai selectat "Serii diferite pentru roluri diferite" si doresti ca fiecare rol sa poate emite doar pe o anumita serie, completeaza mai jos seriile la care are acces fiecare',
                'id'       => 'wc_settings_tab_fgo_section_title2'
            )
        );
        
        $user_roles = array();
        foreach($users as $user){
            if ( in_array($user->roles[0], $user_roles) ) {
                continue;
            }
            array_push($user_roles,$user->roles[0]);
        }

        foreach($user_roles as $user_role){
            $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_invoice_series_'.$user_role] =  array(
                'name' => __( ''.$user_role.':' , 'woocommerce-settings-tab-fgo' ),
                'class' => 'wc_settings_tab_fgo_invoice_series_roles',
                'type' => 'text',
                'desc' => __( 'Optional', 'woocommerce-settings-tab-fgo' ),
                'id'   => 'wc_settings_tab_fgo_invoice_series_'.$user_role.''
            );

            array_push($settings,  $FGO_SETTINGS_ARRAY['wc_settings_tab_fgo_invoice_series_'.$user_role]);
        }

        array_push($settings, array(
            'type' => 'sectionend',
            'id' => 'wc_settings_tab_fgo_section_end2'));

     
        return apply_filters( 'wc_settings_tab_fgo_settings', $settings );
    }

	public static function check_fgo_credentials($settings)
	{
        $root = CONFIG::$FGO_SANDBOX_ROOT;
        if ($_POST['wc_settings_tab_fgo_sandbox'] == '0') {
            $root = CONFIG::$FGO_ROOT;
        }
    

         $key = "4C490B5C";
        $url = $root . 'factura/check';
        $denumire = 'DummyTextForCheckingHash';
        $data = array();
        $data['VersiuneAddon'] = Config::$FGO_VERSIUNE_MODUL;
        $data['CodUnic'] = $_POST['wc_settings_tab_fgo_client_code'];
        $data['Hash'] = CONFIG::generateHash($_POST['wc_settings_tab_fgo_client_code'], $_POST['wc_settings_tab_fgo_private_key'], $denumire);
        $data['Client[Denumire]'] = $denumire;
        $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
        $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
        $token = strtoupper(SHA1( '1' .'1' . $key));
        $data['Token'] = $token;
        $options = array(
        'http' => array(
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        )
        );
        $context  = stream_context_create($options);
    
        try{
        $result = file_get_contents($url, false, $context);
        $response = json_decode($result);

        if ($response->{'Success'} === TRUE)
        {
            update_option('wc_settings_tab_fgo_is_working','1');
        }
        else
        {
            update_option('wc_settings_tab_fgo_is_working','0');
            $class = 'notice notice-error';
            $message = $response->{'Message'};
            printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
        }
        }
        catch(Exception $e){
        update_option('wc_settings_tab_fgo_is_working','');
        $class = 'notice notice-error';
        $message = $e->$e->getMessage() . ' Nu s-a putut realiza conexiunea cu serverul. Verificati permisiunile';
        echo( $e->$e->getMessage() . ' Nu s-a putut realiza conexiunea cu serverul. Verificati permisiunile');
        return false;
        }

        return $response->{'Success'};
    }
    
    public static function checkCredentials(){
       function woocommerce_fgo_check_credentials(){
       
        $root = CONFIG::$FGO_SANDBOX_ROOT;
        if ($_POST['wc_settings_tab_fgo_sandbox'] == '0') {
            $root = CONFIG::$FGO_ROOT;
        }
    

         $key = "4C490B5C";
        $url = $root . 'factura/check';
        $denumire = 'DummyTextForCheckingHash';
        $data = array();
        $data['VersiuneAddon'] = Config::$FGO_VERSIUNE_MODUL;
        $data['CodUnic'] = get_option('wc_settings_tab_fgo_client_code');
        $data['Hash'] = CONFIG::generateHash(get_option('wc_settings_tab_fgo_client_code'),get_option('wc_settings_tab_fgo_private_key'), $denumire);
        $data['Client[Denumire]'] = $denumire;
        $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
        $token = strtoupper(SHA1( '1' .'1' . $key));
        $data['Token'] = $token;
        $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
        $options = array(
        'http' => array(
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        )
        );
        $context  = stream_context_create($options);
    
        try{
        $result = file_get_contents($url, false, $context);
        $response = json_decode($result);

        if ($response->{'Success'} === TRUE)
        {
            echo 'Conexiune ok. Pentru utilizarea modulului salveaza setarile.';
            exit;
        }
        else  if ($response->{'Success'} === FALSE)
        {
           echo 'Conexiune ok. Pentru utilizarea modulului salveaza setarile.';
           exit;
        }
        }
        catch(Exception $e){
            echo 'Eroare. Luati legatura cu furnizorul dv. de hosting pentru rezolvarea problemelor constatate.';
            exit;
        }

        echo 'Eroare. Verifica permisiunile serverului.';
        exit;
    }
    }

}